c ======================================================================
      subroutine solve(A,x,rhs,truev,alpha,wksp,iter,id2)
c ======================================================================
      include 'commons.h'
      complex*8 A(-mx:mx,lneqn,ndmnx,ndmny)
      complex*8 x(lneqn,ndmnx,ndmny,1)
      complex*8 rhs(1),truev(1),alpha(1),wksp(1)
 
      itstart= 1
      idcall = 0
      calltol= 10.d0*tolddm
      jumpcall=min(5,ndmnx/2)
      if((ndmnx+ndmny-1).gt.30) then
        calltol= 5.d0*tolddm
      endif
      ifinish=0
 
c ....................................................................
      do 3000 iter = 1, itmaxddm
c ....................................................................
 
      id1 = mod(iter+1,2)+1
      id2 = mod(iter  ,2)+1
 
c ... adjust the right hand side ......................................
 
      call adjrhs(iter,x(1,1,1,id1),x(1,1,1,id2),rhs,alpha,wksp)
 
      do 1000 jj = 1, ndmny
      do 1000 ii = 1, ndmnx
 
c ... Substitution in Iteration .......................................
 
          do k=2,lneqn
          kb=min(k-1,mx)
          do j= 1, kb
             x(k,ii,jj,id2)=x(k,ii,jj,id2)
     &                    -A(-j,k,ii,jj)*x(k-j,ii,jj,id2)
          enddo
          enddo
c......................................................................
          x(lneqn,ii,jj,id2) = x(lneqn,ii,jj,id2)/A(0,lneqn,ii,jj)
          do k=lneqn-1,1,-1
          kb=min(lneqn-k,mx)
          do j=1,kb
             x(k,ii,jj,id2)=x(k,ii,jj,id2)
     &                     -A(j,k,ii,jj)*x(k+j,ii,jj,id2)
          enddo
          x(k,ii,jj,id2)=x(k,ii,jj,id2)/A(0,k,ii,jj)
          enddo
c
 1000 continue
c
      if(iddirac.eq.1 .and. ndmnx.eq.1) then
         write(1,150) (real(x(i,1,1,id2)),i=1,neqn)
         write(2,150) (imag(x(i,1,1,id2)),i=1,neqn)
         ntemp = mx*(jsrcy-1)
         do i=1,mx
            nn=ntemp + i
            xp=dble(i-1)*hx
            write(11,250) xp,real(x(nn,1,1,id2))
            write(12,250) xp,imag(x(nn,1,1,id2))
         enddo
         return
      endif
 
      if(itmaxddm.eq.1) return

c ... checking the error .............................................
 
      if(iter.eq.1) then
         call error(iter,x(1,1,1,id2),x,truev,terr,ferr,truenorm)
         if(idgrid.eq.1) then
            print'(/"  niter  L",i1,"_rel_error"/1x,22("-"))',inorm
            print'(i6,f9.6)',iter,terr
         endif
         goto 3000
      endif
c
      idcall=idcall+1
      if(iter.lt.itstart .or. idcall.lt.jumpcall) goto 3000
      call error(iter,x(1,1,1,id2),x,truev,terr,ferr,truenorm)
      if(ferr.gt.calltol) idcall=0
 
      if(ferr.ge.10. .or. terr.ge.10.) then
        print*," err: too big."
        goto 9999
      endif
      if (ferr.le.tolddm .or. iter.ge.itmaxddm) then
         if(level.ge.3) print'(" DDM iterations = ",i4)',iter
         goto 9999
      end if
 
 3000 continue
 
 150  format(f12.7)
 250  format(2f12.7)
c
c .....................................................................
c
 9999 return
      end

c ======================================================================
      subroutine adjrhs(iter,xo,xn,rhs,alpha,wksp)
c ======================================================================
      include 'commons.h'
      complex*8 xo(lneqn,ndmnx,ndmny),xn(lneqn,ndmnx,ndmny)
      complex*8 rhs(lneqn,ndmnx,ndmny)
      complex*8 alpha(nx,ny,2)
      complex*8 wksp(lneqn,ndmnx,ndmny)
      complex*8 al,bx1,bx2,by1,by2
c
c.... total filling
c
      if(iter.eq.1 .or. mod(iter,nstar).eq.0) then
         do 100 jj = 1, ndmny
         do 100 ii = 1, ndmnx
         do 100 i  = 1, lneqn
 100        wksp(i,ii,jj) = artdamp*xo(i,ii,jj)
      endif
c
      do 200 jj = 1, ndmny
      do 200 ii = 1, ndmnx
      do 200 i  = 1, lneqn
 200     xn(i,ii,jj) = rhs(i,ii,jj)+wksp(i,ii,jj)
c
c.... inter_boundary columns
c
      do 1000 jj = 1, ndmny
      do 1000 ii = 1, ndmnx-1
      do 1000 j  = 1, my
          neq1 = mx*j
          neq2 = mx*(j-1)+1
          call bdryxy(i,j,ii,jj,alpha,bx1,bx2,by1,by2)
          al = bx2
          xn(neq1,ii,jj)  = xn(neq1,ii,jj)  
     &                 + al*xo(neq2,ii+1,jj)+ xo(neq2+1,ii+1,jj)
          xn(neq2,ii+1,jj)= xn(neq2,ii+1,jj)
     &                 + al*xo(neq1,ii,jj)  + xo(neq1-1,ii,jj)
 1000 continue
c
      ntmp1 = mx*(my-1)
      do 2000 jj = 1, ndmny-1
      do 2000 ii = 1, ndmnx
      do 2000 i  = 1, mx
          neq1 = ntmp1+i
          neq2 = i
          call bdryxy(i,j,ii,jj,alpha,bx1,bx2,by1,by2)
          al = by2
          xn(neq1,ii,jj)  = xn(neq1,ii,jj)  
     &                 + al*xo(neq2,ii,jj+1)+ xo(neq2+mx,ii,jj+1)
          xn(neq2,ii,jj+1)= xn(neq2,ii,jj+1)
     &                 + al*xo(neq1,ii,jj)  + xo(neq1-mx,ii,jj)
 2000 continue
c
 9999 return
      end
c
c ======================================================================
      subroutine error(iter,x,xx,truev,terr,ferr,truenorm)
c ======================================================================
      include 'commons.h'
      complex*8 x(mx,my,ndmnx,ndmny)
      complex*8 xx(mx,my,ndmnx,ndmny,2)
      complex*8 truev(mx,my,ndmnx,ndmny)
c
      if(iter.gt.1 .or. iddirac.eq.1 .or. idgrid.gt.1) goto 2000
*      if(iter.gt.1 .or. iddirac.eq.1) goto 2000
c
      truenorm= 0.0d0
      do 1000 jj= 1,ndmny
      do 1000 ii= 1,ndmnx
      do 1000 j = 1,my
      do 1000 i = 1,mx
         temp= cabs(truev(i,j,ii,jj))
         if(temp.gt.truenorm) truenorm = temp
 1000 continue
c
 2000 continue
c
c --------------------------------------------------
c.... iteration errors : \|u^n-u^{n-1}\| / \|u^n\|
c --------------------------------------------------
      ctmp1 = 0.0d0
      ctmp2 = 0.0d0
      do 2200 jj= 1,ndmny
      do 2200 ii= 1,ndmnx
      do 2200 j = 1,my
      do 2200 i = 1,mx
       temp = cabs(xx(i,j,ii,jj,1)-xx(i,j,ii,jj,2))
       if(temp.gt.ctmp1) ctmp1 = temp
       temp = cabs(x(i,j,ii,jj))
       if(temp.gt.ctmp2) ctmp2 = temp
 2200 continue
      ferr = ctmp1/ctmp2
c
*      if(iddirac.eq.1) then
      if(iddirac.eq.1 .or. idgrid.gt.1) then
         terr = ferr
         goto 9999
      endif
c
c --------------------------------------------------
c.... true errors : \|u^n-u\| / \|u\|
c --------------------------------------------------
      enorm= 0.0d0
      do 3000 jj= 1,ndmny
      do 3000 ii= 1,ndmnx
      do 3000 j = 1,my
      do 3000 i = 1,mx
       temp = cabs(truev(i,j,ii,jj)-x(i,j,ii,jj))
       if(temp.gt.enorm) enorm = temp
 3000 continue
      terr = enorm/truenorm
c
 9999 return
      end
