c=======================================================================
      subroutine smoothGS(ahd,xh,fh,nxx,nyy,iterSGS,idSGS)
c=======================================================================
      implicit none
      integer nxx,nyy,iterSGS,idSGS
      complex*8 ahd(nxx,nyy),xh(nxx,nyy),fh(nxx,nyy)

      integer i,j,iter,nxxm1,nyym1
      complex*8 ctmp
 
c ....smoothing: Symmetric-Gauss-Seidel iteration
 
      nxxm1=nxx-1
      nyym1=nyy-1
 
      do 8888 iter=1,iterSGS
 
      j=1
         i=1
         xh(i,j)=(fh(i,j)+2.*(xh(i+1,j)+xh(i,j+1)))/ahd(i,j)
         do i=2,nxxm1
            xh(i,j)=(fh(i,j)+2.*xh(i,j+1)+xh(i-1,j)+xh(i+1,j))/ahd(i,j)
         enddo

         i=nxx
         xh(i,j)=(fh(i,j)+2.*(xh(i-1,j)+xh(i,j+1)))/ahd(i,j)
 
      do j=2,nyym1
         i=1
         xh(i,j)=(fh(i,j)+2.*xh(i+1,j)+xh(i,j-1)+xh(i,j+1))/ahd(i,j)
         do i=2,nxxm1
           ctmp =xh(i-1,j)+xh(i+1,j)+xh(i,j-1)+xh(i,j+1)
           xh(i,j)=(fh(i,j)+ctmp)/ahd(i,j)
         enddo
         i=nxx
         xh(i,j)=(fh(i,j)+2.*xh(i-1,j)+xh(i,j-1)+xh(i,j+1))/ahd(i,j)
      enddo
 
      j=nyy
         i=1
         xh(i,j)=(fh(i,j)+2.*(xh(i+1,j)+xh(i,j-1)))/ahd(i,j)
         do i=2,nxxm1
           xh(i,j)=(fh(i,j)+2.*xh(i,j-1)+xh(i-1,j)+xh(i+1,j))/ahd(i,j)
         enddo
         i=nxx
         xh(i,j)=(fh(i,j)+2.*(xh(i-1,j)+xh(i,j-1)))/ahd(i,j)

      if(idSGS.eq.0) goto 8888

c.... sweep in the opposite direction for SGS
 
      j=nyy
         i=nxx
         xh(i,j)=(fh(i,j)+2.*(xh(i-1,j)+xh(i,j-1)))/ahd(i,j)
         do i=nxxm1,2,-1
            xh(i,j)=(fh(i,j)+2.*xh(i,j-1)+xh(i-1,j)+xh(i+1,j))/ahd(i,j)
         enddo
         i=1
         xh(i,j)=(fh(i,j)+2.*(xh(i+1,j)+xh(i,j-1)))/ahd(i,j)
 
      do j=nyym1,2,-1
         i=nxx
         xh(i,j)=(fh(i,j)+2.*xh(i-1,j)+xh(i,j-1)+xh(i,j+1))/ahd(i,j)
         do i=nxxm1,2,-1
           ctmp =xh(i-1,j)+xh(i+1,j)+xh(i,j-1)+xh(i,j+1)
           xh(i,j)=(fh(i,j)+ctmp)/ahd(i,j)
         enddo
         i=1
         xh(i,j)=(fh(i,j)+2.*xh(i+1,j)+xh(i,j-1)+xh(i,j+1))/ahd(i,j)
         enddo
 
      j=1
         i=nxx
         xh(i,j)=(fh(i,j)+2.*(xh(i-1,j)+xh(i,j+1)))/ahd(i,j)
         do i=nxxm1,2,-1
           xh(i,j)=(fh(i,j)+2.*xh(i,j+1)+xh(i-1,j)+xh(i+1,j))/ahd(i,j)
         enddo
         i=1
         xh(i,j)=(fh(i,j)+2.*(xh(i+1,j)+xh(i,j+1)))/ahd(i,j)
 
 8888 continue
 
      return
      end

