c ======================================================================
      subroutine residual(nx,ny,a,x,f,res,hx,r8norm,r2norm)
c ======================================================================
      implicit none
      integer nx,ny
      real hx,r8norm,r2norm
      complex*8 a(nx,ny),x(nx,ny),f(nx,ny),res(nx,ny)

      integer i,j,jm1,jp1,nxm1,nym1
      complex*8 axij

c---- res = f - a x

      nxm1=nx-1
      nym1=ny-1

c---- interior points

      do j=2,nym1
         jm1=j-1
         jp1=j+1
      do i=2,nxm1
         axij=-x(i,jm1)-x(i-1,j)+a(i,j)*x(i,j)-x(i+1,j)-x(i,jp1)
         res(i,j)=f(i,j)-axij
      end do
      end do

c---- four corners

      i=1
      j=1
      axij=a(i,j)*x(i,j)-2.*(x(i+1,j)+x(i,j+1))
      res(i,j)=f(i,j)-axij

      i=nx
      j=1
      axij=a(i,j)*x(i,j)-2.*(x(i-1,j)+x(i,j+1))
      res(i,j)=f(i,j)-axij

      i=1
      j=ny
      axij=a(i,j)*x(i,j)-2.*(x(i,j-1)+x(i+1,j))
      res(i,j)=f(i,j)-axij

      i=nx
      j=ny
      axij=a(i,j)*x(i,j)-2.*(x(i,j-1)+x(i-1,j))
      res(i,j)=f(i,j)-axij

c---- four sides

      i=1
      do j=2,nym1
         axij=-x(i,j-1)+a(i,j)*x(i,j)-2.*x(i+1,j)-x(i,j+1)
         res(i,j)=f(i,j)-axij
      end do

      i=nx
      do j=2,nym1
         axij=-x(i,j-1)+a(i,j)*x(i,j)-2.*x(i-1,j)-x(i,j+1)
         res(i,j)=f(i,j)-axij
      end do

      j=1
      do i=2,nxm1
         axij=-x(i-1,j)+a(i,j)*x(i,j)-x(i+1,j)-2.*x(i,j+1)
         res(i,j)=f(i,j)-axij
      end do

      j=ny
      do i=2,nxm1
         axij=-x(i-1,j)+a(i,j)*x(i,j)-x(i+1,j)-2.*x(i,j-1)
         res(i,j)=f(i,j)-axij
      end do

c---- check maximum norm of the residual

      r8norm=0.0
      r2norm=0.0
      do j=2,ny
      do i=2,nx
         r8norm=max(r8norm,cabs(res(i,j)))
         r2norm=r2norm+cabs(res(i,j))**2
      end do
      end do
      r2norm=sqrt(r2norm)*hx

      return
      end

