c=======================================================================
        real*4 function cc(x,y)
c=======================================================================
        include 'commons.h'

        if(ncc.eq.1)then
           cc = 2.0d0
        elseif(ncc.eq.2)then
           cc=1.+x**3+1.5*y
*           cc=1.3+0.5*(x**3+1.5*y+abs(sin(3.*pi*x)*cos(5.*pi*y)))
        elseif(ncc.eq.3)then
           cc=1.6+abs(sin(3.*pi*x)*cos(4.*pi*y))
        elseif(ncc.eq.4)then
           if(x.lt.(0.5d0+0.5d0*hx)) then
              cc=2.0d0
           else
              cc=2.0d0+sin(5.0d0*pi*x*y)
*              cc=2.0d0+sin(7.0d0*pi*x*y)
           endif
        else
           cc = 1.0d0
        endif

        return
        end

c=======================================================================
        real function cc00(x,y)
c=======================================================================
        include 'commons.h'
c
        if(ncc.eq.1)then
           cc = 2.0d0
        elseif(ncc.eq.2)then
           cc = 1.0d0 + x**3 + 1.5*y
        elseif(ncc.eq.3)then
           cc=1.6d0+abs(sin(3.0d0*pi*x)*cos(4.0d0*pi*y))
        elseif(ncc.eq.4)then
           temp=0.5d0+0.5d0*hx
           if(x.lt.(0.5d0+0.5d0*hx)) then
              cc=2.0d0
           else
              cc=2.0d0+sin(5.0d0*pi*x*y)
           endif
        else
           cc = 1.0d0
        endif
c
        return
        end

c=======================================================================
        complex*8 function true(x,y)
c=======================================================================
        complex*8 phi
        include 'commons.h'
        true = phi(x)*phi(y)
        return
        end

c=======================================================================
        complex*8 function r1prhs(x,y)
c=======================================================================
        complex*8 phi,true
        complex*8 phix,phiy,nondamp
        include 'commons.h'

        if(iddirac.eq.1) then
          r1prhs =0.0d0
        else
          phix = phi(x)
          phiy = phi(y)
          coef = cc(x,y)
          nondamp = omega**2
     &       *( (2.0d0-1.0d0/coef**2)*phix*phiy +2.0d0*(phix+phiy) )
          r1prhs = nondamp + im*q**2*true(x,y)
        endif
c
        return
        end

c=======================================================================
        complex*8 function phi(x)
c=======================================================================
        include 'commons.h'
        complex*8 tmp1,tmp2
c
        tmp1= omega*(x-1.0d0)*(0.0d0,1.0d0)
        tmp2=-omega*  x   *(0.0d0,1.0d0)
        phi = cexp(tmp1)+cexp(tmp2)-2.0d0
        return
        end

c=======================================================================
      subroutine rhstrue(rhs,truev)
c=======================================================================
      include 'commons.h'
      complex*8 r1prhs,true
      complex*8 rhs(mx,my,ndmnx,ndmny)
      complex*8 truev(mx,my,ndmnx,ndmny)
c
      hh = hx**2
      if(iddirac.eq.1) goto 3333
c
      do 1000 jj = 1, ndmny
          bbbb = dble(jj-1)*hhy+ay
      do 1000 ii = 1, ndmnx
          aaaa = dble(ii-1)*hhx+ax
      do 1000 j = 1, my
          py = hy*dble(j-1)+bbbb
      do 1000 i = 1, mx
          px = hx*dble(i-1)+aaaa
          rhs(i,j,ii,jj)  = r1prhs(px,py)*hh
          truev(i,j,ii,jj)= true(px,py)
 1000 continue
      goto 9999
c
 3333 continue

      do 2000 jj=1,ndmny
      do 2000 ii=1,ndmnx
      do 2000 j =1,my
      do 2000 i =1,mx
 2000   rhs(i,j,ii,jj) = 0.0d0

      isrcx = (mx+1)/2
      jsrcy = (my+1)/2
      iisrc = 1
*      iisrc = max(1,ndmnx/2)
      jjsrc = max(1,ndmny/2)
      srcxx = ax+dble(iisrc-1)*hhx+dble(isrcx-1)*hx
      srcyy = ay+dble(jjsrc-1)*hhy+dble(jsrcy-1)*hy
      if(level.ge.1) then
         print'(" the source=(",f6.3,",",f6.3,")",
     &          " in subdomain (",i2,",",i2,")")',
     &          srcxx,srcyy,iisrc,jjsrc
      endif
      rhs(isrcx,jsrcy,iisrc,jjsrc) = 1.0
c
 9999 return
      end

c=======================================================================
      subroutine c4rhs(rhs,idrhs)
c=======================================================================
      include 'commons.h'
      complex*8 r1prhs
      complex*8 rhs(mx,my,ndmnx,ndmny)
c
      if(idrhs.eq.0) goto 2500
c
      hh = hx**2
      if(iddirac.eq.1) goto 3333
c
      do 1000 jj = 1, ndmny
          bbbb = dble(jj-1)*hhy+ay
      do 1000 ii = 1, ndmnx
          aaaa = dble(ii-1)*hhx+ax
      do 1000 j = 1, my
          py = hy*dble(j-1)+bbbb
      do 1000 i = 1, mx
          px = hx*dble(i-1)+aaaa
          rhs(i,j,ii,jj)  = r1prhs(px,py)*hh
 1000 continue
      goto 9999
c
 3333 continue

      do 2000 jj=1,ndmny
      do 2000 ii=1,ndmnx
      do 2000 j =1,my
      do 2000 i =1,mx
 2000   rhs(i,j,ii,jj) = 0.0d0

 2500 continue
 
      if(mod(ndmnx,2).eq.0)then
          iisrc = max(1,ndmnx/2)
          isrcx = mx
      else
          iisrc = (ndmnx+1)/2
          isrcx = (mx+1)/2
      endif

      if(mod(ndmny,2).eq.0)then
          jjsrc = max(1,ndmny/2)
          jsrcy = my
      else
          jjsrc = (ndmny+1)/2
          jsrcy = (my+1)/2
      endif

      nnsrcx = idgrid*((iisrc-1)*(mx-1)+isrcx-1)+1
      nnsrcy = idgrid*((jjsrc-1)*(my-1)+jsrcy-1)+1
      if(idrhs.eq.0) goto 9999
 
      srcxx = ax+dble(iisrc-1)*hhx+dble(isrcx-1)*hx
      srcyy = ay+dble(jjsrc-1)*hhy+dble(jsrcy-1)*hy
      if(level.ge.1) then
         print'(" the source=(",f6.3,",",f6.3,")",
     &          " in subdomain (",i2,",",i2,")")',
     &          srcxx,srcyy,iisrc,jjsrc
      endif

      rhs(isrcx,jsrcy,iisrc,jjsrc)=1.0

      if(isrcx.eq.mx .and. iisrc.lt.ndmnx)then
          rhs(1,jsrcy,iisrc+1,jjsrc)=1.0
      endif
      if(jsrcy.eq.my .and. jjsrc.lt.ndmny)then
          rhs(isrcx,1,iisrc,jjsrc+1)=1.0
      endif
      if(isrcx.eq.mx    .and. jsrcy.eq.my .and.
     &   iisrc.lt.ndmnx .and. jjsrc.lt.ndmny)then
          rhs(1,1,iisrc+1,jjsrc+1)=1.0
      endif
 
 9999 return
      end

c=======================================================================
      subroutine iguess0(ndim,x)
c=======================================================================
      integer ndim
      complex*8 x(*)
      integer i
 
      do i=1,ndim
          x(i)=0.d0
      enddo
 
      return
      end

c=======================================================================
      subroutine c_average
c=======================================================================
      include 'commons.h'
c
      jump=4
      c_zero = 0.
      c_mini = 100.
      c_maxi = 0.
      do 1000 jj = 1,ndmny
         bbbb = dble(jj-1)*hhy+ay
      do 1000 ii = 1,ndmnx
         aaaa = dble(ii-1)*hhx+ax
      do 1000  j = 1,my,jump
         py = dble(j-1)*hy +bbbb
      do 1000  i = 1,mx,jump
         px = dble(i-1)*hx +aaaa
         temp = cc(px,py)
         c_zero = c_zero+temp**2
         if(temp.gt.c_maxi) c_maxi = temp
         if(temp.lt.c_mini) c_mini = temp
 1000 continue
      ntmpx= (mx-1)/jump
      ntmpy= (my-1)/jump
      temp = dble((ntmpx+1)*(ntmpy+1)*ndmnx*ndmny)
      c_zero= sqrt(c_zero/temp)
c
 9999 return
      end
