c=======================================================================
      subroutine drivmg(a,x,rhs,truev,alpha,ahd,xh,fh,res,wksp,
     &                  nx2,ny2,nx3,ny3,ngrid,a2,f2,a3,f3,
     &                  iter2g,iterddm,err,ierr)
c=======================================================================
      include 'commons.h'
      complex*8 A(-mx:mx,lneqn,ndmnx,ndmny),x(neqn,*)
      complex*8 rhs(lneqn,ndmnx,ndmny),truev(1)
      complex*8 ahd(1),xh(nnnx,nnny),fh(1)
      complex*8 res(nnnx,nnny),alpha(1),wksp(nnnx*nnny,*)
      integer nx2,ny2,nx3,ny3,ngrid,iter2g,iterddm,ierr
      complex*8 a2(*),f2(*),a3(*),f3(*)
 
      real utime0,stime0,utime1,stime1,tarray(2)
      logical mg3,mg35,mg4

      mg3 =(ngrid.eq.3 .and. idgrid.eq.4)
      mg35=(ngrid.eq.3 .and. idgrid.eq.8)
      mg4 =(ngrid.eq.4 .and. idgrid.eq.8)

      if(mg35) then
         jump=4
      else
         jump=2
      endif

      if(level.ge.1) then
         print'("DRIV_MG: nnnx=",i4," nnny=",i4)',nnnx,nnny
         print*,"iterSGS=",iterSGS," idSGS=",idSGS," idCGNR=",idCGNR,
     &          " idgrid=",idgrid,
     &          " ngrid=",ngrid," ndmnx=",ndmnx," ndmny=",ndmny
         print'(" freq=",f4.1," ncc=",i1," iddirac=",i1,
     &          " tol2grid=",1pe7.1," tolddm=",1pe7.1)',
     &           freq,ncc,iddirac,tol2grid,tolddm
      endif

      do i=1,neqn
         wksp(i,1)=zero
      enddo

      if(idgrid.eq.1) then
        call rhstrue(rhs,truev)
      else
        idrhs=1
        call c4rhs(rhs,idrhs)
      endif
      call adop(alpha)
      call matrix(a,alpha)
      call ludecomp(a)
      call iguess0(nnneqn,xh)

      call c4anf(nnnx,nnny,iddirac,nnsrcx,nnsrcy,level,
     &      ax,bx,ay,by,omega,q,res0,ahd,fh)

      if(mg3.or.mg35.or.mg4) then
         ntmpx=(nnsrcx-1)/2+1
         ntmpy=(nnsrcy-1)/2+1
         call c4anf(nx2,ny2,iddirac,ntmpx,ntmpy,level,
     &         ax,bx,ay,by,omega,q,res2,a2,f2)
      endif

      if(mg4) then
         ntmpx=(nnsrcx-1)/4+1
         ntmpy=(nnsrcy-1)/4+1
         call c4anf(nx3,ny3,iddirac,ntmpx,ntmpy,level,
     &         ax,bx,ay,by,omega,q,res3,a3,f3)
      endif

c--------------

      if(level.ge.1) call etimef77(utime0,stime0)

      iterddm=0
      do 1000 iter2g=0,itmax2grid

         call iguess0(neqn,x)
         call solve(a,x,rhs,truev,alpha,wksp,iter,id2)
            if(idgrid.eq.1) goto 9999
            iterddm=iterddm+iter
         call reorder(1,mx,my,ndmnx,ndmny,nx,ny,x(1,id2),wksp)

         if(mg4) then
            call projection(2,2,nx3,ny3,nx,ny,wksp(1,2),wksp)
            if(idCGNR.eq.0)then
               call smoothGS(a3,wksp(1,2),f3,nx3,ny3,iterSGS,idSGS)
            else
               call cgnr23d(nx3,ny3,1,a3,wksp(1,2),f3,
     &                   wksp(1,3),wksp(1,4),wksp(1,5),wksp(1,6),
     &                   tol2grid,iterCG,iterSGS,0)
            endif
            call projection(2,2,nx2,ny2,nx3,ny3,wksp,wksp(1,2))
            if(idCGNR.eq.0)then
               call smoothGS(a2,wksp,f2,nx2,ny2,iterSGS,idSGS)
            else
               call cgnr23d(nx2,ny2,1,a2,wksp,f2,
     &                   wksp(1,3),wksp(1,4),wksp(1,5),wksp(1,6),
     &                   tol2grid,iterCG,iterSGS,0)
            endif
            call projection(2,2,nnnx,nnny,nx2,ny2,res,wksp)
         elseif(mg35.or.mg3) then
            call projection(2,jump,nx2,ny2,nx,ny,wksp(1,2),wksp)
            if(idCGNR.eq.0)then
               call smoothGS(a2,wksp(1,2),f2,nx2,ny2,iterSGS,idSGS)
            else
               call cgnr23d(nx2,ny2,1,a2,wksp(1,2),f2,
     &                   wksp(1,3),wksp(1,4),wksp(1,5),wksp(1,6),
     &                   tol2grid,iterCG,iterSGS,0)
            endif
            call projection(2,2,nnnx,nnny,nx2,ny2,res,wksp(1,2))
         else
            call projection(2,idgrid,nnnx,nnny,nx,ny,res,wksp)
         endif

         do j=1,nnny
         do i=1,nnnx
           xh(i,j)=xh(i,j)+res(i,j)
         enddo
         enddo
         if(idCGNR.eq.0)then
            call smoothGS(ahd,xh,fh,nnnx,nnny,iterSGS,idSGS)
         else
            call cgnr23d(nnnx,nnny,1,ahd,xh,fh,
     &                wksp(1,3),wksp(1,4),wksp(1,5),wksp(1,6),
     &                tol2grid,iterCG,iterSGS,0)
         endif

         call residual(nnnx,nnny,ahd,xh,fh,res,hhhx,r8,r2)
         relRES=r2/res0
         if(level.ge.2 .or. (level.ge.1.and.mod(iter2g,3).eq.0)) then
            print'(" rel_L8_res(",i3,")=",1pe8.2,"  (DDM=",i3,")")',
     &               iter2g,relRES,iter
         endif
         if (relRES.lt.tol2grid) then
            goto 8888
         else if (relRES.gt.2.0) then
            ierr=1
            goto 8888
         endif

         if(mg4) then
            call projection(1,2,nnnx,nnny,nx2,ny2,res,f2)
            call projection(1,2,nx2,ny2,nx3,ny3,f2,f3)
            call projection(1,2,nx3,ny3,nx,ny,f3,wksp)
         elseif(mg35.or.mg3) then
            call projection(1,2,nnnx,nnny,nx2,ny2,res,f2)
            call projection(1,jump,nx2,ny2,nx,ny,f2,wksp)
         else
            call projection(1,idgrid,nnnx,nnny,nx,ny,res,wksp)
         endif
         call reorder(2,mx,my,ndmnx,ndmny,nx,ny,rhs,wksp)

 1000 continue
c
 8888 iter2g=min(iter2g,itmax2grid)

      if(level.ge.1) call etimef77(utime1,stime1)

      if(iter2g.ge.itmax2grid) ierr=1
      if(level.le.0) return

      if(iddirac.eq.0) then
         call error2G(xh,nnnx,nnny,err)
      else
         err=0.0
      endif

      if(level.ge.1) then
         print'(" Rel_L8_residual(",i3,")=",1pe8.2)',iter2g,relRES
         if(iddirac.eq.0)then
            print'(" Rel_L8_error(",i3,")   =",1pe8.2)',iter2g,err
         endif
         print'(" Total DD iteration  =",i5)',iterddm
         print'("Elapsed Time=",f8.2)',utime1-utime0
         print'("Elapsed Time*0.862=",f8.2)',0.862*(utime1-utime0)
      endif

 9999 return
      end

