c=======================================================================
      subroutine cgnr23d(nx,ny,nz,a,x,b,r,p,ap,wksp,
     &                   tol,iter,it_max,level)
c=======================================================================
!  CGNR for 2D (if nz==1) and 3D
!  a(nx,ny,nz):  IN:  The diagonal of the FD matrix for "(-\Delta)*hx**2"
!  x(nx,ny,nz):  I/O: the initial guess / the solution
!  b(nx,ny,nz):  IN:  the right-hand side
!  r,p,ap,wksp:  work spaces
!-----------------------------------------------------------------------
      implicit none
      integer nx,ny,nz,iter,it_max,level
      real*4  tol
      complex*8 a(nx,ny,*),x(nx,ny,*),b(nx,ny,*)
      complex*8 r(nx,ny,*),p(nx,ny,*),ap(nx,ny,*)
      complex*8 wksp(nx,ny,*)

      integer i,j,k
      real*4  tol2,res0,res,residu
      complex*8 alfa,beta,ctmp,top,bot
 
      tol2 =tol*2.d0
 
!---- Print out

      if(level.ge.1)then
          print'("CGNR23D:",$)'
          print*,"nx=",nx," ny=",ny," nz=",nz
      endif
      if(level.ge.2)print*,"it_max=",it_max," tol=",tol

!---- initialization

      call mtxvec(nx,ny,nz,a,x,wksp,1)
      do k = 1,nz
      do j = 1,ny
      do i = 1,nx
          r(i,j,k)=b(i,j,k)-wksp(i,j,k)
      enddo
      enddo
      enddo

      call mtxvec(nx,ny,nz,a,r,p,2)

      do 100 k=1,nz
      do 100 j=1,ny
      do 100 i=1,nx
          r(i,j,k)=p(i,j,k)
 100  continue

      call l2norm(nx,ny,nz,r,res0)
 
c--------------------------------------------------------
      do 8888 iter=1,it_max
c--------------------------------------------------------

      call vecvec(nx,ny,nz,p,r,top)
      call mtxvec(nx,ny,nz,a,p,ap,1)
      call vecvec(nx,ny,nz,ap,ap,bot)
      alfa=top/bot
 
      do 1000 k = 1,nz
      do 1000 j = 1,ny
      do 1000 i = 1,nx
          x(i,j,k)=x(i,j,k)+alfa*p(i,j,k)
 1000 continue
 
      call mtxvec(nx,ny,nz,a,ap,wksp,2)
      do 1400 k = 1,nz
      do 1400 j = 1,ny
      do 1400 i = 1,nx
          r(i,j,k)=r(i,j,k)-alfa*wksp(i,j,k)
 1400 continue
 
      call l2norm(nx,ny,nz,r,res)
      residu = res/res0

      if(level.ge.2)then
          if(iter.eq.1.or.mod(iter,50).eq.0.or.residu.lt.tol2) then
             print'(5x,"residu(",i4,")= ",1pe7.1,"/",1pe7.1,"=",1pe9.2)'
     &             ,iter,res,res0,residu
          endif
      endif

      if(residu.lt.tol) goto 4444
 
      call mtxvec(nx,ny,nz,a,r,wksp,1)
      call vecvec(nx,ny,nz,ap,wksp,top)
      beta = -top/bot
 
      do 1600 k = 1,nz
      do 1600 j = 1,ny
      do 1600 i = 1,nx
          p(i,j,k)=r(i,j,k)+beta*p(i,j,k)
 1600 continue

c--------------------------------------------------------
 8888 continue
c--------------------------------------------------------
 
 4444 continue
      iter=min(iter,it_max)
 
 9999 return
      end


c=======================================================================
      subroutine mtxvec(nx,ny,nz,a,v,av,icase)
c=======================================================================
      implicit none
      integer nx,ny,nz,icase
      complex*8 a(nx,ny,*),v(nx,ny,*),av(nx,ny,*)
 
      integer i,j,k
      integer nxm1,nym1,nzm1
      integer im1,ip1,jm1,jp1,km1,kp1
      real*4  tx1,tx2,ty1,ty2,tz1,tz2

      if(nz.eq.0 .or. nz.eq.1) then
          goto(21,22) icase
      else if(nz.ge.2) then
          goto(31,32) icase
      endif

!=================================================
!--- 2D case
!=================================================

!------------------------------
 21   continue
!------------------------------
 
      do 100 k = 1,nz
      do 120 j = 1,ny
          ty1 = -1.d0
          ty2 = -1.d0
          jm1=j-1
          jp1=j+1
          if(j.eq.1) then
              ty1 = 0.d0
              ty2 = -2.d0
              jm1=j+1
          else if(j.eq.ny) then
              ty1 = -2.d0
              ty2 = 0.d0
              jp1=j-1
          endif
      do 140 i = 1,nx
          tx1 = -1.d0
          tx2 = -1.d0
          im1=i-1
          ip1=i+1
          if(i.eq.1) then
              tx1 = 0.d0
              tx2 = -2.d0
              im1=i+1
          else if(i.eq.nx) then
              tx1 = -2.d0
              tx2 = 0.d0
              ip1=i-1
          endif
          av(i,j,k) = a(i,j,k)*v(i,j,k)
     &              + tx1*v(im1,j,k) + tx2*v(ip1,j,k)
     &              + ty1*v(i,jm1,k) + ty2*v(i,jp1,k)
*    &              + tz1*v(i,j,km1) + tz2*v(i,j,kp1)
 140  continue
 120  continue
 100  continue

      goto 9999
 
!------------------------------
 22   continue
!------------------------------

      nxm1=nx-1
      nym1=ny-1
      nzm1=nz-1
 
      do 200 k = 1,nz
      do 220 j = 1,ny
          ty1 = -1.d0
          ty2 = -1.d0
          jm1=j-1
          jp1=j+1
          if(j.eq.1) then
              ty1 = 0.d0
              jm1=j+1
          else if(j.eq.2) then
              ty1 = -2.d0
          else if(j.eq.nym1) then
              ty2 = -2.d0
          else if(j.eq.ny) then
              ty2 = 0.d0
              jp1=j-1
          endif
      do 240 i = 1,nx
          tx1 = -1.d0
          tx2 = -1.d0
          im1=i-1
          ip1=i+1
          if(i.eq.1) then
              tx1 = 0.d0
              im1=i+1
          else if(i.eq.2) then
              tx1 = -2.d0
          else if(i.eq.nxm1) then
              tx2 = -2.d0
          else if(i.eq.nx) then
              tx2 = 0.d0
              ip1=i-1
          endif
          av(i,j,k) = conjg(a(i,j,k))*v(i,j,k)
     &              + tx1*v(im1,j,k) + tx2*v(ip1,j,k)
     &              + ty1*v(i,jm1,k) + ty2*v(i,jp1,k)
*    &              + tz1*v(i,j,km1) + tz2*v(i,j,kp1)
 240  continue
 220  continue
 200  continue
 
      goto 9999


!=================================================
!--- 3D case
!=================================================

!------------------------------
 31   continue
!------------------------------
 
      do 1000 k = 1,nz
          tz1 = -1.d0
          tz2 = -1.d0
          km1=k-1
          kp1=k+1
          if(k.eq.1) then
              tz1 = 0.d0
              tz2 = -2.d0
              km1=k+1
          else if(k.eq.nz) then
              tz1 = -2.d0
              tz2 = 0.d0
              kp1=k-1
          endif
      do 1200 j = 1,ny
          ty1 = -1.d0
          ty2 = -1.d0
          jm1=j-1
          jp1=j+1
          if(j.eq.1) then
              ty1 = 0.d0
              ty2 = -2.d0
              jm1=j+1
          else if(j.eq.ny) then
              ty1 = -2.d0
              ty2 = 0.d0
              jp1=j-1
          endif
      do 1400 i = 1,nx
          tx1 = -1.d0
          tx2 = -1.d0
          im1=i-1
          ip1=i+1
          if(i.eq.1) then
              tx1 = 0.d0
              tx2 = -2.d0
              im1=i+1
          else if(i.eq.nx) then
              tx1 = -2.d0
              tx2 = 0.d0
              ip1=i-1
          endif
          av(i,j,k) = a(i,j,k)*v(i,j,k)
     &              + tx1*v(im1,j,k) + tx2*v(ip1,j,k)
     &              + ty1*v(i,jm1,k) + ty2*v(i,jp1,k)
     &              + tz1*v(i,j,km1) + tz2*v(i,j,kp1)
 1400 continue
 1200 continue
 1000 continue

      goto 9999
 
!------------------------------
 32   continue
!------------------------------

      nxm1=nx-1
      nym1=ny-1
      nzm1=nz-1
 
      do 2000 k = 1,nz
          tz1 = -1.d0
          tz2 = -1.d0
          km1=k-1
          kp1=k+1
          if(k.eq.1) then
              tz1 = 0.d0
              km1=k+1
          else if(k.eq.2) then
              tz1 = -2.d0
          else if(k.eq.nzm1) then
              tz2 = -2.d0
          else if(k.eq.nz) then
              tz2 = 0.d0
              kp1=k-1
          endif
      do 2200 j = 1,ny
          ty1 = -1.d0
          ty2 = -1.d0
          jm1=j-1
          jp1=j+1
          if(j.eq.1) then
              ty1 = 0.d0
              jm1=j+1
          else if(j.eq.2) then
              ty1 = -2.d0
          else if(j.eq.nym1) then
              ty2 = -2.d0
          else if(j.eq.ny) then
              ty2 = 0.d0
              jp1=j-1
          endif
      do 2400 i = 1,nx
          tx1 = -1.d0
          tx2 = -1.d0
          im1=i-1
          ip1=i+1
          if(i.eq.1) then
              tx1 = 0.d0
              im1=i+1
          else if(i.eq.2) then
              tx1 = -2.d0
          else if(i.eq.nxm1) then
              tx2 = -2.d0
          else if(i.eq.nx) then
              tx2 = 0.d0
              ip1=i-1
          endif
          av(i,j,k) = conjg(a(i,j,k))*v(i,j,k)
     &              + tx1*v(im1,j,k) + tx2*v(ip1,j,k)
     &              + ty1*v(i,jm1,k) + ty2*v(i,jp1,k)
     &              + tz1*v(i,j,km1) + tz2*v(i,j,kp1)
 2400 continue
 2200 continue
 2000 continue
 
 9999 return
      end


c=======================================================================
      subroutine vecvec(nx,ny,nz,a,b,prod)
c=======================================================================
      implicit none
      integer nx,ny,nz
      complex*8 a(nx,ny,*),b(nx,ny,*)
      complex*8 prod
 
      integer i,j,k

      prod=0.d0

      do k=1,nz
      do j=1,ny
      do i=1,nx
          prod=prod+conjg(a(i,j,k))*b(i,j,k)
      enddo
      enddo
      enddo
 
      return
      end


c=======================================================================
      subroutine l2norm(nx,ny,nz,v,thenorm)
c=======================================================================
      implicit none
      integer nx,ny,nz
      complex*8 v(nx,ny,*)
      real*4 thenorm
 
      integer i,j,k

      thenorm =0.d0
      do 100 k=1,nz
      do 100 j=1,ny
      do 100 i=1,nx
          thenorm=thenorm+real(v(i,j,k))**2+imag(v(i,j,k))**2
 100  continue
      thenorm = sqrt(thenorm/real(nx*ny*nx))
 
 9999 return
      end


c=======================================================================
      subroutine l8norm(nx,ny,nz,v,thenorm)
c=======================================================================
      implicit none
      integer nx,ny,nz
      complex*8 v(nx,ny,*)
      real*4 thenorm
 
      integer i,j,k
      real*4  temp

      thenorm=0.0
      do 100 k = 1,nz
      do 100 j = 1,ny
      do 100 i = 1,nx
         temp=cabs(v(i,j,k))
         if(temp.gt.thenorm)thenorm=temp
 100  continue
 
 9999 return
      end


