c=======================================================================
      subroutine c4anf(nxx,nyy,iddirac,nnsrcx,nnsrcy,level,
     &      ax,bx,ay,by,omega,q,res0,ahd,fh)
c=======================================================================
      implicit none
      integer nxx,nyy,iddirac,nnsrcx,nnsrcy,level
      real    ax,bx,ay,by,omega,q,res0
      complex*8 ahd(nxx,nyy),fh(nxx,nyy)

      integer i,j
      real hxx,hyy,hh,wave
      real srcxx,srcyy,temp,px,py,cc
      complex*8 diag,bdry,r1prhs,im
 
      hxx = (bx-ax)/dble(nxx-1)
      hyy = (by-ay)/dble(nyy-1)
      hh  = hxx**2
      wave= (omega*hxx)**2
      im  = (0.0,1.0)
      diag= 4.+im*(q*hxx)**2
      bdry= im*2.0d0*omega*hxx
 
      do j = 1, nyy
          py = hyy*dble(j-1)+ay
      do i = 1, nxx
          px  = hxx*dble(i-1)+ax
          temp= cc(px,py)**2
          ahd(i,j)= diag-wave/temp
      enddo
      enddo
 
      if(iddirac.eq.0) then
 
         do j = 1,nyy
            ahd(1,j)  = ahd(1,j)  + bdry
            ahd(nxx,j)= ahd(nxx,j)+ bdry
         enddo
         do i = 1,nxx
            ahd(i,1)  = ahd(i,1)  + bdry
            ahd(i,nyy)= ahd(i,nyy)+ bdry
         enddo
 
         do j = 1, nyy
             py = hyy*dble(j-1)+ay
         do i = 1, nxx
             px = hxx*dble(i-1)+ax
             fh(i,j) = r1prhs(px,py)*hh
         enddo
         enddo

      else
 
         do j = 1,nyy
            py = hyy*dble(j-1)+ay
            ahd(1,j)  = ahd(1,j)  + bdry/cc(ax,py)
            ahd(nxx,j)= ahd(nxx,j)+ bdry/cc(bx,py)
         enddo
         do i = 1,nxx
            px = hxx*dble(i-1)+ax
            ahd(i,1)  = ahd(i,1)  + bdry/cc(px,ay)
            ahd(i,nyy)= ahd(i,nyy)+ bdry/cc(px,by)
         enddo

         do j = 1, nyy
         do i = 1, nxx
             fh(i,j)= 0.0
         enddo
         enddo

         srcxx = ax+dble(nnsrcx-1)*hxx
         srcyy = ay+dble(nnsrcy-1)*hyy
         if(level.ge.2) then
            print'(" the source=(",f6.3,",",f6.3,")")',srcxx,srcyy
         endif
         fh(nnsrcx,nnsrcy)=1.0

      endif

      res0=0.0
      do 10 j=2,nyy
      do 10 i=2,nxx
         res0=res0+cabs(fh(i,j))**2
 10   continue
      res0=sqrt(res0)*hxx
c
 9999 return
      end

