c=======================================================================
      subroutine driv2gtest(a,x,rhs,truev,alpha,ahd,xh,fh,res,wksp,
     &                  ngrid,iter2g,iterddm,err,ierr)
c=======================================================================
      include 'commons.h'
      complex*8 A(-mx:mx,lneqn,ndmnx,ndmny),x(neqn,*)
      complex*8 rhs(lneqn,ndmnx,ndmny),truev(1)
      complex*8 ahd(1),xh(nnnx,nnny),fh(1)
      complex*8 res(nnnx,nnny),alpha(1),wksp(1)
      integer ngrid,iter2g,iterddm,ierr
c
      integer i
      real utime0,stime0,utime1,stime1,tarray(2)

      if(level.ge.1) then
         print'("DRIV_2GTEST: nnnx=",i4," nnny=",i4)',nnnx,nnny
         print*,"iterSGS=",iterSGS," idSGS=",idSGS," idgrid=",idgrid,
     &          " ngrid=",ngrid," ndmnx=",ndmnx," ndmny=",ndmny
         print'(" freq=",f4.1," ncc=",i1," iddirac=",i1,
     &          " tol2grid=",1pe7.1," tolddm=",1pe7.1)',
     &           freq,ncc,iddirac,tol2grid,tolddm
      endif

      do 100 i=1,neqn
 100     wksp(i)=zero

      if(idgrid.eq.1) then
        call rhstrue(rhs,truev)
      else
        idrhs=1
        call c4rhs(rhs,idrhs)
      endif
      call adop(alpha)
      call matrix(a,alpha)
      call ludecomp(a)
      call iguess0(nnneqn,xh)
      call c4anf(nnnx,nnny,iddirac,nnsrcx,nnsrcy,level,
     &      ax,bx,ay,by,omega,q,res0,ahd,fh)

c--------------

      if(level.ge.1) call etimef77(utime0,stime0)

      iterddm=0
      do 1000 iter2g=0,itmax2grid

         call iguess0(neqn,x)
         call solve(a,x,rhs,truev,alpha,wksp,iter,id2)
            if(idgrid.eq.1) goto 9999
            iterddm=iterddm+iter

         call reorder(1,mx,my,ndmnx,ndmny,nx,ny,x(1,id2),wksp)

!======================
         if(iter2g.eq.0)then
            call error2G(wksp,nx,ny,err)
            print'(" ****** Rel_L8_error=",1pe8.2," ******")',err
            open(68,file="fort.1")
               write(68,*) nx,ny
               write(68,*) ax,hx,ay,hy
            close(68)
            open(68,file="fort.U_Re")
            open(69,file="fort.U_Im")
               do i=1,nx*ny
                  write(68,*) real(wksp(i))
                  write(69,*) imag(wksp(i))
               enddo
            close(68)
            close(69)
         endif
!======================

         call projection(2,idgrid,nnnx,nnny,nx,ny,res,wksp)
         do j=1,nnny
         do i=1,nnnx
           xh(i,j)=xh(i,j)+res(i,j)
         enddo
         enddo
         call smoothGS(ahd,xh,fh,nnnx,nnny,iterSGS,idSGS)

         call residual(nnnx,nnny,ahd,xh,fh,res,hhhx,r8,r2)
            relRES=r2/res0
            if(level.ge.1) then
               print'(" rel_L2_res(",i3,")=",1pe8.2,"  (DDM=",i3,")")',
     &                  iter2g,relRES,iter
            endif
            if (relRES.lt.tol2grid) then
               goto 8888
            else if (relRES.gt.2.0) then
               ierr=1
               goto 8888
            endif
         call projection(1,idgrid,nnnx,nnny,nx,ny,res,wksp)
         call reorder(2,mx,my,ndmnx,ndmny,nx,ny,rhs,wksp)

 1000 continue
c
 8888 iter2g=min(iter2g,itmax2grid)

      if(level.ge.1) call etimef77(utime1,stime1)

      if(iter2g.ge.itmax2grid) ierr=1
      if(level.le.0) return

      if(iddirac.eq.0) then
         call error2G(xh,nnnx,nnny,err)
      else
         err=0.0
      endif

      print'(" Rel_L2_residual(",i3,")=",1pe8.2
     &      /" Rel_L8_error(",i3,")   =",1pe8.2
     &      /" Total DD iteration  =",i5)',
     &         iter2g,relRES,iter2g,err,iterddm
      if(level.ge.1) print'("Elapsed Time=",f8.2)',utime1-utime0

c
 9999 return
      end

