c====================================================================
      subroutine cendif(mode,in,out,dt,nt,
     &     idbg,ipdmp,ier)
c
c this routine applies a centered difference operaror
c to trace in and puts it in out 
c Roelof Versteeg
c June 1993
c rev WWS 12.94 - per boundary condns, mode flag - computes adjoint
c as well as fwd.

      integer nt,ier,idbg,ipdmp,i
      real dt,dt2
      real out(nt),in(nt)
      character*3 mode

      dt2=1.0e+00/(2.0e+00*dt)
      
      if (mode.eq.'fwd') then
         do i=2,nt-1
            out(i)=(in(i+1)-in(i-1))*dt2
         end do
         out(1)=(in(2)-in(nt))*dt2
         out(nt)=(in(1)-in(nt-1))*dt2
      else if (mode.eq.'adj') then
         do i=2,nt-1
            out(i)=(in(i-1)-in(i+1))*dt2
         end do
         out(1)=(in(nt)-in(2))*dt2
         out(nt)=(in(nt-1)-in(1))*dt2
      else
         write(ipdmp,*)' Error: CENDIF'
         write(ipdmp,*)' unknown mode flag = ',mode
         write(ipdmp,*)' only legit values are fwd and adj'
         ier=1
         return
      end if

      return
      end

c====================================================================
      subroutine indefint(in,out,dt,nt,
     &     idbg,ipdmp,ier)
c
c this routine constructs the indefinite integral of
c trace in and puts it in out 
c
c THIS IS A TEMPORARY KLUDGE - WWS 22.08.95
c SHOULD BE DONE IN FREQUENCY DOMAIN TO BE EXACT INVERSE OF 
c PERIODIC CENTRAL DIFFERENCE OPERATOR

      integer nt,ier,idbg,ipdmp,i
      real dt,dt2
      real out(nt),in(nt)

      dt2=2.0e+00*dt
      out(1)=0.0e+00
      out(2)=0.0e+00
      do i=3,nt
         out(i)=out(i-2)+dt2*in(i)
      end do

      return
      end

c============================================================================

      subroutine  mute_and_taper(seism,seismnt,seismnx,
     &     firstrec,nblock,t0, tf, mv, wmz, ntap,
     &     seismxorig,seismdx,seismdt,seismxsorig,seismdxs,
     &     gather_type,ipdmp,ier)
c     
c     this subroutine applies a mute and taper
c     to the records in seism
c     
      integer seismnt,seismnx,firstrec,nblock,ntap
      real t0, tf, mv, wmz
      integer ier,i,ipdmp,idbg,ntap_tmp
      
      real seismxorig,seismdx,seismdt,xoffset,seismxsorig,seismdxs

      character*3 gather_type
      
      real seism(seismnt,seismnx,1:nblock)
      
c      call get_debug_level('mute_taper','idbg',idbg,ier)
      if(idbg.ge.1)then
         write(ipdmp,*)' MUTE AND TAPER : '
         write(ipdmp,*)' t0    : ',t0
         write(ipdmp,*)' tf    : ',tf
         write(ipdmp,*)' mv    : ',mv
         write(ipdmp,*)' wmz   : ',wmz
         write(ipdmp,*)' ntap  : ',ntap
         write(ipdmp,*)' seismnt : ',seismnt
         write(ipdmp,*)' seismnx : ',seismnx
         write(ipdmp,*)' firstrec : ',firstrec
         write(ipdmp,*)' nblock   : ',nblock
         write(ipdmp,*)' gather_type : ',gather_type
      end if
      
      do i=1,nblock

c     if common offset, calculate offset, do no tapering
c     if common source, taper as indicated

         if (gather_type.eq.'COG') then
            xoffset=seismxsorig+(i-1+firstrec-1)*seismdxs
            ntap_tmp=0
         else if (gather_type.eq.'CSG') then
            ntap_tmp=ntap
         end if
         
         call tapershot(seism(1,1,i),seismnt,seismnx,
     &        ntap_tmp,ipdmp,ier)
         if (ier.ne.0) then
            write(ipdmp,*)' Error: SHOOT from TAPER 1'
            return
         end if
         
         call muteshot(seism(1,1,i),seism(1,1,i),xoffset,
     &        seismnt,seismnx,seismdt,
     &        seismxorig,seismdx,
     &        t0,tf,mv,wmz,
     &        gather_type,ipdmp,ier)
         if (ier.ne.0) then
            write(ipdmp,*)' Error: SHOOT from MUTEREC 1'
            return
         end if
         
      end do
      return
      end
         
c====================================================================================
      
      subroutine tapershot (a,seismnt,seismnx,ntap,ipdmp,ier)
c     
c     tapers ends of record a over ntap traces
c     
      integer ntap,ier,seismnt,seismnx
      real a(seismnt,seismnx)
      integer i,j,ipdmp
      integer fi
      real da,fa
c     
c     n <= 0 signifies no tapering
c     
      if (ntap.le.0) then
         return
      end if
c     
c     both ends at once!!
c     
      da=1/float(ntap)
      do 100 i=1,ntap
         fi=seismnx-i+1
         fa=(i-1)*da
         do 50 j=1,seismnt
            a(j,i) = fa * a (j,i)
            a(j,fi) = fa * a (j,fi)
 50      continue
 100  continue
c     
      return
      end
         
c====================================================================================
         
      subroutine muteshot(recin,recout,xoffset,
     &     seismnt,seismnx,seismdt,
     &     seismxorig,seismdx,
     &     t0, tf, mv, wmz,
     &     gather_type,ipdmp,ier)
c     
c------------------------------------------------------------
c     
c     Linear mute for shot records. 
c     After the time tf the data are set to 0
c     Note that this is slightly different from the
c     a2cpo/muterec. where output and input records
c     can have a different length.
c     
c     Roelof Versteeg
c     after WWS
c     August 1993
c     revised WWS 11.94
c------------------------------------------------------------
c     
      real t0, tf, mv, ms, wmz
      integer ier,seismnt,seismnx,idbg,ipdmp
      real  seismxorig,seismdx,seismdt
      real recin(seismnt,seismnx), recout(seismnt,seismnx)
c     
      integer i, j
      real dt, t, xoffset, t1, t2, t3, slope, tmax, mute
c     
      character*3 gather_type
c     
c------------------------------------------------------
c     
      if (ier.ne.0) return
      
c      call get_debug_level('muteshot','idbg',idbg,ier)      
      if(idbg.ge.1)then
         write(ipdmp,*)' MUTESHOT'
         write(ipdmp,*)' t0   : ',t0
         write(ipdmp,*)' tf   : ',tf
         write(ipdmp,*)' wmz  : ',wmz
         write(ipdmp,*)' mv   : ',mv
         write(ipdmp,*)' gather_type : ',gather_type
      end if
      
      if (mv.lt.(1.0e-6)) then
         write(ipdmp,*)' Error: MUTESHOT'
         write(ipdmp,*)' mute velocity too small: mv = ',mv
         ier=91
         return
      end if
      ms = 1.0/mv
      dt = seismdt
      if ((1.0e+5)*dt.lt.tf) then
         ier = 92
         write(ipdmp,*)' Error: MUTESHOT'
         write(ipdmp,*)' dt too small: = ',dt
         return
      end if
      if (tf.lt.dt) then
         ier=93
         write(ipdmp,*)' Error: MUTESHOT'
         write(ipdmp,*)' final time too small: tf < dt'
         write(ipdmp,*)' dt = ',dt,' tf = ',tf
         return
      end if
      tmax = dt*seismnt
      t3 = tf - wmz
      
      if (wmz.gt.dt) then
         slope = 1.0/wmz
      else
         slope = 0.5
      end if
      
      do 200 j=1,seismnx
         if (gather_type.eq.'CSG') then
            xoffset = abs(seismxorig+(j-1)*seismdx)
         else if (gather_type.ne.'COG') then
            write(ipdmp,*)' Error: MUTESHOT'
            write(ipdmp,*)' undefined gather type = '
            write(ipdmp,*)gather_type
            ier=1
            return
         end if
         t1 = t0 + ms*xoffset
         t2 = t1 + wmz
         if(idbg.ge.1)then
            write(ipdmp,*)' t1     : ',t1
            write(ipdmp,*)' t2     : ',t2
            write(ipdmp,*)' t3     : ',t3
            write(ipdmp,*)' tf     : ',tf
            write(ipdmp,*)' slope  : ',slope
         end if
         
         do 100 i=1,seismnt 
            t = (i-1)*dt
            if (t.lt.t1) then
               mute = 0.
            end if
            if (t.ge.t1) then
               mute = slope*(t - t1)
            end if
            if (t.ge.t2) then
               mute = 1.
            end if
            if (t.ge.t3) then
               mute = mute*slope*(tf - t)
            end if
            if(t.ge.tf) then
               mute = 0.
            end if
            recin(i,j) = mute * recin(i,j)
 100     continue
 200  continue
c     
      return 
      end

c============================================================================

      subroutine cutoff(nz,nx,nblock,a,datum,dz,ier)

c cuts off array a at datum depth, then tapers over a hard-wired
c margin - current assumption is that ten points is equivalent to 
c a wavelength at peak frequency, so that is selected.

c internal to this routine, the data array is considered to be defined
c over a regular rectangular grid with upper left hand corner at (0,0).
c this may or may not be true in the calling routine - in particular
c the parameter datum should be the depth of the cutoff from the top
c of the grid of a. if datum is negative cutoff is skipped.

      integer nz,nx,nblock,ier
      real datum,dz,a(nz,nx,nblock)

      integer ntaper
      parameter (ntaper=11)

      integer i,j,k,istart
      real dtaper

c skip cutoff if datum is negative

      istart=1

      if (datum.gt.(0.0e+00)) then

         istart=nint(datum/(abs(dz)+1.0e-4))+1

         do k=1,nblock
            do j=1,nx
               do i=1,istart
                  a(i,j,k)=0.0e+00
               end do
            end do
         end do

      end if

c taper if ntaper > 1

      if (ntaper.gt.1) then
         dtaper=1.0e+00/float(ntaper-1)
         do k=1,nblock
            do j=1,ntaper
CDIR$ NORECURRENCE
               do i=istart,nz
                  a(i,j,k)=
     &                 float(j-1)*dtaper*a(i,j,k)
                  a(i,nx-j+1,k)=
     &                 float(ntaper-j)*dtaper*
     &                 a(i,nx-j+1,k)
               end do
            end do
            do j=1,nx
CDIR$ NORECURRENCE
               do i=1,ntaper
                  a(istart+i-1,j,k)=
     &                 float(i-1)*dtaper*
     &                 a(istart+i-1,j,k)
                  a(nz-i+1,j,k)=
     &                 float(ntaper-i)*dtaper*
     &                 a(nz-i+1,j,k)
               end do
            end do
         end do
      end if

      return
      end

c======================================================================================

      subroutine modelt(model)

      character*(*) model

      model(1:10)='kirch     '

      return
      end


      
      subroutine normal_trace_mute(trace,trace_index,gather_index,
     &     seismnt,seismnx,seismnxs,t0, tf, mv, wmz, ntaper,
     &     seismxorig,seismdx,seismdt,seismxsorig,
     &     seismdxs,gather_type,ipdmp,ier)

c     invented to apply mute and taper operations to a trace TWICE
c     (i.e. all factors squared) for use in normal map

      integer trace_index,gather_index
      integer ntaper
      integer seismnt,seismnx,seismnxs
      real trace(seismnt),t0,tf,mv,wmz,
     &     seismxorig,seismdx,seismdt,seismxsorig,seismdxs
      character*3 gather_type
      integer ipdmp,ier
      integer i,idbg
      real da,fa
      real dt, t, xoffset, ms, t1, t2, t3, slope, tmax, mute

      if (ier.ne.0) return
c      call get_debug_level('normal_mute','idbg',idbg,ier)

      if(idbg.ge.1)then
         write(ipdmp,*)' NORMAL_MUTE'
         write(ipdmp,*)' t0   : ',t0
         write(ipdmp,*)' tf   : ',tf
         write(ipdmp,*)' wmz  : ',wmz
         write(ipdmp,*)' mv   : ',mv
         write(ipdmp,*)' trace_index    : ',trace_index
         write(ipdmp,*)' gather_index   : ',gather_index
         write(ipdmp,*)' ntaper         : ',ntaper
         write(ipdmp,*)' gather_type    : ',gather_type
         write(ipdmp,*)' seismxorig     : ',seismxorig
         write(ipdmp,*)' seismdx        : ',seismdx
         write(ipdmp,*)' seimdt         : ',seismdt
         write(ipdmp,*)' seimxsorig     : ',seismxsorig
         write(ipdmp,*)' seismdxs       : ',seismdxs
         write(ipdmp,*)' seismnt        : ',seismnt
         write(ipdmp,*)' seismnx        : ',seismnx
         if (idbg.ge.2) then
            write(ipdmp,*)' input trace:'
            write(ipdmp,1000)(trace(i),i=1,seismnt)
         end if
      end if
      
      if (mv.lt.(1.0e-6)) then
         write(ipdmp,*)' Error: MUTESHOT'
         write(ipdmp,*)' mute velocity too small: mv = ',mv
         ier=91
         return
      end if
      ms = 1.0/mv
      dt = seismdt
      if ((1.0e+5)*dt.lt.tf) then
         ier = 92
         write(ipdmp,*)' Error: MUTESHOT'
         write(ipdmp,*)' dt too small: = ',dt
         return
      end if
      if (tf.lt.dt) then
         ier=93
         write(ipdmp,*)' Error: MUTESHOT'
         write(ipdmp,*)' final time too small: tf < dt'
         write(ipdmp,*)' dt = ',dt,' tf = ',tf
         return
      end if
      tmax = dt*(seismnt-1)
      t3 = tf - wmz
      
      if (wmz.gt.dt) then
         slope = 1.0/wmz
      else
         slope = 0.5
      end if
      
      if (gather_type.eq.'CSG') then
         xoffset = abs(seismxorig+(trace_index-1)*seismdx)
      else if (gather_type.eq.'COG') then
         xoffset = abs(seismxsorig+(gather_index-1)*seismdxs)
      else
         write(ipdmp,*)' Error: MUTESHOT'
         write(ipdmp,*)' undefined gather type = '
         write(ipdmp,*)gather_type
         ier=1
         return
      end if
      t1 = t0 + ms*xoffset
      t2 = t1 + wmz
      if(idbg.ge.1)then
         write(ipdmp,*)' t1     : ',t1
         write(ipdmp,*)' t2     : ',t2
         write(ipdmp,*)' t3     : ',t3
         write(ipdmp,*)' tf     : ',tf
         write(ipdmp,*)' slope  : ',slope
      end if
         
      do i=1,seismnt 
         t = (i-1)*dt
         if (t.lt.t1) then
            mute = 0.
         end if
         if (t.ge.t1) then
            mute = slope*(t - t1)
         end if
         if (t.ge.t2) then
            mute = 1.
         end if
         if (t.ge.t3) then
            mute = mute*slope*(tf - t)
         end if
         if(t.ge.tf) then
            mute = 0.
         end if

c     NOTE THAT HERE WE SQUARE THE MUTE AMPLITUDE!

         trace(i) = mute * mute * trace(i)
      end do

c     TAPER

c     n <= 0 signifies no tapering

      if (ntaper.le.0) then
         return
      end if

c     also if trace is within source gather and not muted

      if (gather_type.eq.'CSG') then
         if ((trace_index.gt.ntaper).and.
     &        (trace_index.lt.seismnx-ntaper+1)) then
            if (idbg.ge.2) then
               write(ipdmp,*)' output trace:'
               write(ipdmp,1000)(trace(i),i=1,seismnt)
            end if
            return
         end if
      else if (gather_type.eq.'COG') then
         if ((gather_index.gt.ntaper).and.
     &        (gather_index.lt.seismnxs-ntaper+1)) then
            if (idbg.ge.2) then
               write(ipdmp,*)' output trace:'
               write(ipdmp,1000)(trace(i),i=1,seismnt)
            end if
            return
         end if
      else
         write(ipdmp,*)' Error: NORMAL_MUTE'
         write(ipdmp,*)' illegal gather type = ',gather_type
         ier=1
         return
      end if

      da=1.0e+00/float(ntaper)      
      fa=1.0e+00
      if (gather_type.eq.'COG') then
         if (gather_index.le.ntaper) then
            fa=(gather_index-1)*da
         else if (gather_index.ge.seismnxs-ntaper+1) then
            fa=(seismnxs-gather_index)*da
         end if
      else if (gather_type.eq.'CSG') then
         if (trace_index.le.ntaper) then
            fa=(trace_index-1)*da
         else if (trace_index.ge.seismnx-ntaper+1) then
            fa=(seismnx-trace_index)*da
         end if
      end if

c     NOTE THAT HERE WE SQUARE THE TAPER!

      do i=1,seismnt
         trace(i) = fa * fa * trace(i)
      end do

      if (idbg.ge.2) then
         write(ipdmp,*)' output trace:'
         write(ipdmp,1000)(trace(i),i=1,seismnt)
      end if

 1000 format(6(e10.4,2x))

      return
      end
         


