c====================================================================
      subroutine cendif2(in,out,dt,nt,idbg,ipdmp,ier)
c
c this routine applies a centered difference operaror
c    for the second time-derivative
c we do not assume that the data is periodic

c June 1997 SKIM

      integer nt,ier,idbg,ipdmp,i,ntm1
      real dt,dt2
      real out(nt),in(nt)

      ntm1=nt-1
      dt2=1.0e+00/(dt*dt)
      
CDIR$ NORECURRENCE
      do i=2,ntm1
         out(i)=(in(i-1)-2.*in(i)+in(i+1))*dt2
      end do

c use one-sided second order differences at boundary points
c the four point contribution is (2, -5, 4, -1)/dt^2

      out(1) =( 2.*in(1) -5.*in(2)   +4.*in(3)   -in(4)    )*dt2
      out(nt)=( 2.*in(nt)-5.*in(nt-1)+4.*in(nt-2)-in(nt-3) )*dt2

      return
      end

c============================================================================

      subroutine cutoff3d(nz,nx,ny,nblock,a,datum,dz,ntaper,ier)

c cuts off array a at datum depth, then tapers over a hard-wired margin

c internal to this routine, the data array is considered to be defined
c over a regular rectangular grid with upper left hand corner at (0,0).
c this may or may not be true in the calling routine - in particular
c the parameter datum should be the depth of the cutoff from the top
c of the grid of a. if datum is negative cutoff is skipped.

      integer nz,nx,ny,nblock,ntaper,ier
      real datum,dz,a(nz,nx,ny,nblock)

      integer i,j,k,istart
      real dtaper,factor

c skip cutoff if datum is negative

      istart=1
      if (datum.le.(0.0e+00)) goto 1000

      istart=nint(datum/(abs(dz)+1.0e-4))+1

      do m=1,nblock
CDIR$ NORECURRENCE
      do k=1,ny
      do j=1,nx
      do i=1,istart
          a(i,j,k,m)=0.0e+00
      end do
      end do
      end do
      end do

 1000 continue

c taper if ntaper .ge. 1

      if (ntaper.lt.1) return

      dtaper=1.0e+00/float(ntaper)

      do 2000 m=1,nblock

c the 3rd (y) direction

CDIR$ NORECURRENCE
         do k=1,ntaper
             factor=float(k-1)*dtaper
         do j=1,nx
         do i=istart,nz
             a(i,j,k,m)=factor*a(i,j,k,m)
         end do
         end do
         end do

CDIR$ NORECURRENCE
         do k=1,ntaper
             factor=float(k-1)*dtaper
             kk=ny-k+1
         do j=1,nx
         do i=istart,nz
             a(i,j,kk,m)= factor*a(i,j,kk,m)
         end do
         end do
         end do

c the second (x) direction

CDIR$ NORECURRENCE
         do k=1,ny
         do j=1,ntaper
             factor=float(j-1)*dtaper
         do i=istart,nz
             a(i,j,k,m)=factor*a(i,j,k,m)
         end do
         end do
         end do

CDIR$ NORECURRENCE
         do k=1,ny
         do j=1,ntaper
             factor=float(j-1)*dtaper
             jj=nx-j+1
         do i=istart,nz
             a(i,jj,k,m)=factor*a(i,jj,k,m)
         end do
         end do
         end do

c the first (z) direction

CDIR$ NORECURRENCE
         do k=1,ny
         do j=1,nx
         do i=1,ntaper
             factor=float(i-1)*dtaper
             iia=istart+i-1
             iib=nz-i+1
             a(iia,j,k,m)=factor*a(iia,j,k,m)
             a(iib,j,k,m)=factor*a(iib,j,k,m)
         end do
         end do
         end do

 2000 continue

      return
      end

c====================================================================
      subroutine guassian(f,nf,dt,tt,freq)

      real f(nf)
      real dt,       ! the time interval
     &     tt,       ! the traveltime from the source
     &     freq      ! the frequency

      pi =3.1415927
      fac=(pi*freq)**2
      tol=1.0e-08

CDIR$ NORECURRENCE
      do i=1,nf
         time=(float(i-1)*dt-tt)*0.001
         if (time.lt.(-tol)) then
            f(i)=0.0
         else
            f(i)=exp(-fac*time*time)
*            if(f(i).lt.tol) f(i)=0.0
         end if
      end do
         
      return
      end

c====================================================================
      subroutine ricker(f,nf,dt,tt,freq,amp)

      real f(nf)
      real dt,       ! the time interval
     &     tt,       ! the traveltime from the source
     &     freq,     ! the frequency
     &     amp       ! the amplitude factor

      pi =3.1415927
      fac=(pi*freq)**2
      fac2=2.*amp*fac
      tol=1.0e-08

CDIR$ NORECURRENCE
      do i=1,nf
         time=(float(i-1)*dt-tt)*0.001
         if (time.ge.(-tol)) then
            temp=fac*time*time
            f(i)=f(i) +fac2*(1.0-2.0*temp)*exp(-temp)
         end if
      end do
         
      return
      end
