c========================= transport_rhs3d =======================

      subroutine transport_rhs3d(nx, ny, nz, iz,  
     &     ssi, ssz, tt, amp, rhs,
     &     tx, ty, txx, tyy, txy, ham, apcut,
     &     dx, dy, dz, dz_loc, step_total,
     &     lenwork,work,ipdmp,idbg,ier,id_eno)
c---------------------------------------------------------------------
c    UPWIND TRANSPORT SOLVER
c
c    Produces 2nd order Beam-Warming rhs for 
c    transport equation. Written for log amp version of
c    transport equation:
c
c    2 \nabla \tau \cdot \nabla (\log a) + \nabla^2 \tau = 0
c
c    Uses upwind first differences, centered second differences 
c    of travel time, (these are passed from EIKONAL_RHS) and upwind
c    second order differences of amplitudes. Modifies rhs to reduce
c    out-of-aperture amplitudes
c
c    WWS    12.93
c    RV     02.94
c    RV     05.94 (loops unrolled for IBM)
c    WWS    07.94
c    SKIM   06.97
c---------------------------------------------------------------------
c--Arguments
      integer
     &     nx, ny, nz,          ! grid dimensions
     &     iz,                  ! current depth step
     &     lenwork,             ! length of "work"
     &     idbg,ipdmp,ier,      ! debug and error
     &     id_eno               ! 2nd-order ENO ux & uy (=1:ENO, =0:one-sided)
      real 
     &     step_total,          ! total step taken so far
     &     dx,dy,               ! horizontal step
     &     dz,dz_loc,           ! vertical step
     &     ssi(nx,ny),          ! square slowness array - interpolated
     &     ssz(nx,ny),          ! z-derivative of square slowness
     &     tt(nx,ny),           ! travel time at current depth
     &     amp(nx,ny),          ! amplitude at current depth
     &     rhs(nx,ny),          ! rhs for transp. scheme
     &     tx(nx,ny),           ! ENO first divided x-diff of tt
     &     ty(nx,ny),           ! ENO first divided y-diff of tt
     &     txx(nx+2,ny),        ! second divided x-diff of tt (centered)
     &     tyy(nx,ny+2),        ! second divided y-diff of tt (centered)
     &     apcut(nx,ny),        ! aperture cut
     &     ham(nx,ny),          ! hamiltonian = tz
     &     txy(nx,ny),          ! buffer for tx 1st difference in y
     &     work(nx,ny,1)        ! workspace

      real zero,divdz,divdx,divdy,div2dx,div2dy,slap_max

      integer id_ssx,id_ssy,id_slap,
     &        id_uxm,id_uxp,id_uym,id_uyp,workptr 

      data decay /1.0e+00/
c-----------------------------------------------------------------------

      if (ier.ne.0) return

c==Allocate memory

      id_ssx=1
      id_ssy=2
      id_slap=3
      id_uxm=4
      id_uym=5
      id_uxp=6
      id_uyp=7

      if (lenwork.lt.(7*nx*ny)) then
         write(ipdmp,*) ' Error: TRANS_RHS: lenwork too small'
         ier=ier+1
         return
      end if

c==Useful numbers

      zero=0.0e+00
      nxm1=nx-1
      nxm2=nx-2
      nym1=ny-1
      nym2=ny-2
      divdx=1./dx
      divdy=1./dy	
      divdz=1./dz
      div2dx=1./(2.*dx)
      div2dy=1./(2.*dy)

c==square slowness second order first difference in x,y-directions,
c  linearly extrapolated at ends

      do jy=1,ny
      do jx=2,nxm1
         work(jx,jy,id_ssx)=(ssi(jx+1,jy)-ssi(jx-1,jy))*div2dx
      end do
      end do

      do jy=1,ny
         work(1,jy,id_ssx)=2.*work(2,jy,id_ssx)-work(3,jy,id_ssx)
         work(nx,jy,id_ssx)=2.*work(nxm1,jy,id_ssx)-work(nxm2,jy,id_ssx)
      end do

      do jy=2,nym1
      do jx=1,nx
         work(jx,jy,id_ssy)=(ssi(jx,jy+1)-ssi(jx,jy-1))*div2dy
      end do
      end do

      do jx=1,nx
         work(jx,1,id_ssy)=2.*work(jx,2,id_ssy)-work(jx,3,id_ssy)
      end do

      do jx=1,nx
         work(jx,ny,id_ssy)=2.*work(jx,nym1,id_ssy)-work(jx,nym2,id_ssy)
      end do

c==now we can get "Laplacian\tau"

      do 1000 jy=1,ny
      do 1200 jx=1,nx

         taux=tx(jx,jy)
         tauy=ty(jx,jy)
         tauz=ham(jx,jy)
         tauxx=txx(jx+1,jy)
         tauyy=tyy(jx,jy+1)
         tauxy=txy(jx,jy)
         rtauz=1.0/tauz

         tauzz=( 0.5*( tauz*ssz(jx,jy)-taux*work(jx,jy,id_ssx)
     &                -tauy*work(jx,jy,id_ssy) )
     &            +taux**2*tauxx +tauy**2*tauyy +2.*taux*tauy*tauxy )
     &         * (rtauz**2)

         work(jx,jy,id_slap)=0.5*rtauz*(tauxx+tauyy+tauzz)

 1200 continue
 1000 continue

c==determine max of slap, apply aperture cutoff - outside of aperture
c  make inhomogeneous term equal to decay * max in aperture

      slap_max=zero
      do jy=1,ny
      do jx=1,nx
         slap_max=max(slap_max,work(jx,jy,id_slap))
      end do
      end do

      do jy=1,ny
      do jx=1,nx
         tmpcut=apcut(jx,jy)
         work(jx,jy,id_slap)=tmpcut*work(jx,jy,id_slap)
     &          +decay*(1.-tmpcut)*slap_max
      end do
      end do

c--choose one of finite difference schemes for ux and uy.
c-----------------------------------------------------------
      goto(10,20) (id_eno+1)
c-----------------------------------------------------------

 10   continue
c==one-sided second order difference of amplitude

c--id_uxm

      do jy=1,ny
      do jx=3,nx
         work(jx,jy,id_uxm)=(1.5*amp(jx,jy)-2.0*amp(jx-1,jy)
     &      +0.5*amp(jx-2,jy))*divdx
      end do
      end do

      do jy=1,ny
         work(2,jy,id_uxm)=(amp(3,jy)-amp(1,jy))*div2dx
         work(1,jy,id_uxm)=work(2,jy,id_uxm)
      end do

c--id_uxp

      do jy=1,ny
      do jx=1,nxm2
         work(jx,jy,id_uxp)=(-1.5*amp(jx,jy)+2.0*amp(jx+1,jy)
     &      -0.5*amp(jx+2,jy))*divdx
      end do
      end do

      do jy=1,ny
         work(nxm1,jy,id_uxp)=(amp(nx,jy)-amp(nxm2,jy))*div2dx
         work(nx,  jy,id_uxp)=work(nxm1,jy,id_uxp)
      end do

c--id_uym

      do jy=3,ny
      do jx=1,nx
         work(jx,jy,id_uym)=(1.5*amp(jx,jy)-2.0*amp(jx,jy-1)
     &      +0.5*amp(jx,jy-2))*divdy
      end do
      end do

      do jx=1,nx
         work(jx,2,id_uym)=(amp(jx,3)-amp(jx,1))*div2dy
         work(jx,1,id_uym)=work(jx,2,id_uym)
      end do
 
c--id_uyp

      do jy=1,nym2
      do jx=1,nx
         work(jx,jy,id_uyp)=(-1.5*amp(jx,jy)+2.0*amp(jx,jy+1)
     &      -0.5*amp(jx,jy+2))*divdy
      end do
      end do

      do jx=1,nx
         work(jx,nym1,id_uyp)=(amp(jx,ny)-amp(jx,nym2))*div2dy
         work(jx,ny,  id_uyp)=work(jx,nym1,id_uyp)
      end do

      goto 100
 
 20   continue

c==2nd-order ENO schemes for ux and uy
c  e.g.  dd1 = [(D^+)(D^-)u]*dx/2
c-----------------------------------------------------------
c--id_uxm & id_uxp

      do jy=1,ny
         jx=2
            jxm1=jx-1
            d0  =(amp(jx,jy)-amp(jxm1,jy))*divdx
            dd1 =(amp(jxm1,jy)-2.0*amp(jx,jy)+amp(jx+1,jy))*div2dx
            work(jx,  jy,id_uxm)=d0+dd1
            work(jxm1,jy,id_uxp)=d0-dd1
            work(jxm1,jy,id_uxm)=work(jxm1,jy,id_uxp)
         do jx=3,nxm1
            jxm1=jx-1
            d0  =(amp(jx,jy)-amp(jxm1,jy))*divdx
            dd0 =dd1
            dd1 =(amp(jxm1,jy)-2.0*amp(jx,jy)+amp(jx+1,jy))*div2dx
            if (dd0.lt.zero .and. dd1.lt.zero) then
               work(jx,  jy,id_uxm)=d0+max(dd0,dd1)
               work(jxm1,jy,id_uxp)=d0-max(dd0,dd1)
            else if (dd0.gt.zero .and. dd1.gt.zero) then
               work(jx,  jy,id_uxm)=d0+min(dd0,dd1)
               work(jxm1,jy,id_uxp)=d0-min(dd0,dd1)
            else
               work(jx,  jy,id_uxm)=d0
               work(jxm1,jy,id_uxp)=d0
            end if
         end do
            jx=nx
            jxm1=jx-1
            d0  =(amp(jx,jy)-amp(jxm1,jy))*divdx
            work(jx,  jy,id_uxm)=d0+dd1
            work(jxm1,jy,id_uxp)=d0-dd1
            work(jx,  jy,id_uxp)=work(jx,jy,id_uxm)
      end do

c--id_uym & id_uyp

      jy=2
         jym1=jy-1
         jyp1=jy+1
         do jx=1,nx
            d0  =(amp(jx,jy)-amp(jx,jym1))*divdy
            dd1 =(amp(jx,jym1)-2.0*amp(jx,jy)+amp(jx,jyp1))*div2dy
            work(jx,jy,  id_uym)=d0+dd1
            work(jx,jym1,id_uyp)=d0-dd1
            work(jx,jym1,id_uym)=work(jx,jym1,id_uyp)
         end do
      do jy=3,nym1
         jym1=jy-1
         jym2=jy-2
         jyp1=jy+1
         do jx=1,nx
            d0  =(amp(jx,jy)-amp(jx,jym1))*divdy
            dd0 =(amp(jx,jym2)-2.0*amp(jx,jym1)+amp(jx,jy))*div2dy
            dd1 =(amp(jx,jym1)-2.0*amp(jx,jy)+amp(jx,jyp1))*div2dy
            if (dd0.lt.zero .and. dd1.lt.zero) then
               work(jx,jy,  id_uym)=d0+max(dd0,dd1)
               work(jx,jym1,id_uyp)=d0-max(dd0,dd1)
            else if (dd0.gt.zero .and. dd1.gt.zero) then
               work(jx,jy,  id_uym)=d0+min(dd0,dd1)
               work(jx,jym1,id_uyp)=d0-min(dd0,dd1)
            else
               work(jx,jy,  id_uym)=d0
               work(jx,jym1,id_uyp)=d0
            end if
         end do
      end do
      jy=ny
         jym1=jy-1
         jym2=jy-2
         do jx=1,nx
            d0  =(amp(jx,jy)-amp(jx,jym1))*divdy
            dd1 =(amp(jx,jym2)-2.0*amp(jx,jym1)+amp(jx,jy))*div2dy
            work(jx,jy,  id_uym)=d0+dd1
            work(jx,jym1,id_uyp)=d0-dd1
            work(jx,jy,  id_uyp)=work(jx,jy,id_uym)
         end do

 100  continue
c==Now, combine the RHS of the transport eqn
c-----------------------------------------------------------

      do 2000 jy=1,ny
      do 2200 jx=1,nx

         tmp=tx(jx,jy)
         if (tmp.gt.zero) then
            rhs1=tmp*work(jx,jy,id_uxm)
         else
            rhs1=tmp*work(jx,jy,id_uxp)
         end if

         tmp=ty(jx,jy)
         if (tmp.gt.zero) then
            rhs2=tmp*work(jx,jy,id_uym)
         else
            rhs2=tmp*work(jx,jy,id_uyp)
         end if

         rhs(jx,jy)=-(work(jx,jy,id_slap) +(rhs1+rhs2)/ham(jx,jy) )

 2200 continue
 2000 continue

      return
      end

