      subroutine numer_anal(lineprint,tt_sam,velnz,velnx,velny,
     &   veldz,veldx,veldy,velzorig,velxorig,velyorig,
     &   srcpos,srcpy,srcdep,rho,ap,zd,iverb,ipout,idbg,ipdmp,ier,
     &   data,velmodel)

      integer lineprint,tt_sam,velnz,velnx,velny
      real data(velnz,velnx,velny,2),velmodel(velnz,velnx,velny)
      real tmparr(401,201,2)
      common /s4print/ printdepth

      n1=min(velnz,nint(printdepth)/(10*tt_sam)+1)
      n2=velnx/2
      n3=velny/2

      isave=50
      ntmp=int(velzorig+(n1-1)*veldz)
      if (lineprint.eq.1) then
         write(isave,'("dz=",i2," z=",i5,",dx=dy=dz=",i5)')
     &         int(veldz),ntmp,int(veldz)
      else if (lineprint.eq.2) then
         write(isave,'("dx=",i2," z=",i5,",dx=dy=dz=",i5)')
     &         int(veldx),ntmp,int(veldz)
      else if (lineprint.eq.3) then
         write(isave,'("dy=",i2," z=",i5,",dx=dy=dz=",i5)')
     &         int(veldy),ntmp,int(veldz)
      end if

      isave=60
      write(isave,'(7(i7))') velnz,
     &        int(velxorig),int(veldx),velnx,
     &        int(velyorig),int(veldy),velny

      isave=51
      call pr_line(velnz,velnx,velny,data(1,1,1,1),
     &      lineprint,n1,n2,n3,isave,ier)

      isave=53
      call pr_line(velnz,velnx,velny,data(1,1,1,2),
     &      lineprint,n1,n2,n3,isave,ier)

      isave=55
      do j=1,velnx
         write(isave,'(6(f13.7))') (data(n1,j,k,1),k=1,velny)
      end do

      isave=57
      do j=1,velnx
         write(isave,'(6(f13.7))') (data(n1,j,k,2),k=1,velny)
      end do

      do m=1,2
      do k=1,velny
      do j=1,velnx
         tmparr(j,k,m)=data(n1,j,k,m)
      end do
      end do
      end do

       convel=velmodel(1,1,1)
       call cvttsolve3d(velnx,velny,velnz,veldx,veldy,veldz,
     &    velxorig,velyorig,velzorig,srcpos,srcpy,srcdep,rho,ap,zd,
     &    convel, data(1,1,1,1),data(1,1,1,2),
     &    iverb,ipout,idbg,ipdmp,ier)

      do m=1,2
      tterr=0.0
      ttmax=0.0
      ignorex=16/tt_sam
      ignorey=16/tt_sam
      do k=ignorey,velny-ignorey
      do j=ignorex,velnx-ignorex
         tterr=max(tterr,abs(tmparr(j,k,m)-data(n1,j,k,m)))
         ttmax=max(ttmax,abs(data(n1,j,k,m)))
      end do
      end do
         if(m.eq.1) then
            print'("  Rel_err_TT (h=",f3.0,")=",f12.8)',
     &         veldx,tterr/ttmax
         else
            print'("  Rel_err_AMP(h=",f3.0,")=",f12.8)',
     &         veldx,tterr/ttmax
         end if
      end do

      isave=61
      call pr_line(velnz,velnx,velny,data(1,1,1,1),
     &      lineprint,n1,n2,n3,isave,ier)

      isave=63
      call pr_line(velnz,velnx,velny,data(1,1,1,2),
     &      lineprint,n1,n2,n3,isave,ier)

      isave=65
      do j=1,velnx
         write(isave,'(6(f13.7))') (data(n1,j,k,1),k=1,velny)
      end do

      isave=67
      do j=1,velnx
         write(isave,'(6(f13.7))') (data(n1,j,k,2),k=1,velny)
      end do

      return
      end

c====================================================================
      subroutine pr_2d_section(outfile,n1,n2,n3,obj,
     &              n1a,n1b,n2a,n2b,n3a,n3b,
     &              o1,o2,o3, d1,d2,d3,
     &              isave,ipdmp,ipout,ier)

      character*40 outfile,outfilebin  ! the output file name
      integer n1,n2,n3                 ! dimension of the array obj
      integer n1a,n1b,n2a,n2b,n3a,n3b  ! the first and the end pointers
      integer isave,ipdmp,ipout,ier
      real obj(n1,n2,n3)

      tol  = 1.0e-02

c save the .sep@ file

      npsize=index(outfile,' ')
      outfilebin=outfile
      outfilebin(npsize:npsize)='@'

      open(unit=10,file=outfilebin,form='unformatted',
     &              status='unknown', iostat=ier)
      if (ier.ne.0) then
         write(ipout,*) ' error: openning', outfilebin
         return
      end if

      open(unit=20,file=outfile,form='formatted',
     &              status='unknown', iostat=ier)
      if (ier.ne.0) then
         write(ipout,*) ' error: openning', outfile
         return
      end if

c -----
      ndecim=2
      n1save=n1b-n1a+1
      n2save=n2b-n2a+1
      n3save=n3b-n3a+1

      if ( n3save.eq.1 ) then

         o1save=o1+float(n1a-1)*d1
         o3save=o2+float(n2a-1)*d2
         section=o3+float(n3a-1)*d3
         ntmp = int(log10(max(1.0,abs(section))+tol))+1
         if (section.lt.0.0) ntmp = ntmp+1
         ntmp = ntmp+ndecim+1
         write(20,'("plain:y=",f<ntmp>.<ndecim>)') section

         do j=n2a,n2b
            write(10,iostat=ier) (obj(i,j,n3a),i=n1a,n1b)
            if (ier.ne.0) then
               write(ipout,*) ' error: writing',outfilebin
               return
            end if
         end do
         idpr=3

      else if ( n2save.eq.1 ) then

         o1save=o1+float(n1a-1)*d1
         o3save=o3+float(n3a-1)*d3
         section=o2+float(n2a-1)*d2
         ntmp = int(log10(max(1.0,abs(section))+tol))+1
         if (section.lt.0.0) ntmp = ntmp+1
         ntmp = ntmp+ndecim+1
         write(20,'("plain:x=",f<ntmp>.<ndecim>)') section

         n2save=n3save
         temp=d2
         d2=d3
         d3=temp
         do k=n3a,n3b
            write(10,iostat=ier) (obj(i,n2a,k),i=n1a,n1b)
            if (ier.ne.0) then
               write(ipout,*) ' error: writing',outfilebin
               return
            end if
         end do
         idpr=2

      else if ( n1save.eq.1 ) then

         o1save=o3+float(n3a-1)*d3
         o3save=o2+float(n2a-1)*d2
         section=o1+float(n1a-1)*d1
         ntmp = int(log10(max(1.0,abs(section))+tol))+1
         if (section.lt.0.0) ntmp = ntmp+1
         ntmp = ntmp+ndecim+1
         write(20,'("plain:z=",f<ntmp>.<ndecim>)') section

         n1save=n3save
         d1=d3
         do j=n2a,n2b
            write(10,iostat=ier) (obj(n1a,j,k),k=n3a,n3b)
            if (ier.ne.0) then
               write(ipout,*) ' error: writing',outfilebin
               return
            end if
         end do
         idpr=1

      else
         write(ipout,*)' Error: pr_2d_section'
         ier=120
         return

      end if

c ----------

      n3save=1
      o2save=0.0

      nf_n1 = int(log10(float(max(1,n1save))+0.1))+1
      nf_n2 = int(log10(float(max(1,n2save))+0.1))+1
      nf_n3 = int(log10(float(max(1,n3save))+0.1))+1

      nf_o1 = int(log10(max(1.0,abs(o1save))+tol))+1
      nf_o2 = int(log10(max(1.0,abs(o2save))+tol))+1
      nf_o3 = int(log10(max(1.0,abs(o3save))+tol))+1
      if (o1save.lt.0.0) nf_o1 = nf_o1+1
      if (o2save.lt.0.0) nf_o2 = nf_o2+1
      if (o3save.lt.0.0) nf_o3 = nf_o3+1

      nf_d1 = int(log10(max(1.0,abs(d1))+tol))+1
      nf_d2 = int(log10(max(1.0,abs(d2))+tol))+1
      nf_d3 = int(log10(max(1.0,abs(d3))+tol))+1
      if (d1.lt.0.0) nf_d1 = nf_d1+1
      if (d2.lt.0.0) nf_d2 = nf_d2+1
      if (d3.lt.0.0) nf_d3 = nf_d3+1

      ndecim= 4
      nf_o1 = nf_o1+ndecim+1
      nf_o2 = nf_o2+ndecim+1
      nf_o3 = nf_o3+ndecim+1
      nf_d1 = nf_d1+ndecim+1
      nf_d2 = nf_d2+ndecim+1
      nf_d3 = nf_d3+ndecim+1

      ind1=max(nf_n1,nf_o1,nf_d1)+1
      ind2=max(nf_n2,nf_o2,nf_d2)+1

      write(20,'("n1=",i<nf_n1>,<ind1-nf_n1>x,
     &          "n2=",i<nf_n2>,<ind2-nf_n2>x,
     &          "n3=",i<nf_n3>)') n1save,n2save,n3save

      write(20,'("o1=",f<nf_o1>.<ndecim>,<ind1-nf_o1>x,
     &          "o2=",f<nf_o2>.<ndecim>,<ind2-nf_o2>x,
     &          "o3=",f<nf_o3>.<ndecim>)') o1save,o2save,o3save

      write(20,'("d1=",f<nf_d1>.<ndecim>,<ind1-nf_d1>x,
     &          "d2=",f<nf_d2>.<ndecim>,<ind2-nf_d2>x,
     &          "d3=",f<nf_d3>.<ndecim>)') d1,d2,d3

      write(20,'("ftn=1")')
      write(20,'("bintype=""csg""")')
      write(20,'("aXIs1 unit=""m""")')
      write(20,'("aXIs2 unit=""m""")')
      write(20,'("aXIs3 unit=""m""")')
      write(20,'("in=",a<npsize>)') outfilebin

      close(unit=10,iostat=ier)
      close(unit=20,iostat=ier)

c another format
c idpr =1, 2, or 3
      if(idpr.ne.5) return

      isave=20+idpr
      info=isave+10

      if (idpr.eq.3) then
         do j=n2a,n2b
            write(isave,'(6(1pe12.3))') (obj(i,j,n3a),i=n1a,n1b)
         end do
      else if(idpr.eq.2) then
         do k=n3a,n3b
            write(isave,'(6(1pe12.3))') (obj(i,n2a,k),i=n1a,n1b)
         end do
      else if(idpr.eq.1) then
         do j=n2a,n2b
            write(isave,'(6(1pe12.3))') (obj(n1a,j,k),k=n3a,n3b)
         end do
      end if

      write(info,'(3(i10,1x))') n1b-n1a+1,n2b-n2a+1,n3b-n3a+1
      write(info,'(3(f10,1x))') o1+float(n1a-1)*d1,
     &      o2+float(n2a-1)*d2, o3+float(n3a-1)*d3
      write(info,'(3(f10,1x))') d1,d2,d3
 
c information print out

      write(ipout,'(" the objective  : saved in  fort.",i2)') isave
      write(ipout,'(" the information: saved in  fort.",i2)') info

      return
      end

c====================================================================
      subroutine pr_line(n1,n2,n3,obj,ndir,n1p,n2p,n3p,isave,ier)

      integer n1,n2,n3                 ! dimension of the array obj
      integer ndir                     ! direction of the line printed
      integer isave,ier
      real obj(n1,n2,n3)

      if (ndir.eq.1) then
         write(isave,'(6(1pe12.3))') (obj(i,n2p,n3p),i=1,n1)
      else if(ndir.eq.2) then
         write(isave,'(6(1pe12.3))') (obj(n1p,j,n3p),j=1,n2)
      else if(ndir.eq.3) then
         write(isave,'(6(1pe12.3))') (obj(n1p,n2p,k),k=1,n3)
      else
         stop 'Error: pr_line in util3d.f'
      end if

c information print out
      ntmp=int(log10(max(1.0,float(isave))+0.1))+1

      write(6,'("  the objective : saved in fort.",i<ntmp>)') isave

      return
      end

