c i/o keyword variable [prototype] type source
c mODe=oN
c$input databuf vel * float* VEL
c$output databuf refl * float* REFL
c$input databuf src * float* SRC
c$input databuf seism * float* SEISM
c$input n1 seismnt * int SEISM
c$input n2 seismnx * int SEISM
c$input n3 seismnxs * int SEISM
c$input d1 seismdt * float SEISM
c$input d2 seismdx * float SEISM
c$input d3 seismdxs * float SEISM
c$input o1 seismtorig * float SEISM
c$input o2 seismxorig * float SEISM
c$input o3 seismxsorig * float SEISM
c$input srcdep srcdep * float SEISM
c$input recdep recdep * float SEISM
c$input n1 velnz * int VEL
c$input n2 velnx * int VEL
c$input d1 veldz * float VEL
c$input d2 veldx * float VEL
c$input o1 velzorig * float VEL
c$input o2 velxorig * float VEL
c$input n1 srcnt * int SRC
c$input d1 srcdt * float SRC
c$input o1 srctorig * float SRC
c$input n1 reflnz * int REFLSPACE
c$input n2 reflnx * int REFLSPACE
c$input n3 reflnxs * int REFLSPACE
c$input d1 refldz * float REFLSPACE
c$input d2 refldx * float REFLSPACE
c$input o1 reflzorig * float REFLSPACE
c$input o2 reflxorig * float REFLSPACE
c$input amp_op amp_op * int JOB
c$input aperture ap * float JOB
c$input zd zd * float JOB
c$input t0 t0 * float JOB
c$input tf tf * float JOB
c$input mv mv * float JOB
c$input wmz wmz * float JOB
c$input ntaper ntaper * int JOB
c$input save_ttamp save_ttamp * int JOB
c$input tt_sam tt_sam * int JOB
c$input lentt tt_size * int JOB
c$input tt_size tt * float* *
c$input nblock nblock * int JOB
c$input lenwork len_work * int JOB
c$input len_work work * float* *
c$input update update * int JOB
c$input ipout ipout * int JOB
c$input dumpunit ipdmp * int JOB
c$input debug idbg * int JOB
c$input verbose iverb * int JOB
c$input debug_helm idbg_helm * int JOB
c$input inv_flag inv_flag * int JOB
c$input bintype gather_flag * int SEISM
c$input JOB jobname * table argv[1]
c$input VEL vel2dname * Vel2D JOB
c$input REFL reflname REFLSPACE PSRefl2D JOB
c$input SRC srcname * ts JOB
c$input SEISM seismname * CSG2D JOB
c$input REFLSPACE reflspnm * PSRefl2DSpace JOB

c=============================== KIRCH_ADJ ===============================
c
c     KIRCHHOFF ADJOINT MODELING (PRESTACK MIGRATION)
c                     OR
c     KIRCHHOFF TRUE AMPLITUDE PRESTACK DEPTH MIGRATION USING
c               THE BEYLKIN METHOD
c     
c     This code a combination of work by
c     the TRIP group
c     
c     w symes
c     r versteeg
c     h tran
c     a sei
c     m kern
c     k araya
c     
c     This version: 08.96, WWS
c
c NOTES: this is an attempt to use a design worked out in
c 93 - 94 by the folks listed above, together with an evolved
c (and hopefully more maintainable) driver structure. The 
c original setup is largely the work of RV, and is archived
c in dso3.1. 
c
c The current memory management principle is as follows: nblock
c simulations will be carried out (ie. nblock shots). nblock
c is initialized in the job table.
c
c MODIFICATION OF 21.08.96: in this version data for nblock simulations
c indexed firstrec - lastrec are loaded at one time in the input array
c seism. The one-record-at-a-time design of previous versions is 
c abandoned; thus the input data does not need to be accumulated in
c the work array, and the code becomes considerably shorter. The 
c calling program must set aside sufficient workspace for the input
c (seism) and the output (refl). The maximum length of these is nblock
c records. The calling program must also manage the logic of firstrec
c and lastrec. This driver merely produces output for the index range
c firstrec-lastrec, without attempting to check it for validity.
c
c     Logic of Kirchhoff summation: simulation by blocked gathers
c
c     for each block
c         for each trace
c             for each gather
c                 compute source position
c                 compute receiver position
c                 read source traveltime table
c                 read receiver traveltime table
c                 compute trace
c             next gather
c         next trace
c     next block
c
c     This subroutine performs the block computation (inner two loops);
c     the calling program is set up to perform the outer loop over blocks.
c
c     Blocking strategy: in order to minimize i/o, rely on READ_TT
c     to cache a number of COARSE GRID traveltime tables in core. Arrange 
c     the order of trace computation so that only one or two new tables
c     need to be read from disk or computed for each trace index. Each 
c     table is interpolated as it is read. Thus only two interpolated
c     FINE GRID tables are stored for each trace. This design trades 
c     some computation for memory usage - execution profiles show that
c     interpolation takes up to 10% of CPU time, for FINE/COARSE = 4,
c     but 16 times as many tables can be cached in core as if fine grids
c     were stored as in RV's old design. As shown below, this design 
c     trivially works as well for common offset sim/mig/inv (COG) as for
c     common source (CSG).
c
c     The cache is treated as a disk cache, and only activated if the
c     traveltimes are also stored to disk. 
c
c     21.08.96: Current implementation stores traveltimes to disk only when
c     they are bumped from cache.
c
c     The size of the cache is set in the job deck. 
c
c     The following analysis assumes that shot and receiver spacings
c     are same. If this assumption is not true then the efficiency
c     of the scheme is in general less. The cache mgmt. remains the
c     same, regardless of src and recvr spacing.
c     
c     Notation: g = gather index
c               t = trace index
c             src = src location index
c             rec = rec location index
c
c     For common source gather: src = src(g)
c                               rec = rec(t+g)
c     As g ranges over nblock values, both src and rec range over
c     nblock values. When t --> t+1, source locations remain same
c     but receiver locations shift by 1. Therefore if 2*nblock tables
c     are cached then for each trace only one table must be read or 
c     computed (as opposed to being simply passed back from the cache). 
c     The total number of tables read per block 
c     is nblock+ntraces = nblock+n(recvrs/shot). The number of blocks
c     is n(shots)/nblock. Therefore the total number of tables 
c     read or computed is n(shots)+n(recvrs/shot)*n(shots)/nblock.
c     If the shot and receiver spacings are the same (or commensurable)
c     then most of these will be disk reads rather than computations
c     (calls to the eikonal/transport solvers).
c
c     If someone is clever they may be able to arrange to do the read
c     asynchronously, overlapping the trace computations using tables
c     already cached. This will be especially important in the parallel
c     design.
c
c     MUST ARRANGE that READ_TT KEEPS the source tables and only discards
c     the receiver tables. This cannot work if it only keeps one list and
c     discards the oldest.
c
c     For common offset gather: src = src(t)
c                               rec = rec(t+g)
c     As g ranges over nblock values rec ranges over nblock values.
c     When t --> t+1 (in general) src and rec both shift by 1. Therefore
c     if at least nblock tables are cached then only two tables must be
c     read or computed for each trace index. The total number of tables
c     read per block is at most 2*ntraces = 2*n(shots), and the
c     total for the entire simulation is 2*n(shots)*n(recvrs/shot)/nblock.
c
c     Note that this means: with the same amt. of storage FOR TTAMP TABLES
c     can achieve the same amt. of read/computes for either CSG or COG - 
c     nblock(COG) = 2*nblock(CSG). Of course this does impose a heavier
c     memory burden on COG, since twice as much input data must be loaded.
c
c     If the cache is sufficiently large, and/or if source and receiver
c     positions overlap, actually i/o and computation can be even less.
c
      subroutine kirchadj(inv_flag, vel,refl,src,seism,
     &     seismnt,seismnx,seismnxs,seismdt,seismdx,seismdxs,
     &     seismtorig,seismxorig,seismxsorig,
     &     srcdep,recdep,
     &     velnz,velnx,veldz,veldx,velzorig,velxorig,
     &     srcnt,srcdt,srctorig,
     &     reflnz,reflnx,reflnxs,refldz,refldx,reflzorig,reflxorig,
     &     amp_op,ap,zd,t0,tf,mv,wmz,ntaper,
     &     save_ttamp,tt_sam,tt_size,tt,
     &     firstrec,lastrec,marginx,marginy,
     &     gather_flag,len_work,work,
     &     iverb,idbg,idbg_helm,
     &     update,ipout,ipdmp,ier,
     &     velny,reflny,seismny,
     &     veldy,refldy,seismdy,velyorig,reflyorig,
     &     srcgeom,recgeom)

c     ----------------------------------------------------------
      
      integer 
     &     tt_sam,          ! resampling rate for traveltime map
     &     amp_op,          ! flag for forward amp option (=1, const vel)
     &     velnz,           ! dimension velocity model 1st dimension
     &     velnx,           ! dimension velocity model in 2nd dimension
     &     reflnz,          ! 1st dimension reflectivity model 
     &     reflnx,          ! 2nd dimension reflectivity model 
     &     reflnxs,         ! 3rd dimension reflectivity model 
     &     seismnt,         ! dimension seismogram in 1st (sample) dimension
     &     seismnx,         ! dimension seismogram in 2nd (trace) dimension
     &     seismnxs         ! dimension seismogram in 3rd (record) dimension
      integer 
     &     firstrec,        ! 1st record to be traced in this run
     &     lastrec,         ! last record to be traced in this run
     &     update,          ! update flag - new bg (1) or old (0)
     &     save_ttamp       ! flag whether tt/amp tables should be saved

      integer inv_flag      ! integer flag: = 1 for inversion, = 0 for adjoint

      integer 
     &     srcnt,           ! number of source samples
     &     gather_flag,     ! gather flag (0: CSG, 1: COG)
     &     ntaper,          ! number of traces to be tapered
     &     ipdmp,           ! dump file unit
     &     ipout,           ! output file unit (terminal)
     &     ier              ! error flag

      real 
     &     seismdt,         ! sample distance in traces seismogram
     &     seismdx,         ! sample distance between traces seismogram
     &     seismdxs,        ! sample distance between records seismogram 
     &     seismtorig,      ! initial offset trace
     &     seismxorig,      ! initial trace offset 1st trace
     &     seismxsorig,     ! location of 1st shot in line
     &     srcdep,          ! shot depth
     &     recdep,          ! trace depth
     &     srctorig,        ! source time origin
     &     srcdt            ! source sample distance
      real
     &     t0,              ! mute zero offset intercept
     &     tf,              ! mute final time
     &     mv,              ! muting velocity
     &     wmz,             ! width of mute zone
     &     veldz,           ! sample distance in 1st direction velocity model
     &     veldx,           ! sample distance in 2nd direction velocity model
     &     velzorig,        ! initial offset velocity model 1st direction
     &     velxorig,        ! initial offset velocity model 2nd direction
     &     refldz,          ! sample distance in 1st direction refl model
     &     refldx,          ! sample distance in 2nd direction refl model
     &     reflzorig,       ! initial offset reflectivity model 1st direction
     &     reflxorig,       ! initial offset reflectivity model 2nd direction
     &     rho              ! density
      real 
     &     ap,              ! aperture of amplitude calculation kirchhoff
     &     zd               ! datum depth

c declarations of arrays

      real 
     &     vel(*),          ! velocity model - presumed length velnz*velnx
     &     refl(*),         ! output reflectivity - presumed length 
c                             nblock*reflnz*reflnx*reflny
     &     src(*),          ! source - presumed length seismnt
     &     seism(*)         ! input seismogram - presumed length 
c                             nblock*seismnt*seismnx
      real srcgeom(3,firstrec:lastrec),
     &     recgeom(3,seismnx,seismny,firstrec:lastrec)

c workspace

      integer 
     &     len_work,        ! length of available workspace
     &     work_ptr         ! first word of available workspace
      real 
     &     work(len_work)   ! work array

      integer
     &     tt_size          ! traveltime and amplitude buffer size in words
      real
     &     tt(*)            ! buffer for traveltimes and amplitudes

c local work pointers

      integer
     &     trace_ptr,       ! pointer into seism for current trace
     &     tmp_ptr,         ! temp storage for a trace
     &     ptrace_ptr,      ! storage for preprocessed trace
     &     factor_ptr,      ! workspace for scaled squared velocity
     &     drefl_ptr        ! index into reflectivity

      integer
     &     cache_flag,      ! set by READ_TT if it caches ttamp tables -
c                             initialized to 0 here to cause READ_TT to
c                             initialize cache tables
     &     src_token,       ! identifier for src tt tables
     &     rec_token        ! identifier for rec tt tables

      integer lenwork_loc   ! length of work segment passed to subs, after
c                             allocating local space

c getbuf variables

      integer 
     &     next,            ! index of next free word in work
     &     size             ! size of bite to grab out of buffer

c local variables

      integer
     &     nblock           ! number of records to be created

c nfls is the number of traveltime tables already computed with
c the current model and saved to disk.
c nfls = 0 at the beginning of a new simulation with a new 
c model. It should be saved between calls to KIRCH_ADJ
c It needs to be initialized when irecord=1 (beginning of simulation). 
c Since READ_TT does not have access to irecord, it must be initialized
c and saved here to avoid excessive disk i/o. When update=0 (use old
c ttamp tables if possible) it should also be saved between simulations,
c i.e. between calls to the subroutine which calls this one. The only 
c obvious way to save it between simulations without adding a new special 
c common block and initialization code in the main DSO module (against 
c the DSO design principles) is to write it to a file on exit, and read 
c the file (if it exists) to initialize when update=0 and irecord=1. This
c strategy runs the risk of an unintentional initialization, i.e. when
c update=0 and the contents of the file relate to a different execution,
c hence the initialized nfls will not correctly count the number of ttamp
c files. I don't know what to do about this apart from keeping update=1
c as the default and managing this file, eg. by running from a script
c in a newly created directory.

      integer nfls

      save nfls

      logical found

      integer
     &     ntables,         ! number of tables in a traveltime record:
     &     idbg,            ! debug flag
     &     iverb,           ! verbosity flag
     &     i,j              ! counting indices

c grid compatibility tolerance

      real tol

c local block arrays

      integer
     &     recnzbox,  ! number of z samples in recvr tt box   
     &     recnxbox,  ! number of x samples in recvr tt box
     &     recoff,    ! pointers to work segments holding recvr tt/amp tables
     &     srcnzbox,  ! number of z samples in source tt box   
     &     srcnxbox,  ! number of x samples in source tt box
     &     srcoff     ! pointers to work segments holding src tt/amp tables

      real
     &     recboxorig,! x offset of receiver tt box
     &     recpos,    ! x offset of receiver
     &     srcboxorig,! x offset of source tt box
     &     srcpos     ! x offset of source

      character*3 
     &     gather_type,         ! CSG or COG
     &     mode                 ! mode flag for difference, convolution ops
      character*9  operator     ! INVERSION/MIGRATION

c useful numbers

      real fzero
      integer ione

c workspace for antialiasing filter

      real fmax, pi
      real ap_rec

c workspace for Helmholtz application

      real sz, sx               ! scale factors
      real p                    ! power of Helmholtz operator
      integer idbg_helm         ! debug flag for Helmholtz

c 3D extension, SKIM
      integer velny,reflny,seismny
      real    veldy,refldy,seismdy,velyorig,reflyorig
c  local variable
      integer srcnybox,recnybox
      real    srcboyorig,recboyorig,srcbozorig,recbozorig
      real    sy

c======================= BEGIN EXECUTABLE INSTRUCTIONS =================

      if (ier.ne.0) return

      id_dtt_first=1
      if(iverb.gt.0) write(ipout,'("  ID_DTT_FIRST =",i3)')id_dtt_first

c one simple check to make sure we are not making nonsense...

      if (lastrec.gt.seismnxs) then
         write(ipdmp,*)' Error: KIRCHADJ'
         write(ipdmp,*)' last record index of this block greater than'
         write(ipdmp,*)' total number of simulation records'
         write(ipdmp,*)' last record index     = ',lastrec
         write(ipdmp,*)' total records         = ',seismnxs
         ier=1
         return
      end if

c the beginning of the workspace is now the first word.

      work_ptr = 1

c define block length

      nblock = lastrec-firstrec+1
      
c also initialize cache on first record only

      if (firstrec.eq.1) then
         cache_flag=0
         if (update.ne.0) then
            nfls=0
         else

c if update = 0, read nfls from file if file exists, else = 0.

            found=.false.
            inquire(file='no.of.srcs',exist=found)
            if (found) then
               if (idbg.gt.0) then
                  write(ipdmp,*)' KIRCH_ADJ: found nfls file no.of.srcs'
                  write(ipdmp,*)' read nfls from this file'
               end if
               open(unit=10,file='no.of.srcs',form='formatted',
     &              status='unknown', iostat=ier)
               if (ier.ne.0) then
                  write(ipdmp,*)' Error: KIRCH_ADJ from FILEOPEN'
                  write(ipdmp,*)' on open of no.of.srcs '
                  return
               end if
               read(10,2000)nfls
               if (idbg.ge.0) then
                  write(ipdmp,*)
     &                 ' KIRCH_ADJ: number of saved tables = ',nfls
               end if
               close(unit=10,iostat=ier)
               if (ier.ne.0) then
                  write(ipdmp,*)' Error: KIRCH_ADJ from FILECLS'
                  write(ipdmp,*)' on close of no.of.srcs'
                  return
               end if
            else
               if (idbg.ne.0) then
                  write(ipdmp,*)' KIRCH_ADJ: no nfls file, set nfls=0'
               end if
               nfls=0
            end if
         end if
      end if

      if (idbg.gt.0) then
         write(ipdmp,*)' KIRCH_ADJ:'
         write(ipdmp,*)' firstrec     = ',firstrec
         write(ipdmp,*)' lastrec      = ',lastrec
         write(ipdmp,*)' len_work     = ',len_work
      end if

      if (iverb.gt.0) then
        write(ipout,'("  LOADING DATA FOR INV/MIG RANGE: ",
     &        i3," - ",i3)') firstrec,lastrec
      end if

c ------------ beginning of RV code ---------------------

c compute some numbers

      tol  = 1.0e-4 
      pi   = 3.1415927e+00
      fmax = 35.0e+00
      fzero= 0.0e+00
      ione = 1
      rho  = 1.0e+00
      src_token = 0
      rec_token = 1

c     assign logical inversion flag

      if (inv_flag.eq.0) then
         operator='MIGRATION'
      else if (inv_flag.eq.1) then
         operator='INVERSION'
      else
	 write(ipdmp,*)' Error: KIRCH_ADJ'
	 write(ipdmp,*)' inv_flag has impossible value = ',inv_flag
	 ier=1
	 return
      end if

c     assign number of tables per traveltime record

      if (inv_flag.eq.1) then
         ntables=6
      else
         ntables=2
      endif


c     evaluate flag for gather type

      ap_rec = ap
      if (gather_flag.eq.0) then
         gather_type='CSG'
      else if (gather_flag.eq.1) then
         gather_type='COG'
      else
         write(ipdmp,*)' Error: KIRCH_ADJ: wrong gather_flag'
         ier=1
         return
      end if

      if (idbg.ne.0) then
        write(ipdmp,'("  3D KIRCHHOFF ",a3,1x,a9)')gather_type,operator
         write(ipdmp,*)' INPUT PARAMETER DUMP:'
         write(ipdmp,*)' seismogram parameters '
         write(ipdmp,*)' number of samples per trace     ', seismnt
         write(ipdmp,*)' sample interval                 ', seismdt
         write(ipdmp,*)' start time (seismtorig)         ', seismtorig
         if (gather_type.eq.'CSG') then
            write(ipdmp,*)' traces per shot gather       ',
     &               seismnx," X", seismny
            write(ipdmp,*)' offset of first trace        ', seismxorig
            write(ipdmp,*)' seismdx                      ', seismdx
            write(ipdmp,*)' seismdy                      ', seismdy
            write(ipdmp,*)' number of shot gather        ', seismnxs
            write(ipdmp,*)' x coordinate of first shot   ', seismxsorig
            write(ipdmp,*)' shot interval                ', seismdxs
         else if (gather_type.eq.'COG') then
            write(ipdmp,*)' shots per offset gather      ', seismnx
            write(ipdmp,*)' x coordinate of first shot   ', seismxorig
            write(ipdmp,*)' shot interval                ', seismdx
            write(ipdmp,*)' number of offset gathers     ', seismnxs
            write(ipdmp,*)' offset of first gather       ', seismxsorig
            write(ipdmp,*)' offset interval              ', seismdxs
         end if
         write(ipdmp,*)' number of tables per tt record  ', ntables
         write(ipdmp,*)' shot depth                      ', srcdep
         write(ipdmp,*)' receiver depth                  ', recdep
         write(ipdmp,*)' source  parameters'
         write(ipdmp,*)' srcnt                           ',srcnt
         write(ipdmp,*)' srcdt                           ',srcdt
         write(ipdmp,*)' model parameters'
         write(ipdmp,*)' velnz                           ',velnz
         write(ipdmp,*)' velnx                           ',velnx
         write(ipdmp,*)' velny                           ',velny
         write(ipdmp,*)' veldz                           ',veldz
         write(ipdmp,*)' veldx                           ',veldx
         write(ipdmp,*)' veldy                           ',veldy
         write(ipdmp,*)' velzorig                        ',velzorig
         write(ipdmp,*)' velxorig                        ',velxorig
         write(ipdmp,*)' velyorig                        ',velyorig
         write(ipdmp,*)' reflnz                          ',reflnz
         write(ipdmp,*)' reflnx                          ',reflnx
         write(ipdmp,*)' reflny                          ',reflny
         write(ipdmp,*)' refldz                          ',refldz
         write(ipdmp,*)' refldx                          ',refldx
         write(ipdmp,*)' refldy                          ',refldy
         write(ipdmp,*)' reflzorig                       ',reflzorig
         write(ipdmp,*)' reflxorig                       ',reflxorig
         write(ipdmp,*)' reflyorig                       ',reflyorig
         write(ipdmp,*)' reflnxs                         ',reflnxs
         write(ipdmp,*)' miscellaneous parameters '
         write(ipdmp,*)' firstrec                        ',firstrec
         write(ipdmp,*)' lastrec                         ',lastrec
         write(ipdmp,*)' nblock                          ',nblock
         write(ipdmp,*)' len_work                        ',len_work
         write(ipdmp,*)' amp_op                          ',amp_op
         write(ipdmp,*)' ap                              ',ap
         write(ipdmp,*)' zd                              ',zd
         write(ipdmp,*)' rho                             ',rho
         write(ipdmp,*)' t0                              ',t0
         write(ipdmp,*)' tf                              ',tf
         write(ipdmp,*)' mv                              ',mv
         write(ipdmp,*)' wmz                             ',wmz
         write(ipdmp,*)' ntaper                          ',ntaper
         write(ipdmp,*)' save_ttamp                      ',save_ttamp
         write(ipdmp,*)' update                          ',update
         write(ipdmp,*)' marginx                         ',marginx
         write(ipdmp,*)' marginy                         ',marginy
      end if
      if (idbg.ge.4) then
         ier=999
         return
      end if

      if (iverb.ne.0) then
        write(ipout,'("  3D KIRCHHOFF ",a3,1x,a9)')gather_type,operator
      end if
         
c parameter check to verify that the source distance (seismdxs)
c and the distance between receivers are integer multiples 
c of each other.

      if (abs(seismdx).le.tol*abs(seismdxs)) then
         write(ipdmp,*)' Error: KIRCH_ADJ: seismdx too small'
         ier=209
         return
      end if

      if ((abs(float(nint(seismdxs/seismdx))-
     &     (seismdxs/seismdx)).ge.tol).and.(idbg.gt.0)) then
         write(ipdmp,*)' Warning: KIRCH_ADJ'
         write(ipdmp,*)' receiver interval : ',seismdx
         write(ipdmp,*)' source interval   : ',seismdxs
         write(ipdmp,*)' source interval must be an int mult of '
         write(ipdmp,*)' receiver interval, else this computation '
         write(ipdmp,*)' will be grossly inefficient'
      end if

      if ((abs((seismxorig/seismdx)-nint(seismxorig/seismdx))
     &     .gt.tol).and.(idbg.gt.0)) then
         write(ipdmp,*)' Warning: KIRCH_ADJ'
         write(ipdmp,*)' offset of first receiver: ',seismxorig
         write(ipdmp,*)' must be an integral multiple of '
         write(ipdmp,*)' receiver interval: ',seismdx
         write(ipdmp,*)' else this computation will be grossly ',
     &        'inefficient'
      end if

c  parameter check to see if the source and
c  seismogram have same sampling interval

      if(abs(seismdt-srcdt).gt.tol*seismdt)then
         write(ipdmp,*)' Error: KIRCH_ADJ: seismdt .ne. srcdt'
         ier = 209
         return
      end if

c check that veldz, veldx are safely nonzero

      if (abs(veldz).le.tol .or. abs(veldx).le.tol .or.
     &    abs(veldy).le.tol ) then
         write(ipdmp,*)' Error: KIRCH_ADJ: vel_size too small'
         ier=99
         return
      end if

c  parameter check to see if velocity and reflectivity have
c  same sampling intervals

      if(abs(veldz-refldz).gt.tol .or. abs(veldx-refldx).gt.tol .or.
     &   abs(veldy-refldy).gt.tol) then
         write(ipdmp,*)' Error: KIRCH_ADJ: vel_size .ne. refl_size'
         ier = 209
         return
      end if

      if ((reflnxs.ne.1).and.(reflnxs.ne.seismnxs)) then
         write(ipdmp,*)' Error: KIRCH_ADJ: reflnxs.ne.{1,seismnxs}'
         ier=209
         return
      end if

      if (iverb.gt.0) then
         write(ipout,*)' INITIALIZE...'
      end if

c     mute and taper first since this is the adjoint calculation

      call mute_and_taper(seism,seismnt,seismnx,firstrec,nblock,t0,tf,
     &   mv,wmz,ntaper,seismxorig,seismdx,seismdt,seismxsorig,seismdxs,
     &   gather_type,ipdmp,ier)
      if(ier.ne.0)then
         write(ipdmp,*)' Error: KIRCH_ADJ from MUTE_AND_TAPER '
         return
      end if

c     zero out reflectivity output

      j=nblock*reflnz*reflnx*reflny
      call sconst(j,fzero,refl,ione)

c INITIALIZE OFFSET INTO WORK BUFFER

      next = work_ptr

c STORAGE FOR GATHER AND TRACE INDEPENDENT QUANTITIES:

      size=reflnx*reflnz*reflny
      
      call getbuf('work',factor_ptr,size,next,len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: KIRCH_ADJ from GETBUF or factor_ptr'
         return
      end if

      if (idbg.gt.0) then
         write(ipdmp,*)' gather independent sum. factor stored @',
     &        factor_ptr
      end if

c 3D
      call factor_adj_inv3d(inv_flag,
     &     velnz,velnx,veldz,veldx,velzorig,velxorig,vel,
     &     reflnz,reflnx,reflzorig,reflxorig,work(factor_ptr),
     &     seismdx,ipdmp,idbg,ier,
     &     velny,veldy,velyorig,reflny,reflyorig,seismdy,rho)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: KIRCH_ADJ: factor_adj_inv3d'
         return
      end if

c storage for various traces

c      size = seismnt
      size = max(seismnt,srcnt)
            
      call getbuf('work',tmp_ptr,size,next,len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: KIRCH_ADJ from GETBUF for tmp_ptr'
         return
      end if

      if (idbg.gt.0) then
         write(ipdmp,*)' temporary trace storage at ',tmp_ptr
      end if

      size = seismnt

      call getbuf('work',ptrace_ptr,size,next,len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: KIRCH_ADJ from GETBUF for ptrace_ptr'
         return
      end if

      if (idbg.gt.0) then
         write(ipdmp,*)' preprocessed trace storage at ',ptrace_ptr
      end if

      work_ptr=next

c FINISHED ALLOCATING WORKSPACE FOR USE IN KIRCH_ADJ

c     for common source gathers the gather and source indicies are the same

c     for common offset gathers the headers mean:
c         seismnx             = number of traces = number of sources
c         seismdx             = source step
c         seismxorig          = coordinate of first source
c         seismnxs            = number of offsets
c         seismdxs            = offset step = trace step = source step
c         seismxsorig         = first offset

c ===========================
c LOOP OVER GATHER INDEX
c ===========================

      do i=firstrec,lastrec      ! the 3rd direction in in.sep

c ===========================
c LOOP OVER TRACE INDEX
c ===========================

      do k=1,seismny             ! the 2nd direction in in.sep
      do j=1,seismnx             ! the 2nd direction in in.sep
         
            if(j.eq.2) idbg=0

            if (iverb.ne.0) then
               write(ipout,'(/" 3D KIRCHHOFF ",a3,1x,a9,": gather =",
     &            i4,2x,"trace =",2(i4))') gather_type,operator,i,j,k
            end if

c COMPUTE SOURCE AND RECEIVER POSITIONS, OFFSET INTO SEISM,
c REFL ARRAYS

            drefl_ptr=(i-firstrec)*reflnz*reflnx*reflny + 1
            trace_ptr=(i-firstrec)*seismnt*seismnx*seismny
     &               +(k-1)*seismnt*seismnx +(j-1)*seismnt+ 1

            if (gather_type.eq.'CSG') then

*               srcpos = seismxsorig + (i-1)*seismdxs
*               recpos = srcpos + seismxorig  + (j-1)*seismdx

                srcdep = srcgeom(1,i)
                srcpos = srcgeom(2,i)
                srcpy  = srcgeom(3,i)

                recdep = recgeom(1,j,k,i)
                recpos = recgeom(2,j,k,i)
                recpy  = recgeom(3,j,k,i)

            else if (gather_type.eq.'COG') then

c     here j=source index (=trace index) and i=offset index=recvr index

               srcpos = seismxorig  + (j-1)*seismdx
               recpos = seismxsorig + (i-1)*seismdxs + srcpos

            else

               write(ipdmp,*)' Error: KIRCH_ADJ'
               write(ipdmp,*)' unrecognized gather type: ',gather_type
               ier=1
               return

            end if

            if((gather_flag.eq.0.and.j.eq.1.and.k.eq.1)
     &             .or.(gather_flag.eq.1))then

               lenwork_loc=len_work-work_ptr+1
               if (idbg.ne.0) then
                  write(ipdmp,*)'COMPUTING SOURCE TRAVELTIME TABLE'
                  write(ipdmp,*)' position = ',srcpos
                  write(ipdmp,*)' workspace available = ',lenwork_loc
               end if
               if (iverb.ne.0) then
                  write(ipout,*)'COMPUTING SOURCE TRAVELTIME TABLE'
                  write(ipout,'("  position =",2(f10.2))') srcpos,srcpy
               end if

c The source offset is always the same as the beginning of the workspace,
c since read_tt stores the fine grid table there and the source table is
c the first returned.

c first time through, next is the next word after the aux traces
c are allocated. second and subsequent times it's the region after
c the src table. Either way should work, if the rec comp is to succeed.

               srcoff=work_ptr

               call read_ttdata3d(cache_flag,inv_flag,
     &              vel,tt,work(srcoff),src_token,
     &              velnz,velzorig,veldz,velnx,velxorig,veldx,
     &              seismnt,seismdt,marginx,marginy,
     &              srcnzbox,srcbozorig,srcnxbox,srcboxorig,
     &              srcdep,srcpos,save_ttamp,tt_sam,tt_size,
     &              amp_op,update,lenwork_loc,ntables,
     &              rho,ap,zd,nfls,ipout,ipdmp,idbg,iverb,ier,
     &              velny,velyorig,veldy,srcnybox,srcboyorig,srcpy,
     &              reflnz,reflnx,reflny,reflzorig,reflxorig,reflyorig)
               if (ier.ne.0) then
                  write(ipdmp,*)' Error: KIRCH_ADJ from READ_TT'
                  return
               end if

c receiver table returned in next block of work - now know what size it is!

               next=work_ptr
               size=ntables*srcnzbox*srcnxbox*srcnybox
               call getbuf('work',srcoff,size,next,len_work,ipdmp,ier)
               if (ier.ne.0) then
                  write(ipdmp,*)' Error: KIRCH_ADJ: GETBUF for srcoff'
                  return
               end if
               nextsave=next
               nsrcsize=size

            end if

            next=nextsave
            size=nsrcsize
            lenwork_loc=len_work-next+1

            call getbuf('work',recoff,size,next,len_work,ipdmp,ier)
            if (ier.ne.0) then
               write(ipdmp,*)' Error: KIRCH_ADJ: GETBUF for recoff'
               return
            end if

            if (idbg.gt.0) then
               write(ipdmp,*)'COMPUTING RECEIVER TRAVELTIME TABLE'
               write(ipdmp,*)' position = ',recpos
               write(ipdmp,*)' workspace available = ',lenwork_loc
            end if
            if (iverb.gt.0) then
               write(ipout,*)'COMPUTING RECEIVER TRAVELTIME TABLE'
               write(ipout,'("  position =",2(f10.2))') recpos,recpy
            end if

            call read_ttdata3d(cache_flag,inv_flag,
     &           vel,tt,work(recoff),rec_token,
     &           velnz,velzorig,veldz,velnx,velxorig,veldx,
     &           seismnt,seismdt,marginx,marginy,
     &           recnzbox,recbozorig,recnxbox,recboxorig,
     &           recdep,recpos,save_ttamp,tt_sam,tt_size,
     &           amp_op,update,lenwork_loc,ntables,
     &           rho,ap_rec,zd,nfls,ipout,ipdmp,idbg,iverb,ier,
     &           velny,velyorig,veldy,recnybox,recboyorig,recpy,
     &           reflnz,reflnx,reflny,reflzorig,reflxorig,reflyorig)

            if (ier.ne.0) then
               write(ipdmp,*) ' Error: KIRCH_ADJ from READ_TT'
               return
            end if

            if (iverb.gt.0) then
               write(ipout,*) 'KIRCHHOFF SUM...'
            endif

c PREPROCESS INPUT TRACES

         if(id_dtt_first.eq.1) then
            
            call cendif2(src,work(tmp_ptr),srcdt,srcnt,idbg,ipdmp,ier)
            call convadj0(seism(trace_ptr),work(ptrace_ptr),seismnt,
     &        work(tmp_ptr),srcnt,srctorig,seismtorig,seismdt,ipdmp,ier)
            if (ier.ne.0) then
               write(ipdmp,*)' Error: KIRCHADJ3D: cendif2 or convadj0'
               return
            end if

         else

            call convadj0(seism(trace_ptr),work(tmp_ptr),seismnt,
     &           src,srcnt,srctorig,seismtorig,seismdt,ipdmp,ier)
            if (ier.ne.0) then
               write(ipdmp,*)' Error: KIRCH_ADJ from CONVADJ'
               return
            end if
            
            if (inv_flag.eq.1) then
               call indefint(work(tmp_ptr), work(ptrace_ptr), 
     &              seismdt, seismnt, idbg, ipdmp, ier)
               if (ier.ne.0) then
                  write(ipdmp,*) ' Error: KIRCH_ADJ from INDEFINT'
                  return
               end if
            else
               call cendif2(work(tmp_ptr),work(ptrace_ptr), 
     &              seismdt,seismnt,idbg,ipdmp,ier)
               if (ier.ne.0) then
                  write(ipdmp,*) ' Error: KIRCH_ADJ from CENDIF'
                  return
               end if
            end if

         end if

c     perform Kirchhoff sum, placing result in seism(trace_ptr)
c     (fwd map) or refl(drefl_ptr) (adj map)

         if (idbg.gt.0) then
            write(ipdmp,*)' reflectivity output at       ', drefl_ptr
            write(ipdmp,*)' src tt/amp table loaded at offset', srcoff
            write(ipdmp,*)' rec tt/amp table loaded at offset', recoff
            write(ipdmp,*)' trace loaded at              ', trace_ptr
            write(ipdmp,*)' preprocessed trace loaded at ', ptrace_ptr
         end if

         call kirch_sum_adj3d(gather_flag,inv_flag,
     &        velnz,velnx,velny,veldz,veldx,veldy,zd,
     &        reflnz,reflnx,reflny,reflzorig,reflxorig,reflyorig,
     &        srcnzbox,srcnxbox,srcnybox,
     &        srcbozorig,srcboxorig,srcboyorig,
     &        recnzbox,recnxbox,recnybox,
     &        recbozorig,recboxorig,recboyorig,
     &        refl(drefl_ptr),work(factor_ptr),
     &        work(srcoff),work(recoff),work(ptrace_ptr),
     &        seismnt,seismdt,seismtorig,ipdmp,idbg,ier,ntables)

         if (ier.ne.0) then
            write(ipdmp,*) ' Error: KIRCH_ADJ from KSUM_ADJ'
            return
         end if
            
c ===========================
      end do
      end do
c ===========================
      end do
c ===========================

c     apply cutoff to output reflectivity

      ntaper_refl = 4
      call cutoff3d(reflnz,reflnx,reflny,nblock,refl,
     &             zd-reflzorig,veldz,ntaper_refl,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: KIRCH_ADJ from CUTOFF'
         return
      end if

c     if number of records in reference reflectivity = 1 and
c     number of records in input seismogram is > 1, then
c     presumption is that dim3 sum in seismogram scalar product
c     is scaled by d3recy. So scale output reflectivity by
c     intershot spacing to satisfy adjoint relation (this is
c     same as dim3 step in input / dim3 step in output = 1).

      if ((reflnxs.eq.1).and.(seismnxs.gt.1)) then
         i=reflnz*reflnx*nblock
         j=1
         call sscal(i,abs(seismdxs),refl,j)
      end if

c     if doing inversion, must apply (-Laplacian)^0.5
c     have available at this point work_ptr = end of seism
c     and len_work = remaining workspace - includes ttamps,
c     but overwrite these (must be restored
c     from disk or recomputed on the next call to KIRCH_AJD), 
c     can use all of work for tmp storage.

      if (inv_flag.eq.1) then
         sz=1.0e+00
         sx=1.0e+00
         p=0.5e+00
         do i=firstrec,lastrec
            size=(i-firstrec)*reflnx*reflnz+1
            call helm_dnddi(reflnz,reflnx,veldz,veldx,sz,sx,p,
     &           max(0.0e+00, zd-reflzorig),
     &           refl(size),refl(size),work(work_ptr),
     &           len_work,idbg_helm,ipdmp,ier)
            if (ier.ne.0) then
               write(ipdmp,*)' Error: KIRCH_ADJ from HELM_DNDDI'
               return
            end if
         end do
      endif

c     save nfls data - easiest way is just to overwrite existing 
c     file, even though this is slightly inefficient.

      if (save_ttamp.ne.0) then

         open(unit=10,file='no.of.srcs',form='formatted',
     &           status='unknown', iostat=ier)
         if (ier.ne.0) then
            write(ipdmp,*)' Error: KIRCH_ADJ from FILEOPEN'
            write(ipdmp,*)' on open of no.of.srcs '
            return
         end if
         write(10,2000)nfls
         if (idbg.ge.0) then
            write(ipdmp,*)' KIRCH_ADJ: number of saved tables = ',nfls
         end if
         close(unit=10,iostat=ier)
         if (ier.ne.0) then
            write(ipdmp,*)' Error: KIRCH_ADJ from FILECLS'
            write(ipdmp,*)' on close of no.of.srcs '
            return
         end if

      end if

 2000 format(i10)

      return
      end

