c========================== FACTOR_ADJ_INV =========================

      subroutine factor_adj_inv3d(inversion,
     &     velnz,velnx,veldz,veldx,velzorig,velxorig,vel,
     &     reflnz,reflnx,reflzorig,reflxorig,
     &     factor,seismdx,ipdmp,idbg,ier,
     &     velny,veldy,velyorig,reflny,reflyorig,seismdy,rho)

c------------------------------------------------------------
c
c  this subroutine calculates 2.0*pi*rho*dreceiver/c(i,j)**2
c                    or
c  this subroutine calculates dreceiver*c(i,j)**2*rho/(2.0*pi)
c  for the calculation of the adjoint map

c 220996: this version computes these fields on the reflectivity
c grid, where they are needed. still assumes that velzorig = velxorig = 0

      integer ier,ipdmp,idbg
      integer velnz,velnx,reflnz,reflnx
      real seismdx,seismdy,rho,pi,const,veldz,veldx,
     &     velzorig,velxorig,reflzorig,reflxorig

* 3-D, SKIM
      integer velny,reflny
      real veldy,velyorig,reflyorig

      real vel(velnz,velnx,velny)
      real factor(reflnz,reflnx,reflny)

*      real vel(velnz,velnx)
*      real factor(reflnz,reflnx)

      integer inversion

      real velmin,velmax,tol
      real twopi

      integer i,j,k,iv,jv,kv,nz_slip,nx_slip,ny_slip

      data tol /1.0e-4/, pi /3.1415927/
c
      twopi=2.0*pi

      if(idbg.ge.1)then
	 write(ipdmp,*)' FACTOR_ADJ_INV'
	 write(ipdmp,*)' velnz  : ',velnz
	 write(ipdmp,*)' velnx  : ',velnx
	 write(ipdmp,*)' pi      : ',pi
	 write(ipdmp,*)' rho     : ',rho
	 write(ipdmp,*)' seismdx : ',seismdx
      end if
c
c WWS 30.10.95 - move additional factor of 2 in here, consolidate
c (see notes in ksum_inv)
c         const=abs(seismdx)/(2.0*pi)
c added 20.10.95 by WWS - see comment in KSUM_INV
c         const=const/(pi*pi)
c
c     check that dividing by the squared velocity is OK

      velmax=0.
      jump=3

      do k=1,velny,jump
      do j=1,velnx,jump
      do i=1,velnz,jump
         velmax=max(velmax,vel(i,j,k))
      end do
      end do
      end do

      velmin=velmax

      do k=k,velny,jump
      do j=1,velnx,jump
      do i=1,velnz,jump
         velmin=min(velmin,vel(i,j,k))
      end do
      end do
      end do

      if(idbg.ge.2)then
	 write(ipdmp,*)' FACTOR_ADJ_INV'
         write(ipdmp,*)' const : ',const
         write(ipdmp,*)' velmin: ',velmin
         write(ipdmp,*)' velmax: ',velmax
      end if

      if (velmin.le.tol*velmax) then
         write(ipdmp,*)' Error: FACTOR_ADJ_INV: velmin too small'
         ier=1
         return
      end if

c this version still assumes that the reflectivity and velocity sample
c rates are the same, but no longer enforces that the reflectivity is
c defined on a subgrid of the velocity grid. instead the velocity is
c extended implicitly.

      nz_slip = nint((reflzorig-velzorig)/veldz)
      nx_slip = nint((reflxorig-velxorig)/veldx)
      ny_slip = nint((reflyorig-velyorig)/veldy)

      if (inversion.eq.0) then

         const =2.0*abs(seismdx*seismdy)/rho

CDIR$ NORECURRENCE
         do k=1,reflny
               kv=min(max(ny_slip+k,1),velny)
         do j=1,reflnx
               jv=min(max(nx_slip+j,1),velnx)
         do i=1,reflnz
               iv=min(max(nz_slip+i,1),velnz)
            factor(i,j,k)=const/vel(iv,jv,kv)**2
         end do
         end do
         end do
      
      else if (inversion.eq.1) then

         const =2.0*abs(seismdx*seismdy)/rho

CDIR$ NORECURRENCE
         do k=1,reflny
               kv=min(max(ny_slip+k,1),velny)
         do j=1,reflnx
               jv=min(max(nx_slip+j,1),velnx)
         do i=1,reflnz
               iv=min(max(nz_slip+i,1),velnz)
            factor(i,j,k)=const/vel(iv,jv,kv)**2
         end do
         end do
         end do
      
      end if

      return
      end

