c=======================================================================
      subroutine cvttsolve3d(nx,ny,nz,dx,dy,dz,xmin,ymin,zmin,
     &      xs,ys,zs,rho,ap,zd,vel,tt,amp,iverb,ipout,idbg,ipdmp,ier)

      real tt(nz,nx,ny),amp(nz,nx,ny)

c CONSTANT VELOCITIES ONLY

c Why do we need comment lines for such a simple routine?
c     SKIM 6/1997

      if (ier.ne.0) return

      if (iverb.gt.0) then
         write(ipout,*)' CVTTSOLVE3D'
      end if

      izd=nint((zd-zmin)/dz)+1
      izdm1=izd-1

      rvel=1.0e+00/vel
      r4pi=rho/(4.0*3.1415927)
      dist0=sqrt(dx**2+dy**2+dz**2)

CDIR$ NORECURRENCE
      do 1000 k=1,ny
                     py=(ymin+float(k-1)*dy-ys)**2
      do 2000 j=1,nx
                     px=(xmin+float(j-1)*dx-xs)**2
         do i=izd,nz
                     pz=(zmin+float(i-1)*dz-zs)**2
            distance=sqrt(pz+px+py)
            tt(i,j,k)=distance*rvel
            amp(i,j,k)=r4pi/(max(dist0,distance))
         end do
         do i=1,izdm1
            tt(i,j,k) =0.0
            amp(i,j,k)=amp(izd,j,k)
         end do
 2000 continue
 1000 continue

      return
      end
