c CONVOLVE_ADJ
c
c adjoint discretized convolution operator
c
c WWS 060996
c SKIM 090697
c
c the trapezoidal rule leads to the discrete adjoint convolution formula
c
c   f *^t w (m) = \Delta t \sum_{j=1}^{n_w} f(m+j+n_0-1) w(j),\,\,m=1,...,n_f
c 
c the functions f and w are sampled on the integral grid with spacing \Delta t.
c indexing is as follows:
c
c   f((m-1)\Delta t) \mapsto f(m)
c   w((j-1)\Delta t + t_0) = w((j+n_0-1)\Delta t) \mapsto w(j)
c      where n_0 = t_0/\Delta t
c
c that is, the time of the first sample of w is t_0. the time of the first
c sample of f is nominally 0, though these formulae can be used so long as
c the output first sample is at the same time as the input first sample (by
c global time shift).
c
c the input arrays are declared as f(1:n_f) and w(1:n_w) respectively. In
c the above formula, all samples outside the range of the declarations are
c implicitly treated as zero, i.e. f and w are regarded as defining (sampled
c grid) functions of compact support. the output is sampled on the f grid,
c i.e. an implicit cutoff to the support of f is applied.
c
c -------------------------------------------------------------------------

c i/o keyword variable [prototype] type source
c mODe=oN single=0 nr= ir= nb= fr= lr=
c$input databuf fin * float* datain
c$output databuf fout * float* dataout
c$input n1 nf * int datain
c$input databuf w * float* filter
c$input n1 nw * int filter
c$input o1 t0 * float filter
c$input d1 dt * float datain
c$input dumpunit ipdmp * int par
c$input datain datainnm * ts par
c$input filter filternm * ts par
c$input par parnm * table argv[1]
c$input dataout dataoutnm dataoutSpace ts par
c$input dataoutSpace dataoutspnm * tsSpace par

      subroutine convadj0(fin,fout,nf,w,nw,tw0,tf0,dt,ipdmp,ier)

c     parameters

      integer
     &     nf,            ! length of input and output arrays
     &     nw,            ! length of filter
     &     ipdmp,         ! dump output unit number
     &     ier            ! error flag

      real
     &     fin(nf),       ! input time series
     &     w(nw),         ! filter
     &     fout(nf),      ! output time series
     &     tw0,           ! time of first sample in filter (lag)
     &     tf0,           ! time of first sample in input time series
     &     dt             ! time sample interval

c     internal variables

      integer i,j         ! loop counters
      integer n0          ! index lag

c------------------------------------------------------------------------

      if (ier.ne.0) return

c     check that dt is safely positive

      if (dt.lt.1.e-10) then
         write(ipdmp,*)' Error: CONVOLVE_ADJ'
         write(ipdmp,*)' dt = ',dt,' too small'
         ier=1
         return
      endif

c compute "index lag"
c n0=nint((srctorig-seismtorig)/seismdt)
c this makes the "fout" start with "0.0"
c i.e. fout(1) = [(d/dt)^2(\check(w)*fin)](0.0)

      n0=nint((tw0-tf0)/dt)
      
c convolve

      do i=1,nf
         fout(i)=0.0e+00
         im1pn0=i-1+n0
c           im1pn0+j >=1,  so j >= 1 -im1pn0
c           im1pn0+j <=nf, so j <= nf-im1pn0
         jmin=max(1, 1 -im1pn0)
         jmax=min(nw,nf-im1pn0)
         do j=jmin,jmax
            fout(i)=fout(i)+fin(im1pn0+j)*w(j)
         end do
         fout(i)=fout(i)*dt
      end do

      return
      end

