c========================= STT_CREATE ===============================

      subroutine stt_create3d(inversion,ntables,tt_sam,
     &     velnz,velzorig,veldz,
     &     velnx,velxorig,veldx,seismdt,
     &     srcpos,srcdep,srcpy,velmodel,amp_op,data,
     &     work,lenwork,rho,ap,zd,ipout,ipdmp,idbg,iverb,ier,
     &     velny,velyorig,veldy) 

c------------------------------------------------------------
c  SKIM, 06.97
c------------------------------------------------------------

      integer 
     &     inversion            ! =1, for Beylkin type inversion
     &     ntables,             ! number of data tables
     &     tt_sam,              ! resample factor (1,2 or 4)
     &     amp_op,              ! amplitude option (=1, const vel)
     &     lenwork,             ! length of work array
     &     idbg,ier,ipdmp,      ! debug flag, error flag and dump unit
     &     velnz,velnx,velny    ! dimension of local velocity model

      real velzorig,velxorig,velyorig, ! origin offset velocity model
     &     veldz,veldx,veldy,          ! stepsize velocity model
     &     seismdt,                    ! seismogram time sample step 
     &     srcdep,srcpos,srcpy         ! source position (depth and offset)

      real 
     &     work(lenwork),                  ! work array
     &     velmodel(velnz,velnx,velny),    ! velocity model
     &     data(velnz*velnx*velny,ntables) ! data array for tt and amp

      real  ap,zd,dtrecip   ! kirchhoff aperture, datum depth, and 1/dt

      integer i,j,lworkt
      common /prline/ lineprint
c------------------------------------------------------

      if (ier.ne.0) return

      if (idbg.ne.0) then
         write(ipdmp,*)' STT_CREATE: starting up ...'
      end if

      lworkt=lenwork
 
      if (amp_op.eq.0) then

          if(idbg.ge.1)then
             write(ipdmp,*)' variable velocity code'
          end if

          call ttsolve3d(velnx,velny,velnz,veldx,veldy,veldz,
     &       velxorig,velyorig,velzorig,srcpos,srcpy,srcdep,
     &       rho,ap,zd,velmodel, data(1,1),data(1,2),
     &       work,lworkt,iverb,ipout,idbg,ipdmp,ier)

      else if(amp_op.eq.1) then

          if(idbg.ge.1)then
             write(ipdmp,*)' constant velocity code'
          end if

          convel=velmodel(1,1,1)
          if (convel.lt.0.0001) then
             write(ipout,*)' SttCreate3D.f: bad constant velocity'
             ier=120
             return
          end if

          call cvttsolve3d(velnx,velny,velnz,veldx,veldy,veldz,
     &       velxorig,velyorig,velzorig,srcpos,srcpy,srcdep,rho,ap,zd,
     &       convel, data(1,1),data(1,2),
     &       iverb,ipout,idbg,ipdmp,ier)

      else
          write(ipout,*)' SttCreate3D.f: bad amp_op'
          ier=ier+1
          return
      end if

c========= TEMP ===============================================
      if(lineprint.ge.1 .and. lineprint.le.3) then
         call numer_anal(lineprint,tt_sam,velnz,velnx,velny,
     &      veldz,veldx,veldy,velzorig,velxorig,velyorig,
     &      srcpos,srcpy,srcdep,rho,ap,zd,iverb,ipout,idbg,ipdmp,ier,
     &      data,velmodel)
         ier=ier+1
         print*,"##### SttCreate3D.f: print tt/amp and stop"
         return
      end if
c========= TEMP ===============================================

      if (1.0e+00+seismdt.le.1.0e+00) then
         write(ipdmp,*)' Error: STT'
         write(ipdmp,*)' seismdt too small = ',seismdt
         ier=3
         return
      end if

c divide by dt to "integerize" the traveltimes

      dtrecip = 1.0e+00/seismdt
      ntmp=velnz*velnx*velny

CDIR$ NORECURRENCE
      do i=1,ntmp
          data(i,1) = dtrecip*data(i,1)
      end do

      return 
      end

