      subroutine smooth_ap(nz,nx,apcut,work,len,ipdmp,ier)

c PURPOSE: smooth aperture field
c AUTHOR: WWS
c DATE: 09.10.95

c ARGUMENTS:

      integer
     &     nz,           ! number of points in z
     &     nx,           ! number of points in x
     &     len,          ! length of available workspace
     &     ipdmp,        ! dump unit
     &     ier           ! error flag

      real
     &     apcut(nz,nx), ! aperture field
     &     work(*)       ! workspace

c INTERNAL VARIABLES:

      real
     &     davg          ! workspace for averaging weight

      integer
     &     i,j,k,iavg,   ! loop counters
     &     navg,         ! width of averaging kernel
     &     limavg        ! number of times average is repeated

c====================================================================

      if (ier.ne.0) return

c initialize width of kernel, number of repeats

      navg    = 1
      limavg  = 1
      
c check that there is enough workspace

      if (len.lt.nx) then
         write(ipdmp,*)' Error: SMOOTH_AP'
         write(ipdmp,*)' not enough workspace'
         write(ipdmp,*)' need nx  = ',nx
         write(ipdmp,*)' have len = ',len
         ier=1
         return
      endif

      davg=1.0e+00/float(2*navg+1)

c depth loop - smoothing is horizontal only

      do k=1,nz

c repeat some number of times

         do iavg=1,limavg

c initialize storage

            do i=1,nx
               work(i)=0.0e+00
            end do

c first median minimum filter to shrink the support of apcut

            do i=navg+1,nx-navg
               work(i)=apcut(k,i)
               do j=-navg,navg
                  work(i)=min(work(i),apcut(k,i+j))
               end do
            end do
            do i=navg+1,nx-navg
               apcut(k,i)=work(i)
            end do

c initialize storage

            do i=1,nx
               work(i)=0.0e+00
            end do

c then moving average to smooth

            do i=navg+1,nx-navg
               do j=-navg,navg
                  work(i)=work(i)+apcut(k,i+j)
               end do
            end do
            do i=navg+1,nx-navg
               apcut(k,i)=davg*work(i)
            end do

         end do

      end do

      return
      end
