      subroutine scale_amp_inv(nz,nx,amps,apcut,ipdmp,ier)
c
c Author: WWS
c Date: 20.10.95
c Purpose: forms reciprocal array of <amps> and scales result by <apcut>
c      
      integer 
     &     nz,          ! number of rows
     &     nx,          ! number of columns
     &     ipdmp,       ! output unit number
     &     ier          ! error flag

      real 
     &     amps(nz,nx), ! amplitude array to be scaled
     &     apcut(nz,nx) ! cutoff array

      integer i,j       ! loop indices
      real test, tol    ! test for min

c--------------------------------------------------------------

      tol=1.e-6

c find max

      test=0.0e+00

      do i=1,nz
         do j=1,nx
            test=max(test,amps(i,j))
         end do
      end do

      if (test.lt.tol) then
         write(ipdmp,*)' Error: SCALE_AMP_INV'
         write(ipdmp,*)' amplitude max is < ',tol
         ier=1
         return
      end if

c create min for amplitude division

      test=test*tol
      
c do reciprocal, scaling:

      do i=1,nz
         do j=1,nx
            amps(i,j)=apcut(i,j)*(1.0e+00/max(amps(i,j),test))
         end do
      end do

      return
      end

c-------------------------------------------------------------------

      subroutine scale_grad_inv(nz,nx,tau_x,tau_z,v,ipdmp,ier)
c
c on call: tau_z, tau_x are computed traveltime gradient components
c
c on return: tau_z, tau_x have been scaled by v which is approximately
c the reciprocal length of the traveltime gradient (eikonal equation!)
c
      integer nz, nx, ipdmp, ier

      real tau_x(nz,nx), tau_z(nz,nx), v(nz,nx)

      integer i,j

      do i=1,nx
         do j=1,nz
            tau_x(j,i)=v(j,i)*tau_x(j,i)
            tau_z(j,i)=v(j,i)*tau_z(j,i)
         end do
      end do

      return
      end

c----------------------------------------------------------------------

      subroutine bisect_grad_inv(nz,nx,tau_x,tau_z,ipdmp,ier)

c on call: tau_z, tau_x components of alleged unit vector making
c angle PSI with the vertical

c on return: tau_z, tau_x are components of the unit vector making
c angle PSI/2 with the vertical

c note that cos(psi/2)=sqrt(0.5*(1+cos(psi))
c           sin(psi/2)=sqrt(0.5*(1-cos(psi))
c these formulas (with safeguards for the square roots) are used here,
c with one further refinement: the sign function is used to transfer
c the original sign of each trig function.

      integer nz,nx,ipdmp,ier

      real tau_x(nz,nx), tau_z(nz,nx)

      integer i,j

      real s, tol

      tol=1.e-7

      do i=1,nx
         do j=1,nz
            s=sqrt(max(tol,0.5*(1.0e+00-tau_z(j,i))))
            tau_x(j,i)=sign(s,tau_x(j,i))
            s=sqrt(max(tol,0.5*(1.0e+00+tau_z(j,i))))
            tau_z(j,i)=sign(s,tau_z(j,i))
         end do
      end do

      return
      end

      
