      Program main

      integer
     &     velnz,velnx,velny,     ! dimension velocity model
     &     reflnz,reflnx,reflny,  ! dimension reflectivity model 
     &     seismnt,               ! 1st (sample)dimension seismogram
     &     seismnx,               ! 2nd (trace) dimension seismogram
     &     seismny,               ! 3rd (trace) dimension seismogram
     &     srcnt,            ! number of source samples
     &     firstrec,         ! first record to be traced in this run
     &     lastrec,          ! last record to be traced in this run
     &     len_work,         ! length of available workspace
     &     tt_size,          ! traveltime and amplitude buffer size in words
     &     tt_sam,           ! resampling rate for traveltime map
     &     amp_op,           ! flag for forward amplitude (=1, const vel)
     &     marginx,marginy   ! the number of layers for tt/amp-domain to be
c                              expanded from reflectivity domain

      parameter(velnz  =11,  velnx  =11,  velny  =11)
      parameter(reflnz =101, reflnx =101, reflny =101)
      parameter(marginx=16, marginy=16)
      parameter(len_work=13000000, tt_size=1)
      parameter(seismnt=801,seismnx=41,seismny=41,srcnt=101)
      parameter(firstrec=1, lastrec=1, nblock=lastrec-firstrec+1)

*      parameter(tt_sam =4)
*      parameter(impulse=1)    ! =1, impulse response; else, gaussian source
*      parameter(amp_op=0)     ! flag for forward amp option (=1, constant vel)
*      parameter(lineprint=2)  ! test line-print (=1,2,3, print tt & amp)

      character*40 outfile    ! the out file name

c declarations of arrays

      real
     &     vel(velnz*velnx*velny),                ! velocity model 
     &     refl(nblock*reflnz*reflnx*reflny),     ! output reflectivity
     &     src(srcnt),                            ! source
     &     seism(seismnt,seismnx,seismny,nblock), ! input seismogram
     &     work(len_work),                        ! work array
     &     tt(tt_size)                            ! buffer for tt and amp

      real srcgeom(3,nblock),recgeom(3,seismnx,seismny,nblock)

c ===========================
c end of parameter setting
c ===========================

      integer 
     &     reflnxs,          ! third dimension reflectivity model 
     &     seismnxs,         ! dimension seismogram in third (record) dimension
     &     update,           ! update flag - new bg (1) or old (0)
     &     save_ttamp        ! flag whether tt/amp tables should be saved

      integer inv_flag       ! integer flag: = 1 for inversion, = 0 for adjoint

      integer 
     &     gather_flag,      ! gather flag (0: CSG, 1: COG)
     &     ntaper,           ! number of traces to be tapered
     &     ipout,            ! output file unit (terminal)
     &     ipdmp,            ! dump file unit
     &     idbg,             ! debug flag
     &     iverb,            ! verbosity flag
     &     ier               ! error flag

      real 
     &     seismdt,          ! sample distance in traces seismogram
     &     seismdx,          ! sample distance between traces seismogram
     &     seismdxs,         ! sample distance between records seismogram 
     &     seismtorig,       ! initial offset trace
     &     seismxorig,       ! initial trace offset first trace
     &     seismxsorig,      ! location of first shot in line
     &     srcdep,           ! shot depth
     &     recdep,           ! trace depth
     &     srcdt             ! source sample distance
     &     srctorig          ! source time origin
      real
     &     t0,               ! mute zero offset intercept
     &     tf,               ! mute final time
     &     mv,               ! muting velocity
     &     wmz,              ! width of mute zone
     &     veldz,            ! sample distance in 1st direction velocity model
     &     veldx,            ! sample distance in 2nd direction velocity model
     &     velzorig,         ! initial offset velocity model first direction
     &     velxorig,         ! initial offset velocity model second direction
     &     refldz,           ! sample distance in 1st direction refl model
     &     refldx,           ! sample distance in 2nd direction refl model
     &     reflzorig,        ! initial offset reflectivity model 1st direction
     &     reflxorig,        ! initial offset reflectivity model 2nd direction
     &     rho               ! density
      real 
     &     ap,               ! aperture of amplitude calculation kirchhoff
     &     zd                ! datum depth

c workspace for Helmholtz application

      integer idbg_helm         ! debug flag for Helmholtz

c 3D extension, SKIM
      real veldy,seismdy,refldy,velyorig,reflyorig
      real tarray(2)
      common /prline/ lineprint0
      common /s4print/ printdepth

      tbegin=etime(tarray)
c =========================
c  setting the parameters
c =========================
      write(ipout,'("  ##### Runkirchadj.f: tt_size =",i8)') tt_size

c ---- integer 
      reflnxs=1        ! third dimension reflectivity model 
      seismnxs=1       ! dimension seismogram in third (record) dimension
      update=1         ! update flag - new bg (1) or old (0)
      save_ttamp=1     ! flag whether tt/amp tables should be saved

c ---- integer
      inv_flag=0    ! integer flag: = 1 for inversion, = 0 for adjoint

c ---- integer 
      gather_flag=0    ! gather flag (0: CSG, 1: COG)
      ntaper=0         ! number of traces to be tapered
      ipout=6          ! output file unit (terminal)
      ipdmp=7          ! dump file unit
      idbg=1           ! debug flag
      iverb=1          ! verbosity flag
      ier=0            ! error flag

c ---- real 
      seismdt=4.0       ! sample distance in traces seismogram
      seismdx=50.0      ! sample distance between traces seismogram
      seismdxs=50.0     ! sample distance between records seismogram 
      seismtorig=0.0    ! initial offset trace
      seismxorig=-1000. ! initial trace offset first trace, SKIM
      seismxsorig=2000. ! location of first shot in line, SKIM
      srcdep=8.0        ! shot depth, SKIM
      recdep=8.0        ! trace depth, SKIM
      srcdt=4.0         ! source sample distance
      srctorig=0.0      ! source time origin
c ---- real
      t0=0.             ! mute zero offset intercept
      tf=4000.0         ! mute final time
      mv=2.0            ! muting velocity
      wmz=100.0         ! width of mute zone
      veldz=20.0        ! sample distance in 1st direction velocity model
      veldx=20.0        ! sample distance in 2nd direction velocity model
      velzorig=0.0      ! initial offset velocity model first direction
      velxorig=1000.0   ! initial offset velocity model second direction
      refldz=20.0       ! sample distance in 1st direction refl model
      refldx=20.0       ! sample distance in 2nd direction refl model
      reflzorig=0.0     ! initial offset reflectivity model 1st direction
      reflxorig=1000.0  ! initial offset reflectivity model 2nd direction, SKIM
      rho=1.0           ! density
c ---- real 
      ap=75.0           ! aperture of amplitude calculation kirchhoff
      zd=100.0          ! datum depth

c workspace for Helmholtz application

c ---- integer
      idbg_helm=0      ! debug flag for Helmholtz

c ---- real   
      veldy= veldx
      refldy= refldx
      seismdy= seismdx
      velyorig= -real(velny/2)*veldy
      reflyorig= -real(reflny/2)*refldy
      seismysorig=0.0

c -----------------------------------------------------------
      open(2, file="/symes_west/skim/kirch3d/src/DATA_File")
      read(2,*) tt_sam
      read(2,*) ap
      read(2,*) impulse
      read(2,*) amp_op
      read(2,*) lineprint
      read(2,*) printdepth
      close(2)
      lineprint0=lineprint
c -----------------------------------------------------------
      ione=1
      fzero=0.0

c =========================
c constant velocity
c =========================
      nvel= velnz*velnx*velny
      convel= 2.0
      call sconst(nvel,convel,vel,ione)

c-- source and receiver locations
c---------------------------------

      do k=1,nblock
         srcgeom(1,k)=srcdep
         srcgeom(2,k)=seismxsorig+float(k-1)*seismdxs
         srcgeom(3,k)=seismysorig
      do j=1,seismny
         py=reflyorig+float(j-1)*seismdy
      do i=1,seismnx
         px=reflxorig+float(i-1)*seismdx
         recgeom(1,i,j,k)=recdep
         recgeom(2,i,j,k)=px
         recgeom(3,i,j,k)=py
      end do
      end do
      end do

c -----------------------------------------------------------
c if(impulse=1) Impulse response
c else          Gaussian source & Ricker wavelet seismogram
c -----------------------------------------------------------
      if(impulse.eq.1) then
         if(iverb.gt.0) write(ipout,*)' IMPULSE RESPONSE'
         if(idbg .gt.0) write(ipdmp,*)' IMPULSE RESPONSE'
         call sconst(srcnt,fzero,src,ione)
         src(1)=1.0e+00
      else
         if(iverb.gt.0) write(ipout,*)' GUASSIAN SOURCE'
         if(idbg .gt.0) write(ipdmp,*)' GUASSIAN SOURCE'
         freq=30.0
         call guassian(src,srcnt,srcdt,fzero,freq)
      endif

c-- compute the data
c---------------------

c--initialization for the array "seism"

      ntmp=seismnt*seismnx*seismny*nblock
      call sconst(ntmp,fzero,seism(1,1,1,1),ione)

      oneover4pi =1./(4.*3.1415927)

      do 100 kk=1,2
c-- kk=1: a dip reflector
c-- kk=2: a fat reflector

      if (kk.eq.1) then
         zb=1000.
         dip=15.*3.1415927/180.
      else if (kk.eq.2) then
         zb=1500.
         dip=0.0
      endif

      do k=1,nblock
         distance=cos(dip)*abs(tan(dip)*(srcgeom(2,k)-reflxorig)
     &            +srcgeom(1,k)-zb)
         rptz=srcgeom(1,k)+2.*distance*cos(dip)
         rptx=srcgeom(2,k)+2.*distance*sin(dip)
         rpty=srcgeom(3,k)
      do j=1,seismny
      do i=1,seismnx
         travel_dist=sqrt((recgeom(1,i,j,k)-rptz)**2
     &                   +(recgeom(2,i,j,k)-rptx)**2
     &                   +(recgeom(3,i,j,k)-rpty)**2)
         ttime=travel_dist/convel
         amp=oneover4pi/travel_dist

         if (impulse.eq.1) then
            n1=min(seismnt,nint(ttime/seismdt))
            seism(n1,i,j,k)=seism(n1,i,j,k)+amp
         else
            call ricker(seism(1,i,j,k),seismnt,seismdt,ttime,freq,amp)
         end if
      end do
      end do
      end do

 100  continue

******************************************************************
*      outfile='GauassianData.sep'
*      ione=1
*      midy=seismny/2+1
*      call pr_2d_section(outfile,seismnt,seismnx,seismny,seism,
*     &    ione,seismnt,ione,seismnx,midy,midy,
*     &    reflzorig,reflxorig,reflyorig,seismdt,seismdx,seismdy,
*     &    irefout,ipdmp,ipout,ier)
*      if(ione.eq.1) stop
*****************************************************************

c =========================
c  calling KIRCHADJ
c =========================

      call kirchadj(inv_flag, vel,refl,src,seism,
     &     seismnt,seismnx,seismnxs,seismdt,seismdx,seismdxs,
     &     seismtorig,seismxorig,seismxsorig,
     &     srcdep,recdep,
     &     velnz,velnx,veldz,veldx,velzorig,velxorig,
     &     srcnt,srcdt,srctorig,
     &     reflnz,reflnx,reflnxs,refldz,refldx,reflzorig,reflxorig,
     &     amp_op,ap,zd,t0,tf,mv,wmz,ntaper,
     &     save_ttamp,tt_sam,tt_size,tt,
     &     firstrec,lastrec,marginx,marginy,
     &     gather_flag,len_work,work,
     &     iverb,idbg,idbg_helm,
     &     update,ipout,ipdmp,ier,
     &     velny,reflny,seismny,
     &     veldy,refldy,seismdy,velyorig,reflyorig,
     &     srcgeom,recgeom)

      if (ier.eq.0) then
         write(ipout,'(/" SUCCESS: end of simulation loop")')
      end if

      tend=etime(tarray)
      write(ipout,'(" The elapsed time =",f8.2)') tend-tbegin
      write(ipdmp,'(" The elapsed time =",f8.2)') tend-tbegin

c =========================
c  Printing REFL
c =========================

      outfile='Refl3Dy1.sep'
      ione=1

         do iii=1,3
         midy=iii*(reflny/4)+1
         if(iii.eq.2) outfile(7:8)='y2'
         if(iii.eq.3) outfile(7:8)='y3'
         call pr_2d_section(outfile,reflnz,reflnx,reflny,refl(1),
     &      ione,reflnz,ione,reflnx,midy,midy,
     &      reflzorig,reflxorig,reflyorig,refldz,refldx,refldy,
     &      irefout,ipdmp,ipout,ier)
         end do

         do iii=1,3
         ifix=iii*(reflnx/4)+1
         if(iii.eq.1) outfile(7:8)='x1'
         if(iii.eq.2) outfile(7:8)='x2'
         if(iii.eq.3) outfile(7:8)='x3'
         call pr_2d_section(outfile,reflnz,reflnx,reflny,refl(1),
     &      ione,reflnz,ifix,ifix,ione,reflny,
     &      reflzorig,reflxorig,reflyorig,refldz,refldx,refldy,
     &      irefout,ipdmp,ipout,ier)
         end do

*         ifixz=51
*         outfile(7:9)='z01'
*         call pr_2d_section(outfile,reflnz,reflnx,reflny,refl(1),
*     &      ifixz,ifixz,ione,reflnx,ione,reflny,
*     &      reflzorig,reflxorig,reflyorig,refldz,refldx,refldy,
*     &      irefout,ipdmp,ipout,ier)
*
*         ifixz=61
*         outfile(7:9)='z02'
*         call pr_2d_section(outfile,reflnz,reflnx,reflny,refl(1),
*     &      ifixz,ifixz,ione,reflnx,ione,reflny,
*     &      reflzorig,reflxorig,reflyorig,refldz,refldx,refldy,
*     &      irefout,ipdmp,ipout,ier)
*
*         ifixz=62
*         outfile(7:9)='z03'
*         call pr_2d_section(outfile,reflnz,reflnx,reflny,refl(1),
*     &      ifixz,ifixz,ione,reflnx,ione,reflny,
*     &      reflzorig,reflxorig,reflyorig,refldz,refldx,refldy,
*     &      irefout,ipdmp,ipout,ier)
*
      stop
      end

