c============================ READ_TTDATA ================================
      subroutine read_ttdata3d(cache,inversion,
     &     velmodel,tt,work,token,
     &     velnz,velzorig,veldz,velnx,velxorig,veldx,
     &     seismnt,seismdt,marginx,marginy,
     &     n1box,o1box,n2box,o2box,
     &     srcdep,srcpos,save_ttflag,tt_sam,tt_size,
     &     cv_flag,update,lenwork,ntables,
     &     rho,ap,zd,nfls,ipout,ipdmp,idbg,iverb,ier,
     &     velny,velyorig,veldy,n3box,o3box,srcpy,
     &     reflnz,reflnx,reflny,reflzorig,reflxorig,reflyorig)

c RV      07.93
c rev WWS 11.94
c rev WWS 11.95
c rev WWS 07.96
c rev WWS 09.96

c determines grid on which traveltimes will be computed and Kirchhoff
c summation performed (n1box, n2box, o2box).
c reads or creates traveltime data for a source centered horizonatally
c at location (srcdep,srcpos) in the n1box x n2box grid at (horizontal)
c offset o2box. Assumes homogeneous medium to
c depth zd, cuts off traveltime and amplitude computation
c outside of aperture ap. Does actual computation on resampled
c grid with resample factor tt_sam. Manages list of already computed
c source locations and saved files in static local arrays
c (srcloc, srcfile). If save_ttflag = 1 saves computed tt/amp fields
c on decimated grid to file. If update = 0 uses any tt/amp tables
c found in files with correct location; else computes them.

c INPUT ARGUMENTS:

      integer inversion         ! true if you want to use Beylkin Method
c                                 false otherwise                              
      integer
     &     ier,                 ! error flag
     &     ipdmp,               ! dump unit
     &     cache,               ! flag for cache initialization
     &     lenwork,             ! length of work array
     &     tt_sam,              ! resample factor (1,2 or 4)
     &     tt_size,             ! size of cache
     &     token,               ! identifier - used to mark subsets of
c                                 tables to replace selectively 
     &     cv_flag,             ! amplitude option
     &     velnz,               ! first dimension of velocity model
     &     velnx,               ! second dimension of velocity model
     &     seismnt,             ! number of time samples in trace
     &     save_ttflag,         ! flag indicating whether the traveltimes 
c                                 should be saved to disk
     &     update               ! flag indicating whether new maps should 
c                                 be calculated EVEN if they exist

      real 
     &     srcpos,              ! source offset
     &     srcdep,              ! source depth
     &     velzorig,            ! coord of 1st sample, dim1, vel model
     &     velxorig,            ! coord of 1st sample, dim2, vel model
     &     veldz,               ! sample rate, dim1, vel model
     &     veldx,               ! sample rate, dim2, vel model
     &     seismdt,             ! sample rate in time, seismogram
     &     rho,                 ! density
     &     ap,                  ! aperture for amplitude cutoff
     &     zd                   ! datum depth - vel is const above this

c     velocity model
      real
     &     velmodel(velnz,velnx,velny)

c     workspace buffers
      real
     &     tt(tt_size),
     &     work(lenwork)

c OUTPUT ARGUMENTS:

      integer
     &     n1box,               ! first dimension of tt/amp/tau_x/tau_z box
     &     n2box,               ! second dimension of tt/amp/tau_x/tau_z box
     &     ttamp_ptr            ! pointer to array containing tt in first part,
c                                 amp in second part, tau_x in third part
c                                 tau_z in fourth and phi_xr fifth part
c                                 and apcut in the sixth part
      real
     &     o1box,
     &     o2box                ! offset of left edge of
c                                 tt/amp/tau_x/tau_z/phi_xr box

c 3-D, SKIM
      integer velny,n3box
      real    velyorig,veldy,o3box
      integer reflnz,reflnx,reflny
      real    reflzorig,reflxorig,reflyorig

c INTERNAL VARIABLES:

      integer 
     &     n1box_s,             ! 1st dim of coarse grid tt/amp/tau_x/tau_z box
     &     n2box_s,             ! 2nd dim of coarse grid tt/amp/tau_x/tau_z box
     &     o2box_index,         ! index of left side of tt/amp/tau_x/tau_z box
     &     lenwork_loc,         ! workspace remaining after local needs
     &     work_ptr,             ! index to beginning of free workspace
     &     rw,                  ! read/write flag
     &     sindex,              ! source index
     &     oldest,              ! index of oldest table in cache
     &     oldestage,           ! age of oldest table in cache
     &     i,j,iv,jv,           ! loop counters
     &     ivmin,jvmin,         ! corner indices of velocity grid
     &     idbg                 ! debug flag

      integer ntables

      real
     &     o1box_s,             ! 1st dim origin of coarse grid
c                                 tt/amp/tau_x/tau_z/phi_xr box
     &     o2box_s,             ! 2nd dim origin of coarse grid
c                                 tt/amp/tau_x/tau_z/phi_xr box
     &     d1box_s,             ! 1st dim sample rate of coarse grid
c                                 tt/amp/tau_x/tau_z/phi_xr box
     &     d2box_s,             ! 2nd dim sample rate of coarse grid
c                                 tt/amp/tau_x/tau_z/phi_xr box
     &     srcpos_box           ! rel offset of src in its box

      integer n3box_s
      real o3box_s,d3box_s

      integer
     &     ttamp_sptr,          ! pointer to seg of work holding resampled
c                                 tt/amp/tau_x/tau_z/tau_xx_xr
     &     vel_sptr             ! pointer to seg of work holding resampled vel

      integer 
     &     next,                ! pointer to next free word in work buffer
     &     size                 ! length of segment to grab out of work

      integer
     &     nfls,                ! number of saved traveltime tables
     &     nfls_incore,         ! number saved incore
     &     top_incore,          ! number of words saved incore
     &     mxfls                ! maximum number of sources & receivers
      parameter (mxfls=1)

      integer
     &     srcoff(mxfls),       ! offset of table in tt buffer
c                                 set = 0 when table is not present in core
     &     srcage(mxfls),       ! age parameter - used in "oldest out" rule
c                                 set = 0 when table is not present in core
c                                 always started at 1, so oldest table always
c                                 has srcage = nfls_incore
     &     srctoken(mxfls)      ! token - used to identify subsets of cache
      real srcloc(mxfls,3)      ! coordinates of source positions already
c                                 visited in this simulation
      character*80 
     &     srcfile(mxfls)       ! filenames for saved tt/amp arrays

      logical new(mxfls)        ! true if model is new and tt/amp arrays
c                                 must be recomputed

c      static 
      save
     &     nfls_incore,top_incore,
     &     srcloc, srcfile, new,
     &     srcage, srctoken,
     &     srcoff               ! these should be saved from call to call

      real test,tol             ! used to determine whether current source
c                                 location has already been visited

      real 
     &     slnsavg,             ! slowness average - updated for each
c                                 new velocity model, used for computation
c                                 of traveltime box 
     &     maxtime,             ! time limit
     &     maxoff,              ! max offset = sin(ap)*max depth
     &     maxdep,              ! max depth reached at average slowness
     &     pi,                  ! uh... let's see ...
     &     fudge                ! factor to give margin for deviation from 
c                                 average slowness - weak spot in this design

      save slnsavg            ! keep this around so that it only needs computing
c                                 at beginning of new sim with new vel

      logical found             ! flag for search on source location

      character*4 
     &     ftyp,                ! format designator for tt/amp files
     &     ext4                 ! 4 digit character rep of file number

      character*3 ext3          ! 3 digit character rep of file number
      character*2 ext2          ! 2 digit character rep of file number
      character*1 ext1          ! 1 digit character rep of file number
      character*1 blank

      character charbuf(80)     ! character array in which to store 
c                                 c-compatible string

      integer ntotal            ! workspace for total words read/written
c                                 to disk
      data tol /1.0e-2/
      data fudge /1.2e+00/, pi /3.1415927e+00/
      data blank /' '/

c------------------------------------------------------

      if (ier.ne.0) return

      if (idbg.gt.0) then
         write(ipdmp,*) 'Entering READ_TTDATA'
         write(ipdmp,*) ' workspace available = ',lenwork
      endif

      if (tt_sam.lt.1) then
         write(ipdmp,*)' Error: READ_TT'
         write(ipdmp,*)' resample rate = ',tt_sam,' should be >= 1'
         ier=9
         return
      end if
         
      ftyp='.sep'

c initialize the pointer to free workspace, save length of
c work vector

      lenwork_loc = lenwork

c  NEW COMPUTATION/SIMULATION

      if (idbg.gt.0) then
         write(ipdmp,*)' READ_TT: compute average slowness'
      end if
      if ((nfls.eq.0).or.(.not.found)) then
         slnsavg=0.0e+00
         do k=1,velny
         do j=1,velnx
         do i=1,velnz
               slnsavg=slnsavg + 1.0/velmodel(i,j,k)     
         end do
         end do
         end do
         slnsavg=slnsavg/(velnz*velnx*velny)
      end if   

      if (idbg.gt.0) then
         write(ipdmp,*)' READ_TT: slnsavg = ',slnsavg
      end if
         
c  compute one-way time to deepest possible reflection point
c  at average slowness. Use this plus aperture to compute
c  max offset. limit depth to deepest point in model.

c  Symes, 230996: DON'T limit depth to deepest point in (velocity) model
c  assumes minimum depth = 0 (but not min depth in velocity model!)

      maxtime=0.5*(seismnt-1)*seismdt
      maxdep=maxtime/slnsavg         
      maxoff=maxdep*sin(ap*pi/180.0e+00)
         
c  note that n2box is defined so as always to be odd
c  also define n1box so that after adjustment for resampling
c  will guaranteed be less that velnz
         
c  revision of 230996: no longer restrict n1box by velnz

c      n1box=nint((srcdep+maxdep)/veldz)+1
c      n2box=2*nint(fudge*maxoff/veldx)+1
         
c revision of June 1997: SKIM

      n1box=min(nint((srcdep+maxdep)/veldz)+1,
     &          reflnz+int(reflzorig/veldz))

      surf_dist= fudge*abs(maxoff)
      x_margin = float(marginx)*veldx
      y_margin = float(marginy)*veldy

      x11=min(srcpos,reflxorig) -x_margin
      x11=max(x11,(srcpos-surf_dist))

      x22=max(srcpos,(reflxorig+float(reflnx-1)*veldx)) +x_margin
      x22=min(x22,(srcpos+surf_dist))

      y11=min(srcpy,reflyorig) -y_margin
      y11=max(y11,(srcpy-surf_dist))

      y22=max(srcpy,(reflyorig+float(reflny-1)*veldy)) +y_margin
      y22=min(y22,(srcpy+surf_dist))

      x11=float(nint(x11/veldx))*veldx
      y11=float(nint(y11/veldy))*veldy

      n2box=nint((x22-x11)/veldx)
      n3box=nint((y22-y11)/veldy)
 
      o1box=0.0e+00
      o2box=x11
      o3box=y11

      o1box_s=o1box
      o2box_s=o2box
      o3box_s=o3box

c  define the resampled grid, if necessary redefine the n1box and n2box
c  dimensions
         
      n1box_s=1+nint(float(n1box-1)/float(tt_sam))
      n2box_s=1+nint(float(n2box-1)/float(tt_sam))
      n3box_s=1+nint(float(n3box-1)/float(tt_sam))

      n1box=1+(n1box_s-1)*tt_sam
      n2box=1+(n2box_s-1)*tt_sam
      n3box=1+(n3box_s-1)*tt_sam

      write(ipout,'("  box size: nz,nx,ny =",3(1x,i4))')
     &       n1box,n2box,n3box
      write(ipout,'("  comp box: nz,nx,ny =",3(1x,i4))')
     &       n1box_s,n2box_s,n3box_s

c  make max offset and source position integer multiples of veldx,
c  use to define o2box = left edge of tt/amp box
c  revision of 230996: o1box_s is always = 0

c      o1box=velzorig
c      o1box=0.0e+00
c      maxoff=(n2box-1)*veldx*.5
c      o2box=nint(srcpos/veldx)*veldx - maxoff
         
      if (idbg.gt.0) then
         write(ipdmp,*)' READ_TT: computation of tt/amp box'
         write(ipdmp,*)' nfls:                  ',nfls
         write(ipdmp,*)' resample rate          ',tt_sam
         write(ipdmp,*)' average slowness:      ',slnsavg
         write(ipdmp,*)' maximum offset:        ',maxoff
         write(ipdmp,*)' maximum time:          ',maxtime
         write(ipdmp,*)' maximum depth range:   ',maxdep
         write(ipdmp,*)' n1box:                 ',n1box
         write(ipdmp,*)' n2box:                 ',n2box
         write(ipdmp,*)' n3box:                 ',n3box
         write(ipdmp,*)' o1box:                 ',o1box
         write(ipdmp,*)' o2box:                 ',o2box
         write(ipdmp,*)' o3box:                 ',o3box
         write(ipdmp,*)' n1box_s                ',n1box_s
         write(ipdmp,*)' n2box_s                ',n2box_s
         write(ipdmp,*)' n3box_s                ',n3box_s
      end if
         
c  sample rates

      d1box_s=veldz*tt_sam
      d2box_s=veldx*tt_sam
      d3box_s=veldy*tt_sam
         
c  workspace allocation - finite difference computation
c  set up space to hold fine grid ttamp tables - must be done
c  here to guarantee that this is the first segment of work on return

      if (idbg.gt.0) then
         write(ipdmp,*)' setting up workspace for ttamp grids'
         write(ipdmp,*)' lenwork = ',lenwork
      endif

      next=1
      size=ntables*n1box*n2box*n3box
   
      call getbuf('work',ttamp_ptr,size,next,lenwork,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: READ_TT from GETBUF for ttamp_ptr'
         return
      end if

c  set up workspace to hold coarse grid traveltime,
c  amplitudes, x_component, z_component of gradient of traveltime
c  and mixed x, x_r derivative of traveltime.
         
      size=ntables*n1box_s*n2box_s*n3box_s
      call getbuf('work',ttamp_sptr,size,next,lenwork,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: READ_TT from GETBUF for ttamp_sptr'
         return
      end if
         
c  to create source: resample velocity to coarser grid, compute tt/amp
c  on coarse grid, save to file if indicated, then interpolate back
c  to original grid
         
      size = n1box_s*n2box_s*n3box_s
      call getbuf('work',vel_sptr,size,next,lenwork,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: READ_TT from GETBUF for vel_sptr'
         return
      end if
 
c  revision of 230996, real meat: here you sample the velocity, not
c  on its own grid, but possibly outside - the velocity gets extended
c  by constants, first vertically then horizontally

c  these give the upper left corner indices of the velocity model in 
c  the reflectivity grid, assuming (as we still do for the moment) that
c  the grid spacings are the same.

      jvmin=nint((velzorig-o1box_s)/veldz)
      ivmin=nint((velxorig-o2box_s)/veldx)
      kvmin=nint((velyorig-o3box_s)/veldy)

CDIR$ NORECURRENCE
      do k=1,n3box_s
            kvel=vel_sptr-1+(k-1)*n1box_s*n2box_s
            kv=1-kvmin+(k-1)*tt_sam
            kv=min(velny,max(1,kv))
      do i=1,n2box_s
            ivel=kvel+(i-1)*n1box_s
            iv=1-ivmin+(i-1)*tt_sam
            iv=min(velnx,max(1,iv))
      do j=1,n1box_s
            jv=1-jvmin+(j-1)*tt_sam
            jv=min(velnz,max(1,jv))
         work(ivel+j) = velmodel(jv,iv,kv)
      end do
      end do
      end do
         
      if (idbg.gt.0) then
         write(ipdmp,*)' READ_TT: pointers'
         write(ipdmp,*)' ttamp_ptr       = ',ttamp_ptr
         write(ipdmp,*)' ttamp_sptr      = ',ttamp_sptr
         write(ipdmp,*)' vel_sptr        = ',vel_sptr
      end if

c  update lenwork_loc - note that original length of work vector is
c  still in lenwork
         
      lenwork_loc=lenwork_loc-next
         
c  in the call to stt, note that velzorig is assumed to have stayed
c  the same in the restriction to the box, whereas velxorig has been
c  shifted to o2box. So the relative srcpos has shifted but the
c  relative srcdep has not.
         
      srcpos_box=srcpos-o2box
         
      call stt_create3d(inversion,ntables,tt_sam,
     &     n1box_s,o1box_s,d1box_s,
     &     n2box_s,o2box_s,d2box_s,seismdt,
     &     srcpos,srcdep,srcpy,
     &     work(vel_sptr),cv_flag,work(ttamp_sptr),
     &     work(next),lenwork_loc,rho,ap,zd,ipout,ipdmp,idbg,iverb,ier,
     &     n3box_s,o3box_s,d3box_s)

      if (ier.ne.0) then
         write(ipdmp,*)' Error: READ_TT from STT_CREATE  '
         return
      end if
         
c  ALWAYS update nfls and the srcloc and srcfiles arrays, even
c  if save_ttflag = 0 - because nfls also flags the computation
c  of the box parameters
         
c  also unset the update flag for this position

      nfls = nfls+1

c  MAJOR REDESIGN of 19.08.96: the code to write out data used to be
c  here - now have moved to "bump" segment as tables are written only
c  when they are bumped.

c  NOW, INTERPOLATION: internal coarse grid ---> external grid

      call interpolate3D(work(ttamp_ptr),work(ttamp_sptr),
     &     n1box,n2box,n3box,n1box_s,n2box_s,n3box_s,
     &     ntables,tt_sam,ipdmp,idbg,ier)

      if (ier.ne.0) then
         write(ipdmp,*)' Error: READ_TT from INTERPOLATE  '
         write(ipdmp,*)' ier = ',ier
         return
      end if

      if (idbg.gt.0) then
         write(ipdmp,*)' Leaving READ_TTDATA'
         write(ipdmp,*)' workspace available = ',lenwork
      endif

      return 
      end

c====================================================================
       subroutine interpolate3D(ddfine,ddgros,
     &      n1fine,n2fine,n3fine,n1gros,n2gros,n3gros,
     &      ntables,nratio,ipdmp,idbg,ier)
c----------------------------------------------------------
c  This subroutine interpolates array "ddfine" onto array
c  "ddgros". NOTE that the arrays are 4-dimensional.
c  We have to interpolate for all the 4 dimensions.

c  SKIM 06/1997
c----------------------------------------------------------
       integer n1gros,n2gros,n3gros,n1fine,n2fine,n3fine
       integer nratio,ipdmp,ier,ntables
       integer i,j,k,n,im,jm,km,ii,imp,jmp,kmp
       integer n11,n22,n33

       real ddgros(n1gros,n2gros,n3gros,ntables)
       real ddfine(n1fine,n2fine,n3fine,ntables)
       real bot,top

c check array dimensions
c-------------------------

      n11= 1+(n1gros-1)*nratio
      n22= 1+(n2gros-1)*nratio
      n33= 1+(n3gros-1)*nratio

      if ((n11.ne.n1fine).or.(n22.ne.n2fine).or.(n33.ne.n3fine)) then
         write(ipdmp,*) ' Sorry, bad dimension specifications '
         ier= 713
         return
      end if

c for the case: nratio.eq.1
c----------------------------

      if(nratio.eq.1) then
CDIR$ NORECURRENCE
         do n=1,ntables
         do k=1,n3gros
         do j=1,n2gros
         do i=1,n1gros
            ddfine(i,j,k,n)= ddgros(i,j,k,n)
         end do
         end do
         end do
         end do
         return
      end if

c for the general cases: nratio.ge.2
c-------------------------------------
      fac =1.0/float(nratio)
      nratiom1=nratio-1

      do 1000 n=1,ntables

c fill the lines parallel to the 3rd-direction
c note that "ddfine(im,jm,km,n)=ddgros(i,j,k,n)" below

      do j=1,n2gros
           jm=(j-1)*nratio+1
      do i=1,n1gros
           im=(i-1)*nratio+1
           k=1                             ! for k=1
           km=(k-1)*nratio+1               ! initialize "km" and "top"
           top=ddgros(i,j,k,n)
           ddfine(im,jm,km,n)=top
      do k=2,n3gros
           kmp=km
           bot=top
           km =(k-1)*nratio+1
           top=ddgros(i,j,k,n)
           ddfine(im,jm,km,n)=top
           do ii=1,nratiom1
              ddfine(im,jm,kmp+ii,n)
     &           = (float(nratio-ii)*bot + float(ii)*top) * fac
           end do
      end do
      end do
      end do

c let us see how to fill the planes orthogonal to the 1st-direction
c can we use a similar strategy?

      do i=1,n1gros
           im=(i-1)*nratio+1
      do km=1,n33                          ! why "km=1,n33"??!!
           j=1                             ! for j=1
           jm=(j-1)*nratio+1               ! note: use "ddfine" only
           top=ddfine(im,jm,km,n)
      do j=2,n2gros
           jmp=jm
           bot=top
           jm =(j-1)*nratio+1
           top=ddfine(im,jm,km,n)
           do ii=1,nratiom1
              ddfine(im,jmp+ii,km,n)
     &           = (float(nratio-ii)*bot + float(ii)*top) * fac
           end do
      end do
      end do
      end do

c now, fill the insides of parallel planes, similarly

      do km=1,n33
      do jm=1,n22
           i=1                             ! for i=1
           im =(i-1)*nratio+1
           top=ddfine(im,jm,km,n)
      do i=2,n1gros
           imp=im
           bot=top
           im =(i-1)*nratio+1
           top=ddfine(im,jm,km,n)
           do ii=1,nratiom1
              ddfine(imp+ii,jm,km,n)
     &           = (float(nratio-ii)*bot + float(ii)*top) * fac
           end do
      end do
      end do
      end do

 1000 continue

      return
      end

