************************************************************************
*  3-D Traveltimes and Amplitude via Eikonal and Transport solvers     *
*  Maissa A. Abd El-Mageed                                             *
*  Rice Inversion Project                                              *
*  Copied from: /import/masc5a/maissa/dso3.2/src/tomo/ttamp3d.final    *
************************************************************************
*  SKIM: 6.97

      subroutine ttsolve3d(nx,ny,nz,dx,dy,dz,xmin,ymin,
     &     zmin,xs,ys,zs,rho,ap,zd,v,tt,amps,
     &     work,len_work,iverb,ipout,idbg,ipdmp,ier)

c Arguments:

      integer nx,ny,nz,         ! number of samples in x,y and z
     &        len_work          ! length of available workspace

      real tarray(2),time1,time2,etime,       
     &     dx,dy,dz,xmin,ymin,zmin,    ! steps and the upper left corner
     &     xs,ys,zs,                   ! source coordinates
     &     zd,ap,                      ! datum depth and faithful aperture
     &     v(nz,nx,ny),tt(*),amps(*),  ! velocity array and TT and AMP
     &     work(*)                     ! workspace

      real eik_eps    ! eikonal threshhold
      integer id_eno  ! token for 2nd-order ENO ux & uy (=1:ENO, =0:one-sided)

c----------------------------------------------------------------------

      if (ier.ne.0) return

      id_eno=1

      if (iverb.ge.1) then
         write(ipout,'("  ## id_eno =",i2)') id_eno
         write(ipout,'("  TTAMP3D...")')
         time1=etime(tarray)
      end if

c BIG DEBUG DUMP

      if (idbg.ge.1) then
         write(ipdmp,'(" TTAMP3D: debug dump"   /
     &      "  scalar arguments:"               /
     &      "  nx   = ",i12  / "  ny   = ",i12  / "  nz   = ",i12  /
     &      "  dx   = ",f12.4/ "  dy   = ",f12.4/ "  dz   = ",f12.4/
     &      "  xmin = ",f12.4/ "  ymin = ",f12.4/ "  zmin = ",f12.4/
     &      "  xs   = ",f12.4/ "  ys   = ",f12.4/ "  zs   = ",f12.4/
     &      "  zd   = ",f12.4/ "  ap   = ",f12.4)')
     &      nx,ny,nz,dx,dy,dz,xmin,ymin,zmin,xs,ys,zs,zd,ap
         write(ipdmp,'("  internal scalars: len_work =",i12)') len_work
      end if

c COMPUTE...

c initialize arrays (TTINIT) and downsweep (TTAMP)

      call ttinit(nx,ny,nz,dx,dy,dz,xmin,ymin,zmin,xs,ys,zs,
     &     rho,zd,ap,izd,eik_eps,v,tt,amps,iverb,ipout,idbg,ipdmp,ier)

      call ttamp(nz,nx,ny,dz,dx,dy,izd,eik_eps,v,tt,amps,
     &     work,len_work,iverb,ipout,idbg,ipdmp,ier,id_eno)

      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP3D from TTINIT/TTAMP'
         return
      end if

      if (iverb.ge.1) then
         time2=etime(tarray)
         write(ipout,'("  elapsed time =",f8.2)') time2-time1
      end if

      return
      end

c======================== TTINIT ================================

      subroutine ttinit(nx,ny,nz,dx,dy,dz,xmin,ymin,zmin,xs,ys,zs,
     &     rho,zd,ap,izd,eik_eps,v,tt,a,iverb,ipout,idbg,ipdmp,ier)

c initialized traveltime, traveltime gradient, and amplitude
c grids for 3D geometric acoustics,    WWS 5.93

c NOTE: it is ASSUMED that the velocity is constant over the intial grid
c WWS 7.94 revision of RV revision 2.94

c SKIM 6.97

c arguments

      integer
     &     nx,ny,nz,          ! global grid extents
     &     ipdmp,ier          ! dump unit, error flag

      real
     &     dx,dy,dz,          ! x,y and z steps
     &     xmin,ymin,zmin,    ! corner coordinates of global grid 
     &     xs,ys,zs,          ! source coordinates
     &     zd,                ! datum depth
     &     ap,                ! faithful aperture (degree)
     &     eik_eps,           ! eikonal cutoff
     &     v(nz,nx,ny),       ! input velocity array
     &     tt(nz,nx,ny),      ! traveltime array
     &     a(nz,nx,ny)        ! amplitude array
c internal variables

      integer isx,isy,isz,ix,iy,iz,izd
      real time_max,distance,distance1,tol,pi,velsrc,slwsrc
      real height,small,tancut,sincut
      real ttexact,gradient,rrbig,radius,rplain,rx2
c--------------------------------------------------------------------

      data tol /1.0e-2/, pi /3.1415927/, small /1.0e-4/

      if (ier.ne.0) return

c compute some useful scalars

      isx=nint((xs-xmin)/dx)+1
      isy=nint((ys-ymin)/dy)+1
      isz=nint((zs-zmin)/dz)+1
      izd=nint((zd-zmin)/dz)+1
      tancut=tan(pi*abs(ap)/180.0e+00)
      sincut=sin(pi*abs(ap)/180.0e+00)
      eik_eps=cos(pi*abs(ap)/180.0e+00)

      velsrc=v(isz,isx,isy)
      slwsrc=1./velsrc
      r4pi=rho/(4.*3.1415927)

      if ((velsrc.lt.tol).or.(dz.lt.small)) then
         write(ipdmp,*)' Error: TTINIT: velsrc or dz is too small'
         ier=ier+1
         return
      end if

      if (izd.le.isz) then
         izd=int((zs-zmin)/dz+1.0+tol)+1
         tmp=zmin+float(izd-1)*dz
         if (tmp.gt.zd) then
            zd=tmp
            if(iverb.ge.1) write(ipout,'("  THE NEW zd =",f10.4)') zd
            if(idbg.ge.1)  write(ipdmp,'("  THE NEW zd =",f10.4)') zd
         end if
      end if
      
      if (idbg.ge.1) then
         write(ipdmp,'("  TTINIT:"         /
     &      "  nx,ny,nz        = ",3(i12)  /
     &      "  dx,dy,dz        = ",3(f12.4)/
     &      "  xmin,ymin,zmin  = ",3(f12.4)/
     &      "  xs,ys,zs        = ",3(f12.4)/
     &      "  isx,isy,isz,izd = ",4(i12))')
     &   nx,ny,nz,dx,dy,dz,xmin,ymin,zmin,xs,ys,zs, isx,isy,isz,izd
      end if

c--Loop over grid points

c compute point source response
c
c Compute the radius of the circle and then compute the gradient at
c this radius
c 
c Calculate the travel time and the amplitudes.  The travel time is
c exact if it's inside the circle.  Otherwise it will be linearly
c approximated if it doesn't satisfy the angle condition.  ttexact is
c the exact travel time at the edge of the circle.  it is calculated at
c rrbig.

      height  = zmin+float(izd-1)*dz-zs
      rz2     = height**2
      rrbig   = height*tancut
      gradient= sincut*slwsrc
      ttexact = sqrt(rrbig**2+rz2)*slwsrc

CDIR$ NORECURRENCE
      do iy=1,ny
                  ry2=(ymin+float(iy-1)*dy-ys)**2
      do ix=1,nx
                  rx2=(xmin+float(ix-1)*dx-xs)**2
         radius=sqrt(rx2+ry2+rz2)
         a(izd,ix,iy)=r4pi/radius
         rplain=sqrt(rx2+ry2)
         if (rplain.le.rrbig) then
            tt(izd,ix,iy)=radius*slwsrc
         else
            tt(izd,ix,iy)=gradient*(rplain-rrbig)+ttexact
         end if
      end do
      end do

c      time_max=10000.
      time_max=0.0
      izdm1 = izd-1

CDIR$ NORECURRENCE
      do k=1,ny
      do j=1,nx
         temp_amp=a(izd,j,k)
      do i=1,izdm1
         tt(i,j,k)=time_max
         a(i,j,k) =temp_amp
      end do
      end do
      end do

      return
      end

c============================ TTAMP ==============================

      subroutine ttamp(nz,nx,ny,dz,dx,dy,ntop,eik_eps,v,tt,amp, 
     &     work,lenwork,iverb,ipout,idbg,ipdmp,ier,id_eno)
c-------------------------------------------------------------
c    3D traveltime and geometric optics amplitude solver
c
c    Driver to extend traveltime and amplitudes throughout
c    a rectangular array, given values on the ntop row (i.e.
c    first index = ntop) and above.
c
c    Uses 2nd order Runge-Kutta time step for numerical 
c    Hamiltonian operator, which returns both the nu-
c    merical Hamiltonian and a suitable right-hand side for
c    the transport equation. The local step is also returned
c    by this operator - it is chosen to be the minimum of a
c    safe CFL step and the remainder of the current step.
c
c    Current version (07.94): right hand sides of both eikonal
c    and transport equations are modified to limit ray incidence
c    angles to an aperture and to damp amplitudes along rays
c    at the aperture boundary.
c
c    WWW         05/93
c    HT          08/93
c    WWS         12/93
c    RV          02/94
c    WWS         07/94 - NOTE THAT EVOLUTION COORDINATE IS NOW 1ST!!!!
c    SKIM        06/97
c--------------------------------------------------------------
c--Arguments

      real dz,dx,dy,eik_eps,    ! steps and faithful threshhold
     &     v(nz,nx*ny), tt(nz,nx*ny), amp(nz,nx*ny), work(*)

      integer nz,nx,ny,         ! array dimensions
     &        ntop,             ! row index for initial data
     &        lenwork           ! size of available workspace

c--Internal Variables

      real pi, tol,
     &     dz_loc,step_total,   ! substep and partial step taken so far
     &     amp_peak_init,       ! amp peak
     &     amp_max,amp_min      ! max/min relative amplitude

      integer i,i1,k,j,jx,jy,jx1,jy1,
     &        newwork,             ! workspace available for subs
     &        max_partial_steps,   ! guess
     &        n2ny,nxn2            ! (nx+2)*ny and nx*(ny+2)

c--pointer to buffer: start with "id_"

      integer id_css,   id_nss,    ! current/next time level in ss
     &        id_iss,   id_ssz,    ! interpolation/z-derivative of ss
     &        id_eikrhs,id_trarhs, ! rhs of eik eqn / transport eqn
     &        id_tt1,   id_tt2,    ! travel time
     &        id_dxt,   id_dyt,    ! travel time x/y diff
     &        id_dxxt,  id_dyyt,   ! travel time 2nd x/y diff
     &        id_amp1,  id_amp2,   ! amplitude
     &        id_dxyt,  id_cutoff, ! tx 1st-diff in y  and cutoff
     &        id_work              ! workspace

      real dtaper
      integer ntaper

      logical done,adjust,amplitudes

      data tol /1.e-4/, max_partial_steps /50/, amplitudes /.true./,
     &     pi /3.1415927/, ntaper /4/    

c======================================================================

      if (ier.ne.0) return

c--useful numbers

      zero=0.0e+00
      nxny=nx*ny
      n2ny=(nx+2)*ny
      nxn2=nx*(ny+2)
      divdz=1.0/dz

c--set minimum, maximum relative amplitudes

      dtaper=1.0e+00/float(ntaper)
      amp_min=1.e-3
      amp_max=1.e+1

c--Grab memory

      id_work=1

      call getbuf('work', id_css,    nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_nss,    nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_iss,    nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_ssz,    nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_tt1,    nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_tt2,    nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_amp1,   nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_amp2,   nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_dxt,    nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_dyt,    nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_dxxt,   n2ny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_dyyt,   nxn2,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_dxyt,   nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_eikrhs, nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_trarhs, nxny,id_work,lenwork,ipdmp,ier)
      call getbuf('work', id_cutoff, nxny,id_work,lenwork,ipdmp,ier)

      if (ier.ne.0) then
         write(ipdmp,'("  Error: TTAMP: GETBUF for pointers: ",
     &         "ier =",i3)') ier
         return
      end if

      iss1=id_css        ! save the pointers
      iss2=id_nss        ! do not erase them

      newwork=lenwork-id_work
      amp_peak_init=0.0e+00

      do j=1,nxny
         amp_peak_init=max(amp_peak_init,amp(ntop,j))
      end do

      amp_max=max(1.0e-7,amp_peak_init*amp_max)
      amp_min=max(1.0e-7,amp_peak_init*amp_min)

      id_sszm1=   id_ssz-1
      id_tt1m1=   id_tt1-1
      id_tt2m1=   id_tt2-1
      id_amp1m1=  id_amp1-1
      id_amp2m1=  id_amp2-1
      id_eikrhsm1=id_eikrhs-1
      id_trarhsm1=id_trarhs-1

CDIR$ NORECURRENCE
      do j=1,nxny
         work(id_amp1m1+j)=log(max(amp(ntop,j),amp_min))
         work(id_tt1m1+j) =tt(ntop,j)
      end do

c--Debug instructions

      if (idbg.gt.0) then
         write(ipdmp,'("  TTAMP: inputs"/ "  nx,ny,nz,dx,dy,dz =",
     &      3(i4),3(f10.4))') nx,ny,nz,dx,dy,dz
      end if

      amp_min=log(amp_min)
      amp_max=log(amp_max)

      itotal=0
c==================================================================
      do 1000 i= ntop, nz-1
c==================================================================
c NOTE that the amplitude work vector contains the natural logarithm
c of the amplitude

c--Set step total to zero. Object is to reach dz

      step_total=zero
      done=.false.
      ip1=i+1

c--Set up square slowness arrays, this and next depth levels

      if (mod(i,2).eq.0) then
         id_css=iss1
         id_nss=iss2
      else
         id_css=iss2
         id_nss=iss1
      end if

      id_cssm1=id_css-1
      id_nssm1=id_nss-1

      if (i.eq.ntop) then
CDIR$ NORECURRENCE
         do j=1,nxny
            work(id_cssm1+j)=1.0/v(i,j)**2
         end do
      end if

CDIR$ NORECURRENCE
      do j=1,nxny
         work(id_nssm1+j)=1.0/v(ip1,j)**2
      end do

c--compute and save (s**2)_z

CDIR$ NORECURRENCE
      do j=1,nxny
         work(id_sszm1+j)=(work(id_nssm1+j)-work(id_cssm1+j))*divdz
      end do

c==PARTIAL STEP LOOP
c----------------------------------------------------------------
      do 2000 i1= 1,max_partial_steps
c----------------------------------------------------------------

c==interpolate square slowness field

      if (i1.eq.1) then
         id_iss=id_css
      else
         relstep=(dz-step_total)*divdz
         do j=1,nxny
            work(id_iss-1+j)=relstep*work(id_css-1+j)
     &                 +(1.-relstep)*work(id_nss-1+j)
         end do
      end if

c==First call to numerical hamiltonian.
c  Returns a suitable value of dz_loc each time. 

      adjust= .true.

      call eikonal_rhs3d(nx, ny, nz, i,
     &   work(id_iss),    work(id_tt1),  work(id_eikrhs),
     &   work(id_cutoff), work(id_dxt),  work(id_dyt), 
     &   work(id_dxxt),   work(id_dyyt), work(id_dxyt),
     &   dx, dy, dz_loc, dz, step_total, adjust, newwork, 
     &   eik_eps, work(id_work), ipdmp, idbg,ier)
      
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TTAMP from  EIK_RHS'
         return
      end if

c--First Runge-Kutta half-step for tt

CDIR$ NORECURRENCE
      do j=1,nxny
         work(id_tt2m1+j)=work(id_tt1m1+j)+dz_loc*work(id_eikrhsm1+j)
      end do

c==If amplitudes are to be computed evaluate RHS in transport equation
c  and take first RK half step for amps

      if (amplitudes) then
       
         call transport_rhs3d(nx, ny, nz, i, 
     &      work(id_iss),  work(id_ssz),
     &      work(id_tt1),  work(id_amp1), work(id_trarhs),
     &      work(id_dxt),  work(id_dyt),  work(id_dxxt), 
     &      work(id_dyyt), work(id_dxyt), work(id_eikrhs),
     &      work(id_cutoff),dx, dy, dz, dz_loc, step_total,
     &      newwork, work(id_work),ipdmp, idbg,ier,id_eno)

         if (ier.ne.0) then
            write(ipdmp,*)' Error: TTAMP from TRANS_RHS'
            return
         end if

CDIR$ NORECURRENCE
         do j=1,nxny
         work(id_amp2m1+j)=work(id_amp1m1+j)+dz_loc*work(id_trarhsm1+j)
         end do

c--otherwise just fill the amplitude array with ones
      else

CDIR$ NORECURRENCE
         do j=1,nxny
            amp(ip1,j)=1.0e+00
         end do
      end if

c==Second numerical Hamiltonian evaluation
c-------------------------------------------

      step_total=step_total+dz_loc
      adjust=.false.

      call eikonal_rhs3d(nx, ny, nz, i,
     &   work(id_iss),    work(id_tt2),  work(id_eikrhs),
     &   work(id_cutoff), work(id_dxt),  work(id_dyt), 
     &   work(id_dxxt),   work(id_dyyt), work(id_dxyt),
     &   dx, dy, dz_loc, dz, step_total, adjust, newwork, 
     &   eik_eps, work(id_work),ipdmp, idbg,ier)

c--Second Runge-Kutta half-step for tt

CDIR$ NORECURRENCE
      do j=1,nxny
         ntmp=id_tt1m1+j
         work(ntmp)=0.5*(work(ntmp)+work(id_tt2m1+j)
     &       +dz_loc*work(id_eikrhsm1+j))
      end do

c==Second evaluation of RHS of transport equation
       
      if (.not.amplitudes) goto 520

         call transport_rhs3d(nx, ny, nz, i,
     &      work(id_iss),  work(id_ssz),
     &      work(id_tt2),  work(id_amp2), work(id_trarhs),
     &      work(id_dxt),  work(id_dyt),  work(id_dxxt),
     &      work(id_dyyt), work(id_dxyt), work(id_eikrhs), 
     &      work(id_cutoff), dx, dy, dz, dz_loc, step_total,
     &      newwork, work(id_work),ipdmp, idbg,ier,id_eno)

c--Second RK half step for amps
                  
CDIR$ NORECURRENCE
         do j=1,nxny
            ntmp=id_amp1m1+j
            work(ntmp)=0.5*(work(ntmp)+work(id_amp2m1+j)
     &         +dz_loc*work(id_trarhsm1+j))
         end do

 520  continue

c==If successful record output fields

      if (abs(dz-step_total).ge.(tol*dz)) goto 2000

CDIR$ NORECURRENCE
      do j=1,nxny
         tt(ip1,j)=work(id_tt1m1+j)
      end do

      if (amplitudes) then
CDIR$ NORECURRENCE
         do j=1,nxny
            ntmp=id_amp1m1+j
            work(ntmp)=max(amp_min,min(amp_max,work(ntmp)))
            amp(ip1,j)=exp(work(ntmp))
         end do
      end if

      done=.true.
      goto 3000

c----------------------------------------------------------------
 2000 continue
c----------------------------------------------------------------
         
 3000 continue

c--If we're still not done, then we failed to find an ok step

      if (.not.done) then
         write(ipdmp,*) ' Error:TTAMP'
         write(ipdmp,*) ' after ', max_partial_steps, ' steps'
         write(ipdmp,*) ' failed to take step ', i
         ier=ier+1
         return
      end if

      itotal=itotal+i1
c==================================================================
 1000 continue
c==================================================================
      print*," ## itotal=",itotal

      return
      end
       
