c========================== eikonal_rhs3d ========================

      subroutine eikonal_rhs3d(nx,ny,nz,iz,
     &     ss,tt,ham,apcut,tx,ty,txx,tyy,txy,
     &     dx,dy,dz_loc,dz,step_total,adjust,lenwork,
     &     eik_eps,work,ipdmp,idbg,ier)

c---------------------------------------------------------------
c  Computes a numerical approximation to the Hamiltonian by means
c  of a 2nd order upwind finite-difference scheme For details see
c  paper by Osher & Sethian (1988, J. Comput. Phys. 79, pp.12-49).
c---------------------------------------------------------------
c-- Arguments

      integer nx,ny,nz,         ! grid dimensions
     &        iz,               ! current depth step
     &        lenwork           ! length of "work"

      real eik_eps,             ! eikonal threshhold
     &     step_total,          ! total step taken so far
     &     dx,dy,dz,            ! steps
     &     dz_loc               ! vertical step - full step on call

      real ss(nx,ny),           ! square slowness - interpolated
     &     tt(nx,ny),           ! travel time at current depth
     &     ham(nx,ny),          ! numerical hamiltonian - rhs for eik. scheme
     &     apcut(nx,ny),        ! Hermite tapered cutoff
     &     tx(nx,ny),           ! ENO first difference of tt in x
     &     ty(nx,ny),           ! ENO first difference of tt in y
     &     txx(nx+2,ny),        ! centered 2nd difference of tt in x
     &     tyy(nx,ny+2),        ! centered 2nd difference of tt in y
     &     txy(nx,ny),
     &     work(nx,ny,1)        ! workspace
      
c--Internal Variables

      real cfl_rhs,tol,zero,compa,divdx,divdy,div2dy,
     &     sqeps, sqrham,cutham,d1eno
      integer nxm1, nym1, j, k, jx, jy,
     &        id_dpx,id_dmx,id_dpy,id_dmy,workptr
      logical adjust

      data tol /1.0e-08/

c------------------------------------------------------------------

      if (ier.ne.0) return

c--Useful numbers
      zero=0.0e+00
      one=1.0e+00
      nxm1=nx-1
      nym1=ny-1
      divdx=1./dx
      divdy=1./dy
      div2dy=1./(2.*dy)

c--Allocate memory pointers
      id_dpx=1
      id_dmx=2
      id_dpy=3
      id_dmy=4

      if (lenwork.lt.(4*nx*ny)) then
         write(ipdmp,*) ' Error: eikonal_rhs3d: lenwork is small'
         ier=ier+1
         return
      end if

c--Compute tx=D^+_x\tau and ty=D^+_y\tau

      do jy=1,ny
      do jx=1,nxm1
         tx(jx,jy)=(tt(jx+1,jy)-tt(jx,jy))*divdx
      end do
      end do

      do jy=1,ny
         tx(nx,jy)=tx(nxm1,jy)
c         tx(nx,jy)=zero
      end do

      do jy=1,nym1
      do jx=1,nx
         ty(jx,jy)=(tt(jx,jy+1)-tt(jx,jy))*divdy
      end do
      end do

      do jx=1,nx
         ty(jx,ny)= ty(jx,nym1)
c         ty(jx,ny)=zero
      end do

c--Check for inflow at four faces of the cube, return if detected

      do jx=1,nx
         if (ty(jx,1).gt.zero) ier=ier+1
      end do
      do jx=1,nx
         if (ty(jx,nym1).lt.zero) ier=ier+1
      end do

      do jy=1,ny
         if (tx(1,jy).gt.zero) ier=ier+1
         if (tx(nxm1,jy).lt.zero) ier=ier+1
      end do

      if(ier.ne.0) then
         write(ipdmp,*) ' Error: TTAMP: wrong inflow'
         return
      end if

c--Form second difference of tt .

      do jy=1,ny
         do j=3,nx
            txx(j,jy)=(tx(j-1,jy)-tx(j-2,jy))*divdx
         end do
         txx(1,jy)   =zero
         txx(2,jy)   =0.5*txx(3,jy)
         txx(nx+1,jy)=0.5*txx(nx,jy)
         txx(nx+2,jy)=zero
      end do

      do jy=3,ny
      do jx=1,nx
         tyy(jx,jy)=(ty(jx,jy-1)-ty(jx,jy-2))*divdy
      end do
      end do
      do jx=1,nx
         tyy(jx,1)   =zero
         tyy(jx,2)   =0.5*tyy(jx,3)
         tyy(jx,ny+1)=0.5*tyy(jx,ny)
         tyy(jx,ny+2)=zero
      end do

c--Compute Dxx^\pm and Dyy^\pm

      do jy=1,ny
      do jx=1,nx
         call mso3(txx(jx,jy),txx(jx+1,jy),work(jx,jy,id_dmx))
         call mso3(txx(jx+1,jy),txx(jx+2,jy),work(jx,jy,id_dpx))
      end do
      end do

      do jy=1,ny
      do jx=1,nx
         call mso3(tyy(jx,jy),tyy(jx,jy+1),work(jx,jy,id_dmy))
         call mso3(tyy(jx,jy+1),tyy(jx,jy+2),work(jx,jy,id_dpy))
      end do
      end do

c--The computations of "dma" and "dpa" have been gathered in
c  one single loop for vector "dttx" to stay in the register.

      halfdx=0.5*dx
      do jy=1,ny
         jx=1
            work(jx,jy,id_dmx)=tx(jx,jy)+halfdx*work(jx,jy,id_dmx)
            work(jx,jy,id_dpx)=tx(jx,jy)-halfdx*work(jx,jy,id_dpx)
         do jx=2,nx
            work(jx,jy,id_dmx)=tx(jx-1,jy)+halfdx*work(jx,jy,id_dmx)
            work(jx,jy,id_dpx)=tx(jx,jy)  -halfdx*work(jx,jy,id_dpx)
         end do
      end do

      halfdy=0.5*dy
      jy=1
      do jx=1,nx
         work(jx,jy,id_dmy)=ty(jx,jy)+halfdy*work(jx,jy,id_dmy)
         work(jx,jy,id_dpy)=ty(jx,jy)-halfdy*work(jx,jy,id_dpy)
      end do

      do jy=2,ny
      do jx=1,nx
         work(jx,jy,id_dmy)=ty(jx,jy-1)+halfdy*work(jx,jy,id_dmy)
         work(jx,jy,id_dpy)=ty(jx,jy)  -halfdy*work(jx,jy,id_dpy)
      end do
      end do

c--Compute the Hamiltonian; interleave computation of CFL step, but
c  only change dz_loc if desired THRESHHOLD at sqeps*ss, quadratic taper to
c  0.5*sqeps*ss; also return Hermite cutoff

c      cfl_rhs=0.5*min(dx,dy)
      cfl_rhs=dx*dy/(sqrt(dx**2+dy**2)*1.1)
      compa= dz-step_total
      sqeps= eik_eps**2

      do jy=1,ny
      do jx=1,nx

c         d1eno=(max(work(jx,jy,id_dmx),zero))**2
c     &        +(min(work(jx,jy,id_dpx),zero))**2
c     &        +(max(work(jx,jy,id_dmy),zero))**2
c     &        +(min(work(jx,jy,id_dpy),zero))**2

         d1eno=(max(max(work(jx,jy,id_dmx),zero),
     &            -(min(work(jx,jy,id_dpx),zero))))**2
     &        +(max(max(work(jx,jy,id_dmy),zero),
     &            -(min(work(jx,jy,id_dpy),zero))))**2

         sqslow=ss(jx,jy)

         sqrham=sqslow-d1eno     ! =x for "bmax(x,a)"
         cutham=sqeps*sqslow     ! =a

         if (sqrham.ge.(2.*cutham)) then
            ham(jx,jy)=sqrt(sqrham)
            apcut(jx,jy)=one       ! the function "g"
	 else if(sqrham.le.zero) then
            ham(jx,jy)=sqrt(cutham)
	    apcut(jx,jy)=zero
	 else
            ham(jx,jy)= sqrt(cutham+sqrham**2/(4.*cutham))
            if (sqrham.le.cutham) then
	       apcut(jx,jy)=zero
            else
               tmp=(sqrham-cutham)/cutham
	       apcut(jx,jy)=(-2.*tmp+3.)*tmp**2
            end if
	 end if

         if (adjust) then
            compa=min(compa,cfl_rhs*ham(jx,jy)/(max(sqrt(d1eno),tol)))
         end if

      end do
      end do

c--Safeguarded CFL step selection

      if (adjust) then
         dz_loc= min(dz-step_total,compa)
         remain=dz-(step_total+dz_loc)     ! avoid very small steps
         if (remain.lt.(0.05*dz_loc)) then
            dz_loc=dz-step_total
         else if (remain.lt.(0.25*dz_loc)) then
            dz_loc=0.6*(dz_loc+remain)
         end if
      end if

c==The following corresponds to amplitude computation
c-----------------------------------------------------

c--Compute txy

      div4dy=1./(4.*dy)
      do jy=2,nym1
         jx=1
         txy(jx,jy)=(tx(jx,jy+1)-tx(jx,jy-1))*div2dy
         do jx=2,nx
            txy(jx,jy)=( (tx(jx-1,jy+1)+tx(jx,jy+1))
     &                  -(tx(jx-1,jy-1)+tx(jx,jy-1)) )*div4dy
         end do
      end do

      do jx=1,nx
         txy(jx,1)=txy(jx,2)
      end do

      do jx=1,nx
         txy(jx,ny)=txy(jx,nym1)
      end do

c--Now save ENO_tx and ENO_ty

      do jy=1,ny
      do jx=1,nx
         tx(jx,jy)=max(work(jx,jy,id_dmx),zero)
     &            +min(work(jx,jy,id_dpx),zero)
      end do
      end do

      do jy=1,ny
      do jx=1,nx
         ty(jx,jy)=max(work(jx,jy,id_dmy),zero)
     &            +min(work(jx,jy,id_dpy),zero)
      end do
      end do

      return
      end

