c======================== TTINIT2D_INV ================================

      subroutine ttinit2d_inv(nx,nz,dx,dz,xmin,zmin,xs,zs,zd,ap,
     &     nsz,eikeps,sincut,tancut,
     &     v,tt,a,tau_x,tau_z,phi_xr,apcut,ipdmp,idbg,ier)

c
c initialized traveltime, amplitude, traveltime gradient and mixed 
c (x, x_r) derivative of traveltime grids for 2D geometric acoustics
c to be used in ASMPTOTIC INVERSION
c

c WWS 5.93

c NOTE: it is ASSUMED that the velocity is constant over the
c intial grid

c WWS 7.94 revision of RV revision 2.94
c KA  9.95

c arguments

      integer
     &     nx,nz,             ! global grid extents
     &     ipdmp,ier          ! dump unit, error flag

      real
     &     dx,dz,             ! x and z steps
     &     xmin,zmin,         ! corner coordinates of global grid
     &     xs,zs,             ! source coordinates
     &     zd,                ! datum depth
     &     ap,                ! faithful aperture (degrees)
     &     eikeps,            ! eikonal cutoff
     &     v(nz,nx),          ! input velocity array
     &     tt(nz,nx),         ! traveltime array
     &     a(nz,nx),          ! amplitude array
     &     tau_x(nz,nx),      ! x_component of gradient of tt
     &     tau_z(nz,nx),      ! z_component of gradient of tt
     &     phi_xr(nz,nx),   ! mixed derivative of tt
     &     apcut(nz,nx)       ! aperture field

c internal variables

      integer joff,jleft,jright,i,j
      integer isx,isz,ix,iz,idbg
      integer nsz
      real max_time,distance
      real tol, pi,velsrc,slowsrc
      real outeps,outap
      real fastcomm,distcell,xmxs,zmzs
      real small
      real tancut,sincut,slope

c--------------------------------------------------------------------

      data tol /1.0e-2/, pi /3.1415927/, small /1.0e-10/
      data max_time /1.0e+6/

      if (ier.ne.0) return
      
c      call get_debug_level('ttinit2d_inv','idbg',idbg,ier)

c compute some useful scalars

c note - (24.03.95) isz is either the index of the source depth or
c 1, whichever is bigger - simply avoids trying to sample velocity
c outside of grid.

      isx=nint((xs-xmin)/dx)+1
      isz=max(nint((zs-zmin)/dz),0)+1
      nsz=nint((zd-zmin)/dz)+1
      tancut=tan(pi*abs(ap)/180.0e+00)
      sincut=sin(pi*abs(ap)/180.0e+00)
      eikeps=cos(pi*abs(ap)/180.0e+00)
      outeps=eikeps/sqrt(2.0e+00)
      outap=acos(outeps)

      if (dz.lt.small) then
         write(ipdmp,*)' TTINIT2D_INV: bad news'
         write(ipdmp,*)' dz = ',dz,' < small = ',small
         ier=5
         return
      end if
      joff=max(0,nint(tan(outap)*abs(zd-zs)/dz))
      jleft=max(1,isx-joff)
      jright=min(nx,isx+joff)

      fastcomm = sqrt (v(isz,isx))/(2.0*pi*sqrt(2.0))
      distcell = sqrt (dx * dx + dz * dz)
      velsrc=v(isz,isx)
      slowsrc=1.0e+00/velsrc

      do ix=1,nx
         xmxs= (xmin+ (ix-1)* dx) -xs
         zmzs= zmin + (nsz-1)*dz -zs
         distance= sqrt(xmxs* xmxs+ zmzs* zmzs)
         if (distance.lt.distcell) then
            write(ipdmp,*)' Error: TTINIT2D_INV'
            write(ipdmp,*)' datum point ix = ',ix,' too close to src'
            write(ipdmp,*)' distance = ',distance
            ier=5
            return
         end if
      end do

      if (v(isz,isx).lt.tol) then
         write(ipdmp,*)' Error: TTINIT2D_INV'
         write(ipdmp,*)' velocity at source ',isz,isx
         write(ipdmp,*)' too small: v = ',v(isz,isx)
         ier=5
         return
      end if

      if (idbg.ge.1) then
         write(ipdmp,*)' TTINIT2D_INV: '
         write(ipdmp,*)' nx,nz,dx,dz,xmin,zmin,xs,zs'
         write(ipdmp,*)nx,nz,dx,dz,xmin,zmin,xs,zs
         write(ipdmp,*)' isx,isz,nsz'
         write(ipdmp,*)isx,isz,nsz
         write(ipdmp,*)' tancut,sincut,eikeps=coscut,outeps,outap'
         write(ipdmp,*)tancut,sincut,eikeps,outeps,180.0*outap/pi
         write(ipdmp,*)' joff,jleft,jright'
         write(ipdmp,*)joff,jleft,jright
	 if(idbg.ge.3)then
            write(ipdmp,*)' array v:'
            write(ipdmp,1010)((v(iz,ix),ix=1,nx),
     &           iz=1,nsz)
            write(ipdmp,*)' isz = ',isz,' isx = ',isx
            write(ipdmp,*)' v(isz,isx) = ',v(isz,isx)
	 end if
      end if

      if (idbg.ge.4) then
         write(ipdmp,*)' TTINIT2D_INV: debug return'
         ier=5
         return
      end if

c--  Loop over grid points

c compute point source response

      zmzs= zmin + (nsz-1)*dz -zs

      do ix=jleft,jright
         xmxs= (xmin+ (ix-1)* dx) -xs
         distance= sqrt(xmxs* xmxs+ zmzs* zmzs)
         tt(nsz,ix)= distance/ v(isz,isx)
         tau_x(nsz,ix)= xmxs / ( v(isz,isx) * distance )
         tau_z(nsz,ix)= zmzs / ( v(isz,isx) * distance )
         phi_xr(nsz,ix)= -( zmzs )**2 / 
     &        ( v(isz,isx) * distance **3 )/tau_z(nsz,ix)
         apcut(nsz,ix)=0.0e+00
         a(nsz,ix)= fastcomm/ sqrt(distance)
      end do

      slope=tt(nsz,jleft+1)-tt(nsz,jleft)
      do ix=1,jleft
         xmxs= (xmin+ (ix-1)* dx) -xs
         distance= sqrt(xmxs* xmxs+ zmzs* zmzs)
         tt(nsz,ix)=tt(nsz,jleft) + slope*(ix-jleft)
         tau_x(nsz,ix)=tau_x(nsz,jleft) 
         tau_z(nsz,ix)=tau_z(nsz,jleft) 
c         phi_xr(nsz,ix)= 0.0e+00
         phi_xr(nsz,ix)= phi_xr(nsz,jleft)
         apcut(nsz,ix)=0.0e+00
         a(nsz,ix)= fastcomm/ sqrt(distance)
      end do
      slope=tt(nsz,jright)-tt(nsz,jright-1)
      do ix=jright,nx
         xmxs= (xmin+ (ix-1)* dx) -xs
         distance= sqrt(xmxs* xmxs+ zmzs* zmzs)
         tt(nsz,ix)=tt(nsz,jright) + slope*(ix-jright)
         tau_x(nsz,ix)=tau_x(nsz,jright) 
         tau_z(nsz,ix)=tau_z(nsz,jright)
         phi_xr(nsz,ix)= phi_xr(nsz,jright)
c         phi_xr(nsz,ix)= 0.0e+00
         apcut(nsz,ix)=0.0e+00
         a(nsz,ix)= fastcomm/ sqrt(distance)
      end do

      do j=1,nsz-1
         do i=1,nx
            tt(j,i)=max_time
            tau_x(j,i)= 0.0e+00
            tau_z(j,i)= 0.999e+00
            phi_xr(j,i)= 0.0e+00
            apcut(j,i)=0.0e+00
            a(j,i)=a(nsz,i)
         end do
      end do

      if(idbg.ge.2)then
         write(ipdmp,*)' TTINIT2D_INV : '
         write(ipdmp,*)' jleft  : ',jleft
         write(ipdmp,*)' jright : ',jright
         write(ipdmp,*)' initial traveltimes, level = ',nsz
         write(ipdmp,1010)(tt(nsz,ix),ix=1,nx)
         write(ipdmp,*)' initial tau_x, level = ',nsz
         write(ipdmp,1010)(tau_x(nsz,ix),ix=1,nx)
         write(ipdmp,*)' initial tau_z, level = ',nsz
         write(ipdmp,1010)(tau_z(nsz,ix),ix=1,nx)
         write(ipdmp,*)' initial phi_xr, level = ',nsz
         write(ipdmp,1010)(phi_xr(nsz,ix),ix=1,nx)
         write(ipdmp,*)' initial amplitudes, level = ',nsz
         write(ipdmp,1010)(a(nsz,ix),ix=1,nx)
      end if

 1010 format(5(2x,e10.4))

      return
      end
