c=======================  TTSOLVE25D_FAJ ===============================

      subroutine ttsolve25d_faj(nx,nz,dx,dz,
     &      xmin,zmin,xs,zs,zd,
     &     ap,vel,tt,amps,tau_yy,tau_x,tau_z,
     &     work,len_work,ipdmp,idbg,ier)

c downsweep driver for 25D Cartesian grid traveltime calculations.
c initializes traveltime and amplitude at depth zd > zs, as point
c source traveltime and amplitude within ap degrees from
c vertical, and plane wave traveltime and amplitude for angles
c greater than arccos(cos(ap)/sqrt(2)) degrees.
c returns first arrival traveltime and geometric optics amplitudes.
c then invokes TTAMP which propagates tt and amp downward with
c aperture-limited versions of eikonal and transport equations.

c Original (omnidirectional sweep) WWS 5.93
c
c Revised RV 2.94 added special initial conditions + velocity set +
c single downward traveltime sweep
c
c Rewritten WWS 7.94 

c Arguments:

      integer
     &     nx,nz,            ! number of samples in x and z
     &     len_work,         ! length of available workspace
     &     ipdmp,            ! dump unit number
     &     ier               ! error flag

      real 
     &     dx,dz,            ! steps
     &     xmin,zmin,        ! upper left corner coordinates
     &     xs,zs,            ! source coordinates
     &     zd,               ! datum depth
     &     ap,               ! faithful aperture
     &     vel(*),             ! input velocity array
     &     tt(*),            ! output traveltimes
     &     amps(*),          ! output GO amplitude
     &     tau_yy(*),        ! output GO yy_component of Laplacian tt
     &     tau_x(*),         ! output GO x_component of grad tt
     &     tau_z(*),         ! output GO z_component of grad tt
     &     work(*)           ! workspace

c internal variables

      integer
     &     idbg,             ! debug flag
     &     i,j,              ! loop counters
     &     size              ! size of global grid

      integer
     &     nsz,              ! depth index of datum
     &     new_work          ! remaining workspace

      integer
     &     ssptr,            ! pointer to squared slowness array
     &     workptr           ! pointer to remaining workspace

      real 
     &     vmin,             ! minimum velocity
     &     tol,              ! zerodivide tolerance
     &     eik_eps           ! eikonal threshhold

c----------------------------------------------------------------------

      if (ier.ne.0) return

c      call get_debug_level('ttsolve25d_faj','idbg',idbg,ier)

c set various parameters

      tol = 1.e-8

c size of global arrays

      size = nx*nz

c grab workspace for tmp arrays

      workptr = 1
      if (idbg.ge.1) then
         write(ipdmp,*)' TTSOLVE25D_FAJ ---> Get workspace...'
      end if
      call getbuf('work',ssptr,size,workptr,len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTSOLVE25D_FAJ from GETBUF for ssptr'
         return
      end if
c
      new_work=len_work

c BIG DEBUG DUMP

      if (idbg.ge.1) then
         write(ipdmp,1010)nx,nz,dx,dz,xmin,zmin,
     &        xs,zs,zd,ap
         write(ipdmp,1020)size,ssptr,workptr,len_work
      end if

 1010 format(
     & ' TTSOLVE25D_FAJ: debug dump',/,
     & ' scalar arguments:',/,
     & ' nx           = ',i10,/,
     & ' nz           = ',i10,/,
     & ' dx           = ',e10.4,/,
     & ' dz           = ',e10.4,/,
     & ' xmin         = ',e10.4,/,
     & ' zmin         = ',e10.4,/,
     & ' xs           = ',e10.4,/,
     & ' zs           = ',e10.4,/,
     & ' zd           = ',e10.4,/,
     & ' ap           = ',e10.4)

 1020 format(
     & ' internal scalars:',/,
     & ' size         = ',i10,/,
     & ' ssptr        = ',i10,/,
     & ' workptr      = ',i10,/,
     & ' len_work     = ',i10)

      if (idbg.ge.2) then
         write(ipdmp,1030)
         do i=1,nx
            write(ipdmp,1031)i,(vel(j+(i-1)*nz),j=1,nz)
         end do
      end if

 1030 format(' input velocity array:')
 1031 format(' trace ',i5,/,6(e10.4,2x))

c idbg >= 2: debug exit

      if (idbg.ge.2) then
         write(ipdmp,*)' TTSOLVE25D_FAJ ---> bye-bye...'
      end if

c compute squared slowness array, used throughout

      if (idbg.ge.1) then
         write(ipdmp,*)' TTSOLVE25D_FAJ ---> squared slowness...'
         write(ipdmp,*)' copy to work buffer...'
         write(ipdmp,*)' square...'
         write(ipdmp,*)' reciprocal...'
      end if

      vmin=vel(1)

      do i=1,size
         vmin=min(vmin,vel(i))
         work(ssptr-1+i)=1.0/(max(vel(i),tol)**2)
      end do

      if (vmin.lt.tol) then
         write(ipdmp,*)' Error: TTSOLVE25D_FAJ'
         write(ipdmp,*)' velocity miniumum = ',vmin,' < ',tol
         write(ipdmp,*)' nz = ',nz,' nx = ',nx
         ier=3
         return
      end if

c compute...

c initialize arrays - call TTINIT25D_FAJ

         if (idbg.ge.1) then
            write(ipdmp,*)' TTSOLVE25D_FAJ ---> TTINIT25D_FAJ...'
         end if

c initialize arrays - call TTINIT25D

        call ttinit25d_faj(nx,nz,dx,dz,xmin,zmin,xs,zs,zd,ap,
     &        nsz,eik_eps,vel,tt,amps,tau_x,tau_z,tau_yy,ipdmp,
     &        idbg,ier)
        if (ier.ne.0) then
           write(ipdmp,*)' Error: TTSOLVE25D_FAJ from TTINIT25D_FAJ'
           return
        end if

c downsweep - call TTAMP25D_FAJ

         if (idbg.ge.1) then
            write(ipdmp,*)' TTSOLVE25D_FAJ ---> TTAMP25D_FAJ'
         end if

         call ttamp25d_faj(nz,nx,dz,dx,nsz,vel,
     &        xmin, xs, zs, zd, eik_eps,
     &        work(ssptr),tt,amps,tau_x,tau_z,tau_yy,
     &        work(workptr),new_work,ipdmp,idbg,ier)
         if (ier.ne.0) then
            write(ipdmp,*)' Error: TTSOLVE25D_FAJ from TTAMP25D_FAJ'
            return
         end if

      return
      end
c============================================================================
