c============================ KIRCH_SUM_ADJ3D===========================
      subroutine kirch_sum_adj3d(gather_flag,inversion,
     &     velnz,velnx,velny,veldz,veldx,veldy,datum,
     &     reflnz,reflnx,reflny,reflzorig,reflxorig,reflyorig,
     &     srcnzbox,srcnxbox,srcnybox,
     &     srcbozorig,srcboxorig,srcboyorig,
     &     recnzbox,recnxbox,recnybox,
     &     recbozorig,recboxorig,recboyorig,
     &     refl,factor,srctt,rectt,trace,
     &     seismnt,seismdt,seismtorig,ipdmp,idbg,ier,ntables)

c----------------------------------------------------------------------
c     June 1997, SKIM : adjustment/extension from "rev WWS 11.95"
c----------------------------------------------------------------------
c Input variables

      integer
     &     inversion,          !  false for migration, true for inversion
     &     srcnzbox,           ! number of z samples in source box
     &     srcnxbox,           ! number of x samples in source box
     &     srcnybox,           ! number of y samples in source box
     &     recnzbox,           ! number of z samples in receiver box
     &     recnxbox,           ! number of x samples in receiver box
     &     recnybox,           ! number of y samples in receiver box
     &     seismnt,            ! number of time samples
     &     velnz,              ! number of z samples in velocity array
     &     velnx,              ! number of x samples in velocity array
     &     velny,              ! number of y samples in velocity array
     &     reflnz,             ! number of z samples in reflectivity array
     &     reflnx,             ! number of x samples in reflectivity array
     &     reflny,             ! number of y samples in reflectivity array
     &     gather_flag         ! = 0 for common source, = 1 for common offset

      real 
     &     srcbozorig,srcboxorig,srcboyorig, ! left edge of source box
     &     recbozorig,recboxorig,recboyorig, ! left edge of receiver box
     &     seismdt,            ! time step
     &     reflzorig,          ! z at upper left corner of reflectivity subgrid
     &     reflxorig,          ! x at upper left corner of reflectivity subgrid
     &     reflyorig,          ! y at upper left corner of reflectivity subgrid
     &     veldz,              ! z step
     &     veldx,              ! x step
     &     veldy,              ! y step
     &     datum               ! vel homogeneous, refl = 0 above this depth

      real 
     &     trace(seismnt),                            ! input trace
     &     srctt(srcnzbox,srcnxbox,srcnybox,ntables), ! source traveltime etc.
     &     rectt(recnzbox,recnxbox,recnybox,ntables), ! receiver traveltime etc.
     &     refl(reflnz,reflnx,reflny),                ! output reflectivity
     &     factor(reflnz,reflnx,reflny)               ! array of factors

c Note:
c 1. trace(1) = [(d/dt)^2(\check(src)*seism)](0.0)
c    trace(j) = [(d/dt)^2(\check(src)*seism)]((j-1)*seismdt)
c 2. refl() and factor() are based on an identical geometry
c    you can see it from the variables "nz_slip", "nx_slip",
c    and "ny_slip" in "factoradj3d.f"

c computational box limits
c source and receiver left box indices, relative loop counters in x

      integer it_x_bgn,it_x_end,it_z_bgn,it_z_end,it_y_bgn,it_y_end
      integer isrcboxorig,irecboxorig,jsrc,jrec,ksrc,krec

c reflectivity subgrid: 

      integer 
     &     ireflzorig,           ! z coordinate of upper left corner
     &     ireflxorig,           ! x coordinate of upper left corner
     &     irefl,                ! relative loop counter in z
     &     jrefl                 ! relative loop counter in x

c traveltime variables

      integer inst       ! integer part of computed traveltime
      real 
     &     ttime,        ! computed traveltime
     &     remaind       ! remainder = tt-int(tt)

c miscellaneous variables

      integer i,j,k, idbg,ipdmp,ier

c=====================================================================
      
c RECORD OFFSET DEFINITIONS

      if (ier.ne.0) return

      if (idbg.ne.0) then
         write(ipdmp,*)' KIRCH_SUM_ADJ3D: BEGIN'
      endif

      id_oper = 2*gather_flag+inversion+1

c id_oper = 1, CSG, Migration
c         = 2, CSG, Inversion
c         = 3, COG, Migration
c         = 4, COG, Inversion

      if (id_oper.lt.1 .or. id_oper.gt.4) then
         write(ipdmp,*)' Error: KIRCH_SUM_ADJ3D'
         ier = 200
         write(ipout,*)' Error: KIRCH_SUM_ADJ3D: ier=',ier
         return
      end if

c     work out the left and right limits of the intersection
c     of the source and receiver boxes, in absolute indices and
c     relative to both source and receiver boxes

      if (idbg.ge.2) then
         write(ipdmp,*)' KIRCH_SUM_ADJ3D:'
         write(ipdmp,*)' box stuff'
      endif

      iseism_move=nint(seismtorig/seismdt)

      isrcboxorig=nint(srcboxorig/veldx)+1
      irecboxorig=nint(recboxorig/veldx)+1
      it_x_bgn=max(isrcboxorig,irecboxorig)
      it_x_end=min(isrcboxorig+srcnxbox-1,irecboxorig+recnxbox-1)

      ireflxorig=nint(reflxorig/veldx)+1
      it_x_bgn=max(it_x_bgn,ireflxorig)
      it_x_end=min(it_x_end,ireflxorig+reflnx-1)

c ------------

      isrcboyorig=nint(srcboyorig/veldy)+1
      irecboyorig=nint(recboyorig/veldy)+1
      it_y_bgn=max(isrcboyorig,irecboyorig)
      it_y_end=min(isrcboyorig+srcnybox-1,irecboyorig+recnybox-1)

      ireflyorig=nint(reflyorig/veldy)+1
      it_y_bgn=max(it_y_bgn,ireflyorig)
      it_y_end=min(it_y_end,ireflyorig+reflny-1)
      
      if (it_x_end.le.it_x_bgn .or. it_y_end.le.it_y_bgn) then
         if (idbg.gt.0) then
            write(ipdmp,*)' KIRCH_SUM_ADJ3D: '
            write(ipdmp,*)' src and recvr boxes do not '
            write(ipdmp,*)' intersect, so trace with this aperture == 0'
         end if
         return
      end if

c ------------

c      it_z_bgn= max(nint(abs(datum)/veldz),0)+1
c      it_z_end = min(srcnzbox,recnzbox)
c      ireflzorig=nint(reflzorig/veldz)+1
c      it_z_bgn=max(it_z_bgn,ireflzorig)
c      it_z_end=min(it_z_end,ireflzorig+reflnz-1)

c the following drops the assumption o1box=0.0

      isrcbozorig=nint(srcbozorig/veldz)+1
      irecbozorig=nint(recbozorig/veldz)+1
      it_z_bgn=max(isrcbozorig,irecbozorig)
      it_z_end=min(isrcbozorig+srcnzbox-1,irecbozorig+recnzbox-1)

      it_z_bgn= max(it_z_bgn,(max(nint(abs(datum)/veldz),0)+1))

      ireflzorig=nint(reflzorig/veldz)+1
      it_z_bgn=max(it_z_bgn,ireflzorig)
      it_z_end=min(it_z_end,ireflzorig+reflnz-1)

      if (idbg.gt.0) then
         write(ipdmp,*)' KIRCH_SUM_ADJ3D:'
         write(ipdmp,*)' isrcbozorig   = ',isrcbozorig
         write(ipdmp,*)' isrcboxorig   = ',isrcboxorig
         write(ipdmp,*)' isrcboyorig   = ',isrcboyorig
         write(ipdmp,*)' irecbozorig   = ',irecbozorig
         write(ipdmp,*)' irecboxorig   = ',irecboxorig
         write(ipdmp,*)' irecboyorig   = ',irecboyorig
         write(ipdmp,*)' it_z_bgn      = ',it_z_bgn
         write(ipdmp,*)' it_z_end      = ',it_z_end
         write(ipdmp,*)' it_x_bgn      = ',it_x_bgn
         write(ipdmp,*)' it_x_end      = ',it_x_end
         write(ipdmp,*)' it_y_bgn      = ',it_y_bgn
         write(ipdmp,*)' it_y_end      = ',it_y_end
      end if


c note that times are assumed to have been "integerized" by division
c by dt

c set trace(seismnt)=0 since safeguard step for instant may render this
c garbage

      trace(seismnt-1)=0.0e+00
      trace(seismnt)=0.0e+00

      if(id_oper.ne.1) then
         print*,"KsumAdj3D.f: include more cases **************"
         ier= 200
      end if

      go to (10,20,30,40), id_oper

 10   continue
c===============================
c  CSG, Migration
c===============================
      id_tt =1
      id_amp=2

CDIR$ NORECURRENCE

      do k = it_y_bgn,it_y_end
            ksrc = k-isrcboyorig+1
            krec = k-irecboyorig+1
            krefl= k-ireflyorig+1
      do j = it_x_bgn,it_x_end
            jsrc = j-isrcboxorig+1
            jrec = j-irecboxorig+1
            jrefl= j-ireflxorig+1
      do i= it_z_bgn,it_z_end
            isrc = i-isrcbozorig+1
            irec = i-irecbozorig+1
            irefl= i-ireflzorig+1

         ttime=srctt(isrc,jsrc,ksrc,id_tt)+rectt(irec,jrec,krec,id_tt)
         inst =min(seismnt-2,max(int(ttime),0))
         remaind= min(1.,max(ttime-float(inst),0.))
         inst=inst+1

         refl(irefl,jrefl,krefl)= refl(irefl,jrefl,krefl)
     &     + factor(irefl,jrefl,krefl)
     &       *srctt(isrc,jsrc,ksrc,id_amp)*rectt(irec,jrec,krec,id_amp)
     &       *((1.-remaind)*trace(inst)+remaind *trace(inst+1))
               
      end do
      end do
      end do
      goto 9999

 20   continue
c===============================
c CSG, Inversion
c===============================
      goto 9999

 30   continue
c===============================
c  COG, Migration
c===============================
      goto 9999

 40   continue
c===============================
c  COG, Inversion
c===============================

 9999 return
      end
c=========================================================================

