/* io utilities for sep files -
   originally part of dso i/o package, redesigned for 2D tt/amp
   i/o, 17.07.96 WWS
 */
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#if defined(_IBMR2) || defined(hpux)
#include <fcntl.h>
#else
#include <sys/fcntl.h>
#endif

#define MAX_LEN 80

void cblank(char * name) {
  /*  while( *name != '\0') *name++ = '\0';*/
  int i;
  for(i=0;i<80;i++) {
    name[i]='\0';
  }
}

/* READSEP:
 * opens, reads, and closes header and data files
 */

#if defined (ardent) || defined (vax) || defined (cray)
void READSEP (char * filename, int * n1, int * n2, float * d1, float * d2, 
	       float * o1, float * o2, float * buf, 
	       int * ntotal, int * idbg, int * retcd)

#elif defined(_IBMR2) || defined(hpux)
void readsep (char * filename, int * n1, int * n2, float * d1, float * d2, 
	       float * o1, float * o2, float * buf, 
	       int * ntotal, int * idbg, int * retcd)

#else
void readsep_ (char * filename, int * n1, int * n2, float * d1, float * d2, 
		float * o1, float * o2, float * buf, 
		int * ntotal, int * idbg, int * retcd)
#endif

{
  FILE *fp;
  int fd;
  int i;
  int l;
  int numchar;
  char tmp[80];

  char datafile[MAX_LEN];

  if (*idbg == 1) {
    fprintf(stderr,"READSEP:\n");
    fprintf(stderr,"filename = %s\n",filename);
    fprintf(stderr,"ier      = %d\n",*retcd);
  }

  if ((fp = fopen(filename, "r"))==NULL) {
    *retcd = 16;
    return;
  }

  cblank(tmp);
  cblank(datafile);

  fscanf(fp,"n1=%d n2=%d o1=%g o2=%g d1=%g d2=%g in=%s",n1,n2,o1,o2,d1,d2,tmp);

  /* this is supposed to get rid of the quotes in the filename */

  strncpy(datafile,&tmp[1],strlen(tmp)-2);

  if (*idbg == 1) {
      fprintf(stderr,"SEP HEADER FILE %s\n",filename);
      fprintf(stderr,"n1=%d n2=%d\n",*n1,*n2);
      fprintf(stderr,"o1=%g o2=%g\n",*o1,*o2);
      fprintf(stderr,"d1=%g d2=%g\n",*d1,*d2);
      fprintf(stderr,"datafile=%s\n",datafile);
  }

  fd = open(datafile,O_RDONLY);

  if (fd == -1) {
    *retcd = 13;
    return;
  }

  /* check that the record will fit in available storage */

  if (*ntotal < (*n1)*(*n2)) {
    fprintf(stderr,"Error: READSEP: not enough storage");
    *retcd = 44;
    return;
  }
  *ntotal = (*n1)*(*n2);

  numchar=sizeof(float)*(*ntotal);
  if (read(fd,(char *)buf,numchar) != numchar) {
    fprintf(stderr,"Error: READSEP\n");
    fprintf(stderr,"Failed to read %d floats from file %s\n",
	    *ntotal,datafile);
    *retcd=2; 
    return;
  }

  fclose(fp);
  close(fd);

  *retcd = 0;

}

/* WRITESEP:
 * opens, writes, and closes header and data files
 */

#if defined (ardent) || defined (vax) || defined (cray)
void WRITESEP (char * filename, int * n1, int * n2, float * d1, float * d2, 
	       float * o1, float * o2, float * buf, 
	       int * ntotal, int * idbg, int * retcd)

#elif defined(_IBMR2) || defined(hpux)
void writesep (char * filename, int * n1, int * n2, float * d1, float * d2, 
	       float * o1, float * o2, float * buf, 
	       int * ntotal, int * idbg, int * retcd)

#else
void writesep_ (char * filename, int * n1, int * n2, float * d1, float * d2, 
		float * o1, float * o2, float * buf, 
		int * ntotal, int * idbg, int * retcd)
#endif

{
  FILE *fp;
  int fd;
  int i;
  int l;
  int numchar;

  char datafile[MAX_LEN];

  if (*idbg == 1) {
    fprintf(stderr,"WRITESEP:\n");
    fprintf(stderr,"filename = %s\n",filename);
    fprintf(stderr,"ier      = %d\n",*retcd);
  }

  if ((fp = fopen(filename, "w"))==NULL) {
    *retcd = 16;
    return;
  }

  fprintf(fp,"n1=%d\n",*n1);
  fprintf(fp,"n2=%d\n",*n2);

  fprintf(fp,"o1=%g\n",*o1);
  fprintf(fp,"o2=%g\n",*o2);
  fprintf(fp,"d1=%g\n",*d1);
  fprintf(fp,"d2=%g\n",*d2);

  strcpy(datafile,filename);
  strcat(datafile,"@");
  fprintf(fp,"in=\"%s\"\n",datafile);

  if (*idbg == 1) {
      fprintf(stderr,"SEP HEADER FILE %s\n",filename);
      fprintf(stderr,"n1=%d n2=%d\n",*n1,*n2);
      fprintf(stderr,"o1=%g o2=%g\n",*o1,*o2);
      fprintf(stderr,"d1=%g d2=%g\n",*d1,*d2);
      fprintf(stderr,"datafile=%s\n",datafile);
  }

  fd = open(datafile, O_WRONLY | O_CREAT | O_TRUNC, 0644);

  if (fd == -1) {
    *retcd = 13;
    return;
  }

  *ntotal = (*n1)*(*n2);

  numchar=sizeof(float)*(*ntotal);
  if (write(fd,(char *)buf,numchar) != numchar) {
    fprintf(stderr,"Error: WRITESEP\n");
    fprintf(stderr,"Failed to write %d floats to file %s\n",
	    *ntotal,datafile);
    *retcd=2; 
    return;
  }

  fclose(fp);
  close(fd);

  *retcd = 0;
}
