      SUBROUTINE  SMUL(N,SX,INCX,SY,INCY)                               
C                                                                       
C     COMPONENTWISE MULTIPLICATION OF TWO VECTORS.                      
C     USES UNROLLED LOOPS FOR INCREMENT EQUAL TO 1.                     
C     AFTER LINPACK BLAS - WWS 310596                                   
C                                                                       
      REAL SX(*),SY(*)                                                  
      INTEGER I,INCX,INCY,M,MP1,N                                       
C                                                                       
      IF(N.LE.0)RETURN                                                  
      IF((INCX.EQ.1).AND.(INCY.EQ.1)) GO TO 20                          
C                                                                       
C        CODE FOR INCREMENT NOT EQUAL TO 1                              
C                                                                       
      DO 10 I = 1,N                                                     
        SX(1+(I-1)*INCX) = SX(1+(I-1)*INCX)*SY(1+(I-1)*INCY)            
   10 CONTINUE                                                          
      RETURN                                                            
C                                                                       
C        CODE FOR INCREMENT EQUAL TO 1                                  
C                                                                       
C                                                                       
C        CLEAN-UP LOOP                                                  
C                                                                       
   20 M = MOD(N,5)                                                      
      IF( M .EQ. 0 ) GO TO 40                                           
      DO 30 I = 1,M                                                     
        SX(I) = SY(I)*SX(I)                                             
   30 CONTINUE                                                          
      IF( N .LT. 5 ) RETURN                                             
   40 MP1 = M + 1                                                       
      DO 50 I = MP1,N,5                                                 
        SX(I) = SY(I)*SX(I)                                             
        SX(I + 1) = SY(I+1)*SX(I + 1)                                   
        SX(I + 2) = SY(I+2)*SX(I + 2)                                   
        SX(I + 3) = SY(I+3)*SX(I + 3)                                   
        SX(I + 4) = SY(I+4)*SX(I + 4)                                   
   50 CONTINUE                                                          
      RETURN                                                            
      END                                                               

