      SUBROUTINE  SDIV(N,T,SX,INCX,SY,INCY)                             
C                                                                       
C     COMPONENTWISE DIVISION OF TWO VECTORS.                            
C     USES UNROLLED LOOPS FOR INCREMENT EQUAL TO 1.                     
C     ASSUMES THAT DENOMINATOR IS POSITIVE AND ALWAYS
C     GREATER THAN T
C     AFTER LINPACK BLAS - WWS 310596                
C                                                    
      REAL T,SX(*),SY(*)                             
      INTEGER I,INCX,INCY,M,MP1,N                    
C                                                                       
      IF(N.LE.0)RETURN                                                  
      IF((INCX.EQ.1).AND.(INCY.EQ.1)) GO TO 20                          
C                                                                       
C        CODE FOR INCREMENT NOT EQUAL TO 1                              
C                                                                       
      DO 10 I = 1,N                                                     
        SX(1+(I-1)*INCX) = SX(1+(I-1)*INCX)/MAX(T,SY(1+(I-1)*INCY))     
   10 CONTINUE                                                          
      RETURN                                                            
C                                                                       
C        CODE FOR INCREMENT EQUAL TO 1                                  
C                                                                       
C                                                                       
C        CLEAN-UP LOOP                                                  
C                                                                       
   20 M = MOD(N,5)                                                      
      IF( M .EQ. 0 ) GO TO 40                                           
      DO 30 I = 1,M                                                     
        SX(I) = SX(I)/AMAX1(T,SY(I))                                    
   30 CONTINUE                                                          
   40 MP1 = M + 1                                                       
      DO 50 I = MP1,N,5                                                 
        SX(I) = SX(I)/AMAX1(T,SY(I))                                    
        SX(I + 1) = SX(I+1)/AMAX1(T,SY(I + 1))                          
        SX(I + 2) = SX(I+2)/AMAX1(T,SY(I + 2))                          
        SX(I + 3) = SX(I+3)/AMAX1(T,SY(I + 3))                          
        SX(I + 4) = SX(I+4)/AMAX1(T,SY(I + 4))                          
   50 CONTINUE                                                                
      RETURN 
      END                                                               
