      REAL FUNCTION SASUM(N,SX,INCX)                                    
C                                                                       
C     TAKES THE SUM OF THE ABSOLUTE VALUES.                             
C     USES UNROLLED LOOPS FOR INCREMENT EQUAL TO ONE.                   
C     JACK DONGARRA, LINPACK, 3/11/78.                                  
C                                                                       
      REAL SX(1),STEMP                                                  
      INTEGER I,INCX,M,MP1,N,NINCX                                      
C                                                                       
      SASUM = 0.0E0                                                     
      STEMP = 0.0E0                                                     
      IF(N.LE.0)RETURN                                                  
      IF(INCX.EQ.1)GO TO 20                                             
C                                                                       
C        CODE FOR INCREMENT NOT EQUAL TO 1                              
C                                                                       
      NINCX = N*INCX                                                    
      DO 10 I = 1,NINCX,INCX                                            
        STEMP = STEMP + ABS(SX(I))                                      
   10 CONTINUE                                                          
      SASUM = STEMP                                                     
      RETURN                                                            
C                                                                       
C        CODE FOR INCREMENT EQUAL TO 1                                  
C                                                                       
C                                                                       
C        CLEAN-UP LOOP                                                  
C                                                                       
   20 M = MOD(N,6)                                                      
      IF( M .EQ. 0 ) GO TO 40                                           
      DO 30 I = 1,M                                                     
        STEMP = STEMP + ABS(SX(I))                                      
   30 CONTINUE                                                          
      IF( N .LT. 6 ) GO TO 60                                           
   40 MP1 = M + 1                                                       
      DO 50 I = MP1,N,6                                                 
        STEMP = STEMP + ABS(SX(I)) + ABS(SX(I + 1)) + ABS(SX(I + 2))    
     *  + ABS(SX(I + 3)) + ABS(SX(I + 4)) + ABS(SX(I + 5))              
   50 CONTINUE                                                          
   60 SASUM = STEMP                                                     
      RETURN                                                            
      END                                                               
