      integer function isamin(n,sx,incx)
c***begin prologue  isamin
c***revision date  811015   (yymmdd)
c***category no.  f1a
c***keywords  blas,vector,smallest component
c***date written  october 1979
c***author lawson c. (jpl),hanson r. (sla),
c                            kincaid d. (u texas), krogh f. (jpl)
c***purpose
c    find smallest component of s.p. vector
c***description
c                b l a s  subprogram
c    description of parameters
c
c     --input--
c        n  number of elements in input vector(s)
c       sx  single precision vector with n elements
c     incx  storage spacing between elements of sx
c
c     --output--
c   isamin  smallest index (zero if n.le.0)
c
c     find smallest index of minimum magnitude of single precision sx.
c     isamin =  first i, i = 1 to n, to minimize  abs(sx(1-incx+i*incx)
c
c***references
c  lawson c.l., hanson r.j., kincaid d.r., krogh f.t.,
c   *basic linear algebra subprograms for fortran usage*,
c  algorithm no. 539, transactions on mathematical software,
c  volume 5, number 3, september 1979, 308-323
c***routines called  (none)
c***end prologue  isamin
c
      real sx(1),smin,xmag
c***first executable statement  isamin
      isamin = 0
      if(n.le.0) return
      isamin = 1
      if(n.le.1)return
      if(incx.eq.1)goto 20
c
c        code for increments not equal to 1.
c
      smin = abs(sx(1))
      ns = n*incx
      ii = 1
          do 10 i=1,ns,incx
          xmag = abs(sx(i))
          if(xmag.ge.smin) go to 5
          isamin = ii
          smin = xmag
    5     ii = ii + 1
   10     continue
      return
c
c        code for increments equal to 1.
c
   20 smin = abs(sx(1))
      do 30 i = 2,n
         xmag = abs(sx(i))
         if(xmag.ge.smin) go to 30
         isamin = i
         smin = xmag
   30 continue
      return
      end
