c i/o keyword variable [prototype] type source
c mODe=oN
c$input databuf vel * float* VEL
c$output databuf refl * float* REFL
c$input databuf src * float* SRC
c$input databuf seism * float* SEISM
c$input n1 seismnt * int SEISM
c$input n2 seismnx * int SEISM
c$input n3 seismnxs * int SEISM
c$input d1 seismdt * float SEISM
c$input d2 seismdx * float SEISM
c$input d3 seismdxs * float SEISM
c$input o1 seismtorig * float SEISM
c$input o2 seismxorig * float SEISM
c$input o3 seismxsorig * float SEISM
c$input srcdep srcdep * float SEISM
c$input recdep recdep * float SEISM
c$input n1 velnz * int VEL
c$input n2 velnx * int VEL
c$input d1 veldz * float VEL
c$input d2 veldx * float VEL
c$input o1 velzorig * float VEL
c$input o2 velxorig * float VEL
c$input n1 srcnt * int SRC
c$input d1 srcdt * float SRC
c$input o1 srctorig * float SRC
c$input n1 reflnz * int REFLSPACE
c$input n2 reflnx * int REFLSPACE
c$input n3 reflnxs * int REFLSPACE
c$input d1 refldz * float REFLSPACE
c$input d2 refldx * float REFLSPACE
c$input o1 reflzorig * float REFLSPACE
c$input o2 reflxorig * float REFLSPACE
c$input amp_op amp_op * int JOB
c$input aperture ap * float JOB
c$input zd zd * float JOB
c$input t0 t0 * float JOB
c$input tf tf * float JOB
c$input mv mv * float JOB
c$input wmz wmz * float JOB
c$input ntaper ntaper * int JOB
c$input save_ttamp save_ttamp * int JOB
c$input tt_sam tt_sam * int JOB
c$input lentt tt_size * int JOB
c$input tt_size tt * float* *
c$input nblock nblock * int JOB
c$input lenwork len_work * int JOB
c$input len_work work * float* *
c$input update update * int JOB
c$input ipout ipout * int JOB
c$input dumpunit ipdmp * int JOB
c$input debug idbg * int JOB
c$input verbose iverb * int JOB
c$input debug_helm idbg_helm * int JOB
c$input inv_flag inv_flag * int JOB
c$input spd_flag spd_flag * int JOB
c$input bintype gather_flag * int SEISM
c$input JOB jobname * table argv[1]
c$input VEL vel2dname * Vel2D JOB
c$input REFL reflname REFLSPACE PSRefl2D JOB
c$input SRC srcname * ts JOB
c$input SEISM seismname * CSG2D JOB
c$input REFLSPACE reflspnm * PSRefl2DSpace JOB

c=============================== KIRCH_ADJ ===============================
c
c     KIRCHHOFF ADJOINT MODELING (PRESTACK MIGRATION)
c                     OR
c     KIRCHHOFF TRUE AMPLITUDE PRESTACK DEPTH MIGRATION USING
c               THE BEYLKIN METHOD
c     
c     This code a combination of work by
c     the TRIP group
c     
c     w symes
c     r versteeg
c     h tran
c     a sei
c     m kern
c     k araya
c     
c     This version: 08.96, WWS
c
c NOTES: this is an attempt to use a design worked out in
c 93 - 94 by the folks listed above, together with an evolved
c (and hopefully more maintainable) driver structure. The 
c original setup is largely the work of RV, and is archived
c in dso3.1. 
c
c The current memory management principle is as follows: nblock
c simulations will be carried out (ie. nblock shots). nblock
c is initialized in the job table.
c
c MODIFICATION OF 21.08.96: in this version data for nblock simulations
c indexed firstrec - lastrec are loaded at one time in the input array
c seism. The one-record-at-a-time design of previous versions is 
c abandoned; thus the input data does not need to be accumulated in
c the work array, and the code becomes considerably shorter. The 
c calling program must set aside sufficient workspace for the input
c (seism) and the output (refl). The maximum length of these is nblock
c records. The calling program must also manage the logic of firstrec
c and lastrec. This driver merely produces output for the index range
c firstrec-lastrec, without attempting to check it for validity.
c
c     Logic of Kirchhoff summation: simulation by blocked gathers
c
c     for each block
c         for each trace
c             for each gather
c                 compute source position
c                 compute receiver position
c                 read source traveltime table
c                 read receiver traveltime table
c                 compute trace
c             next gather
c         next trace
c     next block
c
c     This subroutine performs the block computation (inner two loops);
c     the calling program is set up to perform the outer loop over blocks.
c
c     Blocking strategy: in order to minimize i/o, rely on READ_TT
c     to cache a number of COARSE GRID traveltime tables in core. Arrange 
c     the order of trace computation so that only one or two new tables
c     need to be read from disk or computed for each trace index. Each 
c     table is interpolated as it is read. Thus only two interpolated
c     FINE GRID tables are stored for each trace. This design trades 
c     some computation for memory usage - execution profiles show that
c     interpolation takes up to 10% of CPU time, for FINE/COARSE = 4,
c     but 16 times as many tables can be cached in core as if fine grids
c     were stored as in RV's old design. As shown below, this design 
c     trivially works as well for common offset sim/mig/inv (COG) as for
c     common source (CSG).
c
c     The cache is treated as a disk cache, and only activated if the
c     traveltimes are also stored to disk. 
c
c     21.08.96: Current implementation stores traveltimes to disk only when
c     they are bumped from cache.
c
c     The size of the cache is set in the job deck. 
c
c     The following analysis assumes that shot and receiver spacings
c     are same. If this assumption is not true then the efficiency
c     of the scheme is in general less. The cache mgmt. remains the
c     same, regardless of src and recvr spacing.
c     
c     Notation: g = gather index
c               t = trace index
c             src = src location index
c             rec = rec location index
c
c     For common source gather: src = src(g)
c                               rec = rec(t+g)
c     As g ranges over nblock values, both src and rec range over
c     nblock values. When t --> t+1, source locations remain same
c     but receiver locations shift by 1. Therefore if 2*nblock tables
c     are cached then for each trace only one table must be read or 
c     computed (as opposed to being simply passed back from the cache). 
c     The total number of tables read per block 
c     is nblock+ntraces = nblock+n(recvrs/shot). The number of blocks
c     is n(shots)/nblock. Therefore the total number of tables 
c     read or computed is n(shots)+n(recvrs/shot)*n(shots)/nblock.
c     If the shot and receiver spacings are the same (or commensurable)
c     then most of these will be disk reads rather than computations
c     (calls to the eikonal/transport solvers).
c
c     If someone is clever they may be able to arrange to do the read
c     asynchronously, overlapping the trace computations using tables
c     already cached. This will be especially important in the parallel
c     design.
c
c     MUST ARRANGE that READ_TT KEEPS the source tables and only discards
c     the receiver tables. This cannot work if it only keeps one list and
c     discards the oldest.
c
c     For common offset gather: src = src(t)
c                               rec = rec(t+g)
c     As g ranges over nblock values rec ranges over nblock values.
c     When t --> t+1 (in general) src and rec both shift by 1. Therefore
c     if at least nblock tables are cached then only two tables must be
c     read or computed for each trace index. The total number of tables
c     read per block is at most 2*ntraces = 2*n(shots), and the
c     total for the entire simulation is 2*n(shots)*n(recvrs/shot)/nblock.
c
c     Note that this means: with the same amt. of storage FOR TTAMP TABLES
c     can achieve the same amt. of read/computes for either CSG or COG - 
c     nblock(COG) = 2*nblock(CSG). Of course this does impose a heavier
c     memory burden on COG, since twice as much input data must be loaded.
c
c     If the cache is sufficiently large, and/or if source and receiver
c     positions overlap, actually i/o and computation can be even less.
c
      subroutine kirchadj(inv_flag,spd_flag,
     &     vel,refl,src,seism,
     &     seismnt,seismnx,seismnxs,seismdt,seismdx,seismdxs,
     &     seismtorig,seismxorig,seismxsorig,
     &     srcdep,recdep,
     &     velnz,velnx,veldz,veldx,velzorig,velxorig,
     &     srcnt,srcdt,srctorig,
     &     reflnz,reflnx,reflnxs,refldz,refldx,reflzorig,reflxorig,
     &     amp_op,ap,zd,t0,tf,mv,wmz,ntaper,
     &     save_ttamp,tt_sam,tt_size,tt,
     &     firstrec,lastrec,
     &     gather_flag,len_work,work,
     &     iverb,idbg,idbg_helm,
     &     update,ipout,ipdmp,ier)

c     ----------------------------------------------------------
      
      integer 
     &     tt_sam,              ! resampling rate for traveltime map
     &     amp_op,              ! flag for forward amplitude option
     &     velnz,               ! dimension velocity model first dimension
     &     velnx,               ! dimension velocity model in second dimension
     &     reflnz,              ! first dimension reflectivity model 
     &     reflnx,              ! second dimension reflectivity model 
     &     reflnxs,             ! third dimension reflectivity model 
     &     seismnt,             ! dimension seismogram in first (sample) 
c                                 dimension
     &     seismnx,             ! dimension seismogram in second (trace) 
c                                 dimension
     &     seismnxs             ! dimension seismogram in third (record) 
c                                 dimension
      integer 
     &     firstrec,            ! first record to be traced in this run
     &     lastrec,             ! last record to be traced in this run
     &     update,              ! update flag - new bg (1) or old (0)
     &     save_ttamp           ! flag whether tt/amp tables should be saved

      integer inv_flag          ! integer flag: = 1 for inversion, = 0 for adjoint
      integer spd_flag          ! integer flag: = 1 for 2.5D , = 0 2D for amplitude

      integer 
     &     srcnt,               ! number of source samples
     &     gather_flag,         ! gather flag (0: CSG, 1: COG)
     &     ntaper,              ! number of traces to be tapered
     &     ipdmp,               ! dump file unit
     &     ipout,               ! output file unit (terminal)
     &     ier                  ! error flag

      real 
     &     seismdt,             ! sample distance in traces seismogram
     &     seismdx,             ! sample distance between traces seismogram
     &     seismdxs,            ! sample distance between records seismogram 
     &     seismtorig,          ! initial offset trace
     &     seismxorig,          ! initial trace offset first trace
     &     seismxsorig,         ! location of first shot in line
     &     srcdep,              ! shot depth
     &     recdep,              ! trace depth
     &     srctorig,            ! source time origin
     &     srcdt                ! source sample distance
      real
     &     t0,                  ! mute zero offset intercept
     &     tf,                  ! mute final time
     &     mv,                  ! muting velocity
     &     wmz,                 ! width of mute zone
     &     veldz,               ! sample distance in first direction velocity model
     &     veldx,               ! sample distance in second direction velocity model
     &     velzorig,            ! initial offset velocity model first direction
     &     velxorig,            ! initial offset velocity model second direction
     &     refldz,              ! sample distance in first direction reflectivity model
     &     refldx,              ! sample distance in second direction reflectivity model
     &     reflzorig,           ! initial offset reflectivity model first direction
     &     reflxorig,           ! initial offset reflectivity model second direction
     &     rho                  ! density
      real 
     &     ap,                  ! aperture of amplitude calculation kirchhoff
     &     zd                   ! datum depth

c declarations of arrays

      real 
     &     vel(*),              ! velocity model - presumed length velnz*velnx
     &     refl(*),             ! output reflectivity - presumed length 
c                                 nblock*reflnz*reflnx
     &     src(*),              ! source - presumed length seismnt
     &     seism(*)             ! input seismogram - presumed length 
c                                 nblock*seismnt*seismnx

c workspace

      integer 
     &     len_work,            ! length of available workspace
     &     work_ptr             ! first word of available workspace
      real 
     &     work(len_work)       ! work array

      integer
     &     tt_size              ! traveltime and amplitude buffer size in words
      real
     &     tt                   ! buffer for traveltimes and amplitudes

c local work pointers

      integer
     &     trace_ptr,           ! pointer into seism for current trace
     &     tmp_ptr,             ! temp storage for a trace
     &     ptrace_ptr,          ! storage for preprocessed trace
     &     factor_ptr,          ! workspace for scaled squared velocity
     &     drefl_ptr            ! index into reflectivity

      integer
     &     cache_flag,          ! set by READ_TT if it caches ttamp tables -
c                                 initialized to 0 here to cause READ_TT to
c                                 initialize cache tables
     &     src_token,           ! identifier for src tt tables
     &     rec_token            ! identifier for rec tt tables

      integer lenwork_loc       ! length of work segment passed to subs, after
c                                 allocating local space

c getbuf variables

      integer 
     &     next,                ! index of next free word in work
     &     size                 ! size of bite to grab out of buffer

c local variables

      integer
     &     nblock               ! number of records to be created

c nfls is the number of traveltime tables already computed with
c the current model and saved to disk.
c nfls = 0 at the beginning of a new simulation with a new 
c model. It should be saved between calls to KIRCH_ADJ
c It needs to be initialized when irecord=1 (beginning of simulation). 
c Since READ_TT does not have access to irecord, it must be initialized
c and saved here to avoid excessive disk i/o. When update=0 (use old
c ttamp tables if possible) it should also be saved between simulations,
c i.e. between calls to the subroutine which calls this one. The only 
c obvious way to save it between simulations without adding a new special 
c common block and initialization code in the main DSO module (against 
c the DSO design principles) is to write it to a file on exit, and read 
c the file (if it exists) to initialize when update=0 and irecord=1. This
c strategy runs the risk of an unintentional initialization, i.e. when
c update=0 and the contents of the file relate to a different execution,
c hence the initialized nfls will not correctly count the number of ttamp
c files. I don't know what to do about this apart from keeping update=1
c as the default and managing this file, eg. by running from a script
c in a newly created directory.

      integer nfls

      save nfls

      logical found

      integer ntables           ! number of tables in a traveltime record:
c                                 = 2 for migration (tt, amp)
c                                 = 3 for 2.5D migration (tt, amp, tyy)
c                                 = 5 for inversion (tt, amp, tx, tz, txxr)
c                                 = 6 for inversion (tt, amp, tx, tz, txxr, tyy)
      integer
     &     idbg,                ! debug flag
     &     iverb,               ! verbosity flag
     &     i,j                  ! counting indices

c grid compatibility tolerance

      real tol

c local block arrays

      integer
     &     recnzbox,  ! number of z samples in recvr tt box   
     &     recnxbox,  ! number of x samples in recvr tt box
     &     recoff,    ! pointers to work segments holding recvr tt/amp tables
     &     srcnzbox,  ! number of z samples in source tt box   
     &     srcnxbox,  ! number of x samples in source tt box
     &     srcoff     ! pointers to work segments holding src tt/amp tables

      real
     &     recboxorig,! x offset of receiver tt box
     &     recpos,    ! x offset of receiver
     &     srcboxorig,! x offset of source tt box
     &     srcpos     ! x offset of source

      character*3 
     &     gather_type,         ! CSG or COG
     &     mode                 ! mode flag for difference, convolution ops

c useful numbers

      real fzero
      integer ione

c workspace for antialiasing filter

      real fmax, pi
      real ap_rec

c workspace for Helmholtz application

      real sz, sx               ! scale factors
      real p                    ! power of Helmholtz operator
      integer idbg_helm         ! debug flag for Helmholtz

c======================= BEGIN EXECUTABLE INSTRUCTIONS =================

      if (ier.ne.0) return

c one simple check to make sure we are not making nonsense...

      if (lastrec.gt.seismnxs) then
         write(ipdmp,*)' Error: KIRCHADJ'
         write(ipdmp,*)' last record index of this block greater than'
         write(ipdmp,*)' total number of simulation records'
         write(ipdmp,*)' last record index     = ',lastrec
         write(ipdmp,*)' total records         = ',seismnxs
         ier=1
         return
      end if

c the beginning of the workspace is now the first word.

      work_ptr = 1

c define block length

      nblock = lastrec-firstrec+1
      
c also initialize cache on first record only

      if (firstrec.eq.1) then
         cache_flag=0
         if (update.ne.0) then
            nfls=0
         else

c if update = 0, read nfls from file if file exists, else = 0.

            found=.false.
            inquire(file='no.of.srcs',exist=found)
            if (found) then
               if (idbg.gt.0) then
                  write(ipdmp,*)' KIRCH_ADJ: found nfls file no.of.srcs'
                  write(ipdmp,*)' read nfls from this file'
               end if
               open(unit=10,file='no.of.srcs',form='formatted',
     &              status='unknown', iostat=ier)
               if (ier.ne.0) then
                  write(ipdmp,*)' Error: KIRCH_ADJ from FILEOPEN'
                  write(ipdmp,*)' on open of no.of.srcs '
                  return
               end if
               read(10,2000)nfls
               if (idbg.gt.0) then
                  write(ipdmp,*)
     &                 ' KIRCH_ADJ: number of saved tables = ',nfls
               end if
               close(unit=10,iostat=ier)
               if (ier.ne.0) then
                  write(ipdmp,*)' Error: KIRCH_ADJ from FILECLS'
                  write(ipdmp,*)' on close of no.of.srcs'
                  return
               end if
            else
               if (idbg.ne.0) then
                  write(ipdmp,*)' KIRCH_ADJ: no nfls file, set nfls=0'
               end if
               nfls=0
            end if
         end if
      end if

      if (idbg.gt.0) then
         write(ipdmp,*)' KIRCH_ADJ:'
         write(ipdmp,*)' firstrec     = ',firstrec
         write(ipdmp,*)' lastrec      = ',lastrec
         write(ipdmp,*)' len_work     = ',len_work
      end if

      if (iverb.gt.0) then
        write(ipout,*)' LOADING DATA FOR INVERSION/MIGRATION RANGE',
     &        firstrec,' - ',lastrec
      end if

c ------------ beginning of RV code ---------------------

c compute some numbers

      tol  = 1.0e-4 
      pi   = 3.1415927e+00
      fmax = 35.0e+00
      fzero= 0.0e+00
      ione = 1
      rho  = 1.0e+00
      src_token = 0
      rec_token = 1

c     assign logical inversion flag

      if ((inv_flag.ne.0).and.(inv_flag.ne.1)) then
	 write(ipdmp,*)' Error: KIRCH_ADJ'
	 write(ipdmp,*)' inv_flag has impossible value = ',inv_flag
	 ier=1
	 return
      end if

c     assign logical three_d flag

      if ((spd_flag.ne.0).and.(spd_flag.ne.1)) then
	 write(ipdmp,*)' Error: KIRCH_ADJ'
	 write(ipdmp,*)' spd_flag has impossible value = ',spd_flag
	 ier=1
	 return
      end if

c     assign number of tables per traveltime record

      if ((inv_flag.eq.1).and.(spd_flag.eq.1)) then
         ntables=6
      else if ((inv_flag.eq.1).and.(spd_flag.eq.0)) then
         ntables=5
      else if ((inv_flag.eq.0).and.(spd_flag.eq.1)) then
         ntables=3
      else
         ntables=2
      endif

c     evaluate flag for gather type

      ap_rec = ap
      if (gather_flag.eq.0) then
         gather_type='CSG'
      else if (gather_flag.eq.1) then
         gather_type='COG'
      else
         write(ipdmp,*)' Error: KIRCH_ADJ'
         write(ipdmp,*)' gather flag value = ',gather_flag
         write(ipdmp,*)' only legit values are '
         write(ipdmp,*)'      0  - common source gather'
         write(ipdmp,*)'      1  - common offset gather'
         write(ipdmp,*)' check job table'
         ier=1
         return
      end if

      if (idbg.ne.0) then
	 if (inv_flag.eq.1) then
            if (spd_flag.eq.1) then
               if (gather_type.eq.'CSG') then
                  write(ipdmp,*)
     &                 ' 2.5D KIRCHHOFF COMMON SOURCE INVERSION'
               else if (gather_type.eq.'COG') then
                  write(ipdmp,*)
     &                 ' 2.5D KIRCHHOFF COMMON OFFSET INVERSION'
               end if
            endif
            if (spd_flag.eq.0) then
               if (gather_type.eq.'CSG') then
                  write(ipdmp,*)
     &                 ' 2D KIRCHHOFF COMMON SOURCE INVERSION'
               else if (gather_type.eq.'COG') then
                  write(ipdmp,*)
     &                 ' 2D KIRCHHOFF COMMON OFFSET INVERSION'
               end if
            end if
	 else
            if (spd_flag.eq.1) then
               if (gather_type.eq.'CSG') then
                  write(ipdmp,*)
     &                 ' 2.5D KIRCHHOFF COMMON SOURCE MIGRATION'
               else if (gather_type.eq.'COG') then
                  write(ipdmp,*)
     &                 ' 2.5D KIRCHHOFF COMMON OFFSET MIGRATION'
               end if
            end if
            if (spd_flag.eq.0) then
               if (gather_type.eq.'CSG') then
                  write(ipdmp,*)
     &                 ' 2D KIRCHHOFF COMMON SOURCE MIGRATION'
               else if (gather_type.eq.'COG') then
                  write(ipdmp,*)
     &                 ' 2D KIRCHHOFF COMMON OFFSET MIGRATION'
               end if
            end if
         end if
         write(ipdmp,*)' INPUT PARAMETER DUMP:'
         write(ipdmp,*)' seismogram parameters '
         write(ipdmp,*)' number of samples per trace     ', seismnt
         write(ipdmp,*)' sample interval                 ', seismdt
         write(ipdmp,*)' start time                      ', seismtorig
         if (gather_type.eq.'CSG') then
            write(ipdmp,*)' traces per shot gather       ', seismnx
            write(ipdmp,*)' offset of first trace           ', 
     &           seismxorig
            write(ipdmp,*)' trace interval                  ', seismdx
            write(ipdmp,*)' number of shot gather           ', seismnxs
            write(ipdmp,*)' x coordinate of first shot      ', 
     &           seismxsorig
            write(ipdmp,*)' shot interval                   ', seismdxs
         else if (gather_type.eq.'COG') then
            write(ipdmp,*)' shots per offset gather         ', seismnx
            write(ipdmp,*)' x coordinate of first shot      ', 
     &           seismxorig
            write(ipdmp,*)' shot interval                   ', seismdx
            write(ipdmp,*)' number of offset gathers        ', seismnxs
            write(ipdmp,*)' offset of first gather          ', 
     &           seismxsorig
            write(ipdmp,*)' offset interval                 ', seismdxs
         end if
         write(ipdmp,*)' shot depth                      ', srcdep
         write(ipdmp,*)' receiver depth                  ', recdep
         write(ipdmp,*)' source  parameters'
         write(ipdmp,*)' srcnt                           ',srcnt
         write(ipdmp,*)' srcdt                           ',srcdt
         write(ipdmp,*)' model parameters'
         write(ipdmp,*)' velnz                           ',velnz
         write(ipdmp,*)' velnx                           ',velnx
         write(ipdmp,*)' reflnz                          ',reflnz
         write(ipdmp,*)' reflnx                          ',reflnx
         write(ipdmp,*)' reflnxs                         ',reflnxs
         write(ipdmp,*)' refldz                          ',refldz
         write(ipdmp,*)' refldx                          ',refldx
         write(ipdmp,*)' reflzorig                       ',reflzorig
         write(ipdmp,*)' reflxorig                       ',reflxorig
         write(ipdmp,*)' veldz                           ',veldz
         write(ipdmp,*)' veldx                           ',veldx
         write(ipdmp,*)' velzorig                        ',velzorig
         write(ipdmp,*)' velxorig                        ',velxorig
         write(ipdmp,*)' miscellaneous parameters '
         write(ipdmp,*)' firstrec                        ',firstrec
         write(ipdmp,*)' lastrec                         ',lastrec
         write(ipdmp,*)' nblock                          ',nblock
         write(ipdmp,*)' len_work                        ',len_work
         write(ipdmp,*)' amp_op                          ',amp_op
         write(ipdmp,*)' ap                              ',ap
         write(ipdmp,*)' zd                              ',zd
         write(ipdmp,*)' rho                             ',rho
         write(ipdmp,*)' t0                              ',t0
         write(ipdmp,*)' tf                              ',tf
         write(ipdmp,*)' mv                              ',mv
         write(ipdmp,*)' wmz                             ',wmz
         write(ipdmp,*)' ntaper                          ',ntaper
         write(ipdmp,*)' save_ttamp                      ',save_ttamp
         write(ipdmp,*)' update                          ',update
      end if
      if (idbg.ge.4) then
         j=velnz*velnx
         write(ipdmp,*)' VEL:'
         write(ipdmp,1000)(vel(i),i=1,j)
         j=seismnt*seismnx
         write(ipdmp,*)' SEISM: record ',firstrec
         write(ipdmp,1000)(seism(i),i=1,j)
         ier=999
         return
      end if

      if (iverb.ne.0) then
	 if (inv_flag.eq.1) then
            if (spd_flag.eq.1) then
               if (gather_type.eq.'CSG') then
                  write(ipout,*)
     &                 ' 2.5D KIRCHHOFF COMMON SOURCE INVERSION'
               else if (gather_type.eq.'COG') then
                  write(ipout,*)
     &                 ' 2.5D KIRCHHOFF COMMON OFFSET INVERSION'
               end if
            else
               if (gather_type.eq.'CSG') then
                  write(ipout,*)
     &                 ' 2D KIRCHHOFF COMMON SOURCE INVERSION'
               else if (gather_type.eq.'COG') then
                  write(ipout,*)
     &                 ' 2D KIRCHHOFF COMMON OFFSET INVERSION'
               end if
            end if
	 else
            if (spd_flag.eq.1) then
               if (gather_type.eq.'CSG') then
                  write(ipout,*)
     &                 ' 2.5D KIRCHHOFF COMMON SOURCE MIGRATION'
               else if (gather_type.eq.'COG') then
                  write(ipout,*)
     &                 ' 2.5D KIRCHHOFF COMMON OFFSET MIGRATION'
               end if
            else
               if (gather_type.eq.'CSG') then
                  write(ipout,*)
     &                 ' 2D KIRCHHOFF COMMON SOURCE MIGRATION'
               else if (gather_type.eq.'COG') then
                  write(ipout,*)
     &                 ' 2D KIRCHHOFF COMMON OFFSET MIGRATION'
               end if
            end if
         end if
      end if
         
c parameter check to verify that the source distance (seismdxs)
c and the distance between receivers are integer multiples 
c of each other.

      if (abs(seismdx).le.tol*abs(seismdxs)) then
         write(ipdmp,*)' Error: KIRCH_ADJ'
         write(ipdmp,*)' seismdx   = ',seismdx
         write(ipdmp,*)' seismdxs   = ',seismdxs
         write(ipdmp,*)' not safely positive'
         ier=209
         return
      end if

      if ((abs(float(nint(seismdxs/seismdx))-
     &     (seismdxs/seismdx)).ge.tol).and.(idbg.gt.0)) then
         write(ipdmp,*)' Warning: KIRCH_ADJ'
         write(ipdmp,*)' receiver interval : ',seismdx
         write(ipdmp,*)' source interval   : ',seismdxs
         write(ipdmp,*)' source interval must be an int mult of '
         write(ipdmp,*)' receiver interval, else this computation '
         write(ipdmp,*)' will be grossly inefficient'
      end if

      if ((abs((seismxorig/seismdx)-nint(seismxorig/seismdx))
     &     .gt.tol).and.(idbg.gt.0)) then
         write(ipdmp,*)' Warning: KIRCH_ADJ'
         write(ipdmp,*)' offset of first receiver: ',seismxorig
         write(ipdmp,*)' must be an integral multiple of '
         write(ipdmp,*)' receiver interval: ',seismdx
         write(ipdmp,*)' else this computation will be grossly ',
     &        'inefficient'
      end if

c  parameter check to see if the source and
c  seismogram have same sampling interval

      if(abs(seismdt-srcdt).gt.tol*seismdt)then
         write(ipdmp,*)' Error: KIRCH_ADJ'
         write(ipdmp,*)' seismdt : ',seismdt
         write(ipdmp,*)' srcdt   : ',srcdt
         write(ipdmp,*)' they must be identical '
         write(ipdmp,*)' seismdt is sample int in seism '
         write(ipdmp,*)' srcdt is sample int in source '
         ier = 209
         return
      end if

c  parameter check to see if velocity and reflectivity have
c  same sampling intervals

      if(abs(veldz-refldz).gt.tol*veldz)then
         write(ipdmp,*)' Error: KIRCH_ADJ'
         write(ipdmp,*)' veldz : ',veldz
         write(ipdmp,*)' refldz : ',refldz
         write(ipdmp,*)' velocity and reflectivity grids incompatible'
         ier = 209
         return
      end if

      if(abs(veldx-refldx).gt.tol*veldx)then
         write(ipdmp,*)' Error: KIRCH_ADJ'
         write(ipdmp,*)' veldx : ',veldx
         write(ipdmp,*)' refldx : ',refldx
         write(ipdmp,*)' velocity and reflectivity grids incompatible'
         ier = 209
         return
      end if

c checks to ensure that the reflectivity grid is a
c subset of the velocity grid. This assumption will be changed soon, but
c for now:
c   1) the upper left hand corner of the velocity grid is (0,0)
c   2) velocity and reflectivity have the same sample rates

c revision of 230996: no longer need these checks!!!!!

c      if ((reflzorig.lt.0).or.(reflxorig.lt.0).or.
c     &     ((reflzorig+veldz*(reflnz-1)).gt.(veldz*(velnz-1))).or.
c     &     ((reflxorig+veldx*(reflnx-1)).gt.(veldx*(velnx-1)))) then
c         write(ipdmp,*)' Error: KIRCH_ADJ'
c         write(ipdmp,*)' reflectivity grid not subgrid of vel grid'
c         write(ipdmp,*)' velnz     = ',velnz
c         write(ipdmp,*)' velnx     = ',velnx
c         write(ipdmp,*)' veldz     = ',veldz
c         write(ipdmp,*)' veldx     = ',veldx
c         write(ipdmp,*)' reflnz    = ',reflnz
c         write(ipdmp,*)' reflnx    = ',reflnx
c         write(ipdmp,*)' reflzorig = ',reflzorig
c         write(ipdmp,*)' reflxorig = ',reflxorig
c         ier=100
c         return
c      endif
        
      if ((reflnxs.ne.1).and.(reflnxs.ne.seismnxs)) then
         write(ipdmp,*)' Error: KIRCH_ADJ'
         write(ipdmp,*)' number of reflectivity records ',reflnxs
         write(ipdmp,*)' equal neither to 1 nor to number of shot'
         write(ipdmp,*)' records - inconsistent with simulator design'
         ier=209
         return
      end if

c check that veldz, veldx are safely nonzero

      if (abs(velnz*veldz).le.tol*abs(veldz)) then
         write(ipdmp,*)' Error: KIRCH_ADJ'
         write(ipdmp,*)' veldz too small, = ',veldz
         ier=99
         return
      end if

      if (abs(velnx*veldx).le.tol*abs(veldx)) then
         write(ipdmp,*)' Error: KIRCH_ADJ'
         write(ipdmp,*)' veldx too small, = ',veldx
         ier=99
         return
      end if

      if (iverb.gt.0) then
         write(ipout,*)' INITIALIZE...'
      end if

c     mute and taper first since this is the adjoint calculation

      call mute_and_taper(seism,seismnt,seismnx,
     &     firstrec,nblock,
     &     t0, tf, mv, wmz, ntaper,
     &     seismxorig,seismdx,seismdt,seismxsorig,seismdxs,
     &     gather_type,ipdmp,ier)
      if(ier.ne.0)then
         write(ipdmp,*)' Error: KIRCH_ADJ from MUTE_AND_TAPER '
         return
      end if

c     zero out reflectivity output

      j=nblock*reflnz*reflnx
      call sconst(j,fzero,refl,ione)

c INITIALIZE OFFSET INTO WORK BUFFER

      next = work_ptr

c STORAGE FOR GATHER AND TRACE INDEPENDENT QUANTITIES:

c modification of 220996:
c      size=velnx*velnz
      size=reflnx*reflnz
      
      call getbuf('work',factor_ptr,size,next,len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: KIRCH_ADJ from GETBUF
     &       	 or factor_ptr'
         return
      end if

      if (idbg.gt.0) then
         write(ipdmp,*)' gather independent sum. factor stored @',
     &        factor_ptr
      end if

      call factor_adj_inv(inv_flag,spd_flag,
     &     velnz,velnx,veldz,veldx,velzorig,velxorig,vel,
     &     reflnz,reflnx,reflzorig,reflxorig,work(factor_ptr),
     &     seismdx,ipdmp,idbg,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: KIRCH_ADJ from FACTOR_ADJ_INV for',
     &        ' factor_ptr'
         return
      end if

c storage for various traces

      size = seismnt
            
      call getbuf('work',tmp_ptr,size,next,len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: KIRCH_ADJ from GETBUF for',
     &        ' tmp_ptr'
         return
      end if

      if (idbg.gt.0) then
         write(ipdmp,*)' temporary trace storage at ',tmp_ptr
      end if

      call getbuf('work',ptrace_ptr,size,next,len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: KIRCH_ADJ from GETBUF for',
     &        ' tmp_ptr'
         return
      end if

      if (idbg.gt.0) then
         write(ipdmp,*)' preprocessed trace storage at ',ptrace_ptr
      end if

      work_ptr = next
      lenwork_loc = len_work - next

c FINISHED ALLOCATING WORKSPACE FOR USE IN KIRCH_ADJ

c     for common source gathers the gather and source indicies are the same

c     for common offset gathers the headers mean:
c         seismnx             = number of traces = number of sources
c         seismdx             = source step
c         seismxorig          = coordinate of first source
c         seismnxs            = number of offsets
c         seismdxs            = offset step = trace step = source step
c         seismxsorig         = first offset

c LOOP OVER TRACE INDEX

      do j=1,seismnx
         
c LOOP OVER GATHER INDEX

         do i=firstrec,lastrec

            if (iverb.ne.0) then
               if(inv_flag.eq.1)then
                  write(ipout,*)
     &                 ' INVERSION: gather = ',i,' trace = ',j
               else
                  write(ipout,*)
     &                 ' MIGRATION: gather = ',i,' trace = ',j
               endif
            end if

c COMPUTE SOURCE AND RECEIVER POSITIONS, OFFSET INTO SEISM,
c REFL ARRAYS

            drefl_ptr=(i-firstrec)*
     &           reflnz*reflnx
     &           + 1
            trace_ptr=(i-firstrec)*seismnt*seismnx
     &           + (j-1)*seismnt
     &           + 1

            if (gather_type.eq.'CSG') then

               srcpos = seismxsorig + (i-1)*seismdxs
               recpos = srcpos + seismxorig  + (j-1)*seismdx

            else if (gather_type.eq.'COG') then

c     here j=source index (=trace index) and i=offset index=recvr index

               srcpos = seismxorig  + (j-1)*seismdx
               recpos = seismxsorig + (i-1)*seismdxs + srcpos

            else

               write(ipdmp,*)' Error: KIRCH_ADJ'
               write(ipdmp,*)' unrecognized gather type: ',gather_type
               ier=1
               return

            end if

            if (idbg.ne.0) then
               write(ipdmp,*)
     &              ' COMPUTING SOURCE TRAVELTIME TABLE '
               write(ipdmp,*)' position = ',srcpos
               write(ipdmp,*)' workspace available = ',lenwork_loc
            end if
            if (iverb.ne.0) then
               write(ipout,*)
     &              ' COMPUTING SOURCE TRAVELTIME TABLE '
               write(ipout,*)' position = ',srcpos
            end if

c The source offset is always the same as the beginning of the workspace,
c since read_tt stores the fine grid table there and the source table is
c the first returned.

c first time through, next is the next word after the aux traces
c are allocated. second and subsequent times it's the region after
c the src table. Either way should work, if the rec comp is to succeed.

            srcoff=work_ptr

            call read_ttdata(cache_flag,inv_flag,spd_flag,vel,
     &           tt,work(srcoff),src_token,
     &           velnz,velzorig,veldz,
     &           velnx,velxorig,veldx,seismnt,seismdt,
     &           srcnzbox,srcnxbox,srcboxorig,
     &           srcdep,srcpos,save_ttamp,tt_sam,tt_size,
     &           amp_op,update,lenwork_loc,
     &           ap,zd,nfls,ipdmp,idbg,ier)      
            if (ier.ne.0) then
               write(ipdmp,*)' Error: KIRCH_ADJ from READ_TT'
               return
            end if

c receiver table returned in next block of work - now know what size it is!

c only allocate this space ONCE - on the first pass through the 
c double loop!!!!

            if ((j.eq.1).and.(i.eq.firstrec)) then

               size=ntables*srcnzbox*srcnxbox
               call getbuf('work',srcoff,size,next,len_work,ipdmp,
     &              ier)
               if (ier.ne.0) then
                  write(ipdmp,*)' Error: KIRCH_ADJ from GETBUF for',
     &                 ' srcoff'
                  return
               end if

               lenwork_loc = len_work - next

               call getbuf('work',recoff,size,next,len_work,ipdmp,
     &              ier)
               if (ier.ne.0) then
                  write(ipdmp,*)' Error: KIRCH_ADJ from GETBUF for',
     &                 ' recoff'
                  return
               end if

            end if

            if (idbg.gt.0) then
               write(ipdmp,*)
     &              ' COMPUTING RECEIVER TRAVELTIME TABLE '
               write(ipdmp,*)' position = ',recpos
               write(ipdmp,*)' workspace available = ',lenwork_loc
            end if
            if (iverb.gt.0) then
               write(ipout,*)
     &              ' COMPUTING RECEIVER TRAVELTIME TABLE '
               write(ipout,*)' position = ',recpos
            end if
            call read_ttdata(cache_flag,inv_flag,spd_flag,vel,
     &           tt,work(recoff),rec_token,
     &           velnz,velzorig,veldz,
     &           velnx,velxorig,veldx,seismnt,seismdt,
     &           recnzbox,recnxbox,recboxorig,
     &           recdep,recpos,save_ttamp,tt_sam,tt_size,
     &           amp_op,update,lenwork_loc,
     &           ap_rec,zd,nfls,ipdmp,idbg,ier)      
            if (ier.ne.0) then
               write(ipdmp,*)
     &              ' Error: KIRCH_ADJ from READ_TT'
               return
            end if

            if (iverb.gt.0) then
               write(ipout,*)' KIRCHHOFF SUM...'
            endif

c     PREPROCESS INPUT TRACES
            
            call convadj(seism(trace_ptr),work(tmp_ptr),seismnt,
     &           src,srcnt,srctorig,seismdt,ipdmp,ier)
            if (ier.ne.0) then
               write(ipdmp,*)' Error: KIRCH_ADJ from CONVADJ'
               return
            end if
            
            if (inv_flag.eq.1) then
               call indefint(
     &              work(tmp_ptr), work(ptrace_ptr), 
     &              seismdt, seismnt, idbg, ipdmp, ier)
               if (ier.ne.0) then
                  write(ipdmp,*)
     &                 ' Error: KIRCH_ADJ from INDEFINT'
                  return
               end if
            else
               mode='adj'
               call cendif(mode,
     &              work(tmp_ptr), work(ptrace_ptr), 
     &              seismdt, seismnt, idbg, ipdmp, ier)
               if (ier.ne.0) then
                  write(ipdmp,*)
     &                 ' Error: KIRCH_ADJ from CENDIF'
                  return
               end if
            end if

c     perform Kirchhoff sum, placing result in seism(trace_ptr)
c     (fwd map) or refl(drefl_ptr) (adj map)

            if (idbg.gt.0) then
               write(ipdmp,*)' reflectivity output at     ',
     &              drefl_ptr
               write(ipdmp,*)' src tt/amp table loaded at offset',
     &              srcoff
               write(ipdmp,*)' rec tt/amp table loaded at offset',
     &              recoff
               write(ipdmp,*)' trace loaded at            ',
     &              trace_ptr
               write(ipdmp,*)' preprocessed trace loaded at  ',
     &              ptrace_ptr
            end if

            call kirch_sum_adj(
     &	         gather_flag,inv_flag,spd_flag,
     &           velnz,velnx,veldz,veldx,zd,
     &           reflnz,reflnx,reflzorig,reflxorig,
     &           srcnzbox,srcnxbox,srcboxorig,
     &           recnzbox,recnxbox,recboxorig,
     &           refl(drefl_ptr),work(factor_ptr),
     &           work(srcoff),
     &           work(recoff),
     &           work(ptrace_ptr),
     &           seismnt,seismdt,
     &           ipdmp,idbg,ier)
            if (ier.ne.0) then
               write(ipdmp,*)
     &              ' Error: KIRCH_ADJ from KSUM_ADJ'
               return
            end if
            
         end do
         
      end do

c     apply cutoff to output reflectivity

      call cutoff(reflnz,reflnx,nblock,refl,zd-reflzorig,veldz,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: KIRCH_ADJ from CUTOFF'
         return
      end if

c     if number of records in reference reflectivity = 1 and
c     number of records in input seismogram is > 1, then
c     presumption is that dim3 sum in seismogram scalar product
c     is scaled by d3recy. So scale output reflectivity by
c     intershot spacing to satisfy adjoint relation (this is
c     same as dim3 step in input / dim3 step in output = 1).

      if ((reflnxs.eq.1).and.(seismnxs.gt.1)) then
         i=reflnz*reflnx*nblock
         j=1
         call sscal(i,abs(seismdxs),refl,j)
      end if

c     if doing inversion, must apply (-Laplacian)^0.5
c     have available at this point work_ptr = end of seism
c     and len_work = remaining workspace - includes ttamps,
c     but overwrite these (must be restored
c     from disk or recomputed on the next call to KIRCH_AJD), 
c     can use all of work for tmp storage.

      if (inv_flag.eq.1) then
         sz=1.0e+00
         sx=1.0e+00
         p=0.5e+00
         do i=firstrec,lastrec
            size=(i-firstrec)*reflnx*reflnz+1
            call helm_dnddi(reflnz,reflnx,veldz,veldx,sz,sx,p,
     &           max(0.0e+00, zd-reflzorig),
     &           refl(size),refl(size),work(work_ptr),
     &           len_work,idbg_helm,ipdmp,ier)
            if (ier.ne.0) then
               write(ipdmp,*)' Error: KIRCH_ADJ from HELM_DNDDI'
               return
            end if
         end do
      endif

c     save nfls data - easiest way is just to overwrite existing 
c     file, even though this is slightly inefficient.

      if (save_ttamp.ne.0) then

         open(unit=10,file='no.of.srcs',form='formatted',
     &           status='unknown', iostat=ier)
         if (ier.ne.0) then
            write(ipdmp,*)' Error: KIRCH_ADJ from FILEOPEN'
            write(ipdmp,*)' on open of no.of.srcs '
            return
         end if
         write(10,2000)nfls
         if (idbg.gt.0) then
            write(ipdmp,*)' KIRCH_ADJ: number of saved tables = ',nfls
         end if
         close(unit=10,iostat=ier)
         if (ier.ne.0) then
            write(ipdmp,*)' Error: KIRCH_ADJ from FILECLS'
            write(ipdmp,*)' on close of no.of.srcs '
            return
         end if

      end if
         
 1000 format(6(e12.4,2x))
 2000 format(i10)

      return
      end

c========================================================================
