c===================== FACTOR_FWD ==========================
        
      subroutine factor_fwd(three_d,
     &     velnz,velnx,factor,vel,
     &     seismdt,rho,veldz,veldx,
     &     idbg,ipdmp, ier)  

c-----------------------------------------------------------

      integer ier,ipdmp,idbg
      integer velnz,velnx,i,j
      real factor(velnz,velnx)
      real vel(velnz,velnx)
      real veldx,veldz,pi,rho,seismdt,const
      real velmin,velmax,tol,twopi

      logical three_d

      tol=1.e-4

c     evaluate pi, constant

      pi=4.0*atan(1.0)
      twopi=2.0*pi
      rho=1.0

      if(three_d)then
         const=2.0*sqrt(twopi)*abs(veldz*veldx)/(seismdt*rho)
      else
         const=twopi*abs(veldz*veldx)/(seismdt*rho)
      endif
c      const=pi/rho
     
      if(idbg.ge.2)then
	 write(ipdmp,*)' FACTOR_FWD'
	 write(ipdmp,*)' velnz   : ',velnz
	 write(ipdmp,*)' velnx   : ',velnx
	 write(ipdmp,*)' veldz   : ',veldz
	 write(ipdmp,*)' seismdt   : ',seismdt
	 write(ipdmp,*)' rho      : ',rho
	 write(ipdmp,*)' vel(1,1) : ',vel(1,1)

      end if

c     check that dividing by the squared velocity is OK

      velmax=0

      do j=1,velnx
         do i=1,velnz
            velmax=max(velmax,vel(i,j))
         end do
      end do

      velmin=velmax

      do j=1,velnx
         do i=1,velnz
            velmin=min(velmin,vel(i,j))
         end do
      end do

      if(idbg.ge.2)then
	 write(ipdmp,*)' FACTOR_FWD'
         write(ipdmp,*)' const : ',const
         write(ipdmp,*)' velmin: ',velmin
         write(ipdmp,*)' velmax: ',velmax
      end if

      if (velmin.le.tol*velmax) then
         write(ipdmp,*)' Error: FACTOR_FWD'
         write(ipdmp,*)' velocity range dangerously large'
         write(ipdmp,*)' minimum velocity  = ',velmin
         write(ipdmp,*)' maximum           = ',velmax
         ier=1
         return
      end if

      do j=1,velnx
         do i=1,velnz
	    if(three_d)then
               factor(i,j)=const/(vel(i,j)*vel(i,j)*vel(i,j))
            else 
               factor(i,j)=const/(vel(i,j)*vel(i,j))
            end if
         end do
      end do

      return
      end
c===========================================================
