c========================== FACTOR_ADJ_INV =========================

      subroutine factor_adj_inv(inversion,three_d,
     &     velnz,velnx,veldz,veldx,velzorig,velxorig,vel,
     &     reflnz,reflnx,reflzorig,reflxorig,
     &     factor,seismdx,ipdmp,idbg,ier)  

c------------------------------------------------------------
c
c  this subroutine calculates 2.0*pi*rho*dreceiver/c(i,j)**2
c                    or
c  this subroutine calculates dreceiver*c(i,j)**2*rho/(2.0*pi)
c  for the calculation of the adjoint map

c 220996: this version computes these fields on the reflectivity
c grid, where they are needed. still assumes that velzorig = velxorig = 0

      integer ier,ipdmp,idbg
      integer velnz,velnx,reflnz,reflnx
      real seismdx,rho,pi,const,veldz,veldx,
     &     velzorig,velxorig,reflzorig,reflxorig
      real vel(velnz,velnx)
c      real factor(velnz,velnx)
      real factor(reflnz,reflnx)

      integer inversion, three_d

      real velmin,velmax,tol
      real twopi

      integer i,j,iv,jv

      data rho /1.0/, tol /1.0e-4/, pi /3.1415927/
c
c evaluate pi
c  
c      pi=4.*atan(1.0)

       twopi=2.0*pi

      if(idbg.ge.1)then
	 write(ipdmp,*)' FACTOR_ADJ_INV'
	 write(ipdmp,*)' velnz  : ',velnz
	 write(ipdmp,*)' velnx  : ',velnx
	 write(ipdmp,*)' pi      : ',pi
	 write(ipdmp,*)' rho     : ',rho
	 write(ipdmp,*)' seismdx : ',seismdx
      end if
c
c WWS 30.10.95 - move additional factor of 2 in here, consolidate
c (see notes in ksum_inv)
c         const=abs(seismdx)/(2.0*pi)
c added 20.10.95 by WWS - see comment in KSUM_INV
c         const=const/(pi*pi)
c
      if((inversion.eq.1).and.(three_d.eq.1))then
c         const=abs(seismdx)*sqrt(twopi)/(pi*pi*pi)
         const=abs(seismdx)/(8.0*pi)
      else if((inversion.eq.1).and.(three_d.eq.0))then
         const=abs(seismdx)/(pi*pi*pi)
      else if((inversion.eq.0).and.(three_d.eq.1))then
         const=2.0*sqrt(twopi)*abs(seismdx)/rho
      else
         const=twopi*abs(seismdx)/rho
      endif
c      const=pi/rho

c     check that dividing by the squared velocity is OK

      velmax=0

      do j=1,velnx
         do i=1,velnz
            velmax=max(velmax,vel(i,j))
         end do
      end do

      velmin=velmax

      do j=1,velnx
         do i=1,velnz
            velmin=min(velmin,vel(i,j))
         end do
      end do

      if(idbg.ge.2)then
	 write(ipdmp,*)' FACTOR_ADJ_INV'
         write(ipdmp,*)' const : ',const
         write(ipdmp,*)' velmin: ',velmin
         write(ipdmp,*)' velmax: ',velmax
      end if

      if (velmin.le.tol*velmax) then
         write(ipdmp,*)' Error: FACTOR_ADJ_INV'
         write(ipdmp,*)' velocity range dangerously large'
         write(ipdmp,*)' minimum velocity  = ',velmin
         write(ipdmp,*)' maximum           = ',velmax
         ier=1
         return
      end if

c this version still assumes that the reflectivity and velocity sample
c rates are the same, but no longer enforces that the reflectivity is
c defined on a subgrid of the velocity grid. instead the velocity is
c extended implicitly.

      do i=1,reflnz
         if (reflzorig+(i-1)*veldz.lt.velzorig) then
            iv=1
         else if (reflzorig+(i-1)*veldz.gt.
     &           velzorig+(velnz-1)*veldz) then
            iv=velnz
         else
            iv=i+nint((reflzorig-velzorig)/veldz)
         endif
         do j=1,reflnx
c implicit extension
            if (reflxorig+(j-1)*veldx.lt.velxorig) then
               jv=1
            else if (reflxorig+(j-1)*veldx.gt.
     &              velxorig+(velnx-1)*veldx) then
               jv=velnx
            else
               jv=j+nint((reflxorig-velxorig)/veldx)
            endif

            if(inversion.eq.1)then
               if(three_d.eq.1)then 
                  factor(i,j)=const*vel(iv,jv)*vel(iv,jv)
               else
                  factor(i,j)=const*vel(iv,jv)
               endif
            else
               if(three_d.eq.1)then 
                  factor(i,j)=const/(vel(iv,jv)*vel(iv,jv)*vel(iv,jv))
               else
                  factor(i,j)=const/(vel(iv,jv)*vel(iv,jv))
               endif
            endif
         end do
      end do
      
      return
      end
c========================================================================
