c======== CVTTSOLVE FOR 2D MODELLING & MIGRATION =================

      subroutine cvttsolve2d_faj(
     &     nx,nz,dx,dz,xmin,zmin,dt,xs,zs,zd,
     &     v,tt,a,work,len_work,
     &     ipdmp,idbg,ier)

c CONSTANT VELOCITIES ONLY

c 2D Ray Theory
c returns first arrival traveltime, traveltime gradient
c components, and geometric optics amplitudes.

c WWS 5.93
c KARAYA 2.96 Modified to give both 2D & 2.5D amplitudes:

c Arguments:

      integer
     &     nx,nz,            ! number of samples in x and z
     &     len_work,         ! length of available workspace
     &     ipdmp,            ! dump unit number
     &     idbg,             ! verbose output unit number
     &     ier               ! error flag

      real 
     &     dx,dz,            ! steps
     &     xmin,zmin,        ! upper left corner coordinates
     &     xs,zs,            ! source coordinates
     &     zd,               ! datum depth
     &     v(nz,nx),         ! input velocity array
     &     tt(nz,nx),        ! output traveltimes
     &     a(nz,nx),         ! output GO amplitude
     &     work(*)           ! workspace
       real dt,testval

c internal variables

      integer i,j,nsz
      real c,x,z,r,pi,dc,twopi,rvel

c------------------------------------------------------------------

      if (ier.ne.0) return
      
      if(idbg.ge.1)then
         write(ipdmp,*)'
     &	 *** TTSOLVE: CONSTANT 2D VELOCITY VERSION ***'
      end if

      pi=3.1415927
      c=v(1,1)
      dc=1/c
      rvel=sqrt(v(1,1))
      twopi=2.0*pi

      if(idbg.gt.1)then
         write(ipdmp,*)' nx,nz,v(1,nx),v(nz,1)'
         write(ipdmp,*) nx,nz,v(1,nx),v(nz,1)
         write(ipdmp,*)' c,dx,dz,xs,zs,zd,xmin,zmin'
         write(ipdmp,*) c,dx,dz,xs,zs,zd,xmin,zmin
      end if
c
c correction june 26 1993: added factor 
c in amplitudes 
c
      testval = sqrt(dx**2+dz**2)

c      nsz=max( nint(zd/dz),0 ) + 1
      nsz=nint((zd-zmin)/dz)+1

      do j=1,nx
         x=xmin+(j-1)*dx
         do i=1,nsz-1
            tt(i,j)=1.0e+06
            a(i,j)=0.0e+00
         end do
         do i=nsz,nz
            z=zmin+(i-1)*dz
            r=sqrt((x-xs)**2+(z-zs)**2)
            tt(i,j)=r*dc
            if (r.gt.testval) then
               a(i,j) =rvel/(twopi*sqrt(2.0*r))
            else
               a(i,j) =rvel/(twopi*sqrt(2.0*testval))
            end if
         end do
      end do

      return
      end

c========================================================================
      subroutine cvttsolve25d_faj(
     &     nx,nz,dx,dz,xmin,zmin,dt,xs,zs,zd,
     &     v,tt,a,tau_yy,
     &     work,len_work,ipdmp,idbg,ier)

c CONSTANT VELOCITIES ONLY

c 2.5D Ray Theory
c returns first arrival traveltime, geometric optics amplitudes,
c traveltime gradient components, mixed x and x_r partial
c derivative of the traveltime and tau_yy.

c WWS 5.93
c KA  7/95
c WWS 26.10.95 no longer need to return apcut
c KA  2/96 modified tto give 3D spreading and tau_yy.

c Arguments:

      integer
     &     nx,nz,            ! number of samples in x and z
     &     len_work,         ! length of available workspace
     &     ipdmp,            ! dump unit number
     &     idbg,             ! verbose output unit number
     &     ier               ! error flag

      real 
     &     dx,dz,            ! steps
     &     xmin,zmin,        ! upper left corner coordinates
     &     xs,zs,            ! source coordinates
     &     zd,               ! datum depth
     &     v(nz,nx),         ! input velocity array
     &     tt(nz,nx),        ! output traveltimes
     &     a(nz,nx),         ! output GO amplitude
     &     tau_yy(nz,nx),    ! output GO yy_component of Laplacian of tt
     &     work(*)           ! workspace
       real dt,testval

c internal variables

      integer i,j,nsz
      real c,x,z,r,pi,dc,four_pi

c------------------------------------------------------------------

      if (ier.ne.0) return
      
c      call get_debug_level('cvttsolve25d_faj','idbg',idbg,ier)

      if(idbg.ge.1)then
         write(ipdmp,*)'
     &	 *** CVTTSOLVE25D_FAJ: CONSTANT VELOCITY VERSION ***'
      end if

      pi=3.1415927
      c=v(1,1)
      dc=1/c
      four_pi=4.0*pi

      if(idbg.ge.1)then
         write(ipdmp,*)' nx,nz,v(1,nx),v(nz,1)'
         write(ipdmp,*) nx,nz,v(1,nx),v(nz,1)
         write(ipdmp,*)' c,dx,dz,xs,zs,zd,xmin,zmin'
         write(ipdmp,*) c,dx,dz,xs,zs,zd,xmin,zmin
      end if
c
c correction june 26 1993: added factor 
c in amplitudes 
c
      testval = sqrt(dx**2+dz**2)

      nsz=nint((zd-zmin)/dz)+1
c
      do j=1,nx
         x=xmin+(j-1)*dx
c
         do i=1,nsz-1
            z=zs-zd
            r=sqrt(x*x+z*z)
            tt(i,j)=1.0e+06
            tau_yy(i,j)=1.0/(c*r)
            a(i,j)=0.0e+00
         end do
c
         do i=nsz,nz
            z=zmin+(i-1)*dz
            r=sqrt((x-xs)**2+(z-zs)**2)
            tt(i,j)=r*dc
            tau_yy(i,j) =1.0e+00/(c*r)
            if (r.gt.testval) then
               a(i,j) = 1.0/(four_pi*r)
            else
               a(i,j) = 1.0/(four_pi*testval)
            end if
         end do
      end do

c ADDED 20.10.95 WWS

      return
      end
c========================================================================
      subroutine cvttsolve2d_inv(
     &     nx,nz,dx,dz,xmin,zmin,dt,xs,zs,zd,
     &     v,tt,a,tau_x,tau_z,phi_xr,
     &     work,len_work,ipdmp,idbg,ier)

c CONSTANT VELOCITIES ONLY

c 2D Ray Theory
c returns first arrival traveltime, geometric optics amplitudes,
c traveltime gradient components, and mixed x and x_r partial
c derivative of the traveltime.

c WWS 5.93
c KARAYA  7/95
c WWS 26.10.95 no longer need to return apcut

c Arguments:

      integer
     &     nx,nz,            ! number of samples in x and z
     &     len_work,         ! length of available workspace
     &     ipdmp,            ! dump unit number
     &     idbg,             ! verbose output unit number
     &     ier               ! error flag

      real 
     &     dx,dz,            ! steps
     &     xmin,zmin,        ! upper left corner coordinates
     &     xs,zs,            ! source coordinates
     &     zd,               ! datum depth
     &     v(nz,nx),         ! input velocity array
     &     tt(nz,nx),        ! output traveltimes
     &     a(nz,nx),         ! output GO amplitude
     &     tau_x(nz,nx),     ! output GO x_component of gradient of tt
     &     tau_z(nz,nx),     ! output GO z_component of gradient of tt
     &     phi_xr(nz,nx),    ! output GO mixed x,x_r derivative of tt
c     &     apcut(nz,nx),     ! output GO aperture field
     &     work(*)           ! workspace
       real dt,testval

c internal variables

      integer i,j,nsz
c     integer apcut_ptr,work_ptr,size
      real c,x,z,r,pi,dc,twopi,rvel

c------------------------------------------------------------------

      if (ier.ne.0) return
      
c      call get_debug_level('cvttsolve2d_inv','idbg',idbg,ier)

      if(idbg.ge.1)then
         write(ipdmp,*)'
     &	 *** TTSOLVE2D_INV: CONSTANT VELOCITY VERSION ***'
      end if

      pi=3.1415927
      c=v(1,1)
      dc=1/c
      rvel=sqrt(v(1,1))
      twopi=2.0*pi

c size of global array:
      
c     size = nx*nz

c grab workspace for tmp array:

c     work_ptr=1
c     if(idbg.ge.1)then
c write(ipdmp,*) 'CVTTSOLVE2D_INV ---> get workspace ...'
c     endif
c     call getbuf('work',apcut_ptr,size,work_ptr,len_work,ipdmp,ier)
c     if(ier.ne.0)then
c write(ipdmp,*) 'Error: CVTTSOLVE2D_INV from GETBUF for apcut_ptr'
c return
c     endif
   
      if(idbg.ge.1)then
        write(ipdmp,*)' nx,nz,v(1,nx),v(nz,1)'
         write(ipdmp,*) nx,nz,v(1,nx),v(nz,1)
         write(ipdmp,*)' c,dx,dz,xs,zs,zd,xmin,zmin'
         write(ipdmp,*) c,dx,dz,xs,zs,zd,xmin,zmin
      end if
c
c correction june 26 1993: added factor 
c in amplitudes 
c
      testval = sqrt(dx**2+dz**2)

c      nsz=max( nint(zd/dz),0 ) + 1
      nsz=nint((zd-zmin)/dz)+1
c
      do j=1,nx
         x=xmin+(j-1)*dx
c
         do i=1,nsz-1
            tt(i,j)=1.0e+06
            tau_x(i,j)=0.0e+00
            tau_z(i,j)=0.999e+00
            phi_xr(i,j)=0.0e+00
c            apcut(i,j)=1.0e+00
            a(i,j)=0.0e+00
         end do
c
         do i=nsz,nz
            z=zmin+(i-1)*dz
            r=sqrt((x-xs)**2+(z-zs)**2)
            tt(i,j)=r*dc
            tau_x(i,j) =(x-xs)/(c*r)
            tau_z(i,j) =(z-zs)/(c*r)
            phi_xr(i,j) =-tau_z(i,j)/r
c            apcut(i,j)=1.0e+00
            if (r.gt.testval) then
               a(i,j) =twopi*sqrt(2.0*r)/rvel
            else
               a(i,j) =twopi*sqrt(2.0*testval)/rvel
            end if
         end do
      end do

c ADDED 20.10.95 WWS

c      if (idbg.ge.1) then
c         write(ipdmp,*)' CVTTSOLVE2D_INV ---> SMOOTH_AP'
c      end if      

c      new_work=len_work
c      call smooth_ap(nz,nx,work(apcut_ptr),work(work_ptr),new_work,
c     &               ipdmp,ier)
c      if(ier.ne.0)then
c         write(ipdmp,*)' Error: CVTTSOLVE2D_INV from SMOOTH_AP'
c         return
c      end if

c      if (idbg.ge.1) then
c         write(ipdmp,*)' CVTTSOLVE2D_INV ---> SCALE_AMP'
c      end if      

c      call scale_amp_inv(nz,nx,a,work(apcut_ptr),ipdmp,ier)
c      if (ier.ne.0) then
c         write(ipdmp,*)' Error: CVTTSOLVE2D_INV from SCALE_AMP'
c         return
c      end if

      if (idbg.ge.1) then
         write(ipdmp,*)' CVTTSOLVE2D_INV ---> SCALE_GRAD'
      end if      

      call scale_grad_inv(nz,nx,tau_x,tau_z,v,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: CVTTSOLVE2D_INV from SCALE_GRAD'
         return
      end if

      call bisect_grad_inv(nz,nx,tau_x,tau_z,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: CVTTSOLVE2D_INV from BISECT_GRAD'
         return
      end if

      return
      end
c======================================================================
      subroutine cvttsolve25d_inv(
     &     nx,nz,dx,dz,xmin,zmin,dt,xs,zs,zd,
c     &     v,tt,a,tau_x,tau_z,phi_xr,apcut,
     &     v,tt,a,tau_x,tau_z,phi_xr,tau_yy,
     &     work,len_work,ipdmp,idbg,ier)

c CONSTANT VELOCITIES ONLY

c 2.5D Ray Theory
c returns first arrival traveltime, geometric optics amplitudes,
c traveltime gradient components, mixed x and x_r partial
c derivative of the traveltime and tau_yy.

c WWS 5.93
c KA  7/95
c WWS 26.10.95 no longer need to return apcut
c KA  2/96 modified tto give 3D spreading and tau_yy.

c Arguments:

      integer
     &     nx,nz,            ! number of samples in x and z
     &     len_work,         ! length of available workspace
     &     ipdmp,            ! dump unit number
     &     idbg,             ! verbose output unit number
     &     ier               ! error flag

      real 
     &     dx,dz,            ! steps
     &     xmin,zmin,        ! upper left corner coordinates
     &     xs,zs,            ! source coordinates
     &     zd,               ! datum depth
     &     v(nz,nx),         ! input velocity array
     &     tt(nz,nx),        ! output traveltimes
     &     a(nz,nx),         ! output GO amplitude
     &     tau_x(nz,nx),     ! output GO x_component of gradient of tt
     &     tau_z(nz,nx),     ! output GO z_component of gradient of tt
     &     phi_xr(nz,nx),    ! output GO mixed x,x_r derivative of tt
     &     tau_yy(nz,nx),    ! output GO yy_component of Laplacian of tt
c     &     apcut(nz,nx),     ! output GO aperture field
     &     work(*)           ! workspace
       real dt,testval

c internal variables

      integer i,j,nsz
      real c,x,z,r,pi,dc,four_pi

c------------------------------------------------------------------

      if (ier.ne.0) return
      
c      call get_debug_level('cvttsolve25d_inv','idbg',idbg,ier)

      if(idbg.ge.1)then
         write(ipdmp,*)'
     &	 *** TTSOLVE25D_INV: CONSTANT VELOCITY VERSION ***'
      end if

      pi=3.1415927
      c=v(1,1)
      dc=1/c
      four_pi=4.0*pi

      if(idbg.ge.1)then
         write(ipdmp,*)' nx,nz,v(1,nx),v(nz,1)'
         write(ipdmp,*) nx,nz,v(1,nx),v(nz,1)
         write(ipdmp,*)' c,dx,dz,xs,zs,zd,xmin,zmin'
         write(ipdmp,*) c,dx,dz,xs,zs,zd,xmin,zmin
      end if
c
c correction june 26 1993: added factor 
c in amplitudes 
c
      testval = sqrt(dx**2+dz**2)

c      nsz=max( nint(zd/dz),0 ) + 1
      nsz=nint((zd-zmin)/dz)+1
c
      do j=1,nx
         x=xmin+(j-1)*dx
c
         do i=1,nsz-1
            z=zs-zd
            r=sqrt(x*x+z*z)
            tt(i,j)=1.0e+06
            tau_x(i,j)=0.0e+00
            tau_z(i,j)=0.999e+00
            phi_xr(i,j)=0.0e+00
            tau_yy(i,j)=1.0/(c*r)
c            apcut(i,j)=1.0e+00
            a(i,j)=0.0e+00
         end do
c
         do i=nsz,nz
            z=zmin+(i-1)*dz
            r=sqrt((x-xs)**2+(z-zs)**2)
            tt(i,j)=r*dc
            tau_x(i,j) =(x-xs)/(c*r)
            tau_z(i,j) =(z-zs)/(c*r)
            tau_yy(i,j) =1.0e+00/(c*r)
            phi_xr(i,j) =-tau_z(i,j)/r
c            apcut(i,j)=1.0e+00
            if (r.gt.testval) then
               a(i,j) =four_pi*r
            else
               a(i,j) =four_pi*testval
            end if
         end do
      end do

c ADDED 20.10.95 WWS

      if (idbg.ge.1) then
         write(ipdmp,*)' CVTTSOLVE25D_INV ---> SCALE_INV'
         write(6,*)' CVTTSOLVE25D_INV ---> SCALE_INV'
      end if      

      call scale_grad_inv(nz,nx,tau_x,tau_z,v,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: CVTTSOLVE25D_INV from SCALE_GRAD'
         return
      end if

      if (idbg.ge.1) then
         write(6,*)' CVTTSOLVE25D_INV: return'
      end if

      call bisect_grad_inv(nz,nx,tau_x,tau_z,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: CVTTSOLVE25D_INV from BISECT_GRAD'
         return
      end if

      return
      end
c========================================================================
