
c--------------------------------------------------------------------

      subroutine transport_rhs(nx, nz, iz, ss, 
     &     tt, amp, rhs,
     &     tx, txx, ham, apcut,
     &     dx, dz, step_total, lenwork, 
     &     work, idbg, ipdmp, ier)

c---------------------------------------------------------------------
c
c    UPWIND TRANSPORT SOLVER
c
c    Produces 2nd order Beam-Warming rhs for 
c    transport equation. Written for log amp version of
c    transport equation:
c
c    \nabla \tau \cdot \nabla (\log a) + 0.5 \nabla^2 \tau = 0
c
c    Uses upwind first differences, centered second differences 
c    of travel time, (these are passed from EIKONAL_RHS) and upwind
c    second order differences of amplitudes. Modifies rhs to reduce
c    out-of-aperture amplitudes
c
c    WWS    12.93
c    RV     02.94
c    RV     05.94 (loops unrolled for IBM)
c    WWS    07.94
c
c    MATLAB VERSION
c
c function ampham=ampstepu(ss,ssp,uc,tt,dx,dz,tx,txx,ham,g);
c 
c [nz,nx]=size(uc);
c zz=zeros(1,nx);
c 
c v=tx./ham;
c 
c txx(2:nx-1)=0.25*(txx(1:nx-2)+2*txx(2:nx-1)+txx(3:nx));
c txx(2:nx-1)=0.25*(txx(1:nx-2)+2*txx(2:nx-1)+txx(3:nx));
c ssx=zeros(1,nx);
c ssx(2:nx-1)=(ss(3:nx)-ss(1:nx-2))/(2.0*dx);
c ssx(1)=ssx(2);
c ssx(nx)=ssx(nx-1);
c ssz=(ssp-ss)/dz;
c slap=(0.5*(ssz -v.*ssx)./ham) + ss.*txx./(ham.*ham);
c slap=0.5*slap./ham;
c 
c slap=slap.*g;
c slap=slap+2*max(slap')*(ones(g)-g);
c 
c luc=-0.5*dz*(uc(3:nx)-2*uc(2:nx-1)+uc(1:nx-2))/(dx*dx);
c uxm=zz;
c uxm(3:nx)=(1.5*uc(3:nx)-2*uc(2:nx-1)+0.5*uc(1:nx-2))/dx;
c uxm(3:nx)=uxm(3:nx) + v(3:nx).*luc;
c uxp=zz;
c uxp(1:nx-2)=(-1.5*uc(1:nx-2)+2*uc(2:nx-1)-0.5*uc(3:nx))/dx;
c uxp(1:nx-2)=uxp(1:nx-2) + v(1:nx-2).*luc;
c 
c vdu=(max(v,zz).*uxm + min(v,zz).*uxp);
c 
c ampham=-(vdu+slap);
c 
c---------------------------------------------------------------------

c-- Arguments
      integer
     &     nx, nz,              ! grid dimensions
     &     iz,                  ! current depth step
     &     lenwork,             ! length of "work"
     &     idbg, ipdmp, ier     ! debug and error
      real 
     &     step_total,          ! total step taken so far
     &     dx,                  ! horizontal step
     &     dz,                  ! vertical step
     &     amp(nx),             ! amplitude at current depth
     &     ss(nz,nx),           ! square slowness array
     &     tt(nx),              ! travel time at current depth
     &     rhs(nx),             ! rhs for transp. scheme
     &     tx(nx),              ! first divided x-diff of tt (ENO)
     &     txx(*),              ! second divided x-diff of tt (centered)
     &     apcut(*),            ! aperture
     &     ham(*),              ! hamiltonian = tz
     &     work(*)              ! workspace

c-- Internal Variables

      real
     &     relstep, tol, zero,smallamp,smallampl,dxspec,dzdiv,dxdiv,
     &     helptmp,decay,maxslap

      integer
     &     j, ssptr, ssxptr,
     &     sszptr, slapptr, vptr, uxmptr, uxpptr,
     &     workptr

      data tol /0.001/
      data smallamp /1.0e-20/
      data decay /1.0e+00/

c-----------------------------------------------------------------------

      if (ier.ne.0) return

      if (idbg.ge.1) then
         write(ipdmp,*)' TRANS_RHS'
      end if
      if (idbg.ge.2) then
         write(ipdmp,*)' inputs:'
         write(ipdmp,*)' nx,nz,iz,dx,dz,step_total'
         write(ipdmp,*)  nx,nz,iz,dx,dz,step_total
	 if(idbg.ge.4)then
            write(ipdmp,*)' ss: '
            write(ipdmp,1000)(ss(iz,j),j=1,nx)
	 end if
         write(ipdmp,*)' tt: '
         write(ipdmp,1000)(tt(j),j=1,nx)
         write(ipdmp,*)' amp: '
         write(ipdmp,1000)(amp(j),j=1,nx)
         write(ipdmp,*)' tx:'
         write(ipdmp,1000)(tx(j),j=1,nx)
         write(ipdmp,*)' txx:'
         write(ipdmp,1000)(txx(j),j=1,nx+2)
         write(ipdmp,*)' apcut:'
         write(ipdmp,1000)(apcut(j),j=1,nx)
      end if

c--  Useful numbers
c---------------------
      zero= 0.0e+00
      smallampl=log(smallamp)

c--  Allocate memory
c----------------------
      workptr= 1
      call getbuf('work', vptr, nx, workptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TRANS_RHS from GETBUF for vptr'
         return
      end if
      call getbuf('work', ssptr, nx, workptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TRANS_RHS from GETBUF for ssptr'
         return
      end if
      call getbuf('work', ssxptr, nx, workptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TRANS_RHS from GETBUF for ssxptr'
         return
      end if
      call getbuf('work', sszptr, nx, workptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TRANS_RHS from GETBUF for sszptr'
         return
      end if
      call getbuf('work', slapptr, nx, workptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TRANS_RHS from GETBUF for slapptr'
         return
      end if
      call getbuf('work', uxmptr, nx, workptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TRANS_RHS from GETBUF for uxmptr'
         return
      end if
      call getbuf('work', uxpptr, nx, workptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TRANS_RHS from GETBUF for uxpptr'
         return
      end if

c interpolate square slowness field

      relstep = (dz - step_total)/dz

CDIR$ NORECURRENCE
      do j=1,nx
         work(ssptr-1+j)=relstep*ss(iz,j) + 
     &        (1.0e+00 - relstep)*ss(iz+1,j)
      end do

c square slowness second order first difference in 1 direction,
c linearly extrapolated at ends

      dxspec=1/(2.0e+00*dx)
CDIR$ NORECURRENCE
      do j=2,nx-1
         work(ssxptr-1+j)=(work(ssptr-1+j+1)-work(ssptr-1+j-1))*dxspec
      end do
      work(ssxptr)=2.0e+00*work(ssxptr+1)-work(ssxptr+2)
      work(ssxptr-1+nx)=2.0e+00*work(ssxptr-1+nx-1)-work(ssxptr-1+nx-2)

c square slowness first difference in 2 direction

      dzdiv=1/dz
CDIR$ NORECURRENCE
      do j=1,nx
         work(sszptr-1+j)=(ss(iz+1,j)-ss(iz,j))*dzdiv
      end do

CDIR$ NORECURRENCE
      do j=1,nx
         helptmp = 1.0e+00/ham(j)
         work(vptr-1+j)=tx(j)*helptmp
         work(slapptr-1+j) = 0.5e+00*helptmp*(
     &        (0.5e+00*(work(sszptr-1+j) -
     &        work(vptr-1+j)*work(ssxptr-1+j))*helptmp) +
     &        work(ssptr-1+j)*txx(j+1)*(helptmp**2))
      end do

c         work(slapptr-1+j) = 
c     &        0.5*work(slapptr-1+j)*helptmp

c determine max of slap, apply aperture cutoff - outside of 
c aperture make inhomogeneous term equal to decay * max in 
c aperture

      maxslap = 0.0e+00
CDIR$ NORECURRENCE
      do j=1,nx
         work(slapptr-1+j)=apcut(j)*work(slapptr-1+j)
         maxslap=max(maxslap,work(slapptr-1+j))
      end do
      do j=1,nx
         work(slapptr-1+j)=work(slapptr-1+j)+
     &        decay*(1.0e+00-apcut(j))*maxslap
      end do

c one-sided second order difference of amplitude
c
c     work(uxmptr)=0.0e+00
c     work(uxmptr+1)=0.0e+00
c     dxdiv=1/dx
c     do j=3,nx
c        work(uxmptr-1+j)=(1.5e+00*amp(j)-2.0e+00*amp(j-1)
c    &        +0.5e+00*amp(j-2))*dxdiv
c     end do
c     work(uxpptr-1+nx)=0.0e+00
c     work(uxpptr-1+nx-1)=0.0e+00
c     do j=1,nx-2
c        work(uxpptr-1+j)=(-1.5e+00*amp(j)+2.0e+00*amp(j+1)
c    &        -0.5e+00*amp(j+2))*dxdiv
c     end do
c finally compute rhs
c     do j=1,nx
c        rhs(j)=-(work(slapptr-1+j)
c    &        +max(work(vptr-1+j),zero)*work(uxmptr-1+j)
c    &        +min(work(vptr-1+j),zero)*work(uxpptr-1+j))
c     end do
c
c TAKE above lines together
c
c for j=1,2
c
      dxdiv=1.0e+00/dx
      j=1
      work(uxmptr)=0.0e+00
      work(uxpptr-1+j)=(-1.5e+00*amp(j)+2.0e+00*amp(j+1)
     &        -0.5e+00*amp(j+2))*dxdiv
      rhs(j)=-(work(slapptr-1+j)
     &        +max(work(vptr-1+j),zero)*work(uxmptr-1+j)
     &        +min(work(vptr-1+j),zero)*work(uxpptr-1+j))
      j=2
      work(uxmptr+1)=0.0e+00
      work(uxpptr-1+j)=(-1.5e+00*amp(j)+2.0e+00*amp(j+1)
     &        -0.5e+00*amp(j+2))*dxdiv
      rhs(j)=-(work(slapptr-1+j)
     &        +max(work(vptr-1+j),zero)*work(uxmptr-1+j)
     &        +min(work(vptr-1+j),zero)*work(uxpptr-1+j))
c
c for j=3,nx -2
c
CDIR$ NORECURRENCE
      do j=3,nx-2
      work(uxmptr-1+j)=(1.5e+00*amp(j)-2.0e+00*amp(j-1)
     &        +0.5e+00*amp(j-2))*dxdiv
      work(uxpptr-1+j)=(-1.5e+00*amp(j)+2.0e+00*amp(j+1)
     &        -0.5e+00*amp(j+2))*dxdiv
      rhs(j)=-(work(slapptr-1+j)
     &        +max(work(vptr-1+j),zero)*work(uxmptr-1+j)
     &        +min(work(vptr-1+j),zero)*work(uxpptr-1+j))
      end do
c
c for j=nx-1,nx
c 
      j=nx-1
      work(uxmptr-1+j)=(1.5e+00*amp(j)-2.0e+00*amp(j-1)
     &        +0.5e+00*amp(j-2))*dxdiv
      work(uxpptr-1+nx-1)=0.0e+00
      rhs(j)=-(work(slapptr-1+j)
     &        +max(work(vptr-1+j),zero)*work(uxmptr-1+j)
     &        +min(work(vptr-1+j),zero)*work(uxpptr-1+j))

      j=nx
      work(uxmptr-1+j)=(1.5e+00*amp(j)-2.0e+00*amp(j-1)
     &        +0.5e+00*amp(j-2))*dxdiv
      work(uxpptr-1+nx)=0.0e+00
      rhs(j)=-(work(slapptr-1+j)
     &        +max(work(vptr-1+j),zero)*work(uxmptr-1+j)
     &        +min(work(vptr-1+j),zero)*work(uxpptr-1+j))

c ERROR CHECK

      if (idbg.ge.1) then
         write(ipdmp,*)' TRANS_RHS: rhs'
         write(ipdmp,1000)(rhs(j),j=1,nx)
      end if

      if (idbg.ge.3) then
         write(ipdmp,*)' TRANS_RHS: slap'
         write(ipdmp,1000)(work(slapptr-1+j),j=1,nx)
         write(ipdmp,*)' TRANS_RHS: v'
         write(ipdmp,1000)(work(vptr-1+j),j=1,nx)
         write(ipdmp,*)' TRANS_RHS: uxm'
         write(ipdmp,1000)(work(uxmptr-1+j),j=1,nx)
         write(ipdmp,*)' TRANS_RHS: uxp'
         write(ipdmp,1000)(work(uxpptr-1+j),j=1,nx)
      end if

 1000 format(6(e10.4,2x))

      return
      end
