c============================ TTAMP2D_INV ========================

      subroutine ttamp2d_inv (nz, nx, dz, dx, ntop,vel,
     &     xmin,xs,zs,zd, eps, sincut, tancut, ss, tt, amp, 
     &     tau_x, tau_z, phi_xr, apcut, work, lenwork, ipdmp, 
     &     idbg, ier)
c-------------------------------------------------------------
c    2D traveltime and geometric optics amplitude solver
c
c    Driver to extend traveltime and amplitudes throughout
c    a rectangular array, given values on the ntop row (i.e.
c    first index = ntop) and above.
c
c    Uses 2nd order Runge-Kutta time step for numerical 
c    Hamiltonian operator, which returns both the nu-
c    merical Hamiltonian and a suitable right-hand side for
c    the transport equation. The local step is also returned
c    by this operator - it is chosen to be the minimum of a
c    safe CFL step and the remainder of the current step.
c
c    Current version (07.94): right hand sides of both eikonal
c    and transport equations are modified to limit ray incidence
c    angles to an aperture and to damp amplitudes along rays
c    at the aperture boundary.
c
c    WWW             05/93
c    HT              08/93
c    WWS             12/93
c    RV              02/94
c    WWS             07/94 - NOTE THAT EVOLUTION COORDINATE IS
c                            NOW 1ST!!!!
c    KARAYA          08/95 - INCLUDED FACTORS NEEDED IN HIGH
c                            FREQUENCY INVERSION
c--------------------------------------------------------------

c-- Arguments
      real
     &     dz, dx,              ! steps        
     &     eps,                 ! faithful threshhold
     &     sincut,              ! 
     &     tancut,              ! 
     &     ss(nz,nx),           ! slowness squared
     &     tt(nz,nx),           ! output traveltime array
     &     amp(nz,nx),          ! output amplitude array
     &     tau_x(nz,nx),        ! output x_component of gradient tt array
     &     tau_z(nz,nx),        ! output z_component of gradient tt array
     &     phi_xr(nz,nx),     ! output mixed (x,xr) derivative of tt array
     &     apcut(nz,nx),        ! aperture field
     &     work(*)              ! workspace
      real
     &     xmin,                !
     &     vel(nz,nx),          ! velocity array
     &     x,                   ! x-coordinate of output point on datum
     &     xs,                  ! x-coordinate of source
     &     zs,                  ! z-coordinate of source
     &     zd                   ! datum depth

      integer
     &     nz, nx,              ! array dimensions
     &     ntop,                ! row index for initial data
     &     lenwork,             ! size of available workspace
     &     ipdmp,               ! dump unit number
     &     ier                  ! error flag

c-- Internal Variables
      real
     &     pi,                  ! a Greek letter
     &     dztmp,               ! substep
     &     step_total,          ! partial step left to take
     &     init_amp_peak,       ! amp peak
     &     max_amp,             ! max relative amplitude
     &     min_amp,             ! min relative amplitude
     &     tol                  ! tolerance

      integer
     &     i, i1, j,k,l,        ! loop counters
     &     newwork,             ! lenght of remaining workspace for subs
     &     max_partial_steps,   ! guess
     &     idbg,                ! debug flag
     &     idbg_eik,            ! debug flag for eik rhs
     &     idbg_tsp,            ! debug flag for transport rhs
     &     nxp2,                ! nx+2
     &     hamptr,              ! pointer to buffer for rhs of eik eqn
     &     rhsptr,              ! pointer to buffer for rhs of transport eqn
     &     ttptr0,              ! pointer to buffer for travel time
     &     ttptr1,              ! pointer to buffer for travel time
     &     dxtptr,              ! pointer to buffer for travel time x diff
     &     dx2tptr,             ! pointer to buffer for travel time 2nd x diff
     &     apcutptr,            ! pointer to buffer for cutoff
     &     ampptr0,             ! pointer to buffer for amplitude
     &     ampptr1,             ! pointer to buffer for amplitude
     &     work_ptr             ! pointer to buffer for workspace

      integer ntaper
      real dtaper
      logical done, adjust
c
c Work space used in the evaluation of the Beylkin Determinant:
c
      integer 
     &     a_ptr,		! pointer for a the coefficient of u_x
     &     u_x_ptr,		! pointer for u_x 
     &     u_ptr        	! pointer for the initial data at the datum
c
c Internal variables used in the evaluation of the Beylkin Determinant:
c
      integer
     &      size,            ! size of vector representing arrays
     &      ns               ! 

      integer
     &      alpha             ! stability condittion

      logical blech

      data tol /1.e-4/, max_partial_steps /50/, 
     &     pi /3.1415927/, ntaper /4/

c======================================================================

      if (ier.ne.0) return

      blech=.true.

      idbg_eik=0
      idbg_tsp=0

c set minimum, maximum relative amplitudes

      dtaper=1.0e+00/float(ntaper)
      min_amp=1.e-3
      max_amp=1.e+1

      if (idbg.ge.2) then
         write(ipdmp,*)' TTAMP2D_INV: initial traveltimes, amplitudes'
         write(ipdmp,*)' tt:'
         write(ipdmp,*)(tt(ntop,j),j=1,nx)
         write(ipdmp,*)' amps:'
         write(ipdmp,*)(amp(ntop,j),j=1,nx)
      end if

c--  Grab memory
c----------------
      work_ptr= 1
      call getbuf('work', hamptr, nx, work_ptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP2D_INV from GETBUF for hamptr'
         return
      end if
      call getbuf('work', rhsptr, nx, work_ptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP2D_INV from GETBUF for rhsptr'
         return
      end if
      call getbuf('work', ttptr0, nx, work_ptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP2D_INV from GETBUF for ttptr0'
         return
      end if
      call getbuf('work', ttptr1, nx, work_ptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP2D_INV from GETBUF for ttptr1'
         return
      end if
      call getbuf('work', ampptr0, nx, work_ptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP2D_INV from GETBUF for ampptr0'
         return
      end if
      call getbuf('work', ampptr1, nx, work_ptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP2D_INV from GETBUF for ampptr1'
         return
      end if
      nxp2= nx+ 2
      call getbuf('work', dx2tptr, nxp2, work_ptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TTAMP2D_INV from GETBUF for dx2tptr'
         return
      end if
      call getbuf('work', dxtptr, nx, work_ptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TTAMP2D_INV from GETBUF for dxtptr'
         return
      end if
      call getbuf('work', apcutptr, nx, work_ptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TTAMP2D_INV from GETBUF for dxtptr'
         return
      end if

      newwork=lenwork- work_ptr

      init_amp_peak=0.0e+00
      do j=1,nx
         init_amp_peak=max(init_amp_peak,amp(ntop,j))
      end do
      min_amp=max(1.0e-10,init_amp_peak*min_amp)
      max_amp=max(1.0e-10,init_amp_peak*max_amp)
CDIR$ NORECURRENCE
      do j=1,nx
         work(ampptr0-1+j) = log(max(amp(ntop,j),min_amp))
         work(ttptr0-1+j) = tt(ntop,j)
      end do

c--  Debug instructions
c------------------------
      if (idbg.gt.0) then
         write(ipdmp,*) ' TTAMP2D_INV: inputs'
         write(ipdmp,*) ' nx, nz, dx, dz '
         write(ipdmp,*)   nx, nz, dx, dz
         write(ipdmp,*) ' eps'
         write(ipdmp,*)   eps
         write(ipdmp,*) ' TTAMP2D_INV: pointers'
         write(ipdmp,*) ' ttptr0, ttptr1, ampptr0, ampptr1'
         write(ipdmp,*)   ttptr0, ttptr1, ampptr0, ampptr1
         write(ipdmp,*) ' hamptr, rhsptr, work_ptr'
         write(ipdmp,*)   hamptr, rhsptr, work_ptr
         write(ipdmp,*) ' dxtptr, dx2tptr, apcutptr'
         write(ipdmp,*)   dxtptr, dx2tptr, apcutptr
         write(ipdmp,*) ' TTAMP2D_INV: remaining workspace = ',
     &      newwork
         write(ipdmp,*) ' init_amp_peak = ', init_amp_peak
         write(ipdmp,*) ' min_amp = ',min_amp
         write(ipdmp,*) ' max_amp = ',max_amp
      end if

      min_amp=log(min_amp)
      max_amp=log(max_amp)

      if (idbg.ge.2) then
         write(6,*)' TTAMP2D_INV: begin of depth step loop'
      end if

      do i= ntop, nz-1

c NOTE that the amplitude work vector contains the natural logarithm
c of the amplitude

         if (idbg.ge.2) then
            write(ipdmp,*)' TTAMP2D_INV: step ',i
            write(6,*)' TTAMP2D_INV: step ',i
         end if

c-----------------------------------------               
c--  Set step total to zero. Object is to reach dz
c---------------------------------------------------

         step_total= 0.0
           
         done= .false.

c--  PARTIAL STEP LOOP
c
         do i1= 1, max_partial_steps

            if (.not.done) then

               if (idbg.ge.3) then
                  write(ipdmp,*)' TT at begin of step:'
                  write(ipdmp,*)(work(ttptr0-1+j),j=1,nx)
               end if
               
c--  First call to numerical hamiltonian. Returns a
c    suitable value of dztmp each time. dztmp is first
c    initialized to dz at each call with adjust= .true.
c---------------------------------------------------------

               if (idbg.ge.2) then
                  write(ipdmp,*)' TTAMP2D_INV: step ',i,' substep ',i1
                  write(ipdmp,*)' TTAMP2D_INV ---> EIK_RHS 1'
                  write(6,*)' TTAMP2D_INV ---> EIK_RHS 1'
               end if

               adjust= .true.
               dztmp= dz
               
               call eikonal_rhs(nx, nz, i, ss,
     &              work(ttptr0), work(hamptr),
     &              work(dxtptr), work(dx2tptr), 
     &              work(apcutptr),
     &              dx, dztmp, dz, step_total, adjust, newwork, 
     &              eps, work(work_ptr), idbg_eik, ipdmp, ier)
      
               if (ier.ne.0) then
                  write(ipdmp,*) ' Error: TTAMP2D_INV from  EIK_RHS'
                  return
               end if

c--  First Runge-Kutta half-step for tt
c-----------------------------------------

CDIR$ NORECURRENCE
               do j= 1, nx
                  work(ttptr1-1+j) = work(ttptr0-1+j)
     &                 + dztmp* work(hamptr-1+j)
               end do
               if (idbg.ge.3) then
                  write(ipdmp,*)' TT after 1st half step:'
                  write(ipdmp,*)(work(ttptr1-1+j),j=1,nx)
               end if

c--  First evaluation of RHS in transport equation
c---------------------------------------------------------------

               if (idbg.ge.2) then
                  write(ipdmp,*)' TTAMP2D_INV ---> TRANS_RHS 1'
                  write(6,*)' TTAMP2D_INV ---> TRANS_RHS 1'
               end if

               call transport_rhs(nx, nz, i, ss,
     &              work(ttptr0), work(ampptr0), work(rhsptr),
     &              work(dxtptr), work(dx2tptr), 
     &              work(hamptr), work(apcutptr),
     &              dx, dz, step_total, newwork, 
     &              work(work_ptr), idbg_tsp, ipdmp, ier)

               if (ier.ne.0) then
                  write(ipdmp,*)' Error: TTAMP2D_INV from TRANS_RHS'
                  return
               end if

c--  First half step for amps
c----------------------------------------------

               if (blech) then
CDIR$ NORECURRENCE
               do j= 1, nx
                  work(ampptr1-1+j) = work(ampptr0-1+j)
     &                 + dztmp* work(rhsptr-1+j)
               end do

               else
CDIR$ NORECURRENCE
               do j= 1, nx
                  work(ampptr0-1+j) = work(ampptr0-1+j)
     &                 + dztmp* work(rhsptr-1+j)
               end do

               end if

c--  Second numerical Hamiltonian evaluation
c----------------------------------------------

               if (idbg.ge.2) then
                  write(ipdmp,*) ' TTAMP2D_INV ---> EIK_RHS 2'
                  write(6,*) ' TTAMP2D_INV ---> EIK_RHS 2'
               end if

               step_total= step_total + dztmp
               
               adjust= .false.

               call eikonal_rhs(nx, nz, i, ss,
     &              work(ttptr1), work(hamptr),
     &              work(dxtptr), work(dx2tptr), 
     &              work(apcutptr),
     &              dx, dztmp, dz, step_total, adjust, newwork, 
     &              eps, work(work_ptr), idbg_eik, ipdmp, ier)
               if (ier.ne.0) then
                  write(ipdmp,*) ' Error: TTAMP2D_INV from  EIK_RHS'
                  return
               end if


c--  Second Runge-Kutta half-step for tt
c-----------------------------------------
CDIR$ NORECURRENCE
               do j= 1, nx
                  work(ttptr0-1+j) = 0.5*
     &                 ( work(ttptr0-1+j) + work(ttptr1-1+j)
     &                 + dztmp* work(hamptr-1+j)  )
               end do

               if (idbg.ge.2) then
                  write(ipdmp,*) 
     &                 ' step          = ',i,
     &                 ' partial step  = ', i1,
     &                 ' step total    = ', step_total,
     &                 ' complement    = ', dz-step_total
               end if

               if (idbg.ge.3) then
                  write(ipdmp,*)' TT after 2nd half step:'
                  write(ipdmp,*)(work(ttptr0-1+j),j=1,nx)
               end if

c--  Second evaluation of RHS of transport equation
c----------------------------------------------------

               if (blech) then
       
               if (idbg.ge.2) then
                  write(ipdmp,*)' TTAMP2D ---> TRANS_RHS 2'
                  write(6,*)' TTAMP2D ---> TRANS_RHS 2'
               end if

               call transport_rhs(nx, nz, i, ss,
     &              work(ttptr1), work(ampptr1), work(rhsptr),
     &              work(dxtptr), work(dx2tptr), 
     &              work(hamptr), work(apcutptr),
     &              dx, dz, step_total, newwork, 
     &              work(work_ptr), idbg_tsp, ipdmp, ier)

               if (ier.ne.0) then
                  write(ipdmp,*)' Error: TTAMP2D from TRANS_RHS'
                  return
               end if

c--  Second RK half step for amps
CDIR$ NORECURRENCE
               do j= 1, nx
                  work(ampptr0-1+j) = 0.5*(work(ampptr0-1+j)
     &                 +work(ampptr1-1+j)+dztmp* work(rhsptr-1+j))
               end do

               end if

c-----------------------------------------               
c--  If successful record output fields
c-----------------------------------------               

               if (abs(dz-step_total).lt.(tol*dz)) then
                  done= .true.
CDIR$ NORECURRENCE
                  do j= 1, nx
                     tt(i+1,j) = work(ttptr0-1+j)
                     tau_x(i+1,j) = work(dxtptr-1+j)
                     tau_z(i+1,j) = work(hamptr-1+j)
                     apcut(i+1,j) = work(apcutptr-1+j)
                     work(ampptr0-1+j)=max(min_amp,min(max_amp,
     &                    work(ampptr0-1+j)))
                     amp(i+1,j)= exp(work(ampptr0-1+j))
                  end do
c taper!
c                  do j=0,ntaper
c                     amp(i+1,1+j)=dtaper*j*amp(i+1,1+j)
c                     amp(i+1,nx-j)=dtaper*j*amp(i+1,nx-j)
c                  end do

               end if

               if (idbg.ge.3) then
                  write(ipdmp,*)' TT at end of step:'
                  write(ipdmp,*)(work(ttptr0-1+j),j=1,nx)
               end if
               
            end if
            
         end do

c--  If we're still not done, then we failed to find an ok step
c----------------------------------------------------------------

         if (.not.done) then
            write(ipdmp,*) ' Error:TTAMP2D_INV'
            write(ipdmp,*) ' after ', max_partial_steps, ' steps'
            write(ipdmp,*) ' failed to take step ', i
            ier= 187
            return
         end if

c DEBUG!!!!!!!!!!!!!!!!!!!!!! - stop at the first step

         if (idbg.ge.5) then
            if (i.gt.ntop) then
               write(ipdmp,*)' DEBUG EXIT !!!!!!!'
               ier=555
               return
            end if
         end if

      end do

      if (idbg.ge.2) then
         write(6,*)' TTAMP2D_INV: end of depth step loop'
      end if

c=====================================================================
c
c
c Reserve work space for the calculation of the Beylkin Determinant:
c      
      size = nx
      call getbuf('work',u_ptr,size,work_ptr,newwork,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: BELK_DET from GETBUF for u_ptr'
      end if
c
      ns = nz - ntop + 1
      size = nx * ns
      call getbuf('work',a_ptr,size,work_ptr,newwork,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: BELK_DET from GETBUF for a_ptr'
      end if
c
      call getbuf('work',u_x_ptr,size,work_ptr,newwork,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: BELK_DET from GETBUF for u_x_ptr'
      end if
c
c*******************************************************************************
c Next prepare the input data for the numerical solver of the convection
c equation.
c           u_z + au_x = 0.0
c                  
c                                     (xs - x) 
c             u(x,zd) =    _______________________________________
c                                                   2             2
c                         vel(ntop,x) * sqrt[ (x-xs) + (zd - zs) ]
c
c Here                  a = tau_x / tau_z 
c                       u = tau_xs
c                       u(x,zd).
c
c where tau is the traveltime from the receiver to the input
c point and u(x,zd) is u at the datum.
c
c Initialize stability condition:
c
      alpha = 0
c
c      write(6,*)'zd = ',zd,' zs = ',zs
c      write(6,*)'tancut = ',tancut,' sincut = ',sincut
c

      if (idbg.ge.2) then
         write(6,*)' TTAMP2D_INV: prepare phi comp'
      end if
CDIR$ NORECURRENCE
      do i = 1,nx
c	    write(6,*)'Datum velocity = ', vel(ntop,i)
c
c calculate u(x,zd)
c
         x = xmin + (i - 1) * dx
c
c Determine u(x,zd) and put it in a work array that will be used as the initial
c data in code:
c
         if( abs(x-xs)/abs(zs-zd).le.tancut )then
            work(u_ptr + i-1) = ( xs - x ) / 
     &           ( vel(ntop,i) * sqrt( (x-xs)**2 + (zd-zs)**2 ) )
         else
            work(u_ptr + i-1) = sincut/vel(ntop,i)
         endif
c
c For each input point inside the model calculate the 2-D array a:
c
c
CDIR$ NORECURRENCE
         do j= 1,ns
            l = j + ntop -1
            work(a_ptr+(i-1)*ns+j-1) = tau_x(l,i)/tau_z(l,i)
            alpha = 
     &           max ( abs(nint(work(a_ptr+(i-1)*ns+j-1))),alpha )

         end do
      end do
c
c      write(6,*)'alpha = ',alpha
c
c get the (x, x_r) mixed derivative of the travel time - call BELK_DET
c

      if (idbg.ge.2) then
         write(ipdmp,*)' TTAMP2D_INV ---> BELK_DET'
         write(6,*)' TTAMP2D_INV ---> BELK_DET'
      end if

c
      call belk_det(nx,ns,dx,dz,
     &              work(a_ptr),work(u_x_ptr),
     &              work(u_ptr),alpha,work(work_ptr),
     &              newwork,ipdmp,ier)

      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP2D_INV from BELK_DET'
         return
      end if
c
c Finally return phi_xr:
c

      do i = 1,nx
         do j= 1,ns
	    l = j + ntop -1
            k = (i-1)*ns + j-1
	    phi_xr(l,i) = work(u_x_ptr + k)/tau_z(l,i)
         end do
      end do

      if (idbg.ge.2) then
         write(6,*)' TTAMP2D: return'
      end if

      return
      end
c=============================================================================:
