c============================ TTAMP2D ============================

      subroutine ttamp2d_faj (nz, nx, dz, dx,
     &     ntop, eps, ss, tt, amp, 
     &     work, lenwork, ipdmp, idbg, ier)
c-------------------------------------------------------------
c    2D traveltime and geometric optics amplitude solver
c
c    Driver to extend traveltime and amplitudes throughout
c    a rectangular array, given values on the ntop row (i.e.
c    first index = ntop) and above.
c
c    Uses 2nd order Runge-Kutta time step for numerical 
c    Hamiltonian operator, which returns both the nu-
c    merical Hamiltonian and a suitable right-hand side for
c    the transport equation. The local step is also returned
c    by this operator - it is chosen to be the minimum of a
c    safe CFL step and the remainder of the current step.
c
c    Current version (07.94): right hand sides of both eikonal
c    and transport equations are modified to limit ray incidence
c    angles to an aperture and to damp amplitudes along rays
c    at the aperture boundary.
c
c    WWW             05/93
c    HT              08/93
c    WWS             12/93
c    RV              02/94
c    WWS             07/94 - NOTE THAT EVOLUTION COORDINATE IS
c                            NOW 1ST!!!!
c
c--------------------------------------------------------------

c-- Arguments
      real
     &     dz, dx,              ! steps        
     &     eps,                 ! faithful threshhold
     &     ss(nz,nx),           ! slowness squared
     &     tt(nz,nx),           ! output traveltime array
     &     amp(nz,nx),          ! output amplitude array
     &     work(*)              ! workspace
      integer
     &     nz, nx,              ! array dimensions
     &     ntop,                ! row index for initial data
     &     lenwork,             ! size of available workspace
     &     ipdmp,               ! dump unit number
     &     ier                  ! error flag

c-- Internal Variables
      real
     &     pi,                  ! a Greek letter
     &     dztmp,               ! substep
     &     step_total,          ! partial step left to take
     &     init_amp_peak,       ! amp peak
     &     max_amp,             ! max relative amplitude
     &     min_amp,             ! min relative amplitude
     &     tol                  ! tolerance

      integer
     &     i, i1, j,            ! loop counters
     &     newwork,             ! lenght of remaining workspace for subs
     &     max_partial_steps,   ! guess
     &     idbg,                ! debug flag
     &     idbg_eik,            ! debug flag for eik rhs
     &     idbg_tsp,            ! debug flag for transport rhs
     &     nxp2,                ! nx+2
     &     hamptr,              ! pointer to buffer for rhs of eik eqn
     &     rhsptr,              ! pointer to buffer for rhs of transport eqn
     &     ttptr0,              ! pointer to buffer for travel time
     &     ttptr1,              ! pointer to buffer for travel time
     &     dxtptr,              ! pointer to buffer for travel time x diff
     &     dx2tptr,             ! pointer to buffer for travel time 2nd x diff
     &     apcutptr,            ! pointer to buffer for cutoff
     &     ampptr0,             ! pointer to buffer for amplitude
     &     ampptr1,             ! pointer to buffer for amplitude
     &     workptr              ! pointer to buffer for workspace

      integer ntaper
      real dtaper
      logical done, adjust, amplitudes
      data tol /1.e-4/, max_partial_steps /50/, amplitudes /.true./,
     &     pi /3.1415927/, ntaper /4/

c======================================================================

      if (ier.ne.0) return

      idbg_eik=0
      idbg_tsp=0

c set minimum, maximum relative amplitudes

      dtaper=1.0e+00/float(ntaper)
      min_amp=1.e-3
      max_amp=1.e+1

      if (idbg.ge.2) then
         write(ipdmp,*)' TTAMP: initial traveltimes, amplitudes'
         write(ipdmp,*)' tt:'
         write(ipdmp,*)(tt(ntop,j),j=1,nx)
         write(ipdmp,*)' amps:'
         write(ipdmp,*)(amp(ntop,j),j=1,nx)
      end if

c--  Grab memory
c----------------
      workptr= 1
      call getbuf('work', hamptr, nx, workptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP from GETBUF for hamptr'
         return
      end if
      call getbuf('work', rhsptr, nx, workptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP from GETBUF for rhsptr'
         return
      end if
      call getbuf('work', ttptr0, nx, workptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP from GETBUF for ttptr0'
         return
      end if
      call getbuf('work', ttptr1, nx, workptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP from GETBUF for ttptr1'
         return
      end if
      call getbuf('work', ampptr0, nx, workptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP from GETBUF for ampptr0'
         return
      end if
      call getbuf('work', ampptr1, nx, workptr, lenwork, ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: TTAMP from GETBUF for ampptr1'
         return
      end if
      nxp2= nx+ 2
      call getbuf('work', dx2tptr, nxp2, workptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TTAMP from GETBUF for dx2tptr'
         return
      end if
      call getbuf('work', dxtptr, nx, workptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TTAMP from GETBUF for dxtptr'
         return
      end if
      call getbuf('work', apcutptr, nx, workptr, lenwork,
     &     ipdmp, ier)
      if (ier.ne.0) then
         write(ipdmp,*) ' Error: TTAMP from GETBUF for dxtptr'
         return
      end if

      newwork=lenwork- workptr

      init_amp_peak=0.0e+00
      do j=1,nx
         init_amp_peak=max(init_amp_peak,amp(ntop,j))
      end do
      min_amp=max(1.0e-10,init_amp_peak*min_amp)
      max_amp=max(1.0e-10,init_amp_peak*max_amp)
CDIR$ NORECURRENCE      
      do j=1,nx
         work(ampptr0-1+j) = log(max(amp(ntop,j),min_amp))
         work(ttptr0-1+j) = tt(ntop,j)
      end do

c--  Debug instructions
c------------------------
      if (idbg.gt.0) then
         write(ipdmp,*) ' TTAMP: inputs'
         write(ipdmp,*) ' nx, nz, dx, dz '
         write(ipdmp,*)   nx, nz, dx, dz
         write(ipdmp,*) ' eps'
         write(ipdmp,*)   eps
         write(ipdmp,*) ' TTAMP: pointers'
         write(ipdmp,*) ' ttptr0, ttptr1, ampptr0, ampptr1'
         write(ipdmp,*)   ttptr0, ttptr1, ampptr0, ampptr1
         write(ipdmp,*) ' hamptr, rhsptr, workptr'
         write(ipdmp,*)   hamptr, rhsptr, workptr
         write(ipdmp,*) ' dxtptr, dx2tptr, apcutptr'
         write(ipdmp,*)   dxtptr, dx2tptr, apcutptr
         write(ipdmp,*) ' TTAMP: remaining workspace = ',
     &      newwork
         write(ipdmp,*) ' init_amp_peak = ', init_amp_peak
         write(ipdmp,*) ' min_amp = ',min_amp
         write(ipdmp,*) ' max_amp = ',max_amp
      end if

      min_amp=log(min_amp)
      max_amp=log(max_amp)

      do i= ntop, nz-1

c NOTE that the amplitude work vector contains the natural logarithm
c of the amplitude

c-----------------------------------------               
c--  Set step total to zero. Object is to reach dz
c---------------------------------------------------

         step_total= 0.0
           
         done= .false.

c--  PARTIAL STEP LOOP
c
         do i1= 1, max_partial_steps

            if (.not.done) then

c--  First call to numerical hamiltonian. Returns a
c    suitable value of dztmp each time. dztmp is first
c    initialized to dz at each call with adjust= .true.
c---------------------------------------------------------

               if (idbg.ge.2) then
                  write(ipdmp,*)' TTAMP: step ',i,' substep ',i1
                  write(ipdmp,*)' TTAMP ---> EIK_RHS 1'
               end if

               adjust= .true.
               dztmp= dz
               
               call eikonal_rhs(nx, nz, i, ss,
     &              work(ttptr0), work(hamptr),
     &              work(dxtptr), work(dx2tptr), 
     &              work(apcutptr),
     &              dx, dztmp, dz, step_total, adjust, newwork, 
     &              eps, work(workptr), idbg_eik, ipdmp, ier)
      
               if (ier.ne.0) then
                  write(ipdmp,*) ' Error: TTAMP from  EIK_RHS'
                  return
               end if

c--  First Runge-Kutta half-step for tt
c-----------------------------------------

CDIR$ NORECURRENCE
               do j= 1, nx
                  work(ttptr1-1+j) = work(ttptr0-1+j)
     &                 + dztmp* work(hamptr-1+j)
               end do

c If amplitudes are to be computed evaluate RHS in transport equation
c and take first RK half step for amps

               if (amplitudes) then
       
                  if (idbg.ge.2) then
                     write(ipdmp,*)' TTAMP ---> TRANS_RHS'
                  end if

                  call transport_rhs(nx, nz, i, ss,
     &                 work(ttptr0), work(ampptr0), work(rhsptr),
     &                 work(dxtptr), work(dx2tptr), 
     &                 work(hamptr), work(apcutptr),
     &                 dx, dz, step_total, newwork, 
     &                 work(workptr), idbg_tsp, ipdmp, ier)

                  if (ier.ne.0) then
                     write(ipdmp,*)' Error: TTAMP from TRANS_RHS'
                     return
                  end if

CDIR$ NORECURRENCE
                  do j= 1, nx
                     work(ampptr1-1+j) = work(ampptr0-1+j)
     &                    + dztmp* work(rhsptr-1+j)
                  end do

c otherwise just fill the amplitude array with ones

               else

                  do j=1,nx
                     amp(j,i+1)=1.0e+00
                  end do

               end if

c--  Second numerical Hamiltonian evaluation
c----------------------------------------------

               if (idbg.ge.2) then
                  write(ipdmp,*) ' TTAMP ---> EIK_RHS 2'
               end if

               step_total= step_total + dztmp
               
               adjust= .false.

               call eikonal_rhs(nx, nz, i, ss,
     &              work(ttptr1), work(hamptr),
     &              work(dxtptr), work(dx2tptr), 
     &              work(apcutptr),
     &              dx, dztmp, dz, step_total, adjust, newwork, 
     &              eps, work(workptr), idbg_eik, ipdmp, ier)
               if (ier.ne.0) then
                  write(ipdmp,*) ' Error: TTAMP from  EIK_RHS'
                  return
               end if


c--  Second Runge-Kutta half-step for tt
c-----------------------------------------

CDIR$ NORECURRENCE
               do j= 1, nx
                  work(ttptr0-1+j) = 0.5*
     &                 ( work(ttptr0-1+j) + work(ttptr1-1+j)
     &                 + dztmp* work(hamptr-1+j)  )
               end do

               if (idbg.ge.2) then
                  write(ipdmp,*) 
     &                 ' step          = ',i,
     &                 ' partial step  = ', i1,
     &                 ' step total    = ', step_total,
     &                 ' complement    = ', dz-step_total
               end if

c--  Second evaluation of RHS of transport equation
c----------------------------------------------------
       
               if (amplitudes) then

                  if (idbg.ge.2) then
                     write(ipdmp,*)' TTAMP ---> TRANS_RHS 2'
                  end if

                  call transport_rhs(nx, nz, i, ss,
     &                 work(ttptr1), work(ampptr1), work(rhsptr),
     &                 work(dxtptr), work(dx2tptr), 
     &                 work(hamptr), work(apcutptr),
     &                 dx, dz, step_total, newwork, 
     &                 work(workptr), idbg_tsp, ipdmp, ier)
                  
                  if (ier.ne.0) then
                     write(ipdmp,*)' Error: TTAMP from TRANS_RHS'
                     return
                  end if
                  
c--   Second RK half step for amps
                  
CDIR$ NORECURRENCE
                  do j= 1, nx
                     work(ampptr0-1+j) = 0.5*(work(ampptr0-1+j)
     &                    +work(ampptr1-1+j)+dztmp* work(rhsptr-1+j))
                  end do

               end if
c-----------------------------------------               
c--  If successful record output fields
c-----------------------------------------               

               if (abs(dz-step_total).lt.(tol*dz)) then
                  done= .true.
                  do j= 1, nx
                     tt(i+1,j) = work(ttptr0-1+j)
                  end do
                  if (amplitudes) then
CDIR$ NORECURRENCE
                     do j=1, nx
                        work(ampptr0-1+j)=max(min_amp,min(max_amp,
     &                       work(ampptr0-1+j)))
                        amp(i+1,j)= exp(work(ampptr0-1+j))
                     end do
c taper!
CDIR$ NORECURRENCE
                     do j=0,ntaper
                        amp(i+1,1+j)=dtaper*j*amp(i+1,1+j)
                        amp(i+1,nx-j)=dtaper*j*amp(i+1,nx-j)
                     end do

                  end if

               end if
               
            end if
            
         end do

c--  If we're still not done, then we failed to find an ok step
c----------------------------------------------------------------

         if (.not.done) then
            write(ipdmp,*) ' Error:TTAMP'
            write(ipdmp,*) ' after ', max_partial_steps, ' steps'
            write(ipdmp,*) ' failed to take step ', i
            ier= 187
            return
         end if

c DEBUG!!!!!!!!!!!!!!!!!!!!!! - stop at the first step

         if (idbg.ge.5) then
            if (i.gt.ntop) then
               write(ipdmp,*)' DEBUG EXIT !!!!!!!'
               ier=555
               return
            end if
         end if

      end do

      return
      end
c=================================================================
