c========================= STT_CREATE ===============================

      subroutine stt_create(inversion,three_d,ntables,
     &     velnz,velzorig,veldz,
     &     velnx,velxorig,veldx,seismdt,
     &     srcpos,srcdep,velmodel,amp_op_fwd,data,
     &     work,lenwork,ap,zd,ipdmp,idbg,ier) 

c------------------------------------------------------------
c Out-of-core traveltime table creation.
c this is the main code which invokes different schemes
c for traveltime creation dependent on amp_op_fwd
c
c If amp_op_fwd is 0, inversion is true and three_d is true
c the ttsolve25d_inv/(ttinit25d_inv followed by ttamp25d_inv)
c code is invoked.
c
c If amp_op_fwd is 0, inversion is true and three_d is false
c the ttsolve2d_inv/(ttinit2d_inv followed by ttamp2d_inv)
c code is invoked.
c
c If amp_op_fwd is 0, inversion is false and three_d is true
c the ttsolve25d_faj/(ttinit25d_faj followed by ttamp25d_faj)
c code is invoked.
c
c If amp_op_fwd is 0, inversion is false and three_d is false
c the ttsolve2d_faj/(ttinit2d_faj followed by ttamp2d_faj)
c code is invoked.
c
c If amp_op_fwd is 1, inversion is true and three_d is true
c the cvttsolve25d_inv (constant velocity code) is invoked.
c
c If amp_op_fwd is 1 inversion is true and three_d is false
c the cvttsolve2d_inv (constant velocity code) is invoked.
c
c If amp_op_fwd is 1, inversion is false and three_d is true
c the cvttsolve25d_faj (constant velocity code) is invoked.
c
c If amp_op_fwd is 1 inversion is false and three_d is false
c the cvttsolve2d_faj (constant velocity code) is invoked.
c
c WWS 6/93
c RV  8/93
c KA  7/95
c
c MAJOR MOD, 20.10.95, WWS:
c
c if inversion is FALSE now return amplitudes MULTIPLIED BY 
c aperture cutoff
c
c if inversion is TRUE now return RECIPROCAL amplitudes 
c MULTIPLIED BY aperture cutoff
c
c KA  3/96
c------------------------------------------------------------
      integer inversion         ! true for Beylkin type inversion
c                                 false otherwise
      integer three_d          ! true for 2.5D amplitude type false otherwise

      integer 
     &     ntables,             ! number of data tables
     &     ier,                 ! error flag
     &     amp_op_fwd,          ! amplitude option which decides which 
c                                 modeler will be used
     &     idbg,                ! debug flag
     &     lenwork,             ! length of work array
     &     ipdmp                ! dump unit

      integer 
     &     velnz,              ! first dimension of local velocity model
     &     velnx               ! second dimension of local velocity model

      real 
     &     velzorig,              ! offset velocity model, first dimension
     &     velxorig,              ! offset velocity model, second dimension
     &     veldz,              ! stepsize velocity model, first dimension
     &     veldx,              ! stepsize velocity model, second dimension
     &     seismdt,              ! stepsize seismogram, time sample step 
c                                 (first dimension)
     &     srcpos,              ! source position (offset)
     &     srcdep               ! source position (depth)

      real 
     &     work(lenwork),               ! work array
     &     velmodel(velnz,velnx),       ! velocity model
     &     data(velnz,velnx*ntables)    ! data array, will at output contain 
c                                     traveltimes, amplitudes, tau_x, tau_z
c                                     phi_xr and tau_yy

      real  
     &     ap,          ! kirchhoff aperture
     &     zd                   ! datum depth

      real 
     &     dtrecip              ! 1/dt

c index offset factors for various subarrays of ttamp:

      integer
     &     tt_rec,      ! traveltime
     &     amp_rec,     ! (scaled) amplitude
     &     tx_rec,      ! traveltime x-derivative
     &     tz_rec,      ! traveltime z-derivative
     &     txr_rec,     ! traveltime mixed x, xr second derivative
     &     tyy_rec,     ! traveltime yy component of Laplacian
     &     ap_rec       ! aperture field

      integer i,j,lworkt

c------------------------------------------------------
c definition of index offset factors

      data
     &     tt_rec /0/,
     &     amp_rec /1/,
     &     tx_rec /2/,
     &     tz_rec /3/,
     &     txr_rec /4/,
     &     tyy_rec /5/,
     &     ap_rec /6/

c------------------------------------------------------

      if (ier.ne.0) return

      if (idbg.ne.0) then
         write(ipdmp,*)' STT_CREATE: starting up ...'
      end if

c amp_op_fwd = 1:
c constant velocity traveltime calculation
c amp_op_fwd = 0:
c ENO eikonal/transport scheme

      if (amp_op_fwd.eq.0) then
         
         if(idbg.ge.1)then
            write(ipdmp,*)' variable velocity code'
         end if

         lworkt=lenwork

	 if((inversion.eq.1).and.(three_d.eq.1))then

            if (idbg.ge.2) then
               write(ipdmp,*)' lenwork : ',lenwork
               write(ipdmp,*)' lworkt : ',lworkt
               write(6,*)' STT_CREATE ---> TTSOLVE2D_INV'
            end if

            call ttsolve25d_inv(velnx,velnz,veldx,
     &        	 veldz,velxorig,velzorig,
     &           srcpos,srcdep,zd,ap,velmodel,
     &           data(1,tt_rec*velnx+1),
     &           data(1,amp_rec*velnx+1),
     &           data(1,tx_rec*velnx+1),
     &           data(1,tz_rec*velnx+1), 
     &           data(1,txr_rec*velnx+1),
     &           data(1,tyy_rec*velnx+1),
     &           work,lworkt,ipdmp,idbg,ier)

            if (ier.ne.0) then
               write(ipdmp,*)' Error: STT_CREATE from TTSOLVE25D_INV'
               return
            end if

         end if

	 if((inversion.eq.1).and.(three_d.eq.0))then

            if (idbg.ge.2) then
               write(6,*)' STT_CREATE <--- TTSOLVE2D_INV'
            end if

            call ttsolve2d_inv(velnx,velnz,veldx,
     &        	 veldz,velxorig,velzorig,
     &           srcpos,srcdep,zd,ap,velmodel,
     &           data(1,tt_rec*velnx+1),
     &           data(1,amp_rec*velnx+1),
     &           data(1,tx_rec*velnx+1),
     &           data(1,tz_rec*velnx+1), 
     &           data(1,txr_rec*velnx+1),
     &           work,lworkt,ipdmp,idbg,ier)

            if (ier.ne.0) then
               write(ipdmp,*)' Error: STT_CREATE from TTSOLVE2D_INV'
               return
            end if

         end if

	 if((inversion.eq.0).and.(three_d.eq.1))then

            if (idbg.ge.2) then
               write(6,*)' STT_CREATE <--- TTSOLVE2D_FAJ'
            end if

            call ttsolve25d_faj(velnx,velnz,veldx,
     &        	 veldz,velxorig,velzorig,
     &           srcpos,srcdep,zd,ap,velmodel,
     &           data(1,tt_rec*velnx+1),
     &           data(1,amp_rec*velnx+1),
     &           data(1,tx_rec*velnx+1),
     &           data(1,tz_rec*velnx+1), 
     &           data(1,txr_rec*velnx+1),
     &           work,lworkt,ipdmp,idbg,ier)

            if (ier.ne.0) then
               write(ipdmp,*)' Error: STT_CREATE from TTSOLVE2D5_FAJ'
               return
            end if

         end if

	 if((inversion.eq.0).and.(three_d.eq.0))then

            if (idbg.ge.2) then
               write(6,*)' STT_CREATE <--- TTSOLVE2D'
            end if

            call ttsolve2d_faj(velnx,velnz,veldx,
     &           veldz,velxorig,velzorig,
     &           srcpos,srcdep,zd,ap,
     &           velmodel,data(1,tt_rec*velnx+1),
     &           data(1,amp_rec*velnx+1),
     &           work,lworkt,ipdmp,idbg,ier)

            if (ier.ne.0) then
               write(ipdmp,*)' Error: STT_CREATE from TTSOLVE2D'
               return
            end if

	 endif

      else if(amp_op_fwd.eq.1)then

	 if((inversion.eq.1).and.(three_d.eq.1)) then

            if(idbg.ge.1)then
               write(ipdmp,*)'  constant velocity code'
            end if

            call cvttsolve25d_inv(velnx,velnz,
     & 	         veldx,veldz,velxorig,velzorig,
     &           seismdt,srcpos,srcdep,zd,velmodel,
     &           data(1,tt_rec*velnx+1),
     &           data(1,amp_rec*velnx+1),
     &           data(1,tx_rec*velnx+1),
     &           data(1,tz_rec*velnx+1), 
     &           data(1,txr_rec*velnx+1),
     &           data(1,tyy_rec*velnx+1),
     &           work,lworkt,ipdmp,idbg,ier)
         
            if (ier.ne.0) then
               write(ipdmp,*)' Error: STT_CREATE from CVTTSOLVE25D_INV'
               write(ipdmp,*)' ier = ',ier
               return
            end if

         end if

	 if((inversion.eq.1).and.(three_d.eq.0))then

            call cvttsolve2d_inv(velnx,velnz,
     & 	         veldx,veldz,velxorig,velzorig,
     &           seismdt,srcpos,srcdep,zd,velmodel,
     &           data(1,tt_rec*velnx+1),
     &           data(1,amp_rec*velnx+1),
     &           data(1,tx_rec*velnx+1),
     &           data(1,tz_rec*velnx+1), 
     &           data(1,txr_rec*velnx+1),
     &           work,lworkt,ipdmp,idbg,ier)
         
            if (ier.ne.0) then
               write(ipdmp,*)' Error: STT_CREATE from CVTTSOLVE2D_INV'
               write(ipdmp,*)' ier = ',ier
               return
            end if
         end if

	 if((inversion.eq.0).and.(three_d.eq.1))then

            call cvttsolve25d_faj(velnx,velnz,
     & 	         veldx,veldz,velxorig,velzorig,
     &           seismdt,srcpos,srcdep,zd,velmodel,
     &           data(1,tt_rec*velnx+1),
     &           data(1,amp_rec*velnx+1),
     &           data(1,tx_rec*velnx+1),
     &           work,lworkt,ipdmp,idbg,ier)
         
            if (ier.ne.0) then
               write(ipdmp,*)' Error: STT_CREATE from CVTTSOLVE25D_FAJ'
               write(ipdmp,*)' ier = ',ier
               return
            end if
         end if

	 if((inversion.eq.0).and.(three_d.eq.0))then
            call cvttsolve2d_faj(velnx,velnz,veldx,
     & 	         veldz,velxorig,velzorig,
     &           seismdt,srcpos,srcdep,zd,velmodel,
     &           data(1,tt_rec*velnx+1),
     &           data(1,amp_rec*velnx+1),
     &           work,lworkt,ipdmp,idbg,ier)
         
            if (ier.ne.0) then
               write(ipdmp,*)' Error: STT_CREATE from CVTTSOLVE'
               write(ipdmp,*)' ier = ',ier
               return
            end if
	 endif

      end if

      if (1.0e+00+seismdt.le.1.0e+00) then
         write(ipdmp,*)' Error: STT'
         write(ipdmp,*)' seismdt too small = ',seismdt
         ier=3
         return
      end if

c divide by dt to "integerize" the traveltimes

      dtrecip = 1.0e+00/seismdt
      do i = 1,velnz 
         do j = 1,velnx
            data(i,j) = dtrecip*data(i,j)
         end do
      end do

      return 
      end

c========================================================================
