c===========================================================
      subroutine sigma_local(nx,nz,dx,dz,a,az,src,u,v,
     &     work,work_ptr,len_work,ipdmp,ier)
c===========================================================
c
c     This subroutine computes the one step of the scheme
c     to sigma the perturbation equation of the eikonal:
c
c  	| u_z + a u_x = src
c  	|
c  	| u(x,z=zm) = sigma_datum
c
c     So the subroutine iterates the second order scheme 
c     given by:
c
c     u^n+1 = u^n + dz.rhs_x + 0.5.dz.dz.rhs_z1
c 
c     with 
c     
c     rhs_x  = -a.d0(u) + src
c     rhs_z1 = a^2.u_xx + (a.d0(a) - a_z).u_x
c     
c     On the boundary we have a first order upwind scheme:
c
c     u^n+1 = u^n - am(1).dz/dx(u(2)-u(1)) + dz.src(1)
c     u^n+1 = u^n - ap(nx).dz/dx(u(nx)-u(nx-1)) + dz.src(nx)
c
c===========================================================
      
c---
c Arguments 
c---
      integer 
     &     nx,nz,            ! dimension of the array u
     &     work_ptr,         ! first available workspace
     &     len_work,         ! length of available workspace
     &     ipdmp,ier         ! dump unit, error flag

      real
     &     dx,dz,            ! x and z steps
     &     a(nx),            ! input coefficient field
     &     az(nx),           ! its derivative in z 
     &     src(nx),          ! input src field (1/tau_z)
     &     v(nx),            ! input field (level n)
     &     u(nx),            ! output field (level n+1)
     &     work(*)           ! workspace

c---
c Local Variables
c---
      integer
     &     i,                   ! index, debug flag 
     &     min_a_ptr,           ! pointer to the array am=min(a,0)
     &     max_a_ptr,           ! pointer to the array ap=max(a,0)
     &     rhs_x_ptr,           ! pointer to the array rhs_x
     &     rhs_z1_ptr,          ! pointer to the array rhs_z1
     &     rhs_z2_ptr,          ! pointer to the array rhs_z2
     &     a_x_ptr,             ! pointer to the array a_x
     &     u_x_ptr              ! pointer to the array u_x
c
      real tiny                  ! tolerance for inflow test
c-------------------------------------------------------------

      data tiny /1.0e-05/
c
      if (ier.ne.0) return

c     call get_debug_level('sigma_local','idbg',idbg,ier)

c1040 format(6(e10.4,2x))

c     if(idbg.ge.0) then
c        write(ipdmp,*)' ---> SIGMA_LOCAL:'
c        write(ipdmp,*)' nx       =',nx
c        write(ipdmp,*)' nz       =',nz
c        write(ipdmp,*)' dx       =',dx
c        write(ipdmp,*)' dz       =',dz
c        write(ipdmp,*)' work_ptr =',work_ptr
c        write(ipdmp,*)' len_work =',len_work
c     endif 

c     if(idbg.ge.1) then
c        write(ipdmp,*)' SIGMA_LOCAL: a '
c        write(ipdmp,1040)(a(i),i=1,nx)
c        write(ipdmp,*)' SIGMA_LOCAL: az '
c        write(ipdmp,1040)(az(i),i=1,nx)
c        write(ipdmp,*)' SIGMA_LOCAL: SRC '
c        write(ipdmp,1040)(src(i),i=1,nx)
c     endif

c     get some workspace

      call getbuf('work',min_a_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: SIGMA_LOCAL from GETBUF: MIN_A_PTR '
         return
      end if

      call getbuf('work',max_a_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: SIGMA_LOCAL from GETBUF: MAX_A_PTR '
         return
      end if

      call getbuf('work',rhs_x_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: SIGMA_LOCAL from GETBUF: RHS_X_PTR '
         return
      end if

      call getbuf('work',rhs_z1_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: SIGMA_LOCAL from GETBUF: RHS_Z1_PTR '
         return
      end if

      call getbuf('work',rhs_z2_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: SIGMA_LOCAL from GETBUF: RHS_Z2_PTR '
         return
      end if

      call getbuf('work',u_x_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: SIGMA_LOCAL from GETBUF: U_X_PTR '
         return
      end if

      call getbuf('work',a_x_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: SIGMA_LOCAL from GETBUF: A_X_PTR '
         return
      end if

      do i=1,nx
         work(min_a_ptr+i-1)=min(a(i),0.0e+00)
         work(max_a_ptr+i-1)=max(a(i),0.0e+00)
      enddo
c    
      if( (a(nx-2).lt.tiny)
     &     .or.(a(nx-1).lt.tiny)
     &     .or.(a(nx).lt.tiny)
     &     .or.(a(3).gt.-tiny)
     &     .or.(a(2).gt.-tiny)
     &     .or.(a(1).gt.-tiny) ) then 

         write(ipdmp,*)' ERROR SIGMA_LOCAL:'
         write(ipdmp,*)' Inflow at the boundary in the solution '
         write(ipdmp,*)' of the linearized eikonal equation'
         write(ipdmp,*)' am(nx-2) =',work(min_a_ptr+nx-3)
         write(ipdmp,*)' am(nx-1) =',work(min_a_ptr+nx-2)
         write(ipdmp,*)' am(nx)   =',work(min_a_ptr+nx-1)
         write(ipdmp,*)' ap(1)    =',work(max_a_ptr)
         write(ipdmp,*)' ap(2)    =',work(max_a_ptr+1)
         write(ipdmp,*)' ap(3)    =',work(max_a_ptr+2)
         ier=98
         return
      endif

c---
c Computation of the rhs multiplied by dz: - a.u_x + src
c---

      call der_cen_x(work(u_x_ptr),v,nx,dx,ipdmp,ier)
c
      do i=1,nx
         work(rhs_x_ptr+i-1)=-a(i)*work(u_x_ptr+i-1) + src(i)
      enddo

c---
c a.a.u_xx
c---

      call laplacian(work(u_x_ptr),v,nx,dx,ipdmp,ier)

      do i=1,nx
         work(rhs_z1_ptr+i-1)=a(i)*a(i)*work(u_x_ptr+i-1) 
      enddo
      
c---
c (a.a_x - a_z).u_x
c---

      call der_cen_x(work(a_x_ptr),a,nx,dx,ipdmp,ier)

      do i=1,nx
         work(rhs_z1_ptr+i-1)=work(rhs_z1_ptr+i-1) + 
     &    (a(i)*work(a_x_ptr+i-1) - az(i))*work(u_x_ptr+i-1)
      enddo

      do i=2,nx-1
         u(i)=v(i) + dz*work(rhs_x_ptr+i-1) + 
     &        0.5*dz*dz*work(rhs_z1_ptr+i-1)
      enddo

      u(1)=v(1)-work(min_a_ptr)*dz/dx*(v(2)-v(1)) + dz*src(1)
      u(nx)=v(nx)-work(max_a_ptr+nx-1)*dz/dx*(v(nx)-v(nx-1))
     &       + dz*src(nx)

      return 
      end 
c=====================================================================
