c========================================================================
c This subroutine calculates sigma (which is equal to 1/ tau_yy) in
c for 2.5D earth model
c
      subroutine sigma_global(nx,nz,dx,dz,a,src,u,u_d,
     &     alpha,work,work_ptr,len_work,ipdmp,idbg,ier)
c
c
c===========================================================
c
c     This subroutine computes the solution of 
c
c  	| u_z + a u_x = src
c  	|
c  	| u(x,z=zm) = sigma_datum
c
c     using the scheme in subroutine sigma_local
c
c===========================================================
      
c---
c Input arguments 
c---
      integer 
     &     idbg,              ! debuging level 
     &     nx,nz,             ! dimension of the array u
     &     alpha,             ! step variable
     &     work_ptr,          ! first available workspace
     &     len_work,          ! length of available workspace
     &     ipdmp,ier          ! dump unit, error flag

      real
     &     dx,dz,             ! x and z steps
     &     a(nz,nx),          ! input coefficient field
     &     src(nz,nx),        ! input 1/tau_z 
     &     u_d(nx),           ! 1/tau_yy at datum
     &     work(*)            ! workspace
c---
c Output arguments 
c---
      real 
     &     u(nz,nx)           ! sigma (1/tau_yy) everywhere in the grid 

c---
c Local Variables
c---
      integer
     &     i,j,                 ! index
     &     a_int_ptr,           ! pointer to the interpolated a
     &     az_ptr,              ! pointer to the original az (z derivative a)
     &     az_int_ptr,          ! pointer to the interpolated az
     &     src_int_ptr,         ! pointer to the interpolated src
     &     v_int_ptr,           ! pointer to the interpolated v
     &     a_ptr,               ! pointer to a
     &     az1_ptr,             ! pointer to az1
     &     src_ptr,             ! pointer to src
     &     u_ptr,               ! pointer to u
     &     v_ptr,               ! pointer to v
     &     size                 ! guess
      
      real
     &     dy                   ! new step
c==============================================================================

      if (ier.ne.0) return

c      call get_debug_level('sigma_global','idbg',idbg,ier)

      if(idbg.ge.0) then
         write(ipdmp,*)' ---> SIGMA_GLOBAL:'
         write(ipdmp,*)' nx       =',nx
         write(ipdmp,*)' nz       =',nz
         write(ipdmp,*)' dx       =',dx
         write(ipdmp,*)' dz       =',dz
         write(ipdmp,*)' alpha    =',alpha
         write(ipdmp,*)' work_ptr =',work_ptr
         write(ipdmp,*)' len_work =',len_work
      endif

       if(idbg.ge.2) then
          do j=1,nz
             write(ipdmp,1035)j,(a(j,i),i=1,nx)
          enddo
       endif

1035   format(' SIGMA_GLOBAL: a trace ',i5,/,6(e10.4,2x))

c---
c Taper of the perturbation on the boundary of the domain
c---  
      if( (nx.lt.10).or.(nz.lt.10) ) then
         write(ipdmp,*)' Domain too small '
         write(ipdmp,*)' Can''t taper the source  of the '
         write(ipdmp,*)' perturbation of the eikonal equation'
         ier=199
         return
      endif

c--
c Boundary condition: The initial data at the surface:
c--

      do i=1,nx
         u(1,i)=u_d(i)
      enddo

c---
c Get space for intermidiate arrays 
c---
      call getbuf('work',a_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: GLOBAL from GETBUF: 
     &        A_PTR '
         return
      end if     
      
      call getbuf('work',az1_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: GLOBAL from GETBUF: 
     &        AZ1_PTR '
         return
      end if     

      call getbuf('work',src_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: GLOBAL from GETBUF: 
     &        U_x_PTR '
         return
      end if     
      
      call getbuf('work',v_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: GLOBAL from GETBUF: 
     &        V_PTR '
         return
      end if     

      call getbuf('work',u_ptr,nx,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: GLOBAL from GETBUF: 
     &        U_PTR '
         return
      end if     

      call getbuf('work',az_ptr,nx*nz,work_ptr,
     &     len_work,ipdmp,ier)
      if (ier.ne.0) then
         write(ipdmp,*)' Error: GLOBAL from GETBUF: 
     &        AZ_PTR '
         return
      end if     
c_____
c Compute z-derivative of array a:
c_____

      call der_cen_z(work(az_ptr),a,nx,nz,dz,ipdmp,ier)
c
      if (alpha.gt.1) then
         
         size=(alpha+1)*nx

         do j=1,nz-1

c---
c Proceed to do linear interpolation of the coefficients
c but first get space for interpolation  arrays: 
c---
            call getbuf('work',v_int_ptr,size,work_ptr,
     &           len_work,ipdmp,ier)
            if (ier.ne.0) then
               write(ipdmp,*)' Error: GLOBAL from GETBUF: V_INT_PTR '
               return
            end if     

            call getbuf('work',a_int_ptr,size,work_ptr,
     &           len_work,ipdmp,ier)
            if (ier.ne.0) then
               write(ipdmp,*)' Error: GLOBAL from GETBUF: 
     &          A_INT_PTR '
               return
            end if     

            call getbuf('work',az_int_ptr,size,work_ptr,
     &           len_work,ipdmp,ier)
            if (ier.ne.0) then
               write(ipdmp,*)' Error: GLOBAL from GETBUF: 
     &          AZ_INT_PTR '
               return
            end if     

            call getbuf('work',src_int_ptr,size,work_ptr,
     &           len_work,ipdmp,ier)
            if (ier.ne.0) then
               write(ipdmp,*)' Error: GLOBAL from GETBUF: 
     &          SRC_INT_PTR '
               return
            end if     
c
            do i=1,nx
               work(a_ptr+i-1)=a(j,i)
               work(az1_ptr+i-1)=a(j+1,i)
            enddo
            call interp_lin(work(a_int_ptr),work(a_ptr),
     &           work(az1_ptr),nx,alpha,ipdmp,ier)
c
            do i=1,nx
               work(a_ptr+i-1)=work(az_ptr+(j-1)*nx+i-1)
               work(az1_ptr+i-1)=work(az_ptr+j*nx+i-1)
            enddo
            call interp_lin(work(az_int_ptr),work(a_ptr),
     &           work(az1_ptr),nx,alpha,ipdmp,ier)
c
            do i=1,nx
               work(a_ptr+i-1)=src(j,i)
               work(az1_ptr+i-1)=src(j+1,i)
            enddo
            call interp_lin(work(src_int_ptr),work(a_ptr),
     &           work(az1_ptr),nx,alpha,ipdmp,ier)

            dy=dz/alpha
c
            do i=1,nx
               work(v_int_ptr+i-1)=u(j,i)
            enddo
c
            do i=2,alpha+1                            
               call sigma_local(nx,nz,dx,dy,work(a_int_ptr+(i-1)*nx),
     &         work(az_int_ptr+(i-1)*nx),work(src_int_ptr+(i-1)*nx),
     &         work(v_int_ptr+(i-1)*nx),
     &         work(v_int_ptr+(i-2)*nx),
     &         work,work_ptr,len_work,ipdmp,ier)
c
            enddo

            do i=1,nx
               u(j+1,i)=work(v_int_ptr+(alpha)*nx+i-1)
            enddo
c     
         enddo
      else
         do j=1,nz-1
            do i=1,nx
               work(a_ptr+i-1)  =a(j,i)
               work(az1_ptr+i-1)=work(az_ptr+(j-1)*nx+i-1)
               work(src_ptr+i-1)=src(j,i)
               work(v_ptr+i-1)=u(j,i)
            enddo
           if(idbg.ge.1) then
              write(ipdmp,*)' SIGMA_GLOBAL: work(a_ptr) '
              write(ipdmp,1040)(work(a_ptr+i-1),i=1,nx)
              write(ipdmp,*)' SIGMA_GLOBAL: a(',j,',i)'
              write(ipdmp,1040)(a(j,i),i=1,nx)
              write(ipdmp,*)' SIGMA_GLOBAL: work(az1_ptr) '
              write(ipdmp,1040)(work(az1_ptr+i-1),i=1,nx)
              write(ipdmp,*)' SIGMA_GLOBAL: az(',j,',i)'
              write(ipdmp,1040)(work(az_ptr),i=1,nx)
              write(ipdmp,*)' SIGMA_GLOBAL: work(src_ptr) '
              write(ipdmp,1040)(work(src_ptr+i-1),i=1,nx)
              write(ipdmp,*)' SIGMA_GLOBAL: src(',j,',i)'
              write(ipdmp,1040)(src(j,i),i=1,nx)
              write(ipdmp,*)' SIGMA_GLOBAL: work(v_ptr) '
              write(ipdmp,1040)(work(v_ptr+i-1),i=1,nx)
              write(ipdmp,*)' SIGMA_GLOBAL: u(',j,',i)'
              write(ipdmp,1040)(u(j,i),i=1,nx)
           endif
            call sigma_local(nx,nz,dx,dz,work(a_ptr),work(az1_ptr),
     &           work(src_ptr),work(u_ptr),
     &           work(v_ptr),work,work_ptr,len_work,ipdmp,ier)

            do i=1,nx
               u(j+1,i)=work(u_ptr+i-1)
            enddo
           if (idbg.ge.1) then
              write(ipdmp,*)' SIGMA_GLOBAL: work(u_ptr) '
              write(ipdmp,1040)(work(u_ptr+i-1),i=1,nx)
           endif

         enddo         

      endif

 1040 format(6(e10.4,2x))

      return 
      end 
c===========================================================
