c================================================================
      subroutine scale_amp_faj(nz,nx,amps,apcut,ipdmp,ier)
c
c Author: WWS
c Date: 20.10.95
c Purpose: forms array of <amps> and scales result by <apcut>
c      
      integer 
     &     nz,          ! number of rows
     &     nx,          ! number of columns
     &     ipdmp,       ! output unit number
     &     ier          ! error flag

      real 
     &     amps(nz,nx), ! amplitude array to be scaled
     &     apcut(nz,nx) ! cutoff array

      integer i,j       ! loop indices
      real test, tol    ! test for min

c--------------------------------------------------------------

      tol=1.e-6

c find max

      test=0.0e+00

      do i=1,nz
         do j=1,nx
            test=max(test,amps(i,j))
         end do
      end do

      if (test.lt.tol) then
         write(ipdmp,*)' Error: SCALE_AMP_FAJ'
         write(ipdmp,*)' amplitude max is < ',tol
         ier=1
         return
      end if

c create min for amplitude division

      test=test*tol
      
c do reciprocal, scaling:

      do i=1,nz
         do j=1,nx
            amps(i,j)=apcut(i,j)*amps(i,j)
         end do
      end do

      return
      end

c-------------------------------------------------------------------
