#include "table.h"
#include "maxmin.h"
#include "SGF.h"

#if defined (vax) || defined (cray)
extern "C" void KIRCHADJ(int & inv_flag,int & spd_flag,float* vel,float* refl,float* src,float* seism,int & seismnt,int & seismnx,int & seismnxs,float & seismdt,float & seismdx,float & seismdxs,float & seismtorig,float & seismxorig,float & seismxsorig,float & srcdep,float & recdep,int & velnz,int & velnx,float & veldz,float & veldx,float & velzorig,float & velxorig,int & srcnt,float & srcdt,float & srctorig, int & reflnz,int & reflnx,int & reflnxs,float & refldz,float & refldx,float & reflzorig,float & reflxorig,int & cvflag,float & ap,float & zd,float & t0,float & tf,float & mv,float & wmz,int & ntaper,int & save_ttamp,int & tt_sam,int & tt_size,float* tt, int & fr,int & lr, int & gather_flag,int & len_work,float* work,int & iverb,int & idbg,int & idbg_helm,int & update,int & ipout,int & ipdmp,int & ier);

#elif defined (_IBMR2) || defined (AIX) || defined (hpux)
extern "C" void kirchadj(int & inv_flag,int & spd_flag,float* vel,float* refl,float* src,float* seism,int & seismnt,int & seismnx,int & seismnxs,float & seismdt,float & seismdx,float & seismdxs,float & seismtorig,float & seismxorig,float & seismxsorig,float & srcdep,float & recdep,int & velnz,int & velnx,float & veldz,float & veldx,float & velzorig,float & velxorig,int & srcnt,float & srcdt,float & srctorig, int & reflnz,int & reflnx,int & reflnxs,float & refldz,float & refldx,float & reflzorig,float & reflxorig,int & cvflag,float & ap,float & zd,float & t0,float & tf,float & mv,float & wmz,int & ntaper,int & save_ttamp,int & tt_sam,int & tt_size,float* tt, int & fr,int & lr, int & gather_flag,int & len_work,float* work,int & iverb,int & idbg,int & idbg_helm,int & update,int & ipout,int & ipdmp,int & ier);

#else
extern "C" void kirchadj_(int & inv_flag,int & spd_flag,float* vel,float* refl,float* src,float* seism,int & seismnt,int & seismnx,int & seismnxs,float & seismdt,float & seismdx,float & seismdxs,float & seismtorig,float & seismxorig,float & seismxsorig,float & srcdep,float & recdep,int & velnz,int & velnx,float & veldz,float & veldx,float & velzorig,float & velxorig,int & srcnt,float & srcdt,float & srctorig, int & reflnz,int & reflnx,int & reflnxs,float & refldz,float & refldx,float & reflzorig,float & reflxorig,int & cvflag,float & ap,float & zd,float & t0,float & tf,float & mv,float & wmz,int & ntaper,int & save_ttamp,int & tt_sam,int & tt_size,float* tt, int & fr,int & lr, int & gather_flag,int & len_work,float* work,int & iverb,int & idbg,int & idbg_helm,int & update,int & ipout,int & ipdmp,int & ier);

#endif

char SGFSpace::Type;

void main( int argc,char* argv[] )
{

  if( argc != 2 ) {
      cout <<"Usage: kirchadj.x <job>" << endl;
      cout<<"<job>=keyword file specifying job parameters"<<endl;
      exit(0);
  }

  char name[80];

  table   JOB(argv[1]);

  blank(name);
  char * vel2dname;
  vel2dname = new char[80];
  blank(vel2dname);
  strcpy(name, "VEL");
  if(JOB.GetValue(name, vel2dname)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  char * reflname;
  reflname = new char[80];
  blank(reflname);
  strcpy(name, "REFL");
  if(JOB.GetValue(name, reflname)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  char * srcname;
  srcname = new char[80];
  blank(srcname);
  strcpy(name, "SRC");
  if(JOB.GetValue(name, srcname)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  char * seismname;
  seismname = new char[80];
  blank(seismname);
  strcpy(name, "SEISM");
  if(JOB.GetValue(name, seismname)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  char * reflspnm;
  reflspnm = new char[80];
  blank(reflspnm);
  strcpy(name, "REFLSPACE");
  if(JOB.GetValue(name, reflspnm)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get "<<name<<" from JOB"<<endl;
    exit(0);
  }

  SGFSpace  REFLSPACE(reflspnm);

  SGF VEL(vel2dname);
  SGFSpace & VELSpace = (SGFSpace &)(VEL.Space());

  SGF REFL(REFLSPACE,reflname);

  SGF SRC(srcname);
  SGFSpace & SRCSpace = (SGFSpace &)(SRC.Space());

  SGF SEISM(seismname);
  SGFSpace & SEISMSpace = (SGFSpace &)(SEISM.Space());

  cout<<"begin param read"<<endl;

  blank(name);
  int seismnt;
  strcpy(name, "n1");
  if(SEISMSpace.Parameters().GetValue(name, seismnt)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  int seismnx;
  strcpy(name, "n2");
  if(SEISMSpace.Parameters().GetValue(name, seismnx)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  int seismnxs;
  strcpy(name, "n3");
  if(SEISMSpace.Parameters().GetValue(name, seismnxs)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  float seismdt;
  strcpy(name, "d1");
  if(SEISMSpace.Parameters().GetValue(name, seismdt)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  float seismdx;
  strcpy(name, "d2");
  if(SEISMSpace.Parameters().GetValue(name, seismdx)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  float seismdxs;
  strcpy(name, "d3");
  if(SEISMSpace.Parameters().GetValue(name, seismdxs)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  float seismtorig;
  strcpy(name, "o1");
  if(SEISMSpace.Parameters().GetValue(name, seismtorig)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  float seismxorig;
  strcpy(name, "o2");
  if(SEISMSpace.Parameters().GetValue(name, seismxorig)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  float seismxsorig;
  strcpy(name, "o3");
  if(SEISMSpace.Parameters().GetValue(name, seismxsorig)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  float srcdep;
  strcpy(name, "srcdep");
  if(SEISMSpace.Parameters().GetValue(name, srcdep)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  float recdep;
  strcpy(name, "recdep");
  if(SEISMSpace.Parameters().GetValue(name, recdep)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  blank(name);
  int velnz;
  strcpy(name, "n1");
  if(VELSpace.Parameters().GetValue(name, velnz)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from VEL"<<endl;
    exit(0);
  }

  blank(name);
  int velnx;
  strcpy(name, "n2");
  if(VELSpace.Parameters().GetValue(name, velnx)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from VEL"<<endl;
    exit(0);
  }

  blank(name);
  float veldz;
  strcpy(name, "d1");
  if(VELSpace.Parameters().GetValue(name, veldz)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from VEL"<<endl;
    exit(0);
  }

  blank(name);
  float veldx;
  strcpy(name, "d2");
  if(VELSpace.Parameters().GetValue(name, veldx)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from VEL"<<endl;
    exit(0);
  }

  blank(name);
  float velzorig;
  strcpy(name, "o1");
  if(VELSpace.Parameters().GetValue(name, velzorig)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from VEL"<<endl;
    exit(0);
  }

  blank(name);
  float velxorig;
  strcpy(name, "o2");
  if(VELSpace.Parameters().GetValue(name, velxorig)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from VEL"<<endl;
    exit(0);
  }

  blank(name);
  int srcnt;
  strcpy(name, "n1");
  if(SRCSpace.Parameters().GetValue(name, srcnt)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SRC"<<endl;
    exit(0);
  }

  blank(name);
  float srcdt;
  strcpy(name, "d1");
  if(SRCSpace.Parameters().GetValue(name, srcdt)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SRC"<<endl;
    exit(0);
  }

  blank(name);
  float srctorig;
  strcpy(name, "o1");
  if(SRCSpace.Parameters().GetValue(name, srctorig)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SRC"<<endl;
    exit(0);
  }

  blank(name);
  int reflnz;
  strcpy(name, "n1");
  if(REFLSPACE.Parameters().GetValue(name, reflnz)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from REFLSPACE"<<endl;
    exit(0);
  }

  blank(name);
  int reflnx;
  strcpy(name, "n2");
  if(REFLSPACE.Parameters().GetValue(name, reflnx)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from REFLSPACE"<<endl;
    exit(0);
  }

  blank(name);
  int reflnxs;
  strcpy(name, "n3");
  if(REFLSPACE.Parameters().GetValue(name, reflnxs)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from REFLSPACE"<<endl;
    exit(0);
  }

  blank(name);
  float refldz;
  strcpy(name, "d1");
  if(REFLSPACE.Parameters().GetValue(name, refldz)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from REFLSPACE"<<endl;
    exit(0);
  }

  blank(name);
  float refldx;
  strcpy(name, "d2");
  if(REFLSPACE.Parameters().GetValue(name, refldx)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from REFLSPACE"<<endl;
    exit(0);
  }

  blank(name);
  float reflzorig;
  strcpy(name, "o1");
  if(REFLSPACE.Parameters().GetValue(name, reflzorig)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from REFLSPACE"<<endl;
    exit(0);
  }

  blank(name);
  float reflxorig;
  strcpy(name, "o2");
  if(REFLSPACE.Parameters().GetValue(name, reflxorig)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from REFLSPACE"<<endl;
    exit(0);
  }

  blank(name);
  int cvflag;
  strcpy(name, "IsConstantVelocity");
  if(JOB.GetValue(name, cvflag)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  float ap;
  strcpy(name, "Aperture");
  if(JOB.GetValue(name, ap)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  float zd;
  strcpy(name, "TopOfTTWindow");
  if(JOB.GetValue(name, zd)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  float t0;
  strcpy(name, "MuteZeroOffsetInterceptTime");
  if(JOB.GetValue(name, t0)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  float tf;
  strcpy(name, "MuteFinalTime");
  if(JOB.GetValue(name, tf)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  float mv;
  strcpy(name, "MuteTopVelocity");
  if(JOB.GetValue(name, mv)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  float wmz;
  strcpy(name, "MuteTopTaperWidth");
  if(JOB.GetValue(name, wmz)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int ntaper;
  strcpy(name, "MuteSideTaperNumber");
  if(JOB.GetValue(name, ntaper)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int save_ttamp;
  strcpy(name, "SaveTTampTables");
  if(JOB.GetValue(name, save_ttamp)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int tt_sam;
  strcpy(name, "TTampTableSubsampleFactor");
  if(JOB.GetValue(name, tt_sam)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int tt_size;
  strcpy(name, "TTampTableBufferLength");
  if(JOB.GetValue(name, tt_size)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int nblock;
  strcpy(name, "GatherBlockingFactor");
  if(JOB.GetValue(name, nblock)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int len_work;
  strcpy(name, "WorkspaceBufferLength");
  if(JOB.GetValue(name, len_work)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int update=1;
  /*  strcpy(name, "is_new_velocity_model");
  if(JOB.GetValue(name, update)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }
  */

  blank(name);
  int ipout;
  strcpy(name, "FortranOutputUnit");
  if(JOB.GetValue(name, ipout)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int ipdmp;
  strcpy(name, "FortranDumpUnit");
  if(JOB.GetValue(name, ipdmp)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int idbg;
  strcpy(name, "DebugOutputLevel");
  if(JOB.GetValue(name, idbg)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int iverb;
  strcpy(name, "VerboseOutputLevel");
  if(JOB.GetValue(name, iverb)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int idbg_helm;
  strcpy(name, "DebugHelmholtzOutputLevel");
  if(JOB.GetValue(name, idbg_helm)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int inv_flag;
  strcpy(name, "IsInversion");
  if(JOB.GetValue(name, inv_flag)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int spd_flag;
  strcpy(name, "Is3D");
  if(JOB.GetValue(name, spd_flag)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from JOB"<<endl;
    exit(0);
  }

  blank(name);
  int gather_flag;
  strcpy(name, "bintype");
  if(SEISMSpace.Parameters().GetValue(name, gather_flag)){
    cout << "Error: Main Module" <<endl;
    cout << "failed to get header "<<name<<" from SEISM"<<endl;
    exit(0);
  }

  cout<<"end param read"<<endl;

  cout<<"begin workspace alloc"<<endl;

  float*  work;
  work = new float[len_work];

  float* tt;
  tt = new float[tt_size];

  // for velocity and src it's OK to use data buffers - only one
  // record at a time is needed.

  float*  vel;
  vel=VEL.Data_buf();

  float*  src;
  src=SRC.Data_buf();

  // however in this design you need nblock records (max) for both
  // refl and seism, so can't use the data buffers

  float*  refl;
  refl=new float[nblock*reflnz*reflnx];

  float*  seism;
  seism = new float[nblock*seismnt*seismnx];

  SRC.Rewind_Recs();

  SEISM.Rewind_Recs();

  VEL.Rewind_Recs();

  REFL.Rewind_Recs();

  cout<<"end workspace alloc"<<endl;

  cout<<"begin loop"<<endl;

  int ier=0;

  // here is code that needs to be written for every case - defins of 
  // nr, nb

  int nr=seismnxs; int nb=nblock;
  int nbtmp;

  int fr=1;
  int lr=0;

  // load source - same for all records

  SRC.Get_Next_Rec(src);

  // load velocity - same for all records

  VEL.Get_Next_Rec(vel);

  do {

    fr=lr+1;
    lr=min(lr+nb,nr);

    if (lr < fr) {
      cerr<<"Error: RUNKIRCHADJ"<<endl;
      cerr<<"last record index less than first record index"<<endl;
      cerr<<"last record index     = "<<lr<<endl;
      cerr<<"first record index    = "<<fr<<endl;
      cerr<<"total records         = "<<nr<<endl;
      cerr<<"records in block      = "<<nb<<endl;
      exit(0);
    }

    nbtmp = lr-fr+1;
    SEISM.Get_Next_Rec(seism,nbtmp);

    cout<<"simulate record range "<<fr<<" - "<<lr<<endl;
#if defined (vax) || defined (cray)
    KIRCHADJ(inv_flag,spd_flag,vel,refl,src,seism,seismnt,seismnx,seismnxs,seismdt,seismdx,seismdxs,seismtorig,seismxorig,seismxsorig,srcdep,recdep,velnz,velnx,veldz,veldx,velzorig,velxorig,srcnt,srcdt,srctorig,reflnz,reflnx,reflnxs,refldz,refldx,reflzorig,reflxorig,cvflag,ap,zd,t0,tf,mv,wmz,ntaper,save_ttamp,tt_sam,tt_size,tt,fr,lr,gather_flag,len_work,work,iverb,idbg,idbg_helm,update,ipout,ipdmp,ier);
#elif defined (_IBMR2) || defined (AIX) || defined (hpux)
    kirchadj(inv_flag,spd_flag,vel,refl,src,seism,seismnt,seismnx,seismnxs,seismdt,seismdx,seismdxs,seismtorig,seismxorig,seismxsorig,srcdep,recdep,velnz,velnx,veldz,veldx,velzorig,velxorig,srcnt,srcdt,srctorig,reflnz,reflnx,reflnxs,refldz,refldx,reflzorig,reflxorig,cvflag,ap,zd,t0,tf,mv,wmz,ntaper,save_ttamp,tt_sam,tt_size,tt,fr,lr,gather_flag,len_work,work,iverb,idbg,idbg_helm,update,ipout,ipdmp,ier);
#else
    kirchadj_(inv_flag,spd_flag,vel,refl,src,seism,seismnt,seismnx,seismnxs,seismdt,seismdx,seismdxs,seismtorig,seismxorig,seismxsorig,srcdep,recdep,velnz,velnx,veldz,veldx,velzorig,velxorig,srcnt,srcdt,srctorig,reflnz,reflnx,reflnxs,refldz,refldx,reflzorig,reflxorig,cvflag,ap,zd,t0,tf,mv,wmz,ntaper,save_ttamp,tt_sam,tt_size,tt,fr,lr,gather_flag,len_work,work,iverb,idbg,idbg_helm,update,ipout,ipdmp,ier);
#endif
    if (ier) {
      cout<<"Error: Runkirchadj.f from kirchadj" <<endl;
      cout<<"code = "<<ier<<endl;
      exit(0);
    }

    cout << "output record range "<<fr<<" - "<<lr<<endl;
    REFL.Put_Next_Rec(refl,nbtmp);

  } while (lr < nr);

  cout<<"end of simulation loop"<<endl;

  exit(0);
}
