c====================================================================

      subroutine kirch_sum_fwd(three_d,
     &     velnz,velnx,veldz,veldx,datum,
     &     reflnz,reflnx,reflzorig,reflxorig,
     &     srcnzbox,srcnxbox,srcboxorig,
     &     recnzbox,recnxbox,recboxorig,
     &     refl,factor,srctt,rectt,trace,
     &     seismnt,seismdt,
     &     ipdmp,ier)

c----------------------------------------------------------------------
c     
c     Roelof VERSTEEG, 05/93
c     Quang Huy TRAN,  08/93
c     rev WWS 11.94
c     rev WWS 02.96
c     rev KARAYA 03.96
c
c----------------------------------------------------------------------
c Input variables

      logical
     &     three_d             ! = true for 2.5D amplitude, = false for 2D amplitude

      integer 
     &     srcnzbox,           ! number of z samples in source box
     &     srcnxbox,           ! number of x samples in source box
     &     recnzbox,           ! number of z samples in receiver box
     &     recnxbox,           ! number of x samples in receiver box
     &     seismnt,            ! number of time samples
     &     velnz,              ! number of z samples in velocity array
     &     velnx,              ! number of x samples in velocity array
     &     reflnz,             ! number of z samples in reflectivity array
     &     reflnx,             ! number of x samples in reflectivity array
     &     ipdmp, ier          ! dump unit, error flag

      real 
     &     srcboxorig,         ! left edge of source box
     &     recboxorig,         ! left edge of receiver box
     &     seismdt,            ! time step
     &     reflzorig,          ! z at upper left corner of reflectivity subgrid
     &     reflxorig,          ! x at upper left corner of reflectivity subgrid
     &     veldz,              ! z step
     &     veldx,              ! x step
     &     datum               ! vel homogeneous, refl = 0 above this depth

      real 
     &     trace(*),           ! output trace
     &     srctt(*),           ! source traveltime etc.
     &     rectt(*),           ! receiver traveltime etc.
     &     refl(*),            ! output reflectivity
     &     factor(*)           ! array of src-, rec-independent factors
c                                of velocity, pi, etc.

c work space:

c OFFSETS into srctt, rectt arrays for various traveltime-related 
c quantities:

      integer 
     &     src_ttime,           ! offset for the traveltime from the source
     &     src_amp,             ! offset for source amplitudes
     &     src_tau_yy           ! offset for yy_component of Laplacian source traveltime
      integer 
     &     rec_ttime,           ! offset for the traveltime from the reciever
     &     rec_amp,             ! offset for receiver amplitudes
     &     rec_tau_yy           ! offset for yy_component of Laplacian receiver traveltime

c OFFSET MULTIPLIERS: multiply size of traveltime array
c by these to obtain offsets into srctt, rectt for

      integer 
     &     ro_amp,               ! amplitude
     &     ro_tau_yy             ! yy_component of Laplacian traveltime

c computational box limits

      integer boxleft,boxright,boxbottom,boxtop

c source and receiver left box indices, relative loop counters in x

      integer isrcboxorig
      integer irecboxorig
      integer jsrc,jrec

c reflectivity subgrid: 

      integer 
     &     ireflzorig,           ! z coordinate of upper left corner
     &     ireflxorig,           ! x coordinate of upper left corner
     &     irefl,                ! relative loop counter in z
     &     jrefl                 ! relative loop counter in x

c traveltime variables

      integer 
     &     instant       ! integer part of computed traveltime
      real 
     &     ampli,        ! tmp variable for amplitude comp
     &     ttime,        ! computed traveltime
     &     remaind       ! remainder = tt-int(tt)

c miscellaneous variables

      real
     &     tol

      integer 
     &     i, idbg, j

c=====================================================================
      
      data tol /1.0e-4/

c RECORD OFFSET DEFINITIONS

      data ro_amp /1/, ro_tau_yy /2/

c=====================================================================

      if (ier.ne.0) return

c--   Debug level
c------------------
c      call get_debug_level('ksum_fwd', 'idbg', idbg, ier)

c     work out the left and right limits of the intersection
c     of the source and receiver boxes, in absolute indices and
c     relative to both source and receiver boxes

      if (idbg.ge.2) then
         write(ipdmp,*)' KIRCH_SUM_FWD:'
         write(ipdmp,*)' box stuff'
         write(ipdmp,*)' source travel time table:'
         do j=1,srcnxbox
            write(ipdmp,*)' trace ',j
            write(ipdmp,*)(srctt((j-1)*srcnzbox+i),i=1,srcnzbox)
         end do
         write(ipdmp,*)' receivertravel time table:'
         do j=1,recnxbox
            write(ipdmp,*)' trace ',j
            write(ipdmp,*)(rectt((j-1)*recnzbox+i),i=1,recnzbox)
         end do
      endif

      isrcboxorig=nint(srcboxorig/veldx)+1
      irecboxorig=nint(recboxorig/veldx)+1
      boxleft=max(isrcboxorig,irecboxorig)
      boxright=min(isrcboxorig+srcnxbox-1,irecboxorig+recnxbox-1)

      ireflxorig=nint(reflxorig/veldx)+1
      ireflzorig=nint(reflzorig/veldz)+1
      boxleft=max(boxleft,ireflxorig)
      boxright=min(boxright,ireflxorig+reflnx-1)
      
      if (boxright.le.boxleft) then
         if (idbg.gt.0) then
            write(ipdmp,*)' KIRCH_SUM_FWD: '
            write(ipdmp,*)' src and recvr boxes do not '
            write(ipdmp,*)' intersect, so trace with this aperture == 0'
         end if
         return
      end if
      
      boxbottom = min(srcnzbox,recnzbox)

      boxbottom=min(boxbottom,ireflzorig+reflnz-1)

      boxtop= max(nint(abs(datum)/veldz),0)+1

      boxtop=max(boxtop,ireflzorig)

      if (idbg.gt.0) then
         write(ipdmp,*)' KIRCH_SUM_FWD:'
         write(ipdmp,*)' srcnzbox       = ',srcnzbox
         write(ipdmp,*)' recnzbox       = ',recnzbox
         write(ipdmp,*)' isrcboxorig    = ',isrcboxorig
         write(ipdmp,*)' irecboxorig    = ',irecboxorig
         write(ipdmp,*)' boxleft        = ',boxleft
         write(ipdmp,*)' boxright       = ',boxright
         write(ipdmp,*)' boxbottom      = ',boxbottom
         write(ipdmp,*)' datum          = ',datum
         write(ipdmp,*)' ireflzorig     = ',ireflzorig
         write(ipdmp,*)' boxtop         = ',boxtop
      end if

c note that times are assumed to have been "integerized" by division
c by dt

c set trace(seismnt)=0 since safeguard step for instant may render this
c garbage

      trace(seismnt)=0.0e+00

c============================================
c 2.5D Modelling
c============================================

      if(three_d)then

CDIR$ NORECURRENCE
         do j = boxleft,boxright
            jsrc = j-isrcboxorig
            jrec = j-irecboxorig

            src_ttime=jsrc*srcnzbox 
            src_amp=jsrc*srcnzbox + ro_amp*srcnxbox*srcnzbox
            src_tau_yy=jsrc*srcnzbox + ro_tau_yy*srcnxbox*srcnzbox

            rec_ttime=jrec*recnzbox 
            rec_amp=jrec*recnzbox + ro_amp*recnxbox*recnzbox
            rec_tau_yy=jrec*recnzbox + ro_tau_yy*recnxbox*recnzbox

            jrefl=j-ireflxorig
   
            do i= boxtop,boxbottom
   
               ttime=srctt(src_ttime+i)+ rectt(rec_ttime+i)
               instant= min(seismnt-2,max(0,int(ttime)))
               remaind= max(ttime - float(instant),0.0e+00)
               instant=instant+1

               irefl=i-ireflzorig

               ampli= srctt(src_amp+i)*rectt(rec_amp+i)*
     &              factor((j-1)*velnz+i)
     &                  /
     &              sqrt(srctt(src_tau_yy+i)+rectt(rec_tau_yy+i))

               trace(instant)  = trace(instant)
     &           + ampli* refl(jrefl*reflnz+irefl+1)*(1.- remaind)

               trace(instant+1)= trace(instant+1) 
     &           + ampli* refl(jrefl*reflnz+irefl+1)*remaind

c            if (ttime.lt.50.0) then
c               write(ipdmp,*)'KSUM:'
c               write(ipdmp,*)'i = ',i,' j = ',j
c               write(ipdmp,*)'src_ttime = ',src_ttime,' rec_ttime = ',
c     &              rec_ttime
c               write(ipdmp,*)'srctt = ',srctt(src_ttime+i)
c               write(ipdmp,*)'rectt = ',rectt(rec_ttime+i)
c               write(ipdmp,*)'ttime = ',ttime
c               write(ipdmp,*)'refl eval at ',jrefl*reflnz+irefl
c               write(ipdmp,*)'refl  = ',refl(jrefl*reflnz+irefl+1)
c               write(ipdmp,*)'instant = ',instant,' remaind = ',remaind
c               write(ipdmp,*)'src amplitude = ',srctt(src_amp+i)
c               write(ipdmp,*)'src amplitude offset = ',src_amp
c               write(ipdmp,*)'rec amplitude = ',rectt(rec_amp+i)
c               write(ipdmp,*)'rec amplitude offset = ',rec_amp
c               write(ipdmp,*)'factor value = ',factor((j-1)*velnz+i)
c               write(ipdmp,*)'factor evaluated at ',(j-1)*velnz+i
c               write(ipdmp,*)'ampli = ',ampli
c               write(ipdmp,*)'output at ',instant,' = ',
c     &              ampli* refl(jrefl*reflnz+irefl+1)*(1.- remaind)
c               write(ipdmp,*)'output at ',instant+1,' = ',
c     &              ampli* refl(jrefl*reflnz+irefl+1)*remaind
c            endif
            end do

         end do

c set trace(seismnt-0,1)=0 since safeguard step for instant may render this
c garbage

         trace(seismnt-1)=0.0e+00      
         trace(seismnt)=0.0e+00

      end if

c============================================
c 2D Modelling
c============================================

      if(.not.three_d)then

CDIR$ NORECURRENCE
         do j = boxleft,boxright
            jsrc = j-isrcboxorig
            jrec = j-irecboxorig

            src_ttime=jsrc*srcnzbox 
            src_amp=jsrc*srcnzbox + ro_amp*srcnxbox*srcnzbox

            rec_ttime=jrec*recnzbox 
            rec_amp=jrec*recnzbox + ro_amp*recnxbox*recnzbox

            jrefl=j-ireflxorig
   
            do i= boxtop,boxbottom
   
               ttime=srctt(src_ttime+i)+ rectt(rec_ttime+i)
               instant= min(seismnt-2,max(0,int(ttime)))
               remaind= max(ttime - float(instant),0.0e+00)
               instant=instant+1

               irefl=i-ireflzorig

               ampli= srctt(src_amp+i)*rectt(rec_amp+i)*
     &              factor((j-1)*velnz+i)

               trace(instant)  = trace(instant)
     &           + ampli* refl(jrefl*reflnz+irefl+1)*(1.- remaind)

               trace(instant+1)= trace(instant+1) 
     &           + ampli* refl(jrefl*reflnz+irefl+1)*remaind

c            if (ttime.lt.50.0) then
c               write(ipdmp,*)'KSUM:'
c               write(ipdmp,*)'i = ',i,' j = ',j
c               write(ipdmp,*)'src_ttime = ',src_ttime,' rec_ttime = ',
c     &              rec_ttime
c               write(ipdmp,*)'srctt = ',srctt(src_ttime+i)
c               write(ipdmp,*)'rectt = ',rectt(rec_ttime+i)
c               write(ipdmp,*)'ttime = ',ttime
c               write(ipdmp,*)'refl eval at ',jrefl*reflnz+irefl
c               write(ipdmp,*)'refl  = ',refl(jrefl*reflnz+irefl+1)
c               write(ipdmp,*)'instant = ',instant,' remaind = ',remaind
c               write(ipdmp,*)'src amplitude = ',srctt(src_amp+i)
c               write(ipdmp,*)'src amplitude offset = ',src_amp
c               write(ipdmp,*)'rec amplitude = ',rectt(rec_amp+i)
c               write(ipdmp,*)'rec amplitude offset = ',rec_amp
c               write(ipdmp,*)'factor value = ',factor((j-1)*velnz+i)
c               write(ipdmp,*)'factor evaluated at ',(j-1)*velnz+i
c               write(ipdmp,*)'ampli = ',ampli
c               write(ipdmp,*)'output at ',instant,' = ',
c     &              ampli* refl(jrefl*reflnz+irefl+1)*(1.- remaind)
c               write(ipdmp,*)'output at ',instant+1,' = ',
c     &              ampli* refl(jrefl*reflnz+irefl+1)*remaind
c            endif
            end do

         end do

c set trace(seismnt-0,1)=0 since safeguard step for instant may render this
c garbage

         trace(seismnt-1)=0.0e+00      
         trace(seismnt)=0.0e+00

      endif

c      write(ipdmp,*)'KSUM_FWD: TRACE OUTPUT'
c      write(ipdmp,1000)(trace(i),i=1,seismnt)
c 1000 format(6(e10.4,2x))
      return
      end
c====================================================================
