c============================ KIRCH_SUM_ADJ===============================
      subroutine kirch_sum_adj(gather_flag,inversion,
     &     three_d,velnz,velnx,veldz,veldx,datum,
     &     reflnz,reflnx,reflzorig,reflxorig,
     &     srcnzbox,srcnxbox,srcboxorig,
     &     recnzbox,recnxbox,recboxorig,
     &     refl,factor,srctt,rectt,trace,
     &     seismnt,seismdt,
     &     ipdmp,idbg,ier)

c----------------------------------------------------------------------
c     original authors: Roelof Versteeg, Quang-Huy Tran 1993-4
c     rev William W. Symes 11.94
c     rev Kidane Araya     07/95
c     rev WWS 10.95
c     rev WWS 11.95
c----------------------------------------------------------------------
c Input variables

      integer
     &     inversion,          !  false for migration, true for inversion
     &     three_d             !  false for 2D inversion/migration,
c                                 true for 2.5D inversion/migration

      integer 
     &     srcnzbox,           ! number of z samples in source box
     &     srcnxbox,           ! number of x samples in source box
     &     recnzbox,           ! number of z samples in receiver box
     &     recnxbox,           ! number of x samples in receiver box
     &     seismnt,            ! number of time samples
     &     velnz,              ! number of z samples in velocity array
     &     velnx,              ! number of x samples in velocity array
     &     reflnz,             ! number of z samples in reflectivity array
     &     reflnx,             ! number of x samples in reflectivity array
     &     gather_flag,        ! = 0 for common source, = 1 for common offset
     &     ipdmp, ier          ! dump unit, error flag

      real 
     &     srcboxorig,         ! left edge of source box
     &     recboxorig,         ! left edge of receiver box
     &     seismdt,            ! time step
     &     reflzorig,          ! z at upper left corner of reflectivity subgrid
     &     reflxorig,          ! x at upper left corner of reflectivity subgrid
     &     veldz,              ! z step
     &     veldx,              ! x step
     &     datum               ! vel homogeneous, refl = 0 above this depth

      real 
     &     trace(seismnt),      ! input trace
     &     srctt(*),            ! source traveltime etc.
     &     rectt(*),            ! receiver traveltime etc.
     &     refl(*),             ! output reflectivity
     &     factor(*)            ! array of src-, rec-independent factors
c     of velocity, pi, etc.

c work space:

c OFFSETS into srctt, rectt arrays for various traveltime-related 
c quantities:

      integer 
     &     src_ttime,    	! offset for the traveltime from the source
     &     src_amp,             ! offset for source amplitudes
     &     src_tau_x,		! offset for the partial(tau)/partial(x) source
c                       	! traveltime
     &     src_tau_z,	        ! offset for the partial(tau)/partial(z) source
c                       	! traveltime
     &     src_phi_xs,   	! offset for the mixed derivative of tau source
     &     src_tau_yy   	! offset for the yy derivative of tau source

      integer 
     &     rec_ttime,   	! offset for the traveltime from the reciever
     &     rec_amp,             ! offset for receiver amplitudes
     &     rec_tau_x,	        ! offset for the x derivative of tau at reciever
     &     rec_tau_z,           ! offset for the partial(tau)/partial(z) reciever
c                       	! traveltime
     &     rec_phi_xr,          ! offset for the mixed derivative of tau reciever
     &     rec_tau_yy   	! offset for the yy derivative of tau receiver

c OFFSET MULTIPLIERS: multiply size of traveltime array
c by these to obtain offsets into srctt, rectt for

      integer 
     &     ro_amp,              ! amplitude
     &     ro_tau_x,            ! traveltime x derivative
     &     ro_tau_z,            ! traveltime z derivative
     &     ro_phi_xr,           ! takeoff angle derivative wrt rec loc
     &     ro_tau_yy            ! traveltime yy derivative

c computational box limits

      integer boxleft,boxright,boxbottom,boxtop

c source and receiver left box indices, relative loop counters in x

      integer isrcboxorig
      integer irecboxorig
      integer jsrc,jrec

c reflectivity subgrid: 

      integer 
     &     ireflzorig,           ! z coordinate of upper left corner
     &     ireflxorig,           ! x coordinate of upper left corner
     &     irefl,                ! relative loop counter in z
     &     jrefl                 ! relative loop counter in x

c traveltime variables

      integer 
     &     instant       ! integer part of computed traveltime
      real 
     &     ttime,        ! computed traveltime
     &     remaind       ! remainder = tt-int(tt)

c miscellaneous variables

      real
     &     tol

      integer 
     &     i, idbg, j

c=====================================================================
      
      data tol /1.0e-4/

c RECORD OFFSET DEFINITIONS

      data ro_amp /1/, ro_tau_x /2/, ro_tau_z /3/, 
     &     ro_phi_xr /4/, ro_tau_yy /5/

      if (ier.ne.0) return

      if (idbg.ne.0) then
         write(ipdmp,*)' KIRCH_SUM_ADJ: BEGIN'
      endif

c     work out the left and right limits of the intersection
c     of the source and receiver boxes, in absolute indices and
c     relative to both source and receiver boxes

      if (idbg.ge.2) then
         write(ipdmp,*)' KIRCH_SUM_ADJ:'
         write(ipdmp,*)' box stuff'
      endif

      isrcboxorig=nint(srcboxorig/veldx)+1
      irecboxorig=nint(recboxorig/veldx)+1
      boxleft=max(isrcboxorig,irecboxorig)
      boxright=min(isrcboxorig+srcnxbox-1,irecboxorig+recnxbox-1)

      ireflxorig=nint(reflxorig/veldx)+1
      ireflzorig=nint(reflzorig/veldz)+1
      boxleft=max(boxleft,ireflxorig)
      boxright=min(boxright,ireflxorig+reflnx-1)
      
      if (boxright.le.boxleft) then
         if (idbg.gt.0) then
            write(ipdmp,*)' KIRCH_SUM_ADJ: '
            write(ipdmp,*)' src and recvr boxes do not '
            write(ipdmp,*)' intersect, so trace with this aperture == 0'
         end if
         return
      end if
      
      boxbottom = min(srcnzbox,recnzbox)

      boxbottom=min(boxbottom,ireflzorig+reflnz-1)

      if (idbg.gt.0) then
         write(ipdmp,*)' KIRCH_SUM_ADJ:'
         write(ipdmp,*)' isrcboxorig    = ',isrcboxorig
         write(ipdmp,*)' irecboxorig    = ',irecboxorig
         write(ipdmp,*)' boxleft       = ',boxleft
         write(ipdmp,*)' boxright       = ',boxright
         write(ipdmp,*)' boxbottom     = ',boxbottom
      end if

      boxtop= max(nint(abs(datum)/veldz),0)+1

      boxtop=max(boxtop,ireflzorig)

c note that times are assumed to have been "integerized" by division
c by dt

c set trace(seismnt)=0 since safeguard step for instant may render this
c garbage

      trace(seismnt-1)=0.0e+00
      trace(seismnt)=0.0e+00

c===============================
c 2D Migration
c===============================

      if ((inversion.eq.0).and.(three_d.eq.0)) then
                  
CDIR$ NORECURRENCE

         do j = boxleft,boxright
            jsrc = j-isrcboxorig
            jrec = j-irecboxorig

            src_ttime=jsrc*srcnzbox 
            src_amp=jsrc*srcnzbox + ro_amp*srcnxbox*srcnzbox

            rec_ttime=jrec*recnzbox 
            rec_amp=jrec*recnzbox + ro_amp*recnxbox*recnzbox
            
            jrefl=j-ireflxorig
            
            do i= boxtop,boxbottom
               
               ttime=srctt(src_ttime+i)+ rectt(rec_ttime+i)
               instant= min(seismnt-2,max(int(ttime),0))
               remaind= max(ttime - float(instant),0.0e+00)
               instant=instant+1

               irefl=i-ireflzorig

               refl(jrefl*reflnz+irefl+1)= 
     &              refl(jrefl*reflnz+irefl+1)
     &              + factor(jrefl*reflnz+irefl+1)*
     &              srctt(src_amp+i)*rectt(rec_amp+i)*
     &              ( (1.- remaind)* trace(instant)
     &              +      remaind * trace(instant+1) )
               
c               if (idbg.gt.1) then
c                  write(ipdmp,*)' j = ',j,' i = ',i
c                  write(ipdmp,*)' temp    = ',ttime
c                  write(ipdmp,*)' instant = ',instant
c                  write(ipdmp,*)' remaind = ',remaind
c                  write(ipdmp,*)' src j   = ',jsrc
c                  write(ipdmp,*)' rec j   = ',jrec
c                  write(ipdmp,*)' src tt  = ',srctt(src_ttime+i)
c                  write(ipdmp,*)' rec tt  = ',rectt(rec_ttime+i)
c                  write(ipdmp,*)' src amp = ',srctt(src_amp+i)
c                  write(ipdmp,*)' rec amp = ',rectt(rec_amp+i)
c                  write(ipdmp,*)' srcampoff = ',src_amp
c                  write(ipdmp,*)' recampoff = ',rec_amp
c                  write(ipdmp,*)' refl    = ',
c     &                 refl(jrefl*reflnz+irefl+1),' after update'
c                  write(ipdmp,*)' factor  = ',factor((j-1)*velnz+i)
c               end if
            end do
            
         end do

      else if ((inversion.eq.0).and.(three_d.eq.1))then

c===============================
c 2.5D Migration
c===============================
CDIR$ NORECURRENCE

         do j = boxleft,boxright
            jsrc = j-isrcboxorig
            jrec = j-irecboxorig

            src_ttime=jsrc*srcnzbox 
            src_amp=jsrc*srcnzbox + ro_amp*srcnxbox*srcnzbox
            src_tau_yy=jsrc*srcnzbox + 2*srcnxbox*srcnzbox

            rec_ttime=jrec*recnzbox 
            rec_amp=jrec*recnzbox + ro_amp*recnxbox*recnzbox
            rec_tau_yy=jrec*recnzbox + 2*recnxbox*recnzbox
            
            jrefl=j-ireflxorig
            
            do i= boxtop,boxbottom
               
               ttime=srctt(src_ttime+i)+ rectt(rec_ttime+i)
               instant= min(seismnt-1,max(int(ttime),1))
               remaind= max(ttime - float(instant),0.0e+00)
               instant=instant+1

               irefl=i-ireflzorig

               refl(jrefl*reflnz+irefl+1)= 
     &              refl(jrefl*reflnz+irefl+1)
     &              + factor(jrefl*reflnz+irefl+1)*
     &              srctt(src_amp+i)*rectt(rec_amp+i)
     &                    /
     &              sqrt( srctt(src_tau_yy+i)+rectt(rec_tau_yy+i) )
     &              *( (1.- remaind)* trace(instant)
     &              +      remaind * trace(instant+1) )
               
c               if (idbg.gt.1) then
c                  write(ipdmp,*)' j = ',j,' i = ',i
c                  write(ipdmp,*)' temp    = ',ttime
c                  write(ipdmp,*)' instant = ',instant
c                  write(ipdmp,*)' remaind = ',remaind
c                  write(ipdmp,*)' src j   = ',jsrc
c                  write(ipdmp,*)' rec j   = ',jrec
c                  write(ipdmp,*)' src tt  = ',srctt(src_ttime+i)
c                  write(ipdmp,*)' rec tt  = ',rectt(rec_ttime+i)
c                  write(ipdmp,*)' src amp = ',srctt(src_amp+i)
c                  write(ipdmp,*)' rec amp = ',rectt(rec_amp+i)
c                  write(ipdmp,*)' srcampoff = ',src_amp
c                  write(ipdmp,*)' recampoff = ',rec_amp
c                  write(ipdmp,*)' refl    = ',
c     &                 refl(jrefl*reflnz+irefl+1),' after update'
c                  write(ipdmp,*)' factor  = ',factor((j-1)*velnz+i)
c               end if
            end do
            
         end do

      end if
      
      if ((gather_flag.eq.0).and.
     &     (inversion.eq.1).and.
     &     (three_d.eq.0)) then
                  
c===============================
c 2D Common Source Inversion
c===============================
CDIR$ NORECURRENCE

      do j = boxleft,boxright
         jsrc = j-isrcboxorig
         jrec = j-irecboxorig

         src_ttime=jsrc*srcnzbox 
         src_amp=jsrc*srcnzbox + ro_amp*srcnxbox*srcnzbox
         src_tau_x=jsrc*srcnzbox + ro_tau_x*srcnxbox*srcnzbox
         src_tau_z=jsrc*srcnzbox + ro_tau_z*srcnxbox*srcnzbox
         src_phi_xs=jsrc*srcnzbox + ro_phi_xr*srcnxbox*srcnzbox

         rec_ttime=jrec*recnzbox 
         rec_amp=jrec*recnzbox + ro_amp*recnxbox*recnzbox
         rec_tau_x=jrec*recnzbox + ro_tau_x*recnxbox*recnzbox
         rec_tau_z=jrec*recnzbox + ro_tau_z*recnxbox*recnzbox
         rec_phi_xr=jrec*recnzbox + ro_phi_xr*recnxbox*recnzbox

         jrefl=j-ireflxorig

         do i= boxtop,boxbottom

            ttime=srctt(src_ttime+i)+ rectt(rec_ttime+i)
            instant= min(seismnt,max(int(ttime),1))
            remaind= max(ttime - float(instant),0.0e+00)
            instant=instant+1

            irefl=i-ireflzorig

            refl(jrefl*reflnz+irefl+1)= 
     &           refl(jrefl*reflnz+irefl+1)
     &           + factor(jrefl*reflnz+irefl+1)*
     &           ( srctt(src_tau_x+i)*rectt(rec_tau_x+i) 
     &           +  srctt(src_tau_z+i)*rectt(rec_tau_z+i) )
     &           *  abs( rectt(rec_phi_xr+i))
     &           * srctt(src_amp+i)*rectt(rec_amp+i)
     &           *( (1.- remaind)* trace(instant)
     &           +      remaind * trace(instant+1) )

         end do

      end do
      
      else if ((gather_flag.eq.0).and.
     &     (inversion.eq.1).and.(three_d.eq.1)) then
                  
c===============================
c 2.5D Common Source Inversion
c===============================
CDIR$ NORECURRENCE

      do j = boxleft,boxright
         jsrc = j-isrcboxorig
         jrec = j-irecboxorig

         src_ttime=jsrc*srcnzbox 
         src_amp=jsrc*srcnzbox + ro_amp*srcnxbox*srcnzbox
         src_tau_x=jsrc*srcnzbox + ro_tau_x*srcnxbox*srcnzbox
         src_tau_z=jsrc*srcnzbox + ro_tau_z*srcnxbox*srcnzbox
         src_phi_xs=jsrc*srcnzbox + ro_phi_xr*srcnxbox*srcnzbox
         src_tau_yy=jsrc*srcnzbox + ro_tau_yy*srcnxbox*srcnzbox

         rec_ttime=jrec*recnzbox 
         rec_amp=jrec*recnzbox + ro_amp*recnxbox*recnzbox
         rec_tau_x=jrec*recnzbox + ro_tau_x*recnxbox*recnzbox
         rec_tau_z=jrec*recnzbox + ro_tau_z*recnxbox*recnzbox
         rec_phi_xr=jrec*recnzbox + ro_phi_xr*recnxbox*recnzbox
         rec_tau_yy=jrec*recnzbox + ro_tau_yy*recnxbox*recnzbox

         jrefl=j-ireflxorig

         do i= boxtop,boxbottom

            ttime=srctt(src_ttime+i)+ rectt(rec_ttime+i)
            instant= min(seismnt,max(int(ttime),1))
            remaind= max(ttime - float(instant),0.0e+00)
            instant=instant+1

            irefl=i-ireflzorig

            refl(jrefl*reflnz+irefl+1)= 
     &           refl(jrefl*reflnz+irefl+1)
     &           + factor(jrefl*reflnz+irefl+1)*
     &           ( srctt(src_tau_x+i)*rectt(rec_tau_x+i) 
     &           +  srctt(src_tau_z+i)*rectt(rec_tau_z+i) )
     &           *  abs( rectt(rec_phi_xr+i))
     &           * srctt(src_amp+i)*rectt(rec_amp+i)
     &           * sqrt(srctt(src_tau_yy+i)+rectt(rec_tau_yy+i))
     &           *( (1.- remaind)* trace(instant)
     &           +      remaind * trace(instant+1) )

         end do

      end do

      end if

c===============================
c 2D Common Offset Inversion
c===============================

      if ((gather_flag.eq.1).and.
     &     (inversion.eq.1).and.(three_d.eq.0)) then
                  
CDIR$ NORECURRENCE

         do j = boxleft,boxright
            jsrc = j-isrcboxorig
            jrec = j-irecboxorig
            src_ttime=jsrc*srcnzbox 
            src_amp=jsrc*srcnzbox + srcnxbox*srcnzbox
            src_tau_x=jsrc*srcnzbox + 2*srcnxbox*srcnzbox
            src_tau_z=jsrc*srcnzbox + 3*srcnxbox*srcnzbox
            src_phi_xs=jsrc*srcnzbox + 4*srcnxbox*srcnzbox
            rec_ttime=jrec*recnzbox 
            rec_amp=jrec*recnzbox + recnxbox*recnzbox
            rec_tau_x=jrec*recnzbox + 2*recnxbox*recnzbox
            rec_tau_z=jrec*recnzbox + 3*recnxbox*recnzbox
            rec_phi_xr=jrec*recnzbox + 4*recnxbox*recnzbox

c 11.11.95 WWS

            jrefl=j-ireflxorig

            do i= boxtop,boxbottom

               ttime=srctt(src_ttime+i)+ rectt(rec_ttime+i)
               instant= min(seismnt,max(int(ttime),1))
               remaind= max(ttime - float(instant),0.0e+00)

               irefl=i-ireflzorig

               refl(jrefl*reflnz+irefl+1)=
     &  	    refl(jrefl*reflnz+irefl+1)
     &              + factor(jrefl*reflnz+irefl+1)*
     &              ( srctt(src_tau_x+i)*rectt(rec_tau_x+i) +
     &              srctt(src_tau_z+i)*rectt(rec_tau_z+i) )*
     &              abs(srctt(src_phi_xs+i)+rectt(rec_phi_xr+i))*
     &              srctt(src_amp+i)*rectt(rec_amp+i)*
     &              ( (1.- remaind)* trace(instant)
     &              +      remaind * trace(instant+1) )
            end do

         end do

      else if ((gather_flag.eq.1).and.
     &        (inversion.eq.1).and.(three_d.eq.1)) then

c===============================
c 2.5D Common Offset Inversion
c===============================

                  
CDIR$ NORECURRENCE

         do j = boxleft,boxright
            jsrc = j-isrcboxorig
            jrec = j-irecboxorig

            src_ttime=jsrc*srcnzbox 
            src_amp=jsrc*srcnzbox + srcnxbox*srcnzbox
            src_tau_x=jsrc*srcnzbox + 2*srcnxbox*srcnzbox
            src_tau_z=jsrc*srcnzbox + 3*srcnxbox*srcnzbox
            src_phi_xs=jsrc*srcnzbox + 4*srcnxbox*srcnzbox
            src_tau_yy=jsrc*srcnzbox + 5*srcnxbox*srcnzbox

            rec_ttime=jrec*recnzbox 
            rec_amp=jrec*recnzbox + recnxbox*recnzbox
            rec_tau_x=jrec*recnzbox + 2*recnxbox*recnzbox
            rec_tau_z=jrec*recnzbox + 3*recnxbox*recnzbox
            rec_phi_xr=jrec*recnzbox + 4*recnxbox*recnzbox
            rec_tau_yy=jrec*recnzbox + 5*recnxbox*recnzbox

c 11.11.95 WWS

            jrefl=j-ireflxorig

            do i= boxtop,boxbottom

               ttime=srctt(src_ttime+i)+ rectt(rec_ttime+i)
               instant= min(seismnt,max(int(ttime),1))
               remaind= max(ttime - float(instant),0.0e+00)
               instant=instant+1

               irefl=i-ireflzorig

               refl(jrefl*reflnz+irefl+1)=
     &	            refl(jrefl*reflnz+irefl+1)
     &              + factor(jrefl*reflnz+irefl+1)*
     &              ( srctt(src_tau_x+i)*rectt(rec_tau_x+i) 
     &              +  srctt(src_tau_z+i)*rectt(rec_tau_z+i) )
     &              *sqrt( srctt(src_tau_yy+i)+rectt(rec_tau_yy+i) )
     &              *abs(srctt(src_phi_xs+i)+rectt(rec_phi_xr+i))
     &              *srctt(src_amp+i)*rectt(rec_amp+i)
     &              *( (1.- remaind)* trace(instant)
     &              +      remaind * trace(instant+1) )
            end do

         end do

      end if

      return
      end
c=========================================================================

