!=======================================================================
      subroutine sol_LOD(nt,nx,ny,idsol,nb,nwA,nBC,level,ierr,
     &      tauJ,tauK,gamma1,gamma2,gammaT,
     &      at,bt,ax,bx,ay,by,theta,
     &      mnxy,idnumer,id2, ht,hx,hy,scheme,
     &      A1,A2,H,V,E1,E2,U,S,F,ws2,wksp)
!=======================================================================
      implicit none
      integer nt,nx,ny,idsol,nb,nwA,nBC,level,ierr
      real*8  tauJ,tauK,gamma1,gamma2,gammaT
      real*8  at,bt,ax,bx,ay,by,theta
      integer mnxy,idnumer,id2
      real*8  ht,hx,hy
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  H(-nb:nb,0:nx,0:ny),V(-nb:nb,0:ny,0:nx)
      real*8  E1(-nb:nb,0:nx,0:ny),E2(-nb:nb,0:ny,0:nx)
      real*8  U(0:nx,0:ny,0:2),F(0:nt)
      real*8  S(0:nx,0:ny)
      real*8  ws2(0:ny,0:nx),wksp(0:nx,0:ny,*)
      character*40 scheme

!------------------------------------
!---- local variables
!------------------------------------

      integer i,j,k,n,id0,id1,ipjump,nBC1
      integer nxm1,nym1,level0
      real*8  time,htsq,theta_htsq,eps0,AUtilde

!------------------------------------
!---- print out and basic setting
!------------------------------------

      if(level.ge.1)then
         print'("SOL_LOD: idsol=",i2,": ",a40)',idsol,scheme
      endif

      if(level.ge.2)then
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"theta=",theta
         print*,"tauJ=",tauJ," tauK=",tauK
     &        ," gamma1=",gamma1," gamma2=",gamma2," gammaT=",gammaT
      endif

      nxm1=nx-1
      nym1=ny-1
      level0=0

      eps0=1.d-6
      htsq=ht*ht
      theta_htsq=theta*htsq

      id0=0
      id1=1
      ipjump=max(1,((nt/10+49)/50)*50)


!------------------
!---- get H and V
!------------------

      call getHV(n,nx,ny,nb,nBC,level0,ierr,
     &           gammaT,htsq,hx,hy, E1,E2,H,V)


!====================================
!---- Time marching
!====================================
      do n=2,nt
!====================================

      id2=mod(n,3)
      time=at+dble(n-1)*ht
      if(n.eq.2 .or. mod(n,ipjump).eq.0 .or. n.eq.nt) then
          if(level.ge.2) print*,"n=",n," t=",(time+ht)
      endif


!-------------------
!-- Explicit step
!-------------------

      if(idnumer.eq.1)then
          call getS(n,nx,ny,nb,level0,ierr,time,ht,theta,
     &              ax,bx,ay,by,S)
      endif

      !---- Compute "u-tilde"

      do j=0,ny
      do i=0,nx
          wksp(i,j,1)=2.d0*U(i,j,id1)-U(i,j,id0)
      enddo
      enddo

      call explicit(n,nt,nx,ny,nb,idnumer,level0,ierr,
     &       mnxy,theta,ht,hx,hy,time,
     &       tauJ,tauK,gamma1,gamma2,gammaT,
     &       S,F,A1,A2,U(0,0,id2),U(0,0,id1),U(0,0,id0),
     &       wksp(0,0,1),wksp(0,0,2),wksp(0,0,3),wksp(0,0,4))


!------------
!-- X-SWEEP
!------------

      call getAU(1,nx,ny,nb,level0,ierr,E1,E2,wksp(0,0,1),wksp(0,0,2))
          ! wksp(0,0,2) contains "E1 Utilde"

      do j=0,ny
      do i=0,nx
          U(i,j,id2)=gammaT*U(i,j,id2)+htsq*wksp(i,j,2)
      enddo
      enddo

      do j=0,ny
          call substit(nb,(nx+1),level0,H(-nb,0,j),U(0,j,id2))
      enddo


!------------
!-- Y-SWEEP
!------------

      call getAU(2,nx,ny,nb,level0,ierr,E1,E2,wksp(0,0,1),wksp(0,0,2))
          ! wksp(0,0,2) contains "E2 Utilde"

      do i=0,nx
      do j=0,ny
          ws2(j,i)=gammaT*U(i,j,id2)+htsq*wksp(i,j,2)
      enddo
      enddo

      do i=0,nx
          call substit(nb,(ny+1),level0,V(-nb,0,i),ws2(0,i))
      enddo

      do j=0,ny
      do i=0,nx
          U(i,j,id2)=ws2(j,i)
      enddo
      enddo

      id0=id1
      id1=id2

!====================================
      enddo
!====================================

      return
      end
