!=======================================================================
      subroutine readU0G(nx,ny,nInit,level,ierr,ax,bx,ay,by,idnumer,U,G)
!=======================================================================
      implicit none
      integer nx,ny,nInit,level,idnumer,ierr
      real*8  ax,bx,ay,by
      real*8  U(0:nx,0:ny),G(0:nx,0:ny)

      integer ix,iy
      real*8  hx,hy,px,py
      real*8  zero,sol,solt

!---- Interface

      if(level.ge.1)print'("READ_U0G: nInit=",i2)',nInit
      if(level.ge.2) then
          print*,"nx=",nx," ax=",ax," bx=",bx
          print*,"ny=",ny," ay=",ay," by=",by
      endif

!-----------------------

      hx=(bx-ax)/dble(nx)
      hy=(by-ay)/dble(ny)
      zero=0.d0

      if(idnumer.eq.1) goto 1000

!-------------------------
! read "U0" and "G=Ut(0)"
!-------------------------

      if(nInit.eq.0)then

          do iy=0,ny
          do ix=0,nx
             U(ix,iy)=0.d0
          enddo
          enddo

          do iy=0,ny
          do ix=0,nx
             G(ix,iy)=0.d0
          enddo
          enddo

      else if(nInit.eq.1)then

          do iy=0,ny
          do ix=0,nx
             U(ix,iy)=0.d0
          enddo
          enddo

          U(nx/2,ny/2)=1.d0

          do iy=0,ny
          do ix=0,nx
             G(ix,iy)=0.d0
          enddo
          enddo

      else

          print*,"Error: readU0G.f: Be careful on nInit!!"
          ierr=1
          return

      endif

      RETURN

 1000 continue

      do iy=0,ny
          py=ay+hy*dble(iy)
          do ix=0,nx
              px=ax+hx*dble(ix)
              U(ix,iy)=sol(zero,px,py)
              G(ix,iy)=solt(zero,px,py)
          enddo
      enddo



      RETURN
      END

