!=======================================================================
      subroutine mtx35Diff(nA1A2,nx,ny,nb,level,ierr,
     &           ax,bx,ay,by,D,A1,A2)
!=======================================================================
      implicit none
      integer nA1A2,nx,ny,nb,level,ierr
      real*8 ax,bx,ay,by
      real*8 D(0:nx,0:ny,2),A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
    
!---------------------------------------------
! A1(-nb:nb,0:nx,0:ny)=-(D1*Ux)x
! A2(-nb:nb,0:ny,0:nx)=-(D2*Uy)y
! nA1A2   =1:  A1 only
!         =2:  A2 only
!         else: both A1 and A2
!---------------------------------------------

      integer i,ix,iy
      real*8 hx,hy,rhxsq,rhysq
      real*8 diff1,diff2,half
      real*8 c1,c2

      if(level.ge.1) then
          print'("MTX35DIFF:",$)'
          if(nA1A2.eq.1)then
              print*,"A1"
          else if(nA1A2.eq.2)then
              print*,"A2"
          else
              print*,"A1 and A2"
          endif
      endif

      hx=(bx-ax)/dble(nx)
      hy=(by-ay)/dble(ny)
      rhxsq=(1.d0/hx)**2
      rhysq=(1.d0/hy)**2
      half=0.5d0

      c1=16.d0/12.d0
      c2= 1.d0/12.d0

      if(nA1A2.eq.2) goto 1000

!-----------
!--- "A1"
!-----------

      if(nb.eq.1)then

          do iy=0,ny
          diff1=half*(D(0,iy,1)+D(1,iy,1))
          do ix=0,nx
              if(ix.ne.nx) diff2=half*(D(ix,iy,1)+D(ix+1,iy,1))
              A1(-1,ix,iy)=-diff1*rhxsq
              A1( 1,ix,iy)=-diff2*rhxsq
              A1( 0,ix,iy)=-(A1(-1,ix,iy)+A1(1,ix,iy))
              diff1=diff2
          end do
          end do

      else if(nb.eq.2)then

          do iy=0,ny
          diff1=half*(D(0,iy,1)+D(1,iy,1))
          do ix=0,nx
              if(ix.ne.nx) diff2=half*(D(ix,iy,1)+D(ix+1,iy,1))
              if(ix.le.1 .or. ix.ge.(nx-1))then
                  A1(-2,ix,iy)= 0.d0
                  A1(-1,ix,iy)=-diff1*rhxsq
                  A1( 1,ix,iy)=-diff2*rhxsq
                  A1( 2,ix,iy)= 0.d0
              else
                  A1(-2,ix,iy)= diff1*rhxsq*c2
                  A1(-1,ix,iy)=-diff1*rhxsq*c1
                  A1( 1,ix,iy)=-diff2*rhxsq*c1
                  A1( 2,ix,iy)= diff2*rhxsq*c2
              endif
              A1( 0,ix,iy)=-(A1(-2,ix,iy)+A1(-1,ix,iy)
     &                      +A1( 1,ix,iy)+A1( 2,ix,iy))
              diff1=diff2
          end do
          end do

      endif

 1000 if(nA1A2.eq.1) return

!-----------
!--- "A2"
!-----------

      if(nb.eq.1)then

          do ix=0,nx
          diff1=half*(D(ix,0,2)+D(ix,1,2))
          do iy=0,ny
              if(iy.ne.ny) diff2=half*(D(ix,iy,2)+D(ix,iy+1,2))
              A2(-1,iy,ix)=-diff1*rhysq
              A2( 1,iy,ix)=-diff2*rhysq
              A2( 0,iy,ix)=-(A2(-1,iy,ix)+A2(1,iy,ix))
              diff1=diff2
          end do
          end do

      else if(nb.eq.2)then

          do ix=0,nx
          diff1=half*(D(ix,0,2)+D(ix,1,2))
          do iy=0,ny
              if(iy.ne.ny) diff2=half*(D(ix,iy,2)+D(ix,iy+1,2))
              if(iy.le.1 .or. iy.ge.(ny-1))then
                  A2(-2,iy,ix)= 0.d0
                  A2(-1,iy,ix)=-diff1*rhysq
                  A2( 1,iy,ix)=-diff2*rhysq
                  A2( 2,iy,ix)= 0.d0
              else
                  A2(-2,iy,ix)= diff1*rhysq*c2
                  A2(-1,iy,ix)=-diff1*rhysq*c1
                  A2( 1,iy,ix)=-diff2*rhysq*c1
                  A2( 2,iy,ix)= diff2*rhysq*c2
              endif
              A2( 0,iy,ix)=-(A2(-2,iy,ix)+A2(-1,iy,ix)
     &                      +A2( 1,iy,ix)+A2( 2,iy,ix))
              diff1=diff2
          end do
          end do

      endif

      return
      end

