!=======================================================================
      real*8 function ftnK(idK,x,y)
!=======================================================================
      implicit none
      integer idK
      real*8 x,y
      real*8 ax,bx,ay,by
      common /c0geom/ ax,bx,ay,by
      real*8 t1,t2,t3

      if(idK.eq.1) then
          ftnK=1.d0
      else if(idK.eq.2) then
          t1=ay+0.25d0*(by-ay)
          t2=ay+0.50d0*(by-ay)
          t3=ay+0.75d0*(by-ay)
          if(y.le.t1)then
              ftnK=1.d0
          else if(y.le.t2)then
              ftnK=3.d0
          else if(y.le.t3)then
              ftnK=2.d0
          else
              ftnK=1.d0
          endif
      endif

      return
      end

!=======================================================================
      real*8 function sol(t,x,y)
!=======================================================================
      implicit none
      real*8 t,x,y
      real*8 pi
      common /c0math/ pi

      sol=dexp(-t)*dcos(5.d0*pi*x)*dcos(3.d0*pi*y)

      return
      end

!=======================================================================
      real*8 function solt(t,x,y)
!=======================================================================
      implicit none
      real*8 t,x,y
      real*8 pi
      common /c0math/ pi

      solt=-dexp(-t)*dcos(5.d0*pi*x)*dcos(3.d0*pi*y)

      return
      end

!=======================================================================
      real*8 function soltt(t,x,y)
!=======================================================================
      implicit none
      real*8 t,x,y
      real*8 pi
      common /c0math/ pi

      soltt=dexp(-t)*dcos(5.d0*pi*x)*dcos(3.d0*pi*y)

      return
      end

!=======================================================================
      real*8 function pderhs(t,x,y)
!=======================================================================
      implicit none
      real*8 t,x,y
      real*8 solt,soltt
      real*8 tauJ,tauK,gamma1,gamma2
      common /c0coef/ tauJ,tauK,gamma1,gamma2

      pderhs=gamma1*solt(t,x,y)+gamma2*soltt(t,x,y)

      return
      end

