!=======================================================================
      subroutine getU1(nx,ny,nt,nb,nBC,idnumer,level,ierr,
     &           tauJ,tauK,gamma1,gamma2,gammaT,
     &           ax,bx,ay,by,c0,theta, at,ht,hx,hy,
     &           F,S,G,A1,A2,U,wksp,AQU)
!=======================================================================
      implicit none
      integer nx,ny,nt,nb,nBC,idnumer,level,ierr
      real*8  tauJ,tauK,gamma1,gamma2,gammaT
      real*8  ax,bx,ay,by,c0,theta, at,ht,hx,hy
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  F(0:nt),S(0:nx,0:ny),G(0:nx,0:ny)
      real*8  U(0:nx,0:ny,0:2),wksp(0:nx,0:ny,*),AQU(0:nx,0:ny,*)

!---------------------
!---- local variables
!---------------------

      integer ix,iy
      real*8  half_htsq0G2

      half_htsq0G2=0.5d0*ht**2/gamma2

!---- Interface

      if(level.ge.1)then
          print'("GET_U1:",$)'
          print*,"nBC=",nBC
      endif

      call getAU(3,nx,ny,nb,level,ierr,A1,A2,U(0,0,0),AQU(0,0,1))
      call getQU(nx,ny,nb,level,ierr,tauJ,tauK,A1,A2,G,AQU(0,0,2))


      if(idnumer.ge.1)then
          do iy=0,ny
          do ix=0,nx
              U(ix,iy,1)=U(ix,iy,0)+ht*G(ix,iy)
     &           +half_htsq0G2*(S(ix,iy)-gamma1*G(ix,iy)
     &                         -AQU(ix,iy,1)-AQU(ix,iy,2))
          enddo
          enddo
      else
          do iy=0,ny
          do ix=0,nx
              U(ix,iy,1)=U(ix,iy,0)+ht*G(ix,iy)
     &           +half_htsq0G2*(-gamma1*G(ix,iy)
     &                         -AQU(ix,iy,1)-AQU(ix,iy,2))
          enddo
          enddo
      endif

      return
      end

